/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import org.xmlresolver.CatalogResolver;
import org.xmlresolver.ResolvedResource;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.ResourceResolver;
import org.xmlresolver.XMLResolverConfiguration;
import org.xmlresolver.logging.ResolverLogger;

public class StAXResolver
implements XMLResolver {
    protected final ResolverLogger logger;
    ResourceResolver resolver = null;

    public StAXResolver() {
        XMLResolverConfiguration config = new XMLResolverConfiguration();
        this.resolver = new CatalogResolver(config);
        this.logger = config.getFeature(ResolverFeature.RESOLVER_LOGGER);
    }

    public StAXResolver(XMLResolverConfiguration config) {
        this.resolver = new CatalogResolver(config);
        this.logger = config.getFeature(ResolverFeature.RESOLVER_LOGGER);
    }

    public StAXResolver(ResourceResolver resolver) {
        this.resolver = resolver;
        this.logger = resolver.getConfiguration().getFeature(ResolverFeature.RESOLVER_LOGGER);
    }

    public ResolverConfiguration getConfiguration() {
        return this.resolver.getConfiguration();
    }

    @Override
    public Object resolveEntity(String publicId, String systemId, String baseURI, String namespace) throws XMLStreamException {
        this.logger.log("request", "resolveEntity: %s/%s (baseURI: %s, %s)", systemId, namespace, baseURI, publicId);
        ResolvedResource rsrc = this.resolver.resolveEntity(null, publicId, systemId, baseURI);
        if (rsrc == null) {
            this.logger.log("response", "resolvedEntity: %s/%s (baseURI: %s, %s) \u2192 null", systemId, namespace, baseURI, publicId);
            return null;
        }
        this.logger.log("response", "resolvedEntity: %s/%s (baseURI: %s, %s) \u2192 %s", systemId, namespace, baseURI, publicId, rsrc.getResolvedURI());
        return rsrc.getInputStream();
    }
}

