/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.Domain;
import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.Host;
import io.mola.galimatias.TestURL;
import io.mola.galimatias.URL;
import io.mola.galimatias.URLParser;
import io.mola.galimatias.URLUtils;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import org.fest.assertions.Assertions;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=Theories.class)
public class URLTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final List<String> JAVA_URL_PROTOCOLS = Arrays.asList("http", "https", "ftp", "file", "jar");

    @Theory
    public void parse_url_whatwg(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        URL parsedURL = URL.parse(testURL.parsedBaseURL, testURL.rawURL);
        Assertions.assertThat((Object)parsedURL).isEqualTo((Object)testURL.parsedURL);
        Assertions.assertThat((String)parsedURL.scheme()).isEqualTo((Object)testURL.parsedURL.scheme());
        Assertions.assertThat((String)parsedURL.schemeData()).isEqualTo((Object)testURL.parsedURL.schemeData());
        Assertions.assertThat((String)parsedURL.username()).isEqualTo((Object)testURL.parsedURL.username());
        Assertions.assertThat((String)parsedURL.password()).isEqualTo((Object)testURL.parsedURL.password());
        Assertions.assertThat((Object)parsedURL.host()).isEqualTo((Object)testURL.parsedURL.host());
        Assertions.assertThat((int)parsedURL.port()).isEqualTo(testURL.parsedURL.port());
        Assertions.assertThat((String)parsedURL.path()).isEqualTo((Object)testURL.parsedURL.path());
        Assertions.assertThat((String)parsedURL.query()).isEqualTo((Object)testURL.parsedURL.query());
        Assertions.assertThat((String)parsedURL.fragment()).isEqualTo((Object)testURL.parsedURL.fragment());
        Assertions.assertThat((boolean)parsedURL.isHierarchical()).isEqualTo(testURL.parsedURL.isHierarchical());
        Assertions.assertThat((boolean)parsedURL.isOpaque()).isEqualTo(testURL.parsedURL.isOpaque());
    }

    @Theory
    public void parse_url_bad_whatwg(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeTrue((testURL.parsedURL == null ? 1 : 0) != 0);
        this.thrown.expect(GalimatiasParseException.class);
        URL.parse(testURL.parsedBaseURL, testURL.rawURL);
    }

    @Theory
    public void parse_url_host_whatwg(@TestURL.TestURLs(dataset="/data/urltestdata_host_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        URL parsedURL = URL.parse(testURL.parsedBaseURL, testURL.rawURL);
        Assertions.assertThat((Object)parsedURL.host()).isEqualTo((Object)testURL.parsedURL.host());
    }

    @Theory
    public void parse_url_bad_host_whatwg(@TestURL.TestURLs(dataset="/data/urltestdata_host_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeTrue((testURL.parsedURL == null ? 1 : 0) != 0);
        this.thrown.expect(GalimatiasParseException.class);
        URL.parse(testURL.parsedBaseURL, testURL.rawURL);
    }

    @Theory
    public void userInfoWithUsernameAndPassword(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL.username(), testURL.parsedURL.password()});
        Assertions.assertThat((String)testURL.parsedURL.userInfo()).isEqualTo((Object)String.format("%s:%s", testURL.parsedURL.username(), testURL.parsedURL.password()));
    }

    @Theory
    public void userInfoWithUsernameOnly(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL.username()});
        Assume.assumeTrue((testURL.parsedURL.password() == null ? 1 : 0) != 0);
        Assertions.assertThat((String)testURL.parsedURL.userInfo()).isEqualTo((Object)testURL.parsedURL.username());
    }

    @Theory
    public void userInfoWithPasswordOnly(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL.password()});
        Assume.assumeTrue((boolean)"".equals(testURL.parsedURL.username()));
        Assertions.assertThat((String)testURL.parsedURL.userInfo()).isEqualTo((Object)(":" + testURL.parsedURL.password()));
    }

    @Theory
    public void withSchemeFromHierarchical(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((boolean)testURL.parsedURL.isHierarchical());
        for (String scheme : new String[]{"http", "https", "ws", "wss", "ftp", "file"}) {
            Assertions.assertThat((String)testURL.parsedURL.withScheme(scheme).scheme()).isEqualTo((Object)scheme);
        }
    }

    @Theory
    public void withNullScheme(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        this.thrown.expect(NullPointerException.class);
        testURL.parsedURL.withScheme(null);
    }

    @Theory
    public void withEmptyScheme(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        this.thrown.expect(GalimatiasParseException.class);
        testURL.parsedURL.withScheme("");
    }

    @Theory
    public void withSchemeFromOpaque(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((boolean)testURL.parsedURL.isOpaque());
        for (String scheme : new String[]{"data", "foobar"}) {
            Assertions.assertThat((String)testURL.parsedURL.withScheme(scheme).scheme()).isEqualTo((Object)scheme);
        }
    }

    @Theory
    public void withUsername(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((boolean)testURL.parsedURL.isHierarchical());
        Assertions.assertThat((String)testURL.parsedURL.withUsername("user").username()).isEqualTo((Object)"user");
        Assertions.assertThat((String)testURL.parsedURL.withUsername(null).username()).isEqualTo((Object)"");
    }

    @Theory
    public void withUsernameOpaque(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((boolean)testURL.parsedURL.isOpaque());
        this.thrown.expect(GalimatiasParseException.class);
        testURL.parsedURL.withUsername("user");
    }

    @Theory
    public void withPassword(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((boolean)testURL.parsedURL.isHierarchical());
        Assertions.assertThat((String)testURL.parsedURL.withPassword("password").password()).isEqualTo((Object)"password");
        Assertions.assertThat((String)testURL.parsedURL.withPassword(null).password()).isNull();
    }

    @Theory
    public void withPasswordOpaque(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((boolean)testURL.parsedURL.isOpaque());
        this.thrown.expect(GalimatiasParseException.class);
        testURL.parsedURL.withPassword("password");
    }

    @Theory
    public void withHost(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((boolean)testURL.parsedURL.isHierarchical());
        Assertions.assertThat((Object)testURL.parsedURL.withHost("example.com").host()).isEqualTo((Object)Host.parseHost("example.com"));
    }

    @Theory
    public void withHostNoHierarchical(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((!testURL.parsedURL.isHierarchical() ? 1 : 0) != 0);
        this.thrown.expect(GalimatiasParseException.class);
        testURL.parsedURL.withHost("example.com");
    }

    @Theory
    public void withHostNoHierarchical2(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((!testURL.parsedURL.isHierarchical() ? 1 : 0) != 0);
        Host host = Host.parseHost("example.com");
        this.thrown.expect(GalimatiasParseException.class);
        testURL.parsedURL.withHost(host);
    }

    @Theory
    public void withNullHost(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((boolean)testURL.parsedURL.isHierarchical());
        this.thrown.expect(NullPointerException.class);
        testURL.parsedURL.withHost((String)null);
    }

    @Theory
    public void withNullHost2(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((boolean)testURL.parsedURL.isHierarchical());
        this.thrown.expect(NullPointerException.class);
        testURL.parsedURL.withHost((Host)null);
    }

    @Theory
    public void withHostOpaque(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((boolean)testURL.parsedURL.isOpaque());
        this.thrown.expect(GalimatiasParseException.class);
        testURL.parsedURL.withHost("example.com");
    }

    @Theory
    public void withPort(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((boolean)testURL.parsedURL.isHierarchical());
        Assertions.assertThat((int)testURL.parsedURL.withPort(80).port()).isEqualTo(80);
    }

    @Theory
    public void withPortOpaque(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((boolean)testURL.parsedURL.isOpaque());
        this.thrown.expect(GalimatiasParseException.class);
        testURL.parsedURL.withPort(80);
    }

    @Theory
    public void withPath(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((boolean)testURL.parsedURL.isHierarchical());
        Assertions.assertThat((String)testURL.parsedURL.withPath("/foo/bar").path()).isEqualTo((Object)"/foo/bar");
    }

    @Theory
    public void withPathOpaque(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((boolean)testURL.parsedURL.isOpaque());
        this.thrown.expect(GalimatiasParseException.class);
        testURL.parsedURL.withPath("/path");
    }

    @Theory
    public void withQuery(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assertions.assertThat((String)testURL.parsedURL.withQuery("query").query()).isEqualTo((Object)"query");
        Assertions.assertThat((String)testURL.parsedURL.withQuery("?query").query()).isEqualTo((Object)"query");
        Assertions.assertThat((String)testURL.parsedURL.withQuery(null).query()).isEqualTo(null);
    }

    @Theory
    public void withFragment(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assertions.assertThat((String)testURL.parsedURL.withFragment("fragment").fragment()).isEqualTo((Object)"fragment");
        Assertions.assertThat((String)testURL.parsedURL.withFragment("#fragment").fragment()).isEqualTo((Object)"fragment");
        Assertions.assertThat((String)testURL.parsedURL.withFragment(null).fragment()).isEqualTo(null);
    }

    @Theory
    public void getAuthorityNullOnOpaque(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((boolean)testURL.parsedURL.isOpaque());
        Assertions.assertThat((String)testURL.parsedURL.authority()).isNull();
    }

    @Theory
    public void getAuthorityNonNullOnHierarchical(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((boolean)testURL.parsedURL.isHierarchical());
        Assume.assumeFalse((boolean)testURL.parsedURL.scheme().equals("file"));
        Assertions.assertThat((String)testURL.parsedURL.authority()).isNotNull();
    }

    @Theory
    public void toFromJavaURI(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException, URISyntaxException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((boolean)URLTest.isConvertibleToJavaURI(testURL.parsedURL));
        URL oneRound = URL.fromJavaURI(testURL.parsedURL.toJavaURI());
        URL twoRound = URL.fromJavaURI(oneRound.toJavaURI());
        Assertions.assertThat((Object)oneRound).isEqualTo((Object)twoRound);
    }

    @Theory
    public void toFromJavaURIException(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException, URISyntaxException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeFalse((boolean)URLTest.isConvertibleToJavaURI(testURL.parsedURL));
        this.thrown.expect(URISyntaxException.class);
        testURL.parsedURL.toJavaURI();
    }

    private static boolean isConvertibleToJavaURI(URL url) {
        if (url.isOpaque() && "//".equals(url.schemeData())) {
            return false;
        }
        if (url.isHierarchical() && url.host() != null && url.host() instanceof Domain) {
            Domain domain = (Domain)url.host();
            return URLUtils.isASCIIAlpha(domain.labels().get(domain.labels().size() - 1).charAt(0));
        }
        return true;
    }

    @Theory
    public void toFromJavaURL(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException, MalformedURLException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((boolean)JAVA_URL_PROTOCOLS.contains(testURL.parsedURL.scheme()));
        java.net.URL toURL = testURL.parsedURL.toJavaURL();
        Assertions.assertThat((Object)testURL.parsedURL).isEqualTo((Object)URL.fromJavaURL(toURL));
    }

    @Test
    public void equivalences() throws GalimatiasParseException {
        Assertions.assertThat((Object)URL.parse("http://example.com/")).isNotEqualTo((Object)"http://example.com/");
        Assertions.assertThat((Object)URL.parse("http://a.com")).isEqualTo((Object)URL.parse("http://a.com/"));
        Assertions.assertThat((int)URL.parse("http://a.com").hashCode()).isEqualTo(URL.parse("http://a.com/").hashCode());
        Assertions.assertThat((Object)URL.parse("http://a.com/")).isNotEqualTo((Object)URL.parse("http://a.com/?"));
        Assertions.assertThat((int)URL.parse("http://a.com/").hashCode()).isNotEqualTo(URL.parse("http://a.com/?").hashCode());
        Assertions.assertThat((Object)URL.parse("http://a.com/?").withQuery(null)).isEqualTo((Object)URL.parse("http://a.com/"));
        Assertions.assertThat((Object)URL.parse("http://a.com/").withQuery("")).isEqualTo((Object)URL.parse("http://a.com/?"));
        Assertions.assertThat((Object)URL.parse("http://a.com/")).isNotEqualTo((Object)URL.parse("http://a.com/#"));
        Assertions.assertThat((int)URL.parse("http://a.com/").hashCode()).isNotEqualTo(URL.parse("http://a.com/#").hashCode());
        Assertions.assertThat((Object)URL.parse("http://a.com/#").withFragment(null)).isEqualTo((Object)URL.parse("http://a.com/"));
        Assertions.assertThat((Object)URL.parse("http://a.com/").withFragment("")).isEqualTo((Object)URL.parse("http://a.com/#"));
    }

    @Test
    public void reduceObjectCreation() throws GalimatiasParseException {
        URL original = URL.parse("http://a.com/?foo");
        Assertions.assertThat((original == original.withQuery("foo") ? 1 : 0) != 0);
        original = URL.parse("http://a.com/#foo");
        Assertions.assertThat((original == original.withFragment("foo") ? 1 : 0) != 0);
    }

    @Test(expected=NullPointerException.class)
    public void schemeCannotBeNull() throws GalimatiasParseException {
        new URL(null, null, null, null, Host.parseHost("example.com"), -1, "/", null, null, true);
    }

    @Test
    public void internalURLParserChecks() throws GalimatiasParseException {
        Assertions.assertThat((Object)new URLParser("ws", URL.parse("http://example.com"), URLParser.ParseURLState.SCHEME).parse()).isEqualTo((Object)URL.parse("http://example.com"));
        Assertions.assertThat((Object)new URLParser("other.com:222", URL.parse("http://example.com"), URLParser.ParseURLState.HOST).parse()).isEqualTo((Object)URL.parse("http://other.com"));
        Assertions.assertThat((Object)new URLParser("other.com/foo", URL.parse("http://example.com"), URLParser.ParseURLState.HOST).parse()).isEqualTo((Object)URL.parse("http://other.com"));
        Assertions.assertThat((Object)new URLParser("other.com?foo", URL.parse("http://example.com"), URLParser.ParseURLState.HOST).parse()).isEqualTo((Object)URL.parse("http://other.com"));
        Assertions.assertThat((Object)new URLParser("other.com#foo", URL.parse("http://example.com"), URLParser.ParseURLState.HOST).parse()).isEqualTo((Object)URL.parse("http://other.com"));
        Assertions.assertThat((Object)new URLParser("22", URL.parse("http://example.com"), URLParser.ParseURLState.PORT).parse()).isEqualTo((Object)URL.parse("http://example.com:22"));
    }

    @Test
    public void relativizeChecks() throws GalimatiasParseException {
        URL base = URL.parse("about:blank");
        Assertions.assertThat((String)base.relativize(URL.parse("about:blank/foo"))).isEqualTo((Object)"about:blank/foo");
        Assertions.assertThat((String)base.relativize(URL.parse("http://example.com/"))).isEqualTo((Object)"http://example.com/");
        base = URL.parse("http://example.com/");
        Assertions.assertThat((String)base.relativize(URL.parse("about:blank"))).isEqualTo((Object)"about:blank");
        Assertions.assertThat((String)base.relativize(URL.parse("https://example.com/"))).isEqualTo((Object)"https://example.com/");
        Assertions.assertThat((String)base.relativize(URL.parse("http://other.com/"))).isEqualTo((Object)"http://other.com/");
        Assertions.assertThat((String)base.relativize(URL.parse("http://user@example.com/"))).isEqualTo((Object)"http://user@example.com/");
        Assertions.assertThat((String)base.relativize(URL.parse("http://user:pass@example.com/"))).isEqualTo((Object)"http://user:pass@example.com/");
        Assertions.assertThat((String)base.relativize(URL.parse("http://:pass@example.com/"))).isEqualTo((Object)"http://:pass@example.com/");
        Assertions.assertThat((String)base.relativize(URL.parse("http://example.com/foo"))).isEqualTo((Object)"foo");
        Assertions.assertThat((String)base.relativize(URL.parse("http://example.com/foo?bar"))).isEqualTo((Object)"foo?bar");
        Assertions.assertThat((String)base.relativize(URL.parse("http://example.com/foo#bar"))).isEqualTo((Object)"foo#bar");
        Assertions.assertThat((String)base.relativize(URL.parse("http://example.com/foo?bar#baz"))).isEqualTo((Object)"foo?bar#baz");
        base = URL.parse("http://example.com/foo?bar#baz");
        Assertions.assertThat((String)base.relativize(URL.parse("http://example.com/bar"))).isEqualTo((Object)"http://example.com/bar");
        Assertions.assertThat((String)base.relativize(URL.parse("http://example.com/foo/bar"))).isEqualTo((Object)"bar");
        Assertions.assertThat((String)base.relativize(URL.parse("http://example.com/foo/bar"))).isEqualTo((Object)"bar");
        Assertions.assertThat((String)base.relativize(URL.parse("http://example.com/foo"))).isEqualTo((Object)"");
        Assertions.assertThat((String)base.relativize(URL.parse("http://example.com/foo/"))).isEqualTo((Object)"");
        Assertions.assertThat((String)base.relativize(URL.parse("http://example.com/foo?bar#baz"))).isEqualTo((Object)"?bar#baz");
        base = URL.parse("http://example.com/foo/?bar#baz");
        Assertions.assertThat((String)base.relativize(URL.parse("http://example.com/foo"))).isEqualTo((Object)"http://example.com/foo");
        Assertions.assertThat((String)base.relativize(URL.parse("http://example.com/foo/"))).isEqualTo((Object)"");
        Assertions.assertThat((String)base.relativize(URL.parse("http://example.com/foo/?bar#baz"))).isEqualTo((Object)"?bar#baz");
        base = URL.parse("file:///etc/fstab");
        Assertions.assertThat((String)base.relativize(URL.parse("file://localhost/etc/fstab"))).isEqualTo((Object)"file://localhost/etc/fstab");
        Assertions.assertThat((String)base.relativize(URL.parse("file:///etc/fstab"))).isEqualTo((Object)"");
        Assertions.assertThat((String)base.relativize(URL.parse("file:///etc/fstab/bar"))).isEqualTo((Object)"bar");
        Assertions.assertThat((String)base.relativize(URL.parse("file:///etc/fstab?bar#baz"))).isEqualTo((Object)"?bar#baz");
        base = URL.parse("file://localhost/etc/fstab");
        Assertions.assertThat((String)base.relativize(URL.parse("file:///etc/fstab"))).isEqualTo((Object)"file:///etc/fstab");
    }

    @Theory
    public void toHumanStringIdempotence(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        Assume.assumeTrue((boolean)(testURL.parsedURL.host() instanceof Domain));
        Domain domain = (Domain)testURL.parsedURL.host();
        Assertions.assertThat((String)domain.toHumanString()).isEqualTo((Object)Domain.parseDomain(domain.toString()).toHumanString());
        Assertions.assertThat((String)Domain.parseDomain(domain.toString(), true).toString()).isEqualTo((Object)Domain.parseDomain(domain.toString()).toHumanString());
        Assertions.assertThat((String)Domain.parseDomain(domain.toString(), true).toHumanString()).isEqualTo((Object)Domain.parseDomain(domain.toString()).toHumanString());
    }

    @Test
    public void toHumanStringChecks() throws GalimatiasParseException {
        Assertions.assertThat((String)URL.parse("http://\u00e1.com/").toHumanString()).isEqualTo((Object)"http://\u00e1.com/");
        Assertions.assertThat((String)URL.parse("http://\u00e1.com/%2F").toHumanString()).isEqualTo((Object)"http://\u00e1.com//");
        Assertions.assertThat((String)URL.parse("http://\u00e1.com/%7E?%2F#%2F").toHumanString()).isEqualTo((Object)"http://\u00e1.com/~?/#/");
        Assertions.assertThat((String)URL.parse("http://\u00e1/").toHumanString()).isEqualTo((Object)"http://\u00e1/");
    }

    @Theory
    public void toHumanStringNoExceptions(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        testURL.parsedURL.toHumanString();
    }
}

