/*  =========================================================================
    zhttp_server - Simple http server.
To start handling requests:
1. Create a dealer socket
2. Connect the socket to the server backend address provided in the options.
3. Create a zhttp_request.
4. Call zhttp_request_recv to accept a new request.
5. Call zhttp_response_send to send a response.

You can connect as many dealers as you want.
The Server is using simple dealer socket to route the requests.

    Copyright (c) the Contributors as noted in the AUTHORS file.
    This file is part of CZMQ, the high-level C binding for 0MQ:
    http://czmq.zeromq.org.

    This Source Code Form is subject to the terms of the Mozilla Public
    License, v. 2.0. If a copy of the MPL was not distributed with this
    file, You can obtain one at http://mozilla.org/MPL/2.0/.
    =========================================================================
*/

#ifndef ZHTTP_SERVER_H_INCLUDED
#define ZHTTP_SERVER_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

//  @warning THE FOLLOWING @INTERFACE BLOCK IS AUTO-GENERATED BY ZPROJECT
//  @warning Please edit the model at "api/zhttp_server.api" to make changes.
//  @interface
//  This is a draft class, and may change without notice. It is disabled in
//  stable builds by default. If you use this in applications, please ask
//  for it to be pushed to stable state. Use --enable-drafts to enable.
#ifdef CZMQ_BUILD_DRAFT_API
//  *** Draft method, for development use, may change without warning ***
//  Create a new http server
CZMQ_EXPORT zhttp_server_t *
    zhttp_server_new (zhttp_server_options_t *options);

//  *** Draft method, for development use, may change without warning ***
//  Destroy an http server
CZMQ_EXPORT void
    zhttp_server_destroy (zhttp_server_t **self_p);

//  *** Draft method, for development use, may change without warning ***
//  Return the port the server is listening on.
CZMQ_EXPORT int
    zhttp_server_port (zhttp_server_t *self);

//  *** Draft method, for development use, may change without warning ***
//  Self test of this class.
CZMQ_EXPORT void
    zhttp_server_test (bool verbose);

#endif // CZMQ_BUILD_DRAFT_API
//  @end

#ifdef __cplusplus
}
#endif

#endif
