/*
 * Decompiled with CFR 0.152.
 */
package phase;

import beagleutil.PbwtDivUpdater;
import ints.IndexArray;
import ints.IntArray;
import ints.IntList;
import ints.WrappedIntArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.stream.IntStream;
import phase.CodedSteps;
import phase.FixedPhaseData;
import phase.Ibs2;
import phase.PbwtIbsData;
import phase.PhaseData;
import phase.Steps;
import vcf.Markers;
import vcf.XRefGT;

public final class LowFreqPbwtPhaseIbs {
    private final PhaseData phaseData;
    private final Ibs2 ibs2;
    private final XRefGT allHaps;
    private final WrappedIntArray[] ibsHaps;

    public LowFreqPbwtPhaseIbs(PhaseData phaseData, CodedSteps codedSteps, boolean bl) {
        LowFreqPbwtPhaseIbs.checkConsistency(phaseData, codedSteps);
        this.phaseData = phaseData;
        this.ibs2 = phaseData.fpd().stage1Ibs2();
        this.allHaps = codedSteps.allHaps();
        PbwtIbsData pbwtIbsData = new PbwtIbsData(phaseData, codedSteps);
        this.ibsHaps = bl ? (WrappedIntArray[])IntStream.range(0, pbwtIbsData.nBatches()).parallel().mapToObj(n -> this.bwdIbsHaps(pbwtIbsData, n)).flatMap(wrappedIntArrayArray -> Arrays.stream(wrappedIntArrayArray)).toArray(WrappedIntArray[]::new) : (WrappedIntArray[])IntStream.range(0, pbwtIbsData.nBatches()).parallel().mapToObj(n -> this.fwdIbsHaps(pbwtIbsData, n)).flatMap(wrappedIntArrayArray -> Arrays.stream(wrappedIntArrayArray)).toArray(WrappedIntArray[]::new);
    }

    private static void checkConsistency(PhaseData phaseData, CodedSteps codedSteps) {
        FixedPhaseData fixedPhaseData = phaseData.fpd();
        if (fixedPhaseData.stage1Steps() != codedSteps.steps() || fixedPhaseData.stage1XRefGT() != codedSteps.refHaps() || fixedPhaseData.targGT().samples() != codedSteps.targSamples()) {
            throw new IllegalArgumentException("inconsistent data");
        }
    }

    private WrappedIntArray[] bwdIbsHaps(PbwtIbsData pbwtIbsData, int n) {
        IndexArray indexArray;
        int n3;
        int n4 = pbwtIbsData.codedSteps().steps().size();
        int n5 = n * pbwtIbsData.stepsPerBatch();
        int n6 = Math.min(n5 + pbwtIbsData.stepsPerBatch(), n4);
        int n7 = Math.min(n6 + pbwtIbsData.nOverlapSteps(), n4);
        assert (n5 < n4);
        WrappedIntArray[] wrappedIntArrayArray = new WrappedIntArray[n6 - n5];
        int n8 = pbwtIbsData.nHaps();
        PbwtDivUpdater pbwtDivUpdater = new PbwtDivUpdater(n8);
        int[] nArray = IntStream.range(0, n8).toArray();
        int[] nArray2 = IntStream.range(0, n8 + 1).map(n2 -> n7 - 1).toArray();
        int[] nArray3 = new int[n8];
        int[] nArray4 = new int[n8];
        int[] nArray5 = new int[n8];
        for (n3 = n7 - 1; n3 >= n6; --n3) {
            indexArray = pbwtIbsData.codedSteps().get(n3);
            pbwtDivUpdater.bwdUpdate(indexArray, indexArray.valueSize(), n3, nArray, nArray2);
        }
        for (n3 = n6 - 1; n3 >= n5; --n3) {
            indexArray = pbwtIbsData.codedSteps().get(n3);
            pbwtDivUpdater.bwdUpdate(indexArray, indexArray.valueSize(), n3, nArray, nArray2);
            LowFreqPbwtPhaseIbs.setInv(nArray, nArray3);
            this.setIToPrevNextI(pbwtIbsData.codedSteps().steps(), n3, nArray3, nArray4, nArray5);
            wrappedIntArrayArray[n3 - n5] = this.getBwdIbsHaps(n3, nArray, nArray2, nArray4, nArray5, pbwtIbsData);
        }
        return wrappedIntArrayArray;
    }

    private WrappedIntArray[] fwdIbsHaps(PbwtIbsData pbwtIbsData, int n) {
        IndexArray indexArray;
        int n3;
        int n4 = pbwtIbsData.codedSteps().steps().size();
        int n5 = n * pbwtIbsData.stepsPerBatch();
        int n6 = Math.min(n5 + pbwtIbsData.stepsPerBatch(), n4);
        int n7 = Math.max(0, n5 - pbwtIbsData.nOverlapSteps());
        assert (n5 < n4);
        WrappedIntArray[] wrappedIntArrayArray = new WrappedIntArray[n6 - n5];
        int n8 = pbwtIbsData.nHaps();
        PbwtDivUpdater pbwtDivUpdater = new PbwtDivUpdater(n8);
        int[] nArray = IntStream.range(0, n8).toArray();
        int[] nArray2 = IntStream.range(0, n8 + 1).map(n2 -> n7).toArray();
        int[] nArray3 = new int[n8];
        int[] nArray4 = new int[n8];
        int[] nArray5 = new int[n8];
        for (n3 = n7; n3 < n5; ++n3) {
            indexArray = pbwtIbsData.codedSteps().get(n3);
            pbwtDivUpdater.fwdUpdate(indexArray, indexArray.valueSize(), n3, nArray, nArray2);
        }
        for (n3 = n5; n3 < n6; ++n3) {
            indexArray = pbwtIbsData.codedSteps().get(n3);
            pbwtDivUpdater.fwdUpdate(indexArray, indexArray.valueSize(), n3, nArray, nArray2);
            LowFreqPbwtPhaseIbs.setInv(nArray, nArray3);
            this.setIToPrevNextI(pbwtIbsData.codedSteps().steps(), n3, nArray3, nArray4, nArray5);
            wrappedIntArrayArray[n3 - n5] = this.getfwdIbsHaps(n3, nArray, nArray2, nArray4, nArray5, pbwtIbsData);
        }
        return wrappedIntArrayArray;
    }

    private WrappedIntArray getBwdIbsHaps(int n, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, PbwtIbsData pbwtIbsData) {
        Random random = new Random(this.phaseData.seed() + (long)n);
        int n2 = pbwtIbsData.codedSteps().steps().start(n);
        int n3 = pbwtIbsData.codedSteps().steps().end(n) - 1;
        int[] nArray5 = new int[pbwtIbsData.nTargHaps()];
        nArray2[nArray.length] = n - 1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= pbwtIbsData.nTargHaps()) continue;
            int n4 = this.bestBwdStage2Index(n, n2, n3, i, nArray, nArray2, nArray3, nArray4, pbwtIbsData);
            if (n4 >= 0) {
                nArray5[nArray[i]] = nArray[n4];
                continue;
            }
            int n5 = i;
            int n6 = i + 1;
            int n7 = nArray2[n5];
            int n8 = nArray2[n6];
            while (n6 - n5 < pbwtIbsData.nCandidates() && (n <= n7 || n <= n8)) {
                if (n7 <= n8) {
                    n8 = Math.min(nArray2[++n6], n8);
                    continue;
                }
                n7 = Math.min(nArray2[--n5], n7);
            }
            nArray5[nArray[i]] = this.getMatch(n2, n3, i, n5, n6, nArray, random);
        }
        return new WrappedIntArray(nArray5);
    }

    private WrappedIntArray getfwdIbsHaps(int n, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, PbwtIbsData pbwtIbsData) {
        Random random = new Random(this.phaseData.seed() + (long)n);
        int n2 = pbwtIbsData.codedSteps().steps().start(n);
        int n3 = pbwtIbsData.codedSteps().steps().end(n) - 1;
        int[] nArray5 = new int[pbwtIbsData.nTargHaps()];
        nArray2[nArray.length] = n + 1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= pbwtIbsData.nTargHaps()) continue;
            int n4 = this.bestFwdStage2Index(n, n2, n3, i, nArray, nArray2, nArray3, nArray4, pbwtIbsData);
            if (n4 >= 0) {
                nArray5[nArray[i]] = nArray[n4];
                continue;
            }
            int n5 = i;
            int n6 = i + 1;
            int n7 = nArray2[n5];
            int n8 = nArray2[n6];
            while (n6 - n5 < pbwtIbsData.nCandidates() && (n7 <= n || n8 <= n)) {
                if (n8 <= n7) {
                    n8 = Math.max(nArray2[++n6], n8);
                    continue;
                }
                n7 = Math.max(nArray2[--n5], n7);
            }
            nArray5[nArray[i]] = this.getMatch(n2, n3, i, n5, n6, nArray, random);
        }
        return new WrappedIntArray(nArray5);
    }

    private int bestFwdStage2Index(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, PbwtIbsData pbwtIbsData) {
        int n5;
        int n6 = -1;
        int n7 = -1;
        int n8 = 0;
        int n9 = 0;
        int n10 = n4 + 1 < nArray.length ? Math.min(nArray2[n4], nArray2[n4 + 1]) : nArray2[n4];
        int n11 = Math.min(n10 + pbwtIbsData.maxBackoffSteps(), n);
        int n12 = nArray3[n4];
        while (n12 > Integer.MIN_VALUE && this.areIbs2(nArray[n4], nArray[n12], n2, n3)) {
            n12 = nArray3[n12];
        }
        if (n12 > Integer.MIN_VALUE) {
            assert (n12 < n4);
            n5 = n4;
            while (n5 - 1 != n12 && nArray2[n5] <= n11) {
                n8 = Math.max(n8, nArray2[n5--]);
            }
            if (n5 - 1 == n12 && nArray2[n5] <= n11) {
                n8 = Math.max(n8, nArray2[n5]);
                n6 = n12;
            }
        }
        n5 = nArray4[n4];
        while (n5 < Integer.MAX_VALUE && this.areIbs2(nArray[n4], nArray[n5], n2, n3)) {
            n5 = nArray4[n5];
        }
        if (n5 < Integer.MAX_VALUE) {
            assert (n4 < n5);
            int n13 = n4;
            while (n13 + 1 != n5 && nArray2[n13 + 1] <= n11) {
                n9 = Math.max(n9, nArray2[++n13]);
            }
            if (n13 + 1 == n5 && nArray2[n13 + 1] <= n11) {
                n9 = Math.max(n9, nArray2[++n13]);
                n7 = n5;
            }
        }
        if (n8 < n9 && n6 != -1) {
            return n6;
        }
        return n7;
    }

    private int bestBwdStage2Index(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, PbwtIbsData pbwtIbsData) {
        int n5;
        int n6 = pbwtIbsData.codedSteps().steps().size() - 1;
        int n7 = -1;
        int n8 = -1;
        int n9 = n6;
        int n10 = n6;
        int n11 = n4 + 1 < nArray.length ? Math.max(nArray2[n4], nArray2[n4 + 1]) : nArray2[n4];
        int n12 = Math.max(n11 - pbwtIbsData.maxBackoffSteps(), n);
        int n13 = nArray3[n4];
        while (n13 > Integer.MIN_VALUE && this.areIbs2(nArray[n4], nArray[n13], n2, n3)) {
            n13 = nArray3[n13];
        }
        if (n13 > Integer.MIN_VALUE) {
            assert (n13 < n4);
            n5 = n4;
            while (n5 - 1 != n13 && nArray2[n5] >= n12) {
                n9 = Math.min(n9, nArray2[n5--]);
            }
            if (n5 - 1 == n13 && nArray2[n5] >= n12) {
                n9 = Math.min(n9, nArray2[n5]);
                n7 = n13;
            }
        }
        n5 = nArray4[n4];
        while (n5 < Integer.MAX_VALUE && this.areIbs2(nArray[n4], nArray[n5], n2, n3)) {
            n5 = nArray4[n5];
        }
        if (n5 < Integer.MAX_VALUE) {
            assert (n4 < n5);
            int n14 = n4;
            while (n14 + 1 != n5 && nArray2[n14 + 1] >= n12) {
                n10 = Math.min(n10, nArray2[++n14]);
            }
            if (n14 + 1 == n5 && nArray2[n14 + 1] >= n12) {
                n10 = Math.min(n10, nArray2[++n14]);
                n8 = n5;
            }
        }
        if (n9 > n10 && n7 != -1) {
            return n7;
        }
        return n8;
    }

    private boolean areIbs2(int n, int n2, int n3, int n4) {
        int n5 = n >> 1;
        int n6 = n2 >> 1;
        return this.ibs2.areIbs2(n5, n6, n3) || this.ibs2.areIbs2(n5, n6, n4);
    }

    private int getMatch(int n, int n2, int n3, int n4, int n5, int[] nArray, Random random) {
        int n6 = n5 - n4;
        if (n6 == 1) {
            return -1;
        }
        int n7 = -1;
        int n8 = n4 + random.nextInt(n6);
        for (int i = 0; i < n6 && n7 == -1; ++i) {
            if (!this.areIbs2(nArray[n3], nArray[n8], n, n2)) {
                n7 = nArray[n8];
            }
            if (++n8 != n5) continue;
            n8 = n4;
        }
        return n7;
    }

    public PhaseData phaseData() {
        return this.phaseData;
    }

    public XRefGT allHaps() {
        return this.allHaps;
    }

    public int ibsHap(int n, int n2) {
        return this.ibsHaps[n2].get(n);
    }

    private void setIToPrevNextI(Steps steps, int n, int[] nArray, int[] nArray2, int[] nArray3) {
        Arrays.fill(nArray2, Integer.MIN_VALUE);
        Arrays.fill(nArray3, Integer.MAX_VALUE);
        ArrayList<IntList> arrayList = this.lowFreqHapLists(steps, n);
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            int[] nArray4 = this.sortedAIndices(arrayList.get(i), nArray);
            for (int j = 1; j < nArray4.length; ++j) {
                int n3 = nArray4[j - 1];
                int n4 = nArray4[j];
                if (n3 > nArray2[n4]) {
                    nArray2[n4] = n3;
                }
                if (n4 >= nArray3[n3]) continue;
                nArray3[n3] = n4;
            }
        }
    }

    private int[] sortedAIndices(IntList intList, int[] nArray) {
        return intList.stream().map(n -> nArray[n]).sorted().toArray();
    }

    private ArrayList<IntList> lowFreqHapLists(Steps steps, int n) {
        FixedPhaseData fixedPhaseData = this.phaseData.fpd();
        IntArray intArray = fixedPhaseData.stage1To2();
        int n2 = n == 0 ? 0 : intArray.get(steps.start(n));
        int n3 = n + 1 < steps.size() ? intArray.get(steps.start(n + 1)) : fixedPhaseData.targGT().nMarkers();
        return LowFreqPbwtPhaseIbs.lowFreqHapLists(fixedPhaseData, n2, n3);
    }

    private static ArrayList<IntList> lowFreqHapLists(FixedPhaseData fixedPhaseData, int n, int n2) {
        ArrayList<IntList> arrayList = new ArrayList<IntList>();
        Markers markers = fixedPhaseData.targGT().markers();
        for (int i = n; i < n2; ++i) {
            int n3 = markers.marker(i).nAlleles();
            for (int j = 0; j < n3; ++j) {
                IntArray intArray = fixedPhaseData.carriers(i, j);
                if (intArray.size() <= 1) continue;
                arrayList.add(LowFreqPbwtPhaseIbs.hapList(intArray));
            }
        }
        return arrayList;
    }

    private static IntList hapList(IntArray intArray) {
        IntList intList = new IntList(2 * intArray.size());
        int n = intArray.size();
        for (int i = 0; i < n; ++i) {
            int n2 = intArray.get(i);
            int n3 = n2 << 1;
            intList.add(n3);
            intList.add(n3 | 1);
        }
        return intList;
    }

    private static void setInv(int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[nArray[i]] = i;
        }
    }
}

