#
#	aegis - project change supervisor
#	Copyright (C) 1991-1996, 1999, 2001-2004, 2006-2008 Peter Miller
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 3 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program. If not, see
#	<http://www.gnu.org/licenses/>.
#
# lib/cshrc.  Generated from cshrc.in by configure.
#
# Please Note: this file will be over-written by the next installation
# of Aegis.  If you make local modifications, you will need to remember
# to make them again after the next upgrade.
#
if ( ! $?AEGIS_PATH && -d $HOME/lib/aegis/. ) then
	setenv AEGIS_PATH $HOME/lib/aegis
endif

#
# Set the MANPATH environment variable to include the Aegis' library
# directory.  This directory contains subdirectories for each of the
# supported languages, structured in such a way that man(1) programs
# which understand the $LANGUAGE environment variable will be able to find
# manual pages in the user's preferred language.
#
# On old versions of man, you could use man -w to find the default value
# for $MANPATH.  We'll have to submit a bug report, hmm?
#
if ( ! $?MANPATH ) then
    setenv MANPATH "`echo /usr/man:/usr/share/man`"
endif
setenv MANPATH ${MANPATH}:/usr/pkg/man:/usr/pkg/share/aegis
# setenv MANPATH ${MANPATH}:/usr/pkg/man:/usr/pkg/share/aegis:/usr/pkg/share/aegis

#
# Set the AEGIS_AUTOMOUNT_POINTS environment variable to the names
# of the directories which the automounter uses to temporarily mount
# file systems.  Use with extreme caution as this distorts Aegis' idea
# of the shape of the filesystem.
#
#	/tmp_mnt is typical of Sun automounters
#	/a is the default for amd, an OpenSource automounter
#	/.automount is typical of amd on Linux
#
# The automounters need to be configured so that the path below the
# automount point is *identical* to the path without it - because all
# Aegis tries to do is remove the automount prefix *if* the file
# stat()s the same with and without it.  This is the default for the
# Sun automounter, but not typical in the examples in the amd user guide.
#
#	This assignment should really be bracketed by a conditional, but
#	many (all?) cshells have a limit of 20 characters in a variable
#	name (but not environment variables) making the $?name thing
#	barf because it checks for a variable *before* it checks for an
#	environment variable.
#
#if ( ! $?AEGIS_AUTOMOUNT_POINTS ) then
	setenv AEGIS_AUTOMOUNT_POINTS "/tmp_mnt:/a:/.automount"
#endif

#
# Each of the Aegis commands has its own alias This is essential for
# aecd, and convenient for the others.  (Splitting Aegis into many
# commands is only efficient if the target system has shared libraries,
# because the size of the common code portion usually greatly exceeds
# the size of the unique portions.)
#
alias	aeb	'aegis -b \!* -v'
alias	aeca	'aegis -ca \!* -v'
alias	aecd	'cd `aegis -cd \!* -v`'
alias	aechown	'aegis -chown \!* -v'
alias	aeclean	'aegis -clean \!* -v'
alias	aeclone	'aegis -clone \!* -v'
alias	aecp	'aegis -cp \!* -v'
alias	aecpu	'aegis -cpu \!* -v'
alias	aed	'aegis -diff \!* -v'
alias	aedb	'aegis -db \!* -v'
alias	aedbu	'aegis -dbu \!* -v'
alias	aede	'aegis -de \!* -v'
alias	aedeu	'aegis -deu \!* -v'
alias aedless \
    'less `find . -type f \( -name "*,D" -o -name ".*,D" \) -print | sort`'
alias aedmore	\
    'more `find . -type f \( -name "*,D" -o -name ".*,D" \) -print | sort`'
alias	aedn	'aegis -dn \!* -v'
alias	aefa	'aegis -fat \!* -v'
alias	aeib	'aegis -ib \!* -v'
alias	aeibu	'aegis -ibu \!* -v'
alias	aeifail	'aegis -ifail \!* -v'
alias	aeipass	'aegis -ipass \!* -v'
alias	ael	'aegis -l \!* -v'
alias	aem	'aegis -diff -only_merge \!* -v'
alias   aemt    'aegis -mt \!* -v'
alias   aemtu   'aegis -mtu \!* -v'
alias	aemv	'aegis -mv \!* -v'
alias	aemvu	'aegis -mvu \!* -v'
alias	aena	'aegis -na \!* -v'
alias	aenbr	'aegis -nbr \!* -v'
alias	aenbru	'aegis -nbru \!* -v'
alias	aenc	'aegis -nc \!* -v'
alias	aencu	'aegis -ncu \!* -v'
alias	aend	'aegis -nd \!* -v'
alias	aenf	'aegis -nf \!* -v'
alias	aenfu	'aegis -nfu \!* -v'
alias	aeni	'aegis -ni \!* -v'
alias	aenpa	'aegis -new-project-alias \!* -v'
alias	aenpr	'aegis -npr \!* -v'
alias	aenrls	'aegis -nrls \!* -v'
alias	aenrv	'aegis -nrv \!* -v'
alias	aent	'aegis -nt \!* -v'
alias	aentu	'aegis -ntu \!* -v'
alias	aepa	'aegis -pa \!* -v'
alias	aepwd	'aegis -Change_Directory \!* -ter'
alias	aeq	'aegis -q \!* -v'
alias	aer	'aereport \!* -v'
alias	aera	'aegis -ra \!* -v'
alias	aerb	'aegis -rb \!* -v'
alias	aerbu	'aegis -rbu \!* -v'
alias	aerd	'aegis -rd \!* -v'
alias	aerfail	'aegis -rfail \!* -v'
alias	aeri	'aegis -ri \!* -v'
alias	aerm	'aegis -rm \!* -v'
alias	aermu	'aegis -rmu \!* -v'
alias	aerpass	'aegis -rpass \!* -v'
alias	aerpa	'aegis -remove-project-alias \!* -v'
alias	aerpu	'aegis -rpu \!* -v'
alias	aermpr	'aegis -rmpr \!* -v'
alias	aerrv	'aegis -rrv \!* -v'
alias	aet	'aegis -t \!* -v'
alias	aev	'aegis -version \!* -v'

alias	ae_c	'setenv AEGIS_CHANGE "\!*"'
alias	ae_p	'setenv AEGIS_PROJECT "\!*"'
