/*
* MyGoGrinder - a program to practice Go problems
* This class' code copyright (c): Ruediger Klehn (2015)
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

/**
*@author Ruediger Klehn
*/

package GoGrinder;

import java.io.*;
import javax.swing.*; // JFileChooser, ConfirmDialog, MessageDialog, ...
import java.sql.Timestamp;
import java.util.Date;

import GoGrinder.FileWorks;
import GoGrinder.Main;

// some file copy and move tasks are done here - aah, copying a file is writing 
// a second one, so that is delegated to FileWReadWrite; but we have some file name work here
public class FileWCpMv{
  private static final String NL = Main.NEW_LINE;
  public static final int COPY = 0;
  public static final int MOVE = 1;

//private boolean infoUser = true; // "file backed up to ..." etc.: if we write 
                                   // e.g. CA[] properties into the file, and 
                                   // save it encoded, the user needn't get an 
                                   // info, as there is a warning, when he/she 
                                   // activates the "store CA[]" option.
  
  // What we want/can to do in this class: 
  //   * make a backup of the original file to the "backup" folder, when 
  //       editing (check, if file changed: fDate) w. time stamp (user option: switch on!)
  //   * make a copy of the ready edited file to the "edited" folder, w. time 
  //       stamp (user option: switch on!)
  //   * make a backup of an old settings file version (on error) w. time stamp (always)
  //   * move defect sgf to the "defect" folder (user option: switch off!)
  //   * move sgf files with unsupported features (e.g. pass moves) to the 
  //       "notsupported" folder (user option: switch off!)
  //   * add a time stamp to the name of a backed up file, so a backup doesn't 
  //       overwrite a previous backup (user option: switch off!)
  
  public FileWCpMv(){/*NOTHING*/}
  
  public static void fileWCpMvSGF(File source, String targetDir, boolean infoUser, int action){ // action: copy=0 or move=1
    fileWCpMvSGF(source.toString(), targetDir, infoUser, action);
  }
  
  // this is for the standard sctions, when move or copy/backup are chosen: targets are "backup", "edited", etc.
  public static boolean fileWCpMvSGF(String source, String targetDir, boolean infoUser, int action){
   // 0/1 = copy/move, 0/2 addDateTime (action aus 1,2,4,8 kombinieren?)
   // possibly this same method can be used to copy files from an external collection to the own collection
    String SLASH = Main.SLASH;
    File source_F = new File(source);
    String sourceCanonicalFile = "";
    try{
      sourceCanonicalFile = source_F.getCanonicalPath();
    }
    catch(Exception e){
      ExceptionHandler.logCommonProblem(e, "Cannot get the real (\"canonical\") path of a defect file:" + NL + source);
    }
    String source_Parent = source_F.getParent();
//try{
//d.b.g("source_Parent = " + source_Parent 
//    + "\n source_F.getCanonicalFile() - " 
//    + source_F.getCanonicalFile().toString());
//}catch(Exception e){}
    String source_noPath = source_F.getName();
    boolean result = false;
    if(source_Parent.indexOf(Main.pathToProblems) > -1 
       && source.equals(sourceCanonicalFile) // Linux: you can make a soft link to external 
                                             // files / folders inside your problems folder and they 
                                             // are processed as if they were part of your collection
       && source_F.canWrite() ) { // canonical file of a hard linked file would be the same path as the apparent path
     // we make sure, that we only work in our settings folder with our own problems
      String subPath = getSubPath(source_Parent);  // // c:/games/MyGG_Sett/problems/gp.com/17k --> gp.com/17k
//d.b.g("subPath = " + subPath);
      String newName = "";
      if(action == COPY)
        newName = nameAddDatetime(source_noPath);
      else if(action == MOVE) 
        newName = source_noPath;
      String targetPath = Main.pathToSettings + SLASH + targetDir + SLASH + subPath;
      String target = targetPath + SLASH + newName;
      if (!createFolder(targetPath)) return false; // (exists or can be created) and canWrite
      if (action == COPY){
        result = FileWReadWrite.copyFile(source, target);
      }
      else if(action == MOVE){
        result = fileMove(source, target);
      }
      return result;
    }
    else{
      if(!GoGrinder.sgf.SGFParser.VALIDATING)
        d.b.g("Cannot move file! File is not in our problems folder. \n (We'll handle that in a later program version.)");
      // else log this? change message in Validator!
    }
    return false;
  }
  
  public static boolean fileMove(String source, String target){ // only valid for same file system, beware of overwriting!
    File sourceF = new File(source);
    File targetF = new File(target);
    while (targetF.exists()){ // usually this will not happen - but who knows
      String[] s = splitPath(target);
      target = s[0] + Main.SLASH + s[1] + "-x" + s[2]; // prob004-x-x-x-x.sgf if this happens more often
      targetF = new File(target);
    }
    return sourceF.renameTo(targetF); // what, if target is IN a write protected folder?
    // "The return value should always be checked to make sure that the rename operation was successful."
  } // target must not be a directory
  
  public static boolean createFolder(String thisFolder){
    File thisFolderF = new File(thisFolder);
    boolean success = false;
       // test..( , true): need write
       success = FileWorks.testFolder(thisFolderF, true);
    if(!success) success = thisFolderF.mkdirs();
    if (!success) JOptionPane.showMessageDialog(null, "Cannot create folder: \n" + thisFolder);
    return success;
  }
  
   // we use this only while switching writeFile (settings, log) to utf-8
  public static void backupSett(String thisFile){
   // c:\sett\mysett.ini -> c:\sett\mysett-2014-11-16_14h39.11-old.ini
    String[] split = splitPath(thisFile); // path, basename, extension
    String backupPath = split[0] + Main.SLASH + split[1] + "-" + dateTime() + "-old" + split[2];
    boolean success = FileWReadWrite.copyFile(thisFile, backupPath);
  }

   // we use this only while switching writeFile (settings, log) to utf-8
  public static void backupLog(String oldName){
    File oldNameF = new File(oldName);
    if (!oldNameF.exists()) return;
    String[] split = splitPath(oldName); // path, basename, extension
    String newName = split[0] + Main.SLASH + split[1] + "-" + dateTime() + "-old" + split[2];
    
    try{
      boolean success = oldNameF.renameTo(new File(newName));
      if (!success)d.b.g("I tried to backup the log files, but there was a problem.");
    }
    catch(Exception e){
      String msg = "Couldn't rename file." 
                   + NL + "Old name: " + oldName 
                   + NL + "New name: " + newName;
      JOptionPane.showMessageDialog(null, msg);
      ExceptionHandler.logCommonProblem(e, msg);
    }
  }
  
  public static void setFileDate(){}
  // Apache fileUtils: Copies a whole directory to a new location (preserving the file dates).

  
  
  public static String[] splitPath(String path){ // c:\games\MyGGSett\mygrinder.ini -> c:\games\MyGGSett + mygrinder + .ini
    String[] theSplitPath = new String[3];
    File pathF = new File(path);
    String pathParent = pathF.getParent(); // theSplitPath[0] (c:\games\MyGGSett)
    String fileName = pathF.getName(); // (mygrinder.ini)
    String baseName = fileName.substring(0, fileName.lastIndexOf(".")); // theSplitPath[1] (mygrinder)
    // if(fileName.lastIndexOf(".") != -1 && fileName.lastIndexOf(".") != 0) 
    // e.g. .xyz as name - but we don't work with that kind of file
    String extension = fileName.substring(fileName.lastIndexOf(".") , fileName.length()); // theSplitPath[2] (.ini)
    theSplitPath[0] = pathParent; 
    theSplitPath[1] = baseName; 
    theSplitPath[2] = extension;
    return theSplitPath;
  }
  
  private static String nameAddDatetime(String oldName){ // prob17.sgf -> prob17-2014-11-16_14h39.11.sgf
    String extension = oldName.substring(oldName.lastIndexOf(".") , oldName.length()); // ".sgf"
    String baseName = oldName.substring(0, oldName.lastIndexOf(".")); // "prob17"
    String backName = baseName + "-" + dateTime() + extension;
    return backName;
  }
  
  private static String dateTime(){ // 2014-11-16 14:39:11.906 --> 2014-11-16_14h39.11 
    // by import java.sql.Timestamp; // since Java 1.5
    String dateTime = new Timestamp(new Date().getTime()).toString().replace(" ", "_").replace(":", ".").substring(0,19);
    String[] dateTimeA = dateTime.split("\\.", 2);
    dateTime = dateTimeA[0] + "h" + dateTimeA[1];
    return dateTime;
  }
  
  private static String getSubPath(String thisSgfDir){ // c:/games/MyGG_Sett/problems/gp.com/17k --> gp.com/17k
    String subPath = "";
    String cleanPath = "";
    try{
    cleanPath = new File(thisSgfDir).getCanonicalPath(); // removes "/" resp. "\" from the end 
    }
    catch(Exception e){
      String msg = "Problem while trying to get the \"canonical\" name of :\n" + thisSgfDir;
      JOptionPane.showMessageDialog(null, msg);
      ExceptionHandler.logCommonProblem(e, msg);
    }
    subPath = cleanPath.substring(Main.pathToProblems.length() + 1, cleanPath.length() );
    return subPath;
  }
  private String getTargetPath(String subPath){
    return "NOT YET";
  }
}
