/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IntegerIdentifier;
import net.sourceforge.squirrel_sql.fw.util.BaseException;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.laf.BaseLAFPreferencesPanelComponent;
import net.sourceforge.squirrel_sql.plugins.laf.DefaultLookAndFeelController;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPlugin;
import net.sourceforge.squirrel_sql.plugins.laf.LAFRegister;

abstract class AbstractPlasticController
extends DefaultLookAndFeelController {
    private static ILogger s_log = LoggerController.createLogger(AbstractPlasticController.class);
    protected static final String[] PLASTIC_THEME_CLASS_NAMES = new String[]{"com.jgoodies.looks.plastic.theme.BrownSugar", "com.jgoodies.looks.plastic.theme.DarkStar", "com.jgoodies.looks.plastic.theme.DesertBlue", "com.jgoodies.looks.plastic.theme.DesertBluer", "com.jgoodies.looks.plastic.theme.DesertGreen", "com.jgoodies.looks.plastic.theme.DesertRed", "com.jgoodies.looks.plastic.theme.DesertYellow", "com.jgoodies.looks.plastic.theme.ExperienceBlue", "com.jgoodies.looks.plastic.theme.ExperienceGreen", "com.jgoodies.looks.plastic.theme.ExperienceRoyale", "com.jgoodies.looks.plastic.theme.LightGray", "com.jgoodies.looks.plastic.theme.Silver", "com.jgoodies.looks.plastic.theme.SkyBlue", "com.jgoodies.looks.plastic.theme.SkyBluer", "com.jgoodies.looks.plastic.theme.SkyGreen", "com.jgoodies.looks.plastic.theme.SkyKrupp", "com.jgoodies.looks.plastic.theme.SkyPink", "com.jgoodies.looks.plastic.theme.SkyRed", "com.jgoodies.looks.plastic.theme.SkyYellow"};
    public static final String DEFAULT_PLASTIC_THEME_CLASS_NAME = PLASTIC_THEME_CLASS_NAMES[11];
    private final LAFPlugin _lafPlugin;
    private final LAFRegister _lafRegister;
    private Map<String, MetalTheme> _themes = new TreeMap<String, MetalTheme>();

    AbstractPlasticController(LAFPlugin plugin, LAFRegister lafRegister) {
        this._lafPlugin = plugin;
        this._lafRegister = lafRegister;
    }

    @Override
    public void initialize() {
        int i;
        this._themes.clear();
        ClassLoader cl = this.getLAFRegister().getLookAndFeelClassLoader();
        MetalTheme[] extras = this.getExtraThemes();
        if (extras == null) {
            extras = new MetalTheme[]{};
        }
        for (i = 0; i < extras.length; ++i) {
            this._themes.put(extras[i].getName(), extras[i]);
        }
        for (i = 0; i < PLASTIC_THEME_CLASS_NAMES.length; ++i) {
            try {
                Class<?> clazz = Class.forName(PLASTIC_THEME_CLASS_NAMES[i], false, cl);
                MetalTheme theme = (MetalTheme)clazz.newInstance();
                this._themes.put(theme.getName(), theme);
                continue;
            }
            catch (Throwable th) {
                s_log.error((Object)("Error loading theme " + PLASTIC_THEME_CLASS_NAMES[i]), th);
            }
        }
    }

    @Override
    public void aboutToBeInstalled(LAFRegister lafRegister, LookAndFeel laf) {
        MetalTheme theme;
        String name = this.getCurrentThemeName();
        if (name != null && (theme = this.getThemeForName(name)) != null) {
            try {
                this.installCurrentTheme(laf, theme);
            }
            catch (BaseException ex) {
                s_log.error((Object)"Error installing a Theme", (Throwable)ex);
            }
        }
    }

    @Override
    public BaseLAFPreferencesPanelComponent getPreferencesComponent() {
        return new PrefsPanel(this);
    }

    abstract String getCurrentThemeName();

    abstract void setCurrentThemeName(String var1);

    abstract void installCurrentTheme(LookAndFeel var1, MetalTheme var2) throws BaseException;

    MetalTheme getThemeForName(String name) {
        return this._themes.get(name);
    }

    MetalTheme[] getExtraThemes() {
        return new MetalTheme[0];
    }

    LAFRegister getLAFRegister() {
        return this._lafRegister;
    }

    LAFPlugin getLAFPlugin() {
        return this._lafPlugin;
    }

    Iterator<MetalTheme> themesIterator() {
        return this._themes.values().iterator();
    }

    public static abstract class ThemePreferences
    implements IHasIdentifier {
        private String _themeName;
        private IntegerIdentifier _id = new IntegerIdentifier(1);

        public String getThemeName() {
            return this._themeName;
        }

        public void setThemeName(String value) {
            this._themeName = value;
        }

        public IIdentifier getIdentifier() {
            return this._id;
        }
    }

    static final class PrefsPanel
    extends BaseLAFPreferencesPanelComponent {
        private static final long serialVersionUID = 1L;
        private AbstractPlasticController _ctrl;
        private JComboBox _themeCmb;
        private int _origSelThemeIdx;

        PrefsPanel(AbstractPlasticController ctrl) {
            this._ctrl = ctrl;
            this.createUserInterface();
        }

        private void createUserInterface() {
            this.setLayout(new GridBagLayout());
            this._themeCmb = new JComboBox();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.add((Component)new JLabel("Theme:", 4), gbc);
            ++gbc.gridx;
            this.add((Component)this._themeCmb, gbc);
        }

        @Override
        public void loadPreferencesPanel() {
            super.loadPreferencesPanel();
            this.loadThemesCombo();
        }

        @Override
        public boolean applyChanges() {
            super.applyChanges();
            if (this._origSelThemeIdx != this._themeCmb.getSelectedIndex()) {
                this._ctrl.setCurrentThemeName((String)this._themeCmb.getSelectedItem());
                return true;
            }
            return false;
        }

        private void loadThemesCombo() {
            this._themeCmb.removeAllItems();
            Iterator<MetalTheme> it = this._ctrl.themesIterator();
            while (it.hasNext()) {
                this._themeCmb.addItem(it.next().getName());
            }
            if (this._themeCmb.getModel().getSize() > 0) {
                String selThemeName = this._ctrl.getCurrentThemeName();
                if (selThemeName != null && selThemeName.length() > 0) {
                    this._themeCmb.setSelectedItem(selThemeName);
                }
                if (this._themeCmb.getSelectedIndex() == -1) {
                    this._themeCmb.setSelectedIndex(0);
                }
            }
            this._origSelThemeIdx = this._themeCmb.getSelectedIndex();
        }
    }

    protected static interface i18n {
        public static final String THEME = "Theme:";
    }
}

