/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.obr.filter;

import org.apache.ivy.osgi.obr.xml.RequirementFilter;

public class CompareFilter
extends RequirementFilter {
    private Operator operator;
    private final String rightValue;
    private final String leftValue;

    public CompareFilter(String string, Operator operator, String string2) {
        this.leftValue = string;
        this.rightValue = string2;
        this.operator = operator;
    }

    public String getLeftValue() {
        return this.leftValue;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getRightValue() {
        return this.rightValue;
    }

    @Override
    public void append(StringBuffer stringBuffer) {
        stringBuffer.append("(");
        stringBuffer.append(this.leftValue);
        stringBuffer.append(this.operator.toString());
        stringBuffer.append(this.rightValue);
        stringBuffer.append(")");
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.leftValue == null ? 0 : this.leftValue.hashCode());
        n = 31 * n + (this.operator == null ? 0 : this.operator.hashCode());
        n = 31 * n + (this.rightValue == null ? 0 : this.rightValue.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof CompareFilter)) {
            return false;
        }
        CompareFilter compareFilter = (CompareFilter)object;
        if (this.leftValue == null ? compareFilter.leftValue != null : !this.leftValue.equals(compareFilter.leftValue)) {
            return false;
        }
        if (this.operator == null ? compareFilter.operator != null : !this.operator.equals(compareFilter.operator)) {
            return false;
        }
        return !(this.rightValue == null ? compareFilter.rightValue != null : !this.rightValue.equals(compareFilter.rightValue));
    }

    public static class Operator {
        public static Operator EQUALS = new Operator();
        public static Operator LOWER_THAN = new Operator();
        public static Operator LOWER_OR_EQUAL = new Operator();
        public static Operator GREATER_THAN = new Operator();
        public static Operator GREATER_OR_EQUAL = new Operator();

        public String toString() {
            if (this == EQUALS) {
                return "=";
            }
            if (this == GREATER_THAN) {
                return ">";
            }
            if (this == GREATER_OR_EQUAL) {
                return ">=";
            }
            if (this == LOWER_THAN) {
                return "<";
            }
            if (this == LOWER_OR_EQUAL) {
                return "<=";
            }
            return super.toString();
        }
    }
}

