/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.commons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.wiztools.commons.MultiValueMap;

public final class CollectionsUtil {
    public static final MultiValueMap EMPTY_MULTI_VALUE_MAP = new MultiValueMap(){

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object key) {
            return false;
        }

        public boolean containsValue(Object value) {
            return false;
        }

        public Collection get(Object key) {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public Set keySet() {
            return Collections.EMPTY_SET;
        }

        public Collection put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public Collection remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 0;
        }

        public Collection values() {
            return Collections.EMPTY_LIST;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MultiValueMap)) {
                return false;
            }
            MultiValueMap other = (MultiValueMap)obj;
            return other.isEmpty();
        }

        public int hashCode() {
            return super.hashCode();
        }
    };

    public static final <K, V> MultiValueMap<K, V> emptyMultiValueMap() {
        return EMPTY_MULTI_VALUE_MAP;
    }

    public static final <K, V> MultiValueMap<K, V> unmodifiableMultiValueMap(final MultiValueMap<K, V> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        return new MultiValueMap<K, V>(){

            @Override
            public void clear() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean containsKey(K key) {
                return map.containsKey(key);
            }

            @Override
            public boolean containsValue(V value) {
                return map.containsValue(value);
            }

            @Override
            public Collection<V> get(K key) {
                return Collections.unmodifiableCollection(map.get(key));
            }

            @Override
            public boolean isEmpty() {
                return map.isEmpty();
            }

            @Override
            public Set<K> keySet() {
                return Collections.unmodifiableSet(map.keySet());
            }

            @Override
            public Collection<V> put(K key, V value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Collection<V> remove(K key) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public Collection<V> values() {
                Collection values = map.values();
                if (values == null) {
                    return null;
                }
                if (values instanceof List) {
                    return Collections.unmodifiableList((List)values);
                }
                if (values instanceof Set) {
                    return Collections.unmodifiableSet((Set)values);
                }
                return Collections.unmodifiableCollection(values);
            }

            public boolean equals(Object obj) {
                Collection otherValues;
                Set otherKeySet;
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof MultiValueMap)) {
                    return false;
                }
                MultiValueMap other = (MultiValueMap)obj;
                Set mapKeySet = map.keySet();
                if (!(mapKeySet == (otherKeySet = other.keySet()) || mapKeySet != null && mapKeySet.equals(otherKeySet))) {
                    return false;
                }
                Collection mapValues = map.values();
                return mapValues == (otherValues = other.values()) || mapValues != null && mapValues.equals(otherValues);
            }

            public int hashCode() {
                int hash = 7;
                hash = 47 * hash + (map != null ? map.hashCode() : 0);
                return hash;
            }

            public String toString() {
                return map.toString();
            }
        };
    }

    public static <T> List<T> asList(T ... objs) {
        ArrayList<T> l = new ArrayList<T>();
        l.addAll(Arrays.asList(objs));
        return l;
    }
}

