<?php
// (c) Copyright 2002-2010 by authors of the Tiki Wiki/CMS/Groupware Project
// 
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: prefs.php 40721 2012-04-04 20:34:35Z pkdille $

// RULE1: $prefs does not contain serialized values. Only the database contains serialized values.
// RULE2: put array('') in default prefs for serialized values

//this script may only be included - so its better to die if called directly.
if ( basename($_SERVER['SCRIPT_NAME']) == basename(__FILE__) ) {
  header("location: index.php");
  exit;
}

$user_overrider_prefs = array('language', 'style', 'style_option', 'userbreadCrumb', 'tikiIndex', 'wikiHomePage','default_calendars', 'metatag_robots');
initialize_prefs();

function get_default_prefs() {
	static $prefs;
	if( is_array($prefs) )
		return $prefs;

	global $cachelib; require_once 'lib/cache/cachelib.php';
	if( $prefs = $cachelib->getSerialized("tiki_default_preferences_cache") ) {
		return $prefs;
	}
	global $tikidate, $tikilib, $url_host;
	$prefs = array(
		// tiki and version
		'tiki_release' => '0',
		'feature_version_checks' => 'y',
		'tiki_needs_upgrade' => 'n',
		'tiki_version_last_check' => 0,
		'tiki_version_check_frequency' => 604800,
		'lastUpdatePrefs' => 1,

		'tiki_domain_prefix' => 'unchanged',
		'tiki_domain_redirects' => '',

		'feature_print_indexed' => 'n', 

		'groups_are_emulated' => 'n',

		'feature_webdav' => 'n',

		// wiki
		'feature_wiki' => 'y',
		'default_wiki_diff_style' => 'sidediff',
		'feature_backlinks' => 'n',
		'backlinks_name_len' => '0',
		'feature_dump' => 'n',
		'feature_history' => 'y',
		'feature_page_contribution' => 'n',
		'feature_lastChanges' => 'y',
		'feature_likePages' => 'n',
		'feature_listPages' => 'y',
		'feature_listorphanPages' => 'n',
		'feature_listorphanStructure' => 'n',
		'feature_page_title' => 'y',
		'wiki_page_name_above' => 'n',
		'feature_sandbox' => 'n',
		'feature_warn_on_edit' => 'y',
		'feature_wiki_1like_redirection' => 'y',
		'feature_wiki_allowhtml' => 'n',
		'feature_wiki_argvariable' => 'n',
		'feature_wiki_attachments' => 'n',
		'feature_wiki_comments' => 'n',
		'feature_wiki_description' => 'n',
		'feature_wiki_discuss' => 'n',
		'feature_wiki_export' => 'n',
		'feature_wiki_structure' => 'n',
		'feature_wiki_import_page' => 'n',
		'feature_wiki_footnotes' => 'n',
		'feature_wiki_icache' => 'n',
		'feature_wiki_import_html' => 'n',
		'feature_wiki_mindmap' => 'n',
		'feature_wiki_monosp' => 'n',
		'feature_wiki_multiprint' => 'n',
		'feature_wiki_notepad' => 'n',
		'feature_wiki_make_structure' => 'n',
		'feature_wiki_open_as_structure' => 'n',
		'feature_wiki_pageid' => 'n',
		'feature_wiki_paragraph_formatting' => 'n',
		'feature_wiki_paragraph_formatting_add_br' => 'y',
		'feature_wiki_pictures' => 'y',
		'feature_wiki_plurals' => 'y',
		'feature_wiki_print' => 'n',
		'feature_wiki_protect_email' => 'y',
		'feature_wiki_rankings' => 'n',
		'feature_wiki_ratings' => 'n',
		'wiki_simple_ratings' => 'n',
		'wiki_simple_ratings_options' => range( 1, 5 ),
		'feature_wiki_replace' => 'y',
		'feature_wiki_show_hide_before' => 'n',
		'feature_wiki_tables' => 'new',
		'feature_wiki_templates' => 'n',
		'feature_wiki_undo' => 'n',
		'feature_wiki_userpage' => 'n',
		'feature_wiki_userpage_prefix' => 'User:',
		'feature_wiki_usrlock' => 'n',
		'feature_wiki_feedback_polls' => array(),
		'feature_wiki_save_draft' => 'n',
		'feature_wikiwords' => 'n',
		'feature_wikiwords_usedash' => 'y',
		'feature_wiki_pagealias' => 'y',
		'mailin_autocheck' => 'n',
		'mailin_autocheckFreq' => '0',
		'mailin_autocheckLast' => 0,
		'page_bar_position' => 'bottom',
		'warn_on_edit_time' => 2,
		'wikiHomePage' => 'HomePage',
		'wikiLicensePage' => '',
		'wikiSubmitNotice' => '',
		'wiki_authors_style' => 'none',
		'wiki_authors_style_by_page' => 'n',
		'wiki_show_version' => 'n',
		'wiki_bot_bar' => 'n',
		'wiki_cache' => 0,
		'wiki_comments_default_ordering' => 'points_desc',
		'wiki_comments_displayed_default' => 'n',
		'wiki_comments_per_page' => 10,
		'wiki_comments_allow_per_page' => 'n',
		'wiki_creator_admin' => 'n',
		'wiki_feature_copyrights' => 'n',
		'wiki_forum_id' => '',
		'wiki_left_column' => 'y',
		'wiki_list_backlinks' => 'n',
		'wiki_list_comment' => 'y',
		'wiki_list_comment_len' => '200',
		'wiki_list_description' => 'y',
		'wiki_list_description_len' => '200',
		'wiki_list_creator' => 'n',
		'wiki_list_hits' => 'y',
		'wiki_list_lastmodif' => 'y',
		'wiki_list_lastver' => 'n',
		'wiki_list_links' => 'n',
		'wiki_list_name' => 'y',
		'wiki_list_name_len' => '40',
		'wiki_list_size' => 'n',
		'wiki_list_status' => 'n',
		'wiki_list_user' => 'y',
		'wiki_list_versions' => 'y',
		'wiki_list_language' => 'n',
		'wiki_list_categories' => 'n',
		'wiki_list_categories_path' => 'n',
		'wiki_list_id' => 'n',
		'wiki_list_sortorder' => 'pageName',
		'wiki_list_sortdirection' => 'asc',
		'wiki_pagealias_tokens' => 'alias',
		'wiki_prefixalias_tokens' => '',
		'wiki_page_regex' => 'complete',
		'wiki_page_separator' => '...page...',
		'wiki_page_navigation_bar' => 'bottom',
		'wiki_actions_bar' => 'bottom',
		'wiki_pagename_strip' => '',
		'wiki_right_column' => 'y',
		'wiki_structure_bar_position' => 'top',
		'wiki_top_bar' => 'y',
		'wiki_topline_position' => 'top',
		'wiki_uses_slides' => 'n',
		'wiki_watch_author' => 'n',
		'wiki_watch_comments' => 'y',
		'wiki_watch_editor' => 'n',
		'wiki_watch_minor' => 'n',
		'feature_wiki_history_full' => 'n',
		'feature_wiki_categorize_structure' => 'n',
		'feature_wiki_watch_structure' => 'n',
		'feature_wikiapproval' => 'n',
		'wikiapproval_prefix' => '*',
		'wikiapproval_hideprefix' => 'n',
		'wikiapproval_delete_staging' => 'n',
		'wikiapproval_master_group' => '-1',
		'wikiapproval_staging_category' => '0',
		'wikiapproval_approved_category' => '0',
		'wikiapproval_outofsync_category' => '0',
		'wikiapproval_block_editapproved' => 'n',
		'wikiapproval_sync_categories' => 'n',
		'wikiapproval_update_freetags' => 'n',
		'wikiapproval_combine_freetags' => 'n',
		'wiki_edit_section' => 'y',
		'wiki_edit_section_level' => '0',
		'wiki_edit_icons_toggle' => 'n',
		'wiki_edit_plugin' => 'y',
		'wiki_validate_plugin' => 'y',
		'wiki_edit_minor' => 'n',
		'wiki_badchar_prevent' => 'n',
		'wiki_backlinks_name_len' => 0,
		'wiki_ranking_reload_probability' => 1000,
		'wiki_encourage_contribution' => 'n',
		'wiki_timeout_warning' => 'y',
		'wiki_dynvar_style' => 'single',
		'wiki_dynvar_multilingual' => 'n',
		'wiki_keywords' => 'n',
		'wiki_likepages_samelang_only' => 'n',
		'wiki_mandatory_edit_summary' => 'n',

		'wikiplugin_addtocart' => 'n',
		'wikiplugin_addtogooglecal' => 'n',
		'wikiplugin_agentinfo' => 'n',
		'wikiplugin_alink' => 'n',
		'wikiplugin_aname' => 'n',
		'wikiplugin_annotation' => 'n',
		'wikiplugin_archivebuilder' => 'n',
		'wikiplugin_article' => 'y',
		'wikiplugin_articles' => 'y',
		'wikiplugin_attach' => 'y',
		'wikiplugin_attributes' => 'n',
		'wikiplugin_author' => 'y',
		'wikiplugin_avatar' => 'n',
		'wikiplugin_back' => 'n',
		'wikiplugin_backlinks' => 'n',
		'wikiplugin_banner' => 'n',
		'wikiplugin_bigbluebutton' => 'y',
		'wikiplugin_bliptv' => 'y',
		'wikiplugin_bloglist' => 'n',
		'wikiplugin_box' => 'y',
		'wikiplugin_button' => 'n',
		'wikiplugin_calendar' => 'y',
		'wikiplugin_category' => 'y',
		'wikiplugin_catorphans' => 'y',
		'wikiplugin_cclite' => 'n',
		'wikiplugin_catpath' => 'y',
		'wikiplugin_center' => 'y',
		'wikiplugin_chart' => 'y',
		'wikiplugin_code' => 'y',
		'wikiplugin_colorbox' => 'n',
		'wikiplugin_content' => 'y',
		'wikiplugin_cookie' => 'n',
		'wikiplugin_copyright' => 'y',
		'wikiplugin_countdown' => 'n',
		'wikiplugin_datachannel' => 'n',
		'wikiplugin_dbreport' => 'n',
		'wikiplugin_div' => 'y',
		'wikiplugin_dl' => 'y',
		'wikiplugin_draw' => 'y',
		'wikiplugin_equation' => 'n',
		'wikiplugin_events' => 'y',
		'wikiplugin_fade' => 'y',
		'wikiplugin_fancylist' => 'y',
		'wikiplugin_fancytable' => 'y',
		'wikiplugin_file' => 'y',
		'wikiplugin_files' => 'y',
		'wikiplugin_flash' => 'y',
		'wikiplugin_footnote' => 'n',
		'wikiplugin_footnotearea' => 'n',
		'wikiplugin_freetagged' => 'n',
		'wikiplugin_ftp' => 'n',
		'wikiplugin_gauge' => 'n',
		'wikiplugin_googleanalytics' => 'n',
		'wikiplugin_googledoc' => 'n',
		'wikiplugin_googlemap' => 'y',
		'wikiplugin_group' => 'y',
		'wikiplugin_grouplist' => 'n',
		'wikiplugin_groupmailcore' => 'n',
		'wikiplugin_groupstat' => 'n',
		'wikiplugin_html' => 'y',
		'wikiplugin_iframe' => 'n',
		'wikiplugin_img' => 'y',
		'wikiplugin_image' => 'n',    // Experimental, intended to be phased out with new img
		'wikiplugin_include' => 'y',
		'wikiplugin_randominclude' => 'n',
		'wikiplugin_invite' => 'y',
		'wikiplugin_jabber' => 'n',
		'wikiplugin_js' => 'n',
		'wikiplugin_jq' => 'n',
		'wikiplugin_lang' => 'y',
		'wikiplugin_lastmod' => 'n',
		'wikiplugin_listpages' => 'n',
		'wikiplugin_lsdir' => 'n',
		'wikiplugin_mail' => 'n',
		'wikiplugin_map' => 'y',
		'wikiplugin_mcalendar' => 'n',
		'wikiplugin_mediaplayer' => 'y',
		'wikiplugin_memberlist' => 'n',
		'wikiplugin_memberpayment' => 'y',
		'wikiplugin_miniquiz' => 'y',
		'wikiplugin_module' => 'y',
		'wikiplugin_mono' => 'n',
		'wikiplugin_mouseover' => 'y',
		'wikiplugin_mwtable' => 'n',
		'wikiplugin_myspace' => 'n',
		'wikiplugin_objecthits' => 'n',
		'wikiplugin_payment' => 'y',
		'wikiplugin_perm' => 'n',
		'wikiplugin_picture' => 'n',  // Old syntax for images
		'wikiplugin_pluginmanager' => 'n',
		'wikiplugin_poll' => 'y',
		'wikiplugin_profile' => 'n',		
		'wikiplugin_proposal' => 'n',
		'wikiplugin_quote' => 'y',
		'wikiplugin_rcontent' => 'y',
		'wikiplugin_realnamelist' => 'n',
		'wikiplugin_redirect' => 'n',
		'wikiplugin_regex' => 'n',
		'wikiplugin_remarksbox' => 'y',
		'wikiplugin_rss' => 'y',
		'wikiplugin_scroll' => 'n',
		'wikiplugin_sf' => 'n',
		'wikiplugin_share' => 'n',
		'wikiplugin_sharethis' => 'n',
		'wikiplugin_sheet' => 'y',
		'wikiplugin_showpages' => 'n',
		'wikiplugin_skype' => 'n',
		'wikiplugin_smarty' => 'n',
		'wikiplugin_snarf' => 'n',
		'wikiplugin_snarf_cache' => 0,
		'wikiplugin_sort' => 'y',
		'wikiplugin_split' => 'y',
		'wikiplugin_sql' => 'n',
		'wikiplugin_stat' => 'n',
		'wikiplugin_sub' => 'y',
		'wikiplugin_subscribegroup' => 'n',
		'wikiplugin_subscribegroups' => 'n',
		'wikiplugin_subscribenewsletter' => 'n',
		'wikiplugin_sup' => 'y',
		'wikiplugin_survey' => 'y',
		'wikiplugin_tag' => 'n',
		'wikiplugin_tabs' => 'y',
		'wikiplugin_thumb' => 'y',
		'wikiplugin_titlesearch' => 'n',
		'wikiplugin_toc' => 'y',
		'wikiplugin_topfriends' => 'y',
		'wikiplugin_trackercomments' => 'y',
		'wikiplugin_trackerfilter' => 'y',
		'wikiplugin_trackeritemfield' => 'y',
		'wikiplugin_trackerlist' => 'y',
		'wikiplugin_trackertimeline' => 'y',
		'wikiplugin_tracker' => 'y',
		'wikiplugin_trackerprefill' => 'y',
		'wikiplugin_trackerstat' => 'y',
		'wikiplugin_trade' => 'n',
		'wikiplugin_transclude' => 'y',
		'wikiplugin_translated' => 'y',
		'wikiplugin_tr' => 'n',
		'wikiplugin_usercount' => 'n',
		'wikiplugin_userlink' => 'y',
		'wikiplugin_userlist' => 'n',
		'wikiplugin_userpref' => 'n',
		'wikiplugin_versions' => 'n',
		'wikiplugin_vimeo' => 'y',	
		'wikiplugin_vote' => 'y',
		'wikiplugin_watershed' => 'n',
		'wikiplugin_wantedpages' => 'n',
		'wikiplugin_webservice' => 'n',
		'wikiplugin_youtube' => 'y',

		// Inline wiki plugins have their edit plugin icon disabled
		'wikiplugininline_addtocart' => 'n',
		'wikiplugininline_addtogooglecal' => 'n',
		'wikiplugininline_agentinfo' => 'n',
		'wikiplugininline_alink' => 'n',
		'wikiplugininline_aname' => 'n',
		'wikiplugininline_annotation' => 'n',
		'wikiplugininline_archivebuilder' => 'n',
		'wikiplugininline_article' => 'n',
		'wikiplugininline_articles' => 'n',
		'wikiplugininline_attach' => 'n',
		'wikiplugininline_attributes' => 'n',
		'wikiplugininline_avatar' => 'n',
		'wikiplugininline_back' => 'n',
		'wikiplugininline_backlinks' => 'n',
		'wikiplugininline_banner' => 'n',
		'wikiplugininline_bigbluebutton' => 'n',
		'wikiplugininline_bliptv' => 'n',
		'wikiplugininline_bloglist' => 'n',
		'wikiplugininline_box' => 'n',
		'wikiplugininline_button' => 'n',
		'wikiplugininline_calendar' => 'n',
		'wikiplugininline_category' => 'n',
		'wikiplugininline_catorphans' => 'n',
		'wikiplugininline_catpath' => 'n',
		'wikiplugininline_cclite' => 'n',
		'wikiplugininline_center' => 'n',
		'wikiplugininline_chart' => 'n',
		'wikiplugininline_code' => 'n',
		'wikiplugininline_colorbox' => 'n',
		'wikiplugininline_content' => 'n',
		'wikiplugininline_cookie' => 'n',
		'wikiplugininline_copyright' => 'n',
		'wikiplugininline_countdown' => 'n',
		'wikiplugininline_datachannel' => 'n',
		'wikiplugininline_dbreport' => 'n',
		'wikiplugininline_div' => 'n',
		'wikiplugininline_dl' => 'n',
		'wikiplugininline_draw' => 'n',
		'wikiplugininline_equation' => 'n',
		'wikiplugininline_events' => 'n',
		'wikiplugininline_fade' => 'n',
		'wikiplugininline_fancylist' => 'n',
		'wikiplugininline_fancytable' => 'n',
		'wikiplugininline_file' => 'y',
		'wikiplugininline_files' => 'n',
		'wikiplugininline_flash' => 'n',
		'wikiplugininline_footnote' => 'n',
		'wikiplugininline_footnotearea' => 'n',
		'wikiplugininline_freetagged' => 'n',
		'wikiplugininline_ftp' => 'n',
		'wikiplugininline_gauge' => 'n',
		'wikiplugininline_googleanalytics' => 'y',
		'wikiplugininline_googledoc' => 'n',
		'wikiplugininline_googlemap' => 'n',
		'wikiplugininline_group' => 'y',
		'wikiplugininline_grouplist' => 'y',
		'wikiplugininline_groupmailcore' => 'n',
		'wikiplugininline_groupstat' => 'n',
		'wikiplugininline_html' => 'n',
		'wikiplugininline_iframe' => 'n',
		'wikiplugininline_img' => 'n',
		'wikiplugininline_image' => 'n',    // Experimental, may supercede img in 4.0
		'wikiplugininline_include' => 'n',
		'wikiplugininline_invite' => 'n',
		'wikiplugininline_jabber' => 'n',
		'wikiplugininline_js' => 'n',
		'wikiplugininline_jq' => 'n',
		'wikiplugininline_lang' => 'n',
		'wikiplugininline_lastmod' => 'n',
		'wikiplugininline_listpages' => 'n',
		'wikiplugininline_lsdir' => 'n',
		'wikiplugininline_mail' => 'y',
		'wikiplugininline_map' => 'n',
		'wikiplugininline_mcalendar' => 'n',
		'wikiplugininline_mediaplayer' => 'n',
		'wikiplugininline_memberlist' => 'n',
		'wikiplugininline_memberpayment' => 'n',
		'wikiplugininline_miniquiz' => 'n',
		'wikiplugininline_module' => 'n',
		'wikiplugininline_mono' => 'n',
		'wikiplugininline_mouseover' => 'n',
		'wikiplugininline_mwtable' => 'n',
		'wikiplugininline_myspace' => 'n',
		'wikiplugininline_objecthits' => 'n',
		'wikiplugininline_payment' => 'n',
		'wikiplugininline_perm' => 'y',
		'wikiplugininline_picture' => 'n',  // Old syntax for images
		'wikiplugininline_pluginmanager' => 'n',
		'wikiplugininline_poll' => 'n',
		'wikiplugininline_profile' => 'n',
		'wikiplugininline_proposal' => 'n',
		'wikiplugininline_quote' => 'n',
		'wikiplugininline_rcontent' => 'n',
		'wikiplugininline_randominclude' => 'n',
		'wikiplugininline_realnamelist' => 'n',
		'wikiplugininline_redirect' => 'n',
		'wikiplugininline_regex' => 'n',
		'wikiplugininline_remarksbox' => 'n',
		'wikiplugininline_rss' => 'n',
		'wikiplugininline_scroll' => 'n',
		'wikiplugininline_sf' => 'n',
		'wikiplugininline_share' => 'n',
		'wikiplugininline_sharethis' => 'n',
		'wikiplugininline_sheet' => 'n',
		'wikiplugininline_showpages' => 'n',
		'wikiplugininline_skype' => 'n',
		'wikiplugininline_smarty' => 'y',
		'wikiplugininline_snarf' => 'n',
		'wikiplugininline_sort' => 'n',
		'wikiplugininline_split' => 'n',
		'wikiplugininline_sql' => 'n',
		'wikiplugininline_stat' => 'n',
		'wikiplugininline_sub' => 'n',
		'wikiplugininline_subscribegroup' => 'n',
		'wikiplugininline_subscribegroups' => 'n',
		'wikiplugininline_subscribenewsletter' => 'n',
		'wikiplugininline_sup' => 'n',
		'wikiplugininline_survey' => 'n',
		'wikiplugininline_tag' => 'n',
		'wikiplugininline_tabs' => 'n',
		'wikiplugininline_thumb' => 'n',
		'wikiplugininline_titlesearch' => 'n',
		'wikiplugininline_toc' => 'n',
		'wikiplugininline_topfriends' => 'n',
		'wikiplugininline_trackercomments' => 'n',
		'wikiplugininline_trackerfilter' => 'n',
		'wikiplugininline_trackeritemfield' => 'y',
		'wikiplugininline_trackerlist' => 'n',
		'wikiplugininline_trackertimeline' => 'n',
		'wikiplugininline_tracker' => 'n',
		'wikiplugininline_trackerprefill' => 'n',
		'wikiplugininline_trackerstat' => 'n',
		'wikiplugininline_trade' => 'n',
		'wikiplugininline_transclude' => 'y',
		'wikiplugininline_translated' => 'n',
		'wikiplugininline_tr' => 'n',
		'wikiplugininline_usercount' => 'n',
		'wikiplugininline_userlink' => 'n',
		'wikiplugininline_userlist' => 'n',
		'wikiplugininline_userpref' => 'n',
		'wikiplugininline_versions' => 'n',
		'wikiplugininline_vimeo' => 'n',
		'wikiplugininline_vote' => 'n',
		'wikiplugininline_watershed' => 'n',
		'wikiplugininline_wantedpages' => 'n',
		'wikiplugininline_webservice' => 'n',
		'wikiplugininline_youtube' => 'n',
		'wikiplugininline_author' => 'n',

		// webservices
		'webservice_consume_defaultcache' => 300, // 5 min
		'feature_webservices' => 'n',

		// semantic links
		'feature_semantic' => 'n',

		// wysiwyg
		'feature_wysiwyg' => 'n',
		'wysiwyg_optional' => 'y',
		'wysiwyg_default' => 'n',
		'wysiwyg_memo' => 'y',
		'wysiwyg_wiki_parsed' => 'y',
		'wysiwyg_wiki_semi_parsed' => 'n',
		'wysiwyg_toolbar_skin' => 'kama',
		'wysiwyg_htmltowiki' => 'n',
		'wysiwyg_fonts' => 'sans serif;serif;monospace;Arial;Century Gothic;Comic Sans MS;Courier New;Tahoma;Times New Roman;Verdana',

		// wiki3d
		'wiki_feature_3d' => 'n',
		'wiki_3d_width' => 500,
		'wiki_3d_height' => 500,
		'wiki_3d_navigation_depth' => 1,
		'wiki_3d_feed_animation_interval' => 500,
		'wiki_3d_existing_page_color' => '#00CC55',
		'wiki_3d_missing_page_color' => '#FF5555',

		// blogs
		'feature_blogs' => 'n',
		'blog_list_order' => 'created_desc',
		'home_blog' => 0,
		'feature_blog_rankings' => 'n',
		'blog_comments_default_ordering' => 'commentDate_asc',
		'blog_comments_per_page' => 10,
		'feature_blogposts_comments' => 'y',
		'blog_list_user' => 'text',
		'blog_list_title' => 'y',
		'blog_list_title_len' => '35',
		'blog_list_description' => 'y',
		'blog_list_created' => 'y',
		'blog_list_lastmodif' => 'y',
		'blog_list_posts' => 'y',
		'blog_list_visits' => 'y',
		'blog_list_activity' => 'n',
		'feature_blog_mandatory_category' => '-1',
		'feature_blog_heading' => 'y',
		'feature_blog_edit_publish_date' => 'y',
		'feature_blog_sharethis' => 'n',
		'blog_sharethis_publisher' => '',

		// filegals
		'feature_file_galleries' => 'y',
		'home_file_gallery' => 1,
		'fgal_root_id' => 1,
		'fgal_use_db' => 'y',
		'fgal_batch_dir' => '',
		'fgal_match_regex' => '',
		'fgal_nmatch_regex' => '',
		'fgal_use_dir' => '',
		'fgal_podcast_dir' => 'files/',
		'feature_file_galleries_comments' => 'n',
		'file_galleries_comments_default_ordering' => 'points_desc',
		'file_galleries_comments_per_page' => 10,
		'feature_file_galleries_batch' => 'n',
		'feature_file_galleries_rankings' => 'n',
		'fgal_enable_auto_indexing' => 'y',
		'fgal_asynchronous_indexing' => 'y',
		'fgal_allow_duplicates' => 'y',
		'fgal_sort_mode' => '',
		'feature_file_galleries_author' => 'n',
		'fgal_list_id' => 'o',
		'fgal_list_type' => 'y',
		'fgal_list_name' => 'a',
		'fgal_list_description' => 'o',
		'fgal_list_size' => 'y',
		'fgal_list_created' => 'o',
		'fgal_list_lastModif' => 'y',
		'fgal_list_creator' => 'o',
		'fgal_list_author' => 'o',
		'fgal_list_last_user' => 'o',
		'fgal_list_comment' => 'o',
		'fgal_list_files' => 'o',
		'fgal_list_hits' => 'o',
		'fgal_list_lastDownload' => 'n',
		'fgal_list_lockedby' => 'a',
		'fgal_show_path' => 'y',
		'fgal_show_explorer' => 'y',
		'fgal_show_slideshow' => 'n',
		'fgal_default_view' => 'list',
		'fgal_limit_hits_per_file' => 'n',
		'fgal_prevent_negative_score' => 'n',
		'fgal_quota' => 0,
		'fgal_quota_per_fgal' => 'n',
		'fgal_quota_default' => 0,
		'fgal_quota_show' => 'y',
		'fgal_list_backlinks' => 'n',
		'fgal_search_in_content' => 'n',
		'fgal_search' => 'y',
		'fgal_delete_after' => 'n',
		'fgal_delete_after_email' => '',
		'fgal_list_id_admin' => 'y',
		'fgal_list_type_admin' => 'y',
		'fgal_list_name_admin' => 'n',
		'fgal_list_description_admin' => 'o',
		'fgal_list_size_admin' => 'y',
		'fgal_list_created_admin' => 'o',
		'fgal_list_lastModif_admin' => 'y',
		'fgal_list_creator_admin' => 'o',
		'fgal_list_author_admin' => 'o',
		'fgal_list_last_user_admin' => 'o',
		'fgal_list_comment_admin' => 'o',
		'fgal_list_files_admin' => 'o',
		'fgal_list_hits_admin' => 'o',
		'fgal_list_lastDownload_admin' => 'n',
		'fgal_list_lockedby_admin' => 'n',
		'fgal_list_backlinks_admin' => 'y',
		'fgal_keep_fileId' => 'n',
		'fgal_show_thumbactions' => 'y',
		'fgal_thumb_max_size' => 120,

		// imagegals
		'feature_galleries' => 'n',
		'feature_gal_batch' => 'n',
		'feature_gal_slideshow' => 'n',
		'home_gallery' => 0,
		'gal_use_db' => 'y',
		'gal_use_lib' => 'imagick',
		'gal_match_regex' => '',
		'gal_nmatch_regex' => '',
		'gal_use_dir' => '',
		'gal_batch_dir' => '',
		'feature_gal_rankings' => 'n',
		'feature_image_galleries_comments' => 'n',
		'image_galleries_comments_default_order' => 'points_desc',
		'image_galleries_comments_per_page' => 10,
		'gal_list_name' => 'y',
		'gal_list_parent' => 'n',
		'gal_list_description' => 'y',
		'gal_list_created' => 'n',
		'gal_list_lastmodif' => 'y',
		'gal_list_user' => 'n',
		'gal_list_imgs' => 'y',
		'gal_list_visits' => 'y',
		'feature_image_gallery_mandatory_category' => '-1',
		'preset_galleries_info' =>'n',
		'gal_image_mouseover' => 'n',

		// forums
		'feature_forums' => 'n',
		'home_forum' => 0,
		'feature_forum_rankings' => 'n',
		'feature_forum_parse' => 'n',
		'feature_forum_topics_archiving' => 'n',
		'feature_forum_replyempty' => 'n',
		'feature_forum_quickjump' => 'n',
		'feature_forums_allow_thread_titles' => 'n',
		'feature_forum_content_search' => 'y',
		'feature_forums_name_search' => 'y',
		'forums_ordering' => 'created_desc',
		'forum_list_topics' =>  'n',
		'forum_list_posts' =>  'y',
		'forum_list_ppd' =>  'n',
		'forum_list_lastpost' =>  'y',
		'forum_list_visits' =>  'y',
		'forum_list_desc' =>  'y',
		'forum_list_description_len' => '240',
		'feature_forum_local_search' => 'n',
		'feature_forum_local_tiki_search' => 'n',
		'forum_thread_defaults_by_forum' => 'n',
		'forum_thread_user_settings' => 'y',
		'forum_thread_user_settings_threshold' => 10,
		'forum_thread_user_settings_keep' => 'n',
		'forum_comments_per_page' => 20,
		'forum_comments_no_title_prefix' => 'n',
		'forum_thread_style' => 'commentStyle_plain',
		'forum_thread_sort_mode' => 'commentDate_asc',
		'forum_match_regex' => '',
		'forum_reply_notitle' => 'n',

		// articles
		'feature_articles' => 'n',
		'feature_submissions' => 'n',
		'feature_cms_rankings' => 'n',
		'feature_cms_print' => 'y',
		'feature_cms_emails' => 'n',
		'feature_cms_sharethis' => 'n',
		'art_sort_mode' => 'publishDate_desc',
		'art_list_title' => 'y',
		'art_list_title_len' => '50',
		'art_list_id' => 'y',
		'art_list_topic' => 'y',
		'art_list_date' => 'y',
		'art_list_author' => 'y',
		'art_list_rating' => 'n',
		'art_list_reads' => 'y',
		'art_list_size' => 'y',
		'art_list_expire' => 'n',
		'art_list_img' => 'n',
		'art_list_type' => 'y',
		'art_list_visible' => 'n',
		'art_view_type' => 'y',
		'art_view_title' => 'y',
		'art_view_topic' => 'y',
		'art_view_date' => 'y',
		'art_view_author' => 'y',
		'art_view_reads' => 'y',
		'art_view_size' => 'n',
		'art_view_img' => 'y',
		'art_list_lang' => 'n',
		'art_trailer_pos' => 'top',
		'art_header_text_pos' => 'next',
		'feature_article_comments' => 'n',
		'article_comments_default_ordering' => 'points_desc',
		'article_comments_per_page' => 10,
		'article_paginate' => 'n',
		'article_user_rating' => 'n',
		'article_user_rating_options' => range( 1, 5 ),
		'article_image_size_x' => '0',
		'article_image_size_y' => '0',
		'article_custom_attributes' => 'y',
		'article_sharethis_publisher' => '',
		'feature_cms_templates' => 'n',
		'cms_bot_bar' => 'y',
		'cms_left_column' => 'y',
		'cms_right_column' => 'y',
		'cms_top_bar' => 'n',
		'art_home_title' => '',


		// trackers
		'feature_trackers' => 'n',
		't_use_db' => 'y',
		't_use_dir' => '',
		'groupTracker' => 'n',
		'userTracker' => 'n',
		'trackerCreatorGroupName' => ' ',

		// user
		'user_selector_threshold' => 50,
		'user_selector_realnames_tracker' => 'n',
		'user_selector_realnames_messu' => 'n',
		'feature_userlevels' => 'n',
		'userlevels' => function_exists('tra') ? array('1'=>tra('Simple'),'2'=>tra('Advanced')) : array('1'=>'Simple','2'=>'Advanced'),
		'userbreadCrumb' => 4,
		'user_assigned_modules' => 'n',
		'user_flip_modules' => 'module',
		'user_show_realnames' => 'n',
		'user_store_file_gallery_picture' => 'n',
		'user_picture_gallery_id' => 0,
		'user_who_viewed_my_stuff' => 'n',
		'user_who_viewed_my_stuff_days' => 90,
		'user_who_viewed_my_stuff_show_others' => 'n',
		'user_register_prettytracker' => 'n',
		'user_register_prettytracker_tpl' => '',
		'user_trackersync_trackers' => '',
		'user_trackersync_realname' => '',
		'user_trackersync_geo' => 'n',
		'user_trackersync_groups' => 'n',
		'user_trackersync_parentgroup' => -1,
		'feature_mytiki' => 'n',
		'feature_userPreferences' => 'n',
		'feature_user_bookmarks' => 'n',
		'feature_tasks' => 'n',
		'w_use_db' => 'y',
		'w_use_dir' => '',
		'w_displayed_default' => 'n',
		'uf_use_db' => 'y',
		'uf_use_dir' => '',
		'userfiles_quota' => 30,
		'feature_usermenu' => 'n',
		'feature_minical' => 'n',
		'feature_notepad' => 'n',
		'feature_userfiles' => 'n',
		'feature_community_gender' => 'n',
		'feature_community_mouseover' => 'n',
		'feature_community_mouseover_name' => 'y',
		'feature_community_mouseover_gender' => 'y',
		'feature_community_mouseover_picture' => 'y',
		'feature_community_mouseover_friends' => 'y',
		'feature_community_mouseover_score' => 'y',
		'feature_community_mouseover_country' => 'y',
		'feature_community_mouseover_email' => 'y',
		'feature_community_mouseover_lastlogin' => 'y',
		'feature_community_mouseover_distance' => 'y',
		'feature_community_list_name' => 'y',
		'feature_community_list_score' => 'y',
		'feature_community_list_country' => 'y',
		'feature_community_list_distance' => 'y',
		'feature_community_friends_permission' => 'n',
		'feature_community_friends_permission_dep' => '2',
		'change_language' => 'y',
		'change_theme' => 'n',
		'login_is_email' => 'n',
		'login_is_email_obscure' => 'n',
		'validateUsers' => 'y',
		'validateEmail' => 'n',
		'forgotPass' => 'y',
		'change_password' => 'y',
		'available_languages' => array(),
		'available_styles' => array(),
		'lowercase_username' => 'n',
		'username_pattern' => '/^[ \'\-_a-zA-Z0-9@\.]*$/',
		'max_username_length' => '50',
		'min_username_length' => '1',
		'users_serve_avatar_static' => 'y',
		'users_prefs_allowMsgs' => 'y',
		'users_prefs_country' => '',
		'users_prefs_diff_versions' => 'n',
		'users_prefs_display_timezone' => 'Local',
		'users_prefs_email_is_public' => 'n',
		'users_prefs_homePage' => '',
		'users_prefs_lat' => '0',
		'users_prefs_lon' => '0',
		'users_prefs_mess_archiveAfter' => '0',
		'users_prefs_mess_maxRecords' => '10',
		'users_prefs_mess_sendReadStatus' => 'n',
		'users_prefs_minPrio' => '3',
		'users_prefs_mytiki_blogs' => 'y',
		'users_prefs_mytiki_articles' => 'y',
		'users_prefs_mytiki_gals' => 'y',
		'users_prefs_mytiki_items' => 'y',
		'users_prefs_mytiki_msgs' => 'y',
		'users_prefs_mytiki_pages' => 'y',
		'users_prefs_mytiki_tasks' => 'y',
		'users_prefs_mytiki_forum_topics' => 'y',
		'users_prefs_mytiki_forum_replies' => 'y',
		'users_prefs_realName' => '',
		'users_prefs_gender' => '',
		'users_prefs_show_mouseover_user_info' => 'n',
		'users_prefs_tasks_maxRecords' => '10',
		'users_prefs_user_dbl' => 'n',
		'users_prefs_user_information' => 'private',
		'users_prefs_userbreadCrumb' => '4',
		'users_prefs_mailCharset' => 'utf-8',
		'users_prefs_mailCurrentAccount' => '0',
		'validateRegistration' => 'n',
		'validator_emails' => '',
		'url_after_validation' => '',
		'urlOnUsername' => '',

		// user messages
		'feature_messages' => 'n',
		'messu_mailbox_size' => '0',
		'messu_archive_size' => '200',
		'messu_sent_size' => '200',
		'allowmsg_by_default' => 'y',
		'allowmsg_is_optional' => 'y',

		// freetags
		'feature_freetags' => 'n',
		'freetags_browse_show_cloud' => 'y',
		'freetags_cloud_colors' => '',
		'freetags_preload_random_search' => 'y',
		'freetags_browse_amount_tags_in_cloud' => '100',
		'freetags_browse_amount_tags_suggestion' => '10',
		'freetags_normalized_valid_chars' => '',
		'freetags_lowercase_only' => 'y',
		'freetags_feature_3d' => 'n',
		'freetags_3d_width' => 500,
		'freetags_3d_height' => 500,
		'freetags_3d_navigation_depth' => 1,
		'freetags_3d_feed_animation_interval' => 500,
		'freetags_3d_existing_page_color' => '#00CC55',
		'freetags_3d_missing_page_color' => '#FF5555',
		'freetags_3d_autoload' => 'false',
		'freetags_3d_camera_distance' => '200',
		'freetags_3d_elastic_constant' => '0.5f',
		'freetags_3d_eletrostatic_constant' => '1000f',
		'freetags_3d_fov' => '250',
		'freetags_3d_friction_constant' => '0.4f',
		'freetags_3d_node_charge' => '1',
		'freetags_3d_node_mass' => '5',
		'freetags_3d_node_size' => '30',
		'freetags_3d_spring_size' => '100',
		'freetags_3d_text_size' => '40',
		'freetags_3d_adjust_camera' => 'false',
		'freetags_multilingual' => 'n',
		'morelikethis_algorithm' => 'basic',
		'morelikethis_basic_mincommon' => '2',
		'freetags_show_middle' => 'y',

		// search
		'feature_search_stats' => 'n',
		'feature_search' => 'n',
		'feature_search_fulltext' => 'n',
		'feature_search_show_forbidden_obj' => 'n',
		'feature_search_show_forbidden_cat' => 'n',
		'feature_search_show_object_filter' => 'n',
		'feature_search_show_search_box' => 'y',
		'feature_search_show_visit_count' => 'n',
		'feature_search_show_pertinence' => 'n',
		'feature_search_show_object_type' => 'n',
		'feature_search_show_last_modification' => 'y',
		'search_refresh_index_mode' => 'normal',
		'search_parsed_snippet' => 'y',
		'search_default_where' => '',
		'search_default_interface_language' => 'n',
		'search_autocomplete' => 'n',

		// webmail
		'feature_webmail' => 'n',
		'webmail_max_attachment' => 1500000,
		'webmail_view_html' => 'y',
		'webmail_quick_flags' => 'n',

		// contacts
		'feature_contacts' => 'n',

		// faq
		'feature_faqs' => 'n',
		'feature_faq_comments' => 'y',
		'faq_comments_per_page' => 10,
		'faq_comments_default_ordering' => 'points_desc',
		'faq_prefix' => 'QA',

		// quizzes
		'feature_quizzes' => 'n',

		// polls
		'feature_polls' => 'n',
		'feature_poll_comments' => 'n',
		'feature_poll_anonymous' => 'n',
		'poll_comments_default_ordering' => 'points_desc',
		'poll_comments_per_page' => 10,
		'poll_list_categories' => 'n',
		'poll_list_objects' => 'n',
		'poll_multiple_per_object' => 'n',
		'feature_poll_revote' => 'y',

		// surveys
		'feature_surveys' => 'n',

		// featured links
		'feature_featuredLinks' => 'n',

		// directories
		'feature_directory' => 'n',
		'directory_columns' => 3,
		'directory_links_per_page' => 20,
		'directory_open_links' => 'n',
		'directory_validate_urls' => 'n',
		'directory_cool_sites' => 'y',
		'directory_country_flag' => 'y',

		// calendar
		'feature_calendar' => 'n',
		'feature_default_calendars' => 'n',
		'calendar_sticky_popup' => 'n',
		'default_calendars' => array(),
		'calendar_view_mode' => 'month',
		'calendar_view_tab' => 'n',
		'calendar_firstDayofWeek' => 'user',
		'calendar_timespan' => '5',
		'feature_jscalendar' => 'y',
		'feature_action_calendar' => 'n',
		'calendar_start_year' => '-3',
		'calendar_end_year' => '+5',
		'calendar_list_begins_focus' => 'n',
		'feature_cal_manual_time' => 'n',
		'calendar_view_days' => array(0,1,2,3,4,5,6),
		'calendar_addtogooglecal' => 'n',

		// dates
		'server_timezone' => isset($tikidate) ? $tikidate->getTimezoneId() : 'UTC',
		'long_date_format' => '%A %d of %B, %Y',
		'long_time_format' => '%H:%M:%S %Z',
		'short_date_format' => '%Y-%m-%d',
		'short_time_format' => '%H:%M',
		'display_field_order' => 'MDY',
		'tiki_same_day_time_only' => 'y',

		// feed
		'feed_basic_auth' => 'n',
		'feed_cache_time' => '0', // 0 = disabled (default)
		'feed_default_version' => '5',
		'feed_atom_author_name' => '',
		'feed_atom_author_email' => '',
		'feed_atom_author_url' => '',
		'feed_img' => 'img/tiki/Tiki_WCG.png',
		'feed_rss_editor_email' => '',
		'feed_rss_webmaster_email' => '',
		'feed_language' =>  'en-us',
		'feed_articles' => 'n',
		'feed_articles_desc' => tra('Last articles.'),
		'feed_articles_homepage' => '',
		'feed_articles_max' => 10,
		'feed_articles_showAuthor' => 'n',
		'feed_articles_title' => tra('Tiki RSS feed for articles'),
		'feed_blog' => 'n',
		'feed_blog_desc' => '',
		'feed_blog_homepage' => '',
		'feed_blog_max' => 10,
		'feed_blog_showAuthor' => 'n',
		'feed_blog_title' => '',
		'feed_blogs' => 'n',
		'feed_blogs_desc' => tra('Last posts to weblogs.'),
		'feed_blogs_homepage' => '',
		'feed_blogs_max' => 10,
		'feed_blogs_showAuthor' => 'n',
		'feed_blogs_title' => tra('Tiki RSS feed for weblogs'),
		'feed_calendar' => 'n',
		'feed_calendar_desc' => tra('Upcoming events.'),
		'feed_calendar_homepage' => '',
		'feed_calendar_max' => 10,
		'feed_calendar_showAuthor' => 'n',
		'feed_calendar_title' => tra('Tiki RSS feed for calendars'),
		'feed_directories' => 'n',
		'feed_directories_desc' => tra('Last sites.'),
		'feed_directories_homepage' => '',
		'feed_directories_max' => 10,
		'feed_directories_showAuthor' => 'n',
		'feed_directories_title' => tra('Tiki RSS feed for directory sites'),
		'feed_file_galleries' => 'n',
		'feed_file_galleries_desc' => tra('Last files uploaded to the file galleries.'),
		'feed_file_galleries_homepage' => '',
		'feed_file_galleries_max' => 10,
		'feed_file_galleries_showAuthor' => 'n',
		'feed_file_galleries_title' => tra('Tiki RSS feed for file galleries'),
		'feed_file_gallery' => 'n',
		'feed_file_gallery_desc' => tra('Last files uploaded to this file gallery. '),
		'feed_file_gallery_homepage' => '',
		'feed_file_gallery_max' => 10,
		'feed_file_gallery_showAuthor' => 'n',
		'feed_file_gallery_title' => tra('Tiki RSS feed for the file gallery: '),
		'feed_forum' => 'n',
		'feed_forum_desc' => tra('Last posts to this forum. '),
		'feed_forum_homepage' => '',
		'feed_forum_max' => 10,
		'feed_forum_showAuthor' => 'n',
		'feed_forum_title' => tra('Tiki RSS feed for forum: '),
		'feed_forums_max' => 10,
		'feed_forums' => 'n',
		'feed_forums_desc' => tra('Last topics in forums.'),
		'feed_forums_showAuthor' => 'n',
		'feed_forums_title' => tra('Tiki RSS feed for forums'),
		'feed_image_galleries' => 'n',
		'feed_image_galleries_desc' => tra('Last images uploaded to the image galleries.'),
		'feed_image_galleries_homepage' => '',
		'feed_image_galleries_max' => 10,
		'feed_image_galleries_showAuthor' => 'n',
		'feed_image_galleries_title' => tra('Tiki RSS feed for image galleries'),
		'feed_image_gallery' => 'n',
		'feed_image_gallery_desc' => tra('Last images uploaded to this image gallery. '),
		'feed_image_gallery_homepage' => '',
		'feed_image_gallery_max' => 10,
		'feed_image_gallery_showAuthor' => 'n',
		'feed_image_gallery_title' => tra('Tiki RSS feed for the image gallery: '),
		'feed_maps' => 'n',
		'feed_maps_desc' => '',
		'feed_maps_homepage' => '',
		'feed_maps_max' => '',
		'feed_maps_showAuthor' => 'n',
		'feed_maps_title' => '',
		'feed_shoutbox' => '',
		'feed_shoutbox_desc' => tra('Last shoutbox messages.'),
		'feed_shoutbox_homepage' => '',
		'feed_shoutbox_max' => '',
		'feed_shoutbox_showAuthor' => '',
		'feed_shoutbox_title' => tra('Tiki RSS feed for shoutbox messages'),
		'feed_tracker' => 'n',
		'feed_tracker_desc' => tra('Last items published on this tracker.'),
		'feed_tracker_homepage' => '',
		'feed_tracker_max' => 10,
		'feed_tracker_showAuthor' => 'n',
		'feed_tracker_title' => tra('Tiki RSS feed for individual trackers: '),
		'feed_trackers' => 'n',
		'feed_trackers_desc' => '',
		'feed_trackers_homepage' => '',
		'feed_trackers_max' => 10,
		'feed_trackers_showAuthor' => 'n',
		'feed_trackers_title' => '',
		'feed_wiki' => 'n',
		'feed_wiki_desc' => tra('Last modifications to the Wiki.'),
		'feed_wiki_homepage' => '',
		'feed_wiki_max' => 10,
		'feed_wiki_showAuthor' => 'n',		
		'feed_wiki_title' => tra('Tiki RSS feed for the wiki pages'),
		'max_rss_mapfiles' => 10,
		'rss_mapfiles' => 'n',
		'title_rss_mapfiles' => '',

	
		// maps
		'feature_maps' => 'n',
		'map_path' => '',
		'default_map' => '',
		'map_help' => 'MapsHelp',
		'map_comments' => 'MapsComments',
		'gdaltindex' => '',
		'ogr2ogr' => '',
		'mapzone' => '180',

		// gmap
		'feature_gmap' => 'n',
		'gmap_defaultx' => '0',
		'gmap_defaulty' => '0',
		'gmap_defaultz' => '1',
		'gmap_key' => '',
		'gmap_article_list' => 'n',
		'gmap_page_list' => 'n',

		// auth
		'allowRegister' => 'n',
		'eponymousGroups' => 'n',
		'useRegisterPasscode' => 'n',
		'registerPasscode' => isset($tikilib) ? md5($tikilib->genPass()) : md5(mt_rand()),
		'rememberme' => 'disabled',
		'remembertime' => 7200,
		'feature_clear_passwords' => 'n',
		'feature_crypt_passwords' => (CRYPT_MD5 == 1)? 'crypt-md5': 'tikihash',
		'feature_challenge' => 'n',
		'min_user_length' => 1,
		'min_pass_length' => 5,
		'pass_chr_num' => 'n',
		'pass_due' => -1,
		'email_due' => -1,
		'unsuccessful_logins' => 20,
		'generate_password' => 'n',
		'auth_method' => 'tiki',
		'auth_pear' => 'tiki',
		'auth_ldap_url' => '',
		'auth_pear_host' => "localhost",
		'auth_pear_port' => "389",
		'auth_ldap_scope' => "sub",
		'auth_ldap_basedn' => '',
		'auth_ldap_userdn' => '',
		'auth_ldap_userattr' => 'uid',
		'auth_ldap_useroc' => 'inetOrgPerson',
		'auth_ldap_groupdn' => '',
		'auth_ldap_groupattr' => 'cn',
		'auth_ldap_groupnameatr' => '',
		'auth_ldap_groupdescatr' => '',
		'auth_ldap_usergroupattr' => '',
		'auth_ldap_groupgroupattr' => '',
		'auth_ldap_groupoc' => 'groupOfUniqueNames',
		'auth_ldap_memberattr' => 'uniqueMember',
		'auth_ldap_memberisdn' => 'y',
		'auth_ldap_adminuser' => '',
		'auth_ldap_adminpass' => '',
		'auth_ldap_version' => 3,
		'auth_ldap_nameattr' => 'displayName',
		'auth_ldap_countryattr' => '',
		'auth_ldap_emailattr' => '',
		// some more ldap prefs that weren't being initialised here
		// some look like duplicates to me (jb aug 09)
		'ldap_create_user_tiki' => 'n',
		'ldap_create_user_ldap' => 'n',
		'ldap_skip_admin' => 'y',
		'auth_ldap_permit_tiki_users' => 'n',
		'auth_ldap_debug' => 'n',
		'auth_ldap_ssl' => 'n',
		'auth_ldap_starttls' => 'n',
		'auth_ldap_type' => 'default',
		'auth_ldap_syncuserattr' => 'uid',
		'auth_ldap_syncgroupattr' => 'cn',
		
		'auth_phpbb_version' => 3,
		'auth_phpbb_skip_admin' => 'y',
		'auth_phpbb_create_tiki' => 'n',
		'auth_phpbb_dbhost' => '',
		'auth_phpbb_dbport' => '',
		'auth_phpbb_disable_tikionly' => 'n',
		'auth_phpbb_dbuser' => '',
		'auth_phpbb_dbpasswd' => '',
		'auth_phpbb_dbname' => '',
		'auth_phpbb_dbtype' => 'mysql',
		'auth_phpbb_table_prefix' => 'phpbb_',

		'auth_ws_create_tiki' => 'n',

		'https_login' => 'allowed',
		'https_external_links_for_users' => 'n',
		'feature_show_stay_in_ssl_mode' => 'y',
		'feature_switch_ssl_mode' => 'n',
		'https_port' => 443,
		'http_port' => 80,
		'login_url' => 'tiki-login.php',
		'login_scr' => 'tiki-login_scr.php',
		'register_url' => 'tiki-register.php',
		'error_url' => 'tiki-error.php',
		'highlight_group' => '0',
		'cookie_path' => $GLOBALS['tikiroot'],
		'cookie_domain' => '',
		'cookie_name' => 'tikiwiki',
		'user_tracker_infos' => '',
		'desactive_login_autocomplete' => 'n',
		'permission_denied_login_box' => 'n',
		'permission_denied_url' => '',
		'feature_loadbalancer' => 'n',

		// intertiki
		'feature_intertiki' => 'n',
		'feature_intertiki_server' => 'n',
		'feature_intertiki_slavemode' => 'n',
		'interlist' => array(),
		'feature_intertiki_mymaster' => '',
		'feature_intertiki_import_preferences' => 'n',
		'feature_intertiki_import_groups' => 'n',
		'known_hosts' => array(),
		'tiki_key' => '',
		'intertiki_logfile' => '',
		'intertiki_errfile' => '',
		'feature_intertiki_sharedcookie' => 'n',

		// search
		'search_lru_length' => '100',
		'search_lru_purge_rate' => '5',
		'search_max_syllwords' => '100',
		'search_min_wordlength' => '3',
		'search_refresh_rate' => '5',
		'search_syll_age' => '48',

		// categories
		'feature_categories' => 'n',
		'feature_categoryobjects' => 'n',
		'feature_categorypath' => 'n',
		'feature_category_use_phplayers' => 'n',
		'categorypath_excluded' => '',
		'categories_used_in_tpl' => 'n',
		'category_jail' => array(''), //empty string needed to keep preference from setting unexpectedly
		'category_defaults' => false,
		'category_i18n_sync' => 'n',
		'category_i18n_synced' => array(''), //empty string needed to keep preference from setting unexpectedly
		'category_i18n_unsynced' => array(),
		'category_autogeocode_within' => '',
		'category_autogeocode_replace' => 'n',
		'category_autogeocode_fudge' => 'n',
		'expanded_category_jail' => '',
		'expanded_category_jail_key' => '',
		'ws_container' => 0,

		// html pages
		'feature_html_pages' => 'n',

		// use filegals for image inclusion
		'feature_filegals_manager' => 'y',

		// contact & mail
		'feature_contact' => 'n',
		'contact_user' => 'admin',
		'contact_anon' => 'n',
		'mail_crlf' => 'LF',

		// i18n
		'feature_detect_language' => 'n',
		'feature_homePage_if_bl_missing' => 'n',
		'record_untranslated' => 'n',
		'feature_best_language' => 'n',
		'feature_translation' => 'n',
		'feature_urgent_translation' => 'n',
		'feature_urgent_translation_master_only' => 'n',
		'feature_translation_incomplete_notice' => 'y',
		'lang_use_db' => 'n',
		'language' => 'en',
		'restrict_language' => 'n',
		'feature_babelfish' => 'n',
		'feature_babelfish_logo' => 'n',
		'quantify_changes' => 'n',
		'feature_sync_language' => 'n',
		'show_available_translations' =>'y',
		'language_inclusion_threshold' => 3,

		// html header
		'metatag_keywords' => '',
		'metatag_threadtitle' => 'n',
		'metatag_imagetitle' => 'n',
		'metatag_freetags' => 'n',
		'metatag_description' => '',
		'metatag_pagedesc' => 'n',
		'metatag_author' => '',
		'metatag_geoposition' => '',
		'metatag_georegion' => '',
		'metatag_geoplacename' => '',
		'metatag_robots' => '',
		'metatag_revisitafter' => '',
		'head_extra_js' => array(),
		'keep_versions' => 1,
		'feature_custom_home' => 'n',

		// look and feel

		'site_crumb_seper' => '»',
		'site_nav_seper' => '|',
		'feature_sitemycode' => 'y',
		'sitemycode' => '{if $tiki_p_admin == "y"}
<div id="quickadmin" style="text-align: left; padding-left: 12px;"><small>{tr}Quick Admin{/tr}</small>:
{icon _id=database_refresh title="{tr}Clear all Tiki caches{/tr}" href="tiki-admin_system.php?do=all"}
{icon _id=wrench title="{tr}Modify the look &amp; feel (logo, theme, etc.){/tr}" href="tiki-admin.php?page=look&amp;cookietab=2"} 
{if $prefs.lang_use_db eq "y"}{icon _id=world_edit title="{tr}Show interactive translation settings{/tr}" href="tiki-edit_languages.php?interactive_translation_mode=on"}{/if}
{if $prefs.feature_comments_moderation eq "y"}
	{icon _id=comments title="{tr}Comments Moderation{/tr}" href="tiki-list_comments.php"}
{/if}
{icon _id=plugin title="{tr}Plugin Approval{/tr}" href="tiki-plugins.php"}
</div>  
{/if}',
		'sitemycode_publish' => 'n',
		'feature_sitelogo' => 'y',
		'sitelogo_bgcolor' => 'transparent',
		'sitelogo_bgstyle' => '',
		'sitelogo_align' => 'left',
		'sitelogo_title' => 'Tiki powered site',
		'sitelogo_src' => 'img/tiki/Tiki_WCG.png',
		'sitelogo_alt' => 'Site Logo',
		'feature_siteloc' => 'y',
		'feature_sitenav' => 'n',
		'sitenav' => '{tr}Navigation : {/tr}<a href="tiki-contact.php" accesskey="10" title="">{tr}Contact Us{/tr}</a>',
		'feature_sitead' => 'y',
		'sitead' => '',
		'sitead_publish' => 'n',
		'feature_breadcrumbs' => 'n',
		'feature_siteloclabel' => 'y',
		'feature_sitesearch' => 'y',
		'feature_site_login' => 'y',
		'feature_sitemenu' => 'n',
		'feature_sitemenu_custom_code' => '',
		'feature_secondary_sitemenu_custom_code' => '',
		'feature_topbar_version' => 'n',
		'feature_topbar_id_menu' => '42',
		'feature_topbar_custom_code' => '',
		'feature_sitetitle' => 'y',
		'feature_sitedesc' => 'n',
		'feature_bot_logo' => 'n',
		'feature_endbody_code' => '',
		'feature_custom_doctype' => 'n',
		'feature_custom_doctype_content' => '<!DOCTYPE html 
	PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',
		'feature_custom_html_head_content' => '{if $prefs.feature_secondary_sitemenu_custom_code ne ""}<style type="text/css">#sitelogo img {literal}{margin-top: 0; position: relative; top: -12px;}{/literal}</style>{/if}',
		'feature_fixed_width' => 'y',
		'feature_html_head_base_tag' => 'n',

		// layout
		'feature_left_column' => 'y',
		'feature_right_column' => 'y',
		'feature_top_bar' => 'y',
		'feature_bot_bar' => 'y',
		'feature_bot_bar_icons' => 'n',
		'feature_bot_bar_debug' => 'n',
		'feature_bot_bar_rss' => 'y',
		'feature_bot_bar_power_by_tw' => 'y',
		'maxRecords' => 25,
		'maxArticles' => 10,
		'maxVersions' => 0,
		'feature_view_tpl' => 'n',
		'slide_style' => 'slidestyle.css',
		'site_favicon' => 'favicon.png',
		'site_favicon_type' => 'image/png',
		'style' => 'fivealive.css',
		'style_option' => '',
		'use_context_menu_icon' => 'y',
		'use_context_menu_text' => 'y',
		'feature_site_report' => 'n',
		'feature_site_send_link' => 'n',
		'feature_layoutshadows' => 'n',
		'main_shadow_start' => '',
		'main_shadow_end' => '',
		'header_shadow_start' => '',
		'header_shadow_end' => '',
		'middle_shadow_start' => '',
		'middle_shadow_end' => '',
		'center_shadow_start' => '',
		'center_shadow_end' => '',
		'footer_shadow_start' => '',
		'footer_shadow_end' => '',
		'box_shadow_start' => '',
		'box_shadow_end' => '',
		'feature_custom_center_column_header' => '',
		'header_custom_css' => '',
		'header_custom_js' => '',

		// mods
		'feature_mods_provider' => 'n',
		'mods_dir' => 'mods',
		'mods_server' => 'http://mods.tiki.org',

		// dev
		'feature_experimental' => 'n',

		// Action logs
		'feature_actionlog' => 'n',
		'feature_actionlog_bytes' => 'n',

		// admin
		'browsertitle' => '',
		'site_title_location' => 'none',
		'site_title_breadcrumb' => 'invertfull',
		'tmpDir' => 'temp',

		// tell a friend
		'feature_tell_a_friend' => 'n',
		'feature_share' => 'n',

		// copyright
		'feature_copyright' => 'n',

		// textarea
		'feature_smileys' => 'y',
		'popupLinks' => 'y',
		'feature_autolinks' => 'y',
		'default_rows_textarea_wiki' => '20',
		'default_rows_textarea_comment' => '6',
		'default_rows_textarea_forum' => '20',
		'default_rows_textarea_forumthread' => '10',
		'section_comments_parse' => 'y',		// parse wiki markup on comments in all sections

		// toolbars
		// comma delimited items, / delimited rows and | denotes items right justified in toolbar (in reverse order)
		// full list in lib/toolbars/toolbarslib.php Toolbar::getList()
		// cannot contain spaces, commas, forward-slash or pipe chars
		'toolbar_global' => '
			bold,italic,underline,strike, sub, sup,-,color,-,wikiplugin_img,tikiimage,wikiplugin_file,tikilink,link, unlink, anchor,-,
			undo, redo,-,find,replace,-, removeformat,specialchar,smiley|help,switcheditor,autosave/
			templates, cut, copy, paste, pastetext, pasteword,-,h1,h2,h3, left,center,-,
			blockquote,list,numlist,wikiplugin_mouseover,wikiplugin_module,wikiplugin_html, outdent, indent,-,
			pagebreak,rule,-,table,-,wikiplugin_code, source, showblocks,nonparsed|fullscreen/
			format,style,-,fontname,fontsize/
		',
		'toolbar_global_comments' => '
			bold, italic, underline, strike , - , link, smiley | help
		',
		'toolbar_sheet' => 'addrow,addrowbefore,addrowmulti,deleterow,-,addcolumn,addcolumnbefore,addcolumnmulti,deletecolumn,-,
							sheetgetrange,sheetrefresh,-,sheetfind|sheetclose,sheetsave,help/
							bold,italic,underline,strike,center,-,color,bgcolor,-,tikilink,nonparsed|fullscreen/',

		// pagination
		'direct_pagination' => 'y',
		'nextprev_pagination' => 'y',
		'pagination_firstlast' => 'y',
		'pagination_hide_if_one_page' => 'y',
		'pagination_icons' => 'y',
		'pagination_fastmove_links' => 'y',
		'direct_pagination_max_middle_links' => 2,
		'direct_pagination_max_ending_links' => 0,

		// kaltura
		'feature_kaltura' => 'n',
		'wikiplugin_kaltura' => 'y',
		'wikiplugininline_kaltura' => 'n',
		'default_kaltura_editor' => 'kse',
		'partnerId' => '',
		'secret' => '',
		'adminSecret' => '',		
		'kdpUIConf' => '1913592',
		'kdpWidget' => '',
		'kcwUIConf' => '1913682',
		'kseUIConf' => '2434291',
		'kaeUIConf' => '1000865',
		'kuser' => $url_host,
		'kServiceUrl' => 'http://www.kaltura.com/',

		// BigBlueButton
		'bigbluebutton_feature' => 'n',
		'bigbluebutton_server_location' => '',
		'bigbluebutton_server_salt' => '',

		// Shipping
		'shipping_service' => 'n',

		'shipping_fedex_enable' => 'n',
		'shipping_fedex_key' => '',
		'shipping_fedex_password' => '',
		'shipping_fedex_meter' => '',
		'shipping_fedex_account' => '',

		'shipping_ups_enable' => 'n',
		'shipping_ups_username' => '',
		'shipping_ups_password' => '',
		'shipping_ups_license' => '',

		// ReCaptcha
		'recaptcha_enabled' => 'n',
		'recaptcha_pubkey' => '',
		'recaptcha_privkey' => '',
		// Captcha
		'captcha_wordLen' => 6,
		'captcha_width' => 180,
		'captcha_noise' => 100,

		// unsorted features
		'anonCanEdit' => 'n',
		'cacheimages' => 'n',
		'cachepages' => 'n',
		'count_admin_pvs' => 'n',
		'default_mail_charset' =>'utf-8',
		'error_reporting_adminonly' => 'y',
		'error_reporting_level' => 2039,	//	E_ALL & ~E_NOTICE
		'smarty_notice_reporting' => 'n',
		'smarty_security' => 'y',
		'smarty_compilation' => 'modified',
		'feature_htmlpurifier_output' => 'n',
		'feature_ajax' => 'y',
		'ajax_autosave' => 'y',
		'ajax_xajax' => 'n',
		'feature_antibot' => 'y',
		'feature_banners' => 'n',
		'feature_banning' => 'n',
		'feature_comm' => 'n',
		'feature_contribution' => 'n',
		'feature_contribution_display_in_comment' => 'y',
		'feature_contribution_mandatory' => 'n',
		'feature_contribution_mandatory_blog' => 'n',
		'feature_contribution_mandatory_comment' => 'n',
		'feature_contribution_mandatory_forum' => 'n',
		'feature_credits' => 'n',
		'feature_debug_console' => 'n',
		'feature_debugger_console' => 'n',
		'feature_display_my_to_others' => 'n',
		'feature_dynamic_content' => 'n',
		'feature_edit_templates' => 'n',
		'feature_editcss' => 'n',
		'feature_events' => 'n',
		'feature_friends' => 'n',
		'feature_fullscreen' => 'n',
		'feature_help' => 'y',
		'feature_hotwords' => 'n',
		'feature_hotwords_nw' => 'n',
		'feature_integrator' => 'n',
		'feature_live_support' => 'n',
		'feature_mailin' => 'n',
		'feature_menusfolderstyle' => 'y',
		'feature_mobile' => 'n',
		'feature_modulecontrols' => 'n',
		'feature_morcego' => 'n',
		'feature_multilingual' => 'n',
		'feature_multilingual_one_page' => 'n',
		'feature_multilingual_structures' => 'n',
		'feature_machine_translation' => 'n',
		'feature_newsletters' => 'n',
		'feature_obzip' => 'n',
		'feature_perspective' => 'n', // If enabling by default, update further in this file
		'feature_phplayers' => 'n',
		'feature_cssmenus' => 'y',
		'menus_item_names_raw' => 'n',
		'feature_projects' => 'n',
		'feature_ranking' => 'n',
		'feature_redirect_on_error' => 'n',
		'url_anonymous_page_not_found' => '',
		'feature_referer_highlight' => 'n',
		'feature_referer_stats' => 'n',
		'feature_score' => 'n',
		'feature_sheet' => 'n',
		'feature_shoutbox' => 'n',
		'feature_source' => 'y',
		'feature_stats' => 'n',
		'feature_tabs' => 'y',
		'feature_theme_control' => 'n',
		'feature_ticketlib' => 'n',
		'feature_ticketlib2' => 'y',
		'feature_top_banner' => 'n',
		'feature_usability' => 'n',
		'feature_use_quoteplugin' => 'n',
		'feature_use_three_colon_centertag' => 'n',
		'feature_user_watches' => 'n',
		'feature_group_watches' => 'n',
		'feature_user_watches_translations' => 'n',
		'feature_user_watches_languages' => 'n',
		'feature_daily_report_watches' => 'n',
		'feature_quick_object_perms' => 'n',
		'feature_xmlrpc' => 'n',
		'feature_watershed' => 'n',
		'helpurl' => "http://doc.tiki.org/",
		'layout_section' => 'n',
		'limitedGoGroupHome' => 'y',
		'minical_reminders' => 0,
		'modallgroups' => 'n',
		'modseparateanon' => 'n',
		'modhideanonadmin' => 'n',
		'php_docroot' => 'http://php.net/',
		'proxy_host' => '',
		'proxy_port' => '',
		'ip_can_be_checked' => 'n',
		'sender_email' => '',
		'feature_site_report_email' => '',
		'session_storage' => 'default',
		'session_lifetime' => 0,
		'session_silent' => 'n',
		'session_cookie_name' => session_name(),
		'session_protected' => 'n',
		'shoutbox_autolink' => 'n',
		'show_comzone' => 'n',
		'tikiIndex' => 'tiki-index.php',
		'urlIndex' => '',
		'useGroupHome' => 'n',
		'useGroupTheme' => 'n',
		'useUrlIndex' => 'n',
		'use_proxy' => 'n',
		'user_list_order' => 'score_desc',
		'webserverauth' => 'n',
		'feature_purifier' => 'y',
		'feature_shadowbox' => 'y',
		'log_sql' => 'n',
		'log_sql_perf_min' => '0.05',
		'log_mail' => 'n',
		'log_tpl' => 'n',
		'disableJavascript' => 'n',
		'feature_socialnetworks' => 'n',
		'socialnetworks_twitter_consumer_key' =>'',
		'socialnetworks_twitter_consumer_secret' => '',
		'socialnetworks_facebook_api_key' =>'',
		'socialnetworks_facebook_application_secr' => '',
		'socialnetworks_facebook_application_id' => '',
		'socialnetworks_bitly_login' => '',
		'socialnetworks_bitly_key' => '',
		'socialnetworks_bitly_sitewide' => 'n',
	
		'case_patched' => 'n',
		'site_closed' => 'n',
		'site_closed_msg' => 'Site is closed for maintenance; please come back later.',
		'use_load_threshold' => 'n',
		'load_threshold' => 3,
		'site_busy_msg' => 'Server is currently too busy; please come back later.',

		'bot_logo_code' => '',
		'feature_create_webhelp' => 'n',
		'page_n_times_in_a_structure' => 'n',
		'feature_forums_search' => 'n',
		'feature_wiki_ext_icon' => 'y',
		'feature_wiki_ext_rel_nofollow' => 'y',
		'feature_wiki_mandatory_category' => -1,
		'feature_intertiki_imported_groups' => '',
		'feature_wiki_history_ip' => 'n',
		'pam_create_user_tiki' => 'n',
		'pam_service' => '',
		'pam_skip_admin' => 'n',
		'shib_affiliation' => '',
		'shib_create_user_tiki' => 'n',
		'shib_group' => 'Shibboleth',
		'shib_skip_admin' => 'n',
		'shib_usegroup' => 'n',
		'wiki_3d_camera_distance' => '200',
		'wiki_3d_elastic_constant' => '0.3f',
		'wiki_3d_eletrostatic_constant' => '1000f',
		'wiki_3d_fov' => '250',
		'wiki_3d_friction_constant' => '0.8f',
		'wiki_3d_node_charge' => '1',
		'wiki_3d_node_mass' => '5',
		'wiki_3d_node_size' => '15',
		'wiki_3d_spring_size' => '100',
		'wiki_3d_text_size' => '20',
		'articles_feature_copyrights' => 'n',
		'blogues_feature_copyrights' => 'n',
		'faqs_feature_copyrights' => 'n',
		'feature_contributor_wiki' => '',
		'https_login_required' => '',
		'maxRowsGalleries' => '',
		'replimaster' => '',
		'rowImagesGalleries' => '',
		'scaleSizeGalleries' => '',
		'thumbSizeXGalleries' => '',
		'thumbSizeYGalleries' => '',
		'wiki_3d_adjust_camera' => 'true',
		'wiki_3d_autoload' => '',
		'javascript_enabled' => 'n',
		'javascript_cdn' => 'none',
		'feature_template_zoom' => 'y',
		'menus_items_icons' => 'n',
		'menus_items_icons_path' => 'pics/large',
		'feature_iepngfix' => 'n',
		'iepngfix_selectors' => '#sitelogo a img',
		'iepngfix_elements' => '',
		'feature_invite' => 'n',
		
		// JQuery
		'feature_jquery' => 'y',			// Default JS lib for - now "hard-wired" on if javascript_enabled
		'jquery_effect' => '',				// Default effect for general show/hide: ['' | 'slide' | 'fade' | and
											// see http://docs.jquery.com/UI/Effects: 'blind' | 'clip' | 'explode' etc]
		'jquery_effect_direction' => 'vertical', 	// ['horizontal' | 'vertical' | 'left' | 'right' | 'up' | 'down' ]
		'jquery_effect_speed' => 'normal', 	// ['slow' | 'normal' | 'fast' | milliseconds (int) ]
		'jquery_effect_tabs' => 'slide',	// Different effect for tabs (['none' | 'normal' (for jq) | 'slide' etc]
		'jquery_effect_tabs_direction' => 'vertical',
		'jquery_effect_tabs_speed' => 'fast',

		'feature_jquery_ui' => 'y',				// include UI lib for more effects
		'feature_jquery_ui_theme' => 'smoothness',	// theme for UI lib (see http://jqueryui.com/themeroller/ for list & demos - previously ui-darkness)
		'feature_jquery_tooltips' => 'y',		// use JQuery tooltips and override Overlib
		'feature_jquery_autocomplete' => 'y',	// autocomplete on pages in QuickEdit (more coming soon)
		'feature_jquery_superfish' => 'y',		// Effects on CSS (Suckerfish) menus
		'feature_jquery_reflection' => 'n',		// reflection effects on images
		'feature_jquery_jqs5' => 'n',			// slide-show TODO: implement (more)
		'feature_jquery_tablesorter' => 'n',	// sortable tables ([will] override existing)
		'feature_jquery_carousel' => 'n',		// slideshow/carousel for file gals etc
		'feature_jquery_validation' => 'y',		// validation on Trackers etc
		'feature_jquery_media' => 'n',	

		// SefUrl
		'feature_sefurl' => 'n',
		'feature_sefurl_filter' => 'n',
		'feature_sefurl_paths' => array(''), //empty string needed to keep preference from setting unexpectedly
		'feature_sefurl_title_article' =>'n',
		'feature_sefurl_title_blog' =>'n',
		'feature_sefurl_tracker_prefixalias' =>'n',

		// TikiTests
		'feature_tikitests' => 'n',

		// Tiki Profiles
		'profile_sources' => 'http://profiles.tiki.org/profiles',
		'profile_channels' => '',

		// Minichat
		'feature_minichat' => 'n',

		// Memcache
		'memcache_enabled' => 'n',
		'memcache_compress' => 'y',
		'memcache_servers' => false,
		'memcache_expiration' => 3600,
		'memcache_prefix' => 'tiki_',
		'memcache_wiki_data' => 'y',
		'memcache_wiki_output' => 'y',
		'memcache_forum_output' => 'y',

		// Pear::Date
		'feature_pear_date' => 'y',

		'feature_bidi' => 'n',
		'feature_lastup' => 'y',

		//groupalert
		'feature_groupalert' => 'n',

		'zend_mail_handler' => 'sendmail',
		'zend_mail_smtp_server' => '',
		'zend_mail_smtp_auth' => '',
		'zend_mail_smtp_user' => '',
		'zend_mail_smtp_pass' => '',
		'zend_mail_smtp_port' => 25,
		'zend_mail_smtp_security' => '',

		// Transitions
		'feature_group_transition' => 'n',
		'feature_category_transition' => 'n',


		'terminology_profile_installed' => 'n',


		// Multidomain
		'multidomain_active' => 'n',
		'multidomain_config' => '',

		'tiki_minify_javascript' => 'n',
		'tiki_minify_css' => 'n',
		'tiki_minify_css_single_file' => 'n',
		'tiki_cachecontrol_session' => '',
		'tiki_cachecontrol_nosession' => '',
		'tiki_cdn' => '',
		'tiki_cdn_ssl' => '',

		// Token Access
		'auth_token_access' => 'n',
		'auth_token_access_maxtimeout' => 3600*24*7,
		'auth_token_access_maxhits' => 10,
		'auth_token_tellafriend' => 'n',
		'auth_token_share' => 'n',
	
		// PDF
		'print_pdf_from_url' => 'none',
		'print_pdf_webkit_path' => '',
		'print_pdf_webservice_url' => '',

		// Metrics
		'feature_metrics_dashboard' => 'n',
		'metrics_trend_prefix' => '(',
		'metrics_trend_suffix' => '%)',
		'metrics_trend_novalue' => '(N/A)',
		'metrics_pastresults_count' => 50,
		'metrics_metric_name_length' => 255,
		'metrics_tab_name_length' => 255,
		'metrics_cache_output' => 'y',

		// Payment
		'payment_feature' => 'n',
		'payment_system' => 'paypal',
		'payment_currency' => 'USD',
		'payment_default_delay' => 30,
		'payment_paypal_business' => '',
		'payment_paypal_environment' => 'https://www.paypal.com/cgi-bin/webscr',
		'payment_paypal_ipn' => 'y',
		'payment_cclite_registries' => '',
		'payment_cclite_currencies' => '',
	 	'payment_cclite_gateway' => '',
		'payment_cclite_merchant_key' => '',
		'payment_cclite_merchant_user' => 'manager',
		'payment_cclite_mode' => 'test',
		'payment_cclite_notify' => 'y',
		'payment_cclite_hashing_algorithm' => 'sha1',
		'payment_manual' => '',
		'payment_invoice_prefix' => '',

		// Rating
		'rating_advanced' => 'n',
		'rating_recalculation' => 'vote',
		'rating_recalculation_odd' => '100',
		'rating_recalculation_count' => '100',

		// CAS
		'cas_create_user_tiki' => 'n',
		'cas_create_user_tiki_ldap' => 'n',
		'cas_autologin' => 'n',
		'cas_skip_admin' => 'n',
		'cas_show_alternate_login' => 'y',
		'cas_version' => '1.0',
		'cas_hostname' => '',
		'cas_port' => '',
		'cas_path' => '',
		'cas_extra_param' => '',
		'cas_authentication_timeout' => '0',
		'cas_force_logout' => 'n',

		// Comments
		'feature_comments_post_as_anonymous' => 'n',
		'feature_comments_moderation' => 'n',
		'feature_comments_locking' => 'n',
		'comments_notitle' => 'y',
		'comments_field_email' => 'n',
		'comments_field_website' => 'n',
		'comments_vote' => 'n',
	);

	// Special default values

	global $tikidomain;
	if ( is_file('styles/'.$tikidomain.'/'.$prefs['site_favicon']) )
		$prefs['site_favicon'] = 'styles/'.$tikidomain.'/'.$prefs['site_favicon'];
	elseif ( ! is_file($prefs['site_favicon']) )
		$prefs['site_favicon'] = false;

	$_SESSION['tmpDir'] = class_exists('TikiInit') ? TikiInit::tempdir() : '/tmp';

	$prefs['feature_bidi'] = 'n';
	$prefs['feature_lastup'] = 'y';

	// Be sure we have a default value for user prefs
	foreach ( $prefs as $p => $v ) {
		if ( substr($p, 0, 12) == 'users_prefs_' ) {
			$prefs[substr($p, 12)] = $v;
		}
	}

	$cachelib->cacheItem("tiki_default_preferences_cache",serialize($prefs));
	return $prefs;
}


function initialize_prefs() {
	// Initialize prefs for which we want to use the site value (they will be prefixed with 'site_')
	// ( this is also used in tikilib, not only when reloading prefs )
	
	global $prefs, $tikiroot, $tikilib, $user_overrider_prefs;
		
	// Check if prefs needs to be reloaded
	if (isset($_SESSION['s_prefs'])) {

		// lastUpdatePrefs pref is retrived in tiki-setup_base
		$lastUpdatePrefs = $prefs['lastUpdatePrefs'];

		// Reload if there was an update of some prefs
		if ( empty($_SESSION['s_prefs']['lastReadingPrefs']) || $lastUpdatePrefs > $_SESSION['s_prefs']['lastReadingPrefs'] ) {
			$_SESSION['need_reload_prefs'] = true;
		} else {
			$_SESSION['need_reload_prefs'] = false;
		}

		// Reload if the virtual host or tikiroot has changed
		if (!isset($_SESSION['lastPrefsSite'])) $_SESSION['lastPrefsSite'] = '';
		//   (this is needed when using the same php sessions for more than one tiki)
		if ( $_SESSION['lastPrefsSite'] != $_SERVER['SERVER_NAME'].'|'.$tikiroot ) {
			$_SESSION['lastPrefsSite'] = $_SERVER['SERVER_NAME'].'|'.$tikiroot;
			$_SESSION['need_reload_prefs'] = true;
		}

	} else {
		$_SESSION['need_reload_prefs'] = true;
	}

	$defaults = get_default_prefs();
	// Set default prefs only if needed
	if ( ! $_SESSION['need_reload_prefs'] ) {
		$modified = $_SESSION['s_prefs'];
	} else {

		// Find which preferences need to be serialized/unserialized, based on the default values (those with arrays as values)
		if ( ! isset($_SESSION['serialized_prefs']) ) {
			$_SESSION['serialized_prefs'] = array();
			foreach ( $defaults as $p => $v )
			if ( is_array($v) ) $_SESSION['serialized_prefs'][] = $p;
		}

		// Override default prefs with values specified in database
		$modified = isset($tikilib) ? $tikilib->get_db_preferences() : "";

		// Unserialize serialized preferences
		if ( isset($_SESSION['serialized_prefs']) && is_array($_SESSION['serialized_prefs']) ) {
			foreach ( $_SESSION['serialized_prefs'] as $p ) {
				if ( isset($modified[$p]) && ! is_array($modified[$p]) ) $modified[$p] = unserialize($modified[$p]);
			}
		}

		// Keep some useful sites values available before overriding with user prefs
		// (they could be used in templates, so we need to set them even for Anonymous)
		foreach ( $user_overrider_prefs as $uop ) {
			$modified['site_'.$uop] = isset($modified[$uop])?$modified[$uop]:$defaults[$uop];
		}

		// Assign prefs to the session
		$_SESSION['s_prefs'] = $modified;
	}

	// Disabled by default so it has to be modified
	if( isset($modified['feature_perspective']) && $modified['feature_perspective'] == 'y' ) {
		if( ! isset( $section ) || $section != 'admin' ) {
			require_once 'lib/perspectivelib.php';
			if( $persp = $perspectivelib->get_current_perspective( $modified ) ) {
				$changes = $perspectivelib->get_preferences( $persp );
				$modified = array_merge( $modified, $changes );
			}
		}
	}

	$prefs = empty($modified) ? $defaults : array_merge( $defaults, $modified );
}
