<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\MyBusinessVerifications;

class AddressVerificationData extends \Google\Model
{
  protected $addressType = PostalAddress::class;
  protected $addressDataType = '';
  public $business;
  public $expectedDeliveryDaysRegion;

  /**
   * @param PostalAddress
   */
  public function setAddress(PostalAddress $address)
  {
    $this->address = $address;
  }
  /**
   * @return PostalAddress
   */
  public function getAddress()
  {
    return $this->address;
  }
  public function setBusiness($business)
  {
    $this->business = $business;
  }
  public function getBusiness()
  {
    return $this->business;
  }
  public function setExpectedDeliveryDaysRegion($expectedDeliveryDaysRegion)
  {
    $this->expectedDeliveryDaysRegion = $expectedDeliveryDaysRegion;
  }
  public function getExpectedDeliveryDaysRegion()
  {
    return $this->expectedDeliveryDaysRegion;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AddressVerificationData::class, 'Google_Service_MyBusinessVerifications_AddressVerificationData');
