/*----------------------------------------------------------------------------*/
/*                                                                            */
/* Copyright (c) 1995, 2004 IBM Corporation. All rights reserved.             */
/* Copyright (c) 2005-2017 Rexx Language Association. All rights reserved.    */
/*                                                                            */
/* This program and the accompanying materials are made available under       */
/* the terms of the Common Public License v1.0 which accompanies this         */
/* distribution. A copy is also available at the following address:           */
/* https://www.oorexx.org/license.html                                        */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or                 */
/* without modification, are permitted provided that the following            */
/* conditions are met:                                                        */
/*                                                                            */
/* Redistributions of source code must retain the above copyright             */
/* notice, this list of conditions and the following disclaimer.              */
/* Redistributions in binary form must reproduce the above copyright          */
/* notice, this list of conditions and the following disclaimer in            */
/* the documentation and/or other materials provided with the distribution.   */
/*                                                                            */
/* Neither the name of Rexx Language Association nor the names                */
/* of its contributors may be used to endorse or promote products             */
/* derived from this software without specific prior written permission.      */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS          */
/* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT   */
/* OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,      */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,        */
/* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY     */
/* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING    */
/* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS         */
/* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.               */
/*                                                                            */
/*----------------------------------------------------------------------------*/
/******************************************************************************/
/* REXX  Support                                                              */
/*                                                                            */
/*                                                                            */
/* Error subcodes                                                             */
/*                                                                            */
/*   Note: The base codes are defined in document ANSI X3.274-1996            */
/*         ANS for Information Technology - Programming Language REXX         */
/*                                                                            */
/*        -- file is generated by build process                 --            */
/*        -- DO NOT CHANGE THIS FILE, ALL CHANGES WILL BE LOST! --            */
/******************************************************************************/

#ifndef ooRexxErrorCodes_Included
#define ooRexxErrorCodes_Included

/* error subcodes and message numbers                                         */
/*      message identifier ----------------------------------- message number */
   
#define Rexx_Error_Program_unreadable                                     3000
#define Rexx_Error_Program_unreadable_name                                3001
#define Rexx_Error_Program_unreadable_user_defined                        3900
#define Rexx_Error_Program_unreadable_notfound                            3901
#define Rexx_Error_Program_unreadable_output_error                        3902
#define Rexx_Error_Program_unreadable_version                             3903
#define Rexx_Error_Program_unreadable_invalid_encoding                    3905
#define Rexx_Error_Program_interrupted                                    4000
#define Rexx_Error_Program_interrupted_condition                          4001
#define Rexx_Error_Program_interrupted_user_defined                       4900
#define Rexx_Error_System_resources                                       5000
#define Rexx_Error_System_resources_user_defined                          5900
#define Rexx_Error_Unmatched_quote                                        6000
#define Rexx_Error_Unmatched_quote_comment                                6001
#define Rexx_Error_Unmatched_quote_single                                 6002
#define Rexx_Error_Unmatched_quote_double                                 6003
#define Rexx_Error_Unmatched_quote_user_defined                           6900
#define Rexx_Error_When_expected                                          7000
#define Rexx_Error_When_expected_when                                     7001
#define Rexx_Error_When_expected_whenotherwise                            7002
#define Rexx_Error_When_expected_nootherwise                              7003
#define Rexx_Error_Unexpected_then                                        8000
#define Rexx_Error_Unexpected_then_then                                   8001
#define Rexx_Error_Unexpected_then_else                                   8002
#define Rexx_Error_Unexpected_when                                        9000
#define Rexx_Error_Unexpected_when_when                                   9001
#define Rexx_Error_Unexpected_when_otherwise                              9002
#define Rexx_Error_Unexpected_end                                         10000
#define Rexx_Error_Unexpected_end_nodo                                    10001
#define Rexx_Error_Unexpected_end_control                                 10002
#define Rexx_Error_Unexpected_end_nocontrol                               10003
#define Rexx_Error_Unexpected_end_select                                  10004
#define Rexx_Error_Unexpected_end_then                                    10005
#define Rexx_Error_Unexpected_end_else                                    10006
#define Rexx_Error_Unexpected_end_select_nolabel                          10007
#define Rexx_Error_Control_stack                                          11000
#define Rexx_Error_Control_stack_full                                     11001
#define Rexx_Error_Control_stack_user_defined                             11900
#define Rexx_Error_Invalid_character                                      13000
#define Rexx_Error_Invalid_character_char                                 13001
#define Rexx_Error_Invalid_character_user_defined                         13900
#define Rexx_Error_Incomplete_do                                          14000
#define Rexx_Error_Incomplete_do_do                                       14001
#define Rexx_Error_Incomplete_do_select                                   14002
#define Rexx_Error_Incomplete_do_then                                     14003
#define Rexx_Error_Incomplete_do_else                                     14004
#define Rexx_Error_Incomplete_do_loop                                     14005
#define Rexx_Error_Incomplete_do_otherwise                                14901
#define Rexx_Error_Invalid_hex                                            15000
#define Rexx_Error_Invalid_hex_hexblank                                   15001
#define Rexx_Error_Invalid_hex_binblank                                   15002
#define Rexx_Error_Invalid_hex_invhex                                     15003
#define Rexx_Error_Invalid_hex_invbin                                     15004
#define Rexx_Error_Invalid_hex_invhex_group                               15005
#define Rexx_Error_Invalid_hex_invbin_group                               15006
#define Rexx_Error_Label_not_found                                        16000
#define Rexx_Error_Label_not_found_name                                   16001
#define Rexx_Error_Unexpected_procedure                                   17000
#define Rexx_Error_Unexpected_procedure_call                              17001
#define Rexx_Error_Unexpected_procedure_interpret                         17901
#define Rexx_Error_Then_expected                                          18000
#define Rexx_Error_Then_expected_if                                       18001
#define Rexx_Error_Then_expected_when                                     18002
#define Rexx_Error_Symbol_or_string                                       19000
#define Rexx_Error_Symbol_or_string_address                               19001
#define Rexx_Error_Symbol_or_string_call                                  19002
#define Rexx_Error_Symbol_or_string_name                                  19003
#define Rexx_Error_Symbol_or_string_signal                                19004
#define Rexx_Error_Symbol_or_string_trace                                 19006
#define Rexx_Error_Symbol_or_string_parse                                 19007
#define Rexx_Error_Symbol_or_string_user_defined                          19900
#define Rexx_Error_Symbol_or_string_class                                 19901
#define Rexx_Error_Symbol_or_string_method                                19902
#define Rexx_Error_Symbol_or_string_routine                               19903
#define Rexx_Error_Symbol_or_string_requires                              19904
#define Rexx_Error_Symbol_or_string_external                              19905
#define Rexx_Error_Symbol_or_string_metaclass                             19906
#define Rexx_Error_Symbol_or_string_subclass                              19907
#define Rexx_Error_Symbol_or_string_inherit                               19908
#define Rexx_Error_Symbol_or_string_tilde                                 19909
#define Rexx_Error_Symbol_or_string_colon                                 19911
#define Rexx_Error_Symbol_or_string_stream                                19912
#define Rexx_Error_Symbol_or_string_mixinclass                            19913
#define Rexx_Error_Symbol_or_string_attribute                             19914
#define Rexx_Error_Symbol_or_string_constant                              19915
#define Rexx_Error_Symbol_or_string_constant_value                        19916
#define Rexx_Error_Symbol_or_string_digits_value                          19917
#define Rexx_Error_Symbol_or_string_fuzz_value                            19918
#define Rexx_Error_Symbol_or_string_trace_value                           19919
#define Rexx_Error_Symbol_or_string_resource                              19920
#define Rexx_Error_Symbol_or_string_resource_end                          19921
#define Rexx_Error_Symbol_or_string_keyword                               19922
#define Rexx_Error_Symbol_or_string_package_attribute_bad_value           19923
#define Rexx_Error_Symbol_or_string_package_attribute_missing             19924
#define Rexx_Error_Symbol_or_string_directive_option                      19925
#define Rexx_Error_Symbol_expected                                        20000
#define Rexx_Error_Symbol_expected_user_defined                           20900
#define Rexx_Error_Symbol_expected_drop                                   20901
#define Rexx_Error_Symbol_expected_expose                                 20902
#define Rexx_Error_Symbol_expected_parse                                  20903
#define Rexx_Error_Symbol_expected_var                                    20904
#define Rexx_Error_Symbol_expected_numeric                                20905
#define Rexx_Error_Symbol_expected_varref                                 20906
#define Rexx_Error_Symbol_expected_leave                                  20907
#define Rexx_Error_Symbol_expected_iterate                                20908
#define Rexx_Error_Symbol_expected_end                                    20909
#define Rexx_Error_Symbol_expected_on                                     20911
#define Rexx_Error_Symbol_expected_off                                    20912
#define Rexx_Error_Symbol_expected_use                                    20913
#define Rexx_Error_Symbol_expected_raise                                  20914
#define Rexx_Error_Symbol_expected_user                                   20915
#define Rexx_Error_Symbol_expected_directive                              20916
#define Rexx_Error_Symbol_expected_colon                                  20917
#define Rexx_Error_Symbol_expected_LABEL                                  20918
#define Rexx_Error_Symbol_expected_annotation_attribute                   20919
#define Rexx_Error_Symbol_expected_namespace                              20920
#define Rexx_Error_Symbol_expected_namespace_class                        20921
#define Rexx_Error_Symbol_expected_qualified_call                         20922
#define Rexx_Error_Symbol_expected_qualified_symbol                       20923
#define Rexx_Error_Symbol_expected_annotation_type                        20924
#define Rexx_Error_Symbol_expected_form                                   20925
#define Rexx_Error_Symbol_expected_delegate                               20926
#define Rexx_Error_Symbol_expected_use_local                              20927
#define Rexx_Error_Symbol_expected_indirect                               20928
#define Rexx_Error_Symbol_expected_after_keyword                          20929
#define Rexx_Error_Symbol_expected_after_prefix_reference                 20930
#define Rexx_Error_Symbol_expected_after_use_arg_reference                20931
#define Rexx_Error_Symbol_expected_after_stem_keyword                     20932
#define Rexx_Error_Symbol_expected_address_with                           20933
#define Rexx_Error_Symbol_expected_counter                                20934
#define Rexx_Error_Invalid_data                                           21000
#define Rexx_Error_Invalid_data_user_defined                              21900
#define Rexx_Error_Invalid_data_nop                                       21901
#define Rexx_Error_Invalid_data_select                                    21902
#define Rexx_Error_Invalid_data_name                                      21903
#define Rexx_Error_Invalid_data_condition                                 21904
#define Rexx_Error_Invalid_data_signal                                    21905
#define Rexx_Error_Invalid_data_trace                                     21906
#define Rexx_Error_Invalid_data_leave                                     21907
#define Rexx_Error_Invalid_data_iterate                                   21908
#define Rexx_Error_Invalid_data_end                                       21909
#define Rexx_Error_Invalid_data_form                                      21911
#define Rexx_Error_Invalid_data_guard_off                                 21912
#define Rexx_Error_Invalid_data_constant_dir                              21913
#define Rexx_Error_Invalid_data_resource_dir                              21914
#define Rexx_Error_Invalid_character_string                               22000
#define Rexx_Error_Invalid_character_string_char                          22001
#define Rexx_Error_Invalid_character_string_user_defined                  22900
#define Rexx_Error_Invalid_character_string_DBCS                          22901
#define Rexx_Error_Invalid_data_string                                    23000
#define Rexx_Error_Invalid_data_string_char                               23001
#define Rexx_Error_Invalid_data_string_user_defined                       23900
#define Rexx_Error_Invalid_trace                                          24000
#define Rexx_Error_Invalid_trace_trace                                    24001
#define Rexx_Error_Invalid_trace_debug                                    24901
#define Rexx_Error_Invalid_subkeyword                                     25000
#define Rexx_Error_Invalid_subkeyword_callon                              25001
#define Rexx_Error_Invalid_subkeyword_calloff                             25002
#define Rexx_Error_Invalid_subkeyword_signalon                            25003
#define Rexx_Error_Invalid_subkeyword_signaloff                           25004
#define Rexx_Error_Invalid_subkeyword_form                                25011
#define Rexx_Error_Invalid_subkeyword_parse                               25012
#define Rexx_Error_Invalid_subkeyword_numeric                             25015
#define Rexx_Error_Invalid_subkeyword_procedure                           25017
#define Rexx_Error_Invalid_subkeyword_string_user_defined                 25900
#define Rexx_Error_Invalid_subkeyword_class                               25901
#define Rexx_Error_Invalid_subkeyword_method                              25902
#define Rexx_Error_Invalid_subkeyword_routine                             25903
#define Rexx_Error_Invalid_subkeyword_requires                            25904
#define Rexx_Error_Invalid_subkeyword_use                                 25905
#define Rexx_Error_Invalid_subkeyword_raise                               25906
#define Rexx_Error_Invalid_subkeyword_raiseoption                         25907
#define Rexx_Error_Invalid_subkeyword_description                         25908
#define Rexx_Error_Invalid_subkeyword_additional                          25909
#define Rexx_Error_Invalid_subkeyword_result                              25911
#define Rexx_Error_Invalid_subkeyword_guard_on                            25912
#define Rexx_Error_Invalid_subkeyword_guard                               25913
#define Rexx_Error_Invalid_subkeyword_callonname                          25914
#define Rexx_Error_Invalid_subkeyword_signalonname                        25915
#define Rexx_Error_Invalid_subkeyword_forward_option                      25916
#define Rexx_Error_Invalid_subkeyword_to                                  25917
#define Rexx_Error_Invalid_subkeyword_arguments                           25918
#define Rexx_Error_Invalid_subkeyword_continue                            25919
#define Rexx_Error_Invalid_subkeyword_forward_class                       25921
#define Rexx_Error_Invalid_subkeyword_message                             25922
#define Rexx_Error_Invalid_subkeyword_select                              25923
#define Rexx_Error_Invalid_subkeyword_options                             25924
#define Rexx_Error_Invalid_subkeyword_attribute                           25925
#define Rexx_Error_Invalid_subkeyword_resource                            25926
#define Rexx_Error_Invalid_subkeyword_following                           25927
#define Rexx_Error_Invalid_subkeyword_annotation                          25928
#define Rexx_Error_Invalid_subkeyword_use_strict                          25929
#define Rexx_Error_Invalid_subkeyword_address_input                       25930
#define Rexx_Error_Invalid_subkeyword_address_output                      25931
#define Rexx_Error_Invalid_subkeyword_address_error                       25932
#define Rexx_Error_Invalid_subkeyword_address_with_io_option              25933
#define Rexx_Error_Invalid_subkeyword_address_with_option                 25934
#define Rexx_Error_Invalid_whole_number                                   26000
#define Rexx_Error_Invalid_whole_number_repeat                            26002
#define Rexx_Error_Invalid_whole_number_for                               26003
#define Rexx_Error_Invalid_whole_number_parse                             26004
#define Rexx_Error_Invalid_whole_number_digits                            26005
#define Rexx_Error_Invalid_whole_number_fuzz                              26006
#define Rexx_Error_Invalid_whole_number_trace                             26007
#define Rexx_Error_Invalid_whole_number_power                             26008
#define Rexx_Error_Invalid_whole_number_intdiv                            26011
#define Rexx_Error_Invalid_whole_number_rem                               26012
#define Rexx_Error_Invalid_whole_number_user_defined                      26900
#define Rexx_Error_Invalid_whole_number_method                            26901
#define Rexx_Error_Invalid_whole_number_compareto                         26902
#define Rexx_Error_Invalid_whole_number_compare                           26903
#define Rexx_Error_Invalid_whole_number_stem_array_index                  26904
#define Rexx_Error_Invalid_do                                             27000
#define Rexx_Error_Invalid_do_whileuntil                                  27001
#define Rexx_Error_Invalid_do_forever                                     27901
#define Rexx_Error_Invalid_do_duplicate                                   27902
#define Rexx_Error_Invalid_do_with_no_control                             27903
#define Rexx_Error_Invalid_do_with_no_over                                27904
#define Rexx_Error_Invalid_do_simple_do_counter                           27905
#define Rexx_Error_Invalid_leave                                          28000
#define Rexx_Error_Invalid_leave_leave                                    28001
#define Rexx_Error_Invalid_leave_iterate                                  28002
#define Rexx_Error_Invalid_leave_leavevar                                 28003
#define Rexx_Error_Invalid_leave_iteratevar                               28004
#define Rexx_Error_Invalid_leave_iterate_name                             28005
#define Rexx_Error_Environment_name                                       29000
#define Rexx_Error_Environment_name_name                                  29001
#define Rexx_Error_Name_too_long                                          30000
#define Rexx_Error_Name_too_long_name                                     30001
#define Rexx_Error_Name_too_long_user_defined                             30900
#define Rexx_Error_Invalid_variable                                       31000
#define Rexx_Error_Invalid_variable_assign                                31001
#define Rexx_Error_Invalid_variable_number                                31002
#define Rexx_Error_Invalid_variable_period                                31003
#define Rexx_Error_Invalid_variable_user_defined                          31900
#define Rexx_Error_Expression_result                                      33000
#define Rexx_Error_Expression_result_digits                               33001
#define Rexx_Error_Expression_result_maxdigits                            33002
#define Rexx_Error_Expression_user_defined                                33900
#define Rexx_Error_Expression_result_address                              33901
#define Rexx_Error_Expression_result_signal                               33902
#define Rexx_Error_Expression_result_trace                                33903
#define Rexx_Error_Expression_result_raise                                33904
#define Rexx_Error_Logical_value                                          34000
#define Rexx_Error_Logical_value_if                                       34001
#define Rexx_Error_Logical_value_when                                     34002
#define Rexx_Error_Logical_value_while                                    34003
#define Rexx_Error_Logical_value_until                                    34004
#define Rexx_Error_Logical_value_logical                                  34005
#define Rexx_Error_Logical_value_logical_list                             34006
#define Rexx_Error_Logical_value_user_defined                             34900
#define Rexx_Error_Logical_value_method                                   34901
#define Rexx_Error_Logical_value_guard                                    34902
#define Rexx_Error_Logical_value_authorization                            34903
#define Rexx_Error_Logical_value_property                                 34904
#define Rexx_Error_Logical_value_when_case                                34905
#define Rexx_Error_Logical_value_supplier                                 34906
#define Rexx_Error_Invalid_expression                                     35000
#define Rexx_Error_Invalid_expression_general                             35001
#define Rexx_Error_Invalid_expression_user_defined                        35900
#define Rexx_Error_Invalid_expression_prefix                              35901
#define Rexx_Error_Invalid_expression_if                                  35902
#define Rexx_Error_Invalid_expression_when                                35903
#define Rexx_Error_Invalid_expression_control                             35904
#define Rexx_Error_Invalid_expression_by                                  35905
#define Rexx_Error_Invalid_expression_to                                  35906
#define Rexx_Error_Invalid_expression_for                                 35907
#define Rexx_Error_Invalid_expression_while                               35908
#define Rexx_Error_Invalid_expression_until                               35909
#define Rexx_Error_Invalid_expression_over                                35911
#define Rexx_Error_Invalid_expression_interpret                           35912
#define Rexx_Error_Invalid_expression_options                             35913
#define Rexx_Error_Invalid_expression_address                             35914
#define Rexx_Error_Invalid_expression_signal                              35915
#define Rexx_Error_Invalid_expression_trace                               35916
#define Rexx_Error_Invalid_expression_form                                35917
#define Rexx_Error_Invalid_expression_assign                              35918
#define Rexx_Error_Invalid_expression_operator                            35919
#define Rexx_Error_Invalid_expression_guard                               35921
#define Rexx_Error_Invalid_expression_raise_description                   35922
#define Rexx_Error_Invalid_expression_raise_additional                    35923
#define Rexx_Error_Invalid_expression_raise_list                          35924
#define Rexx_Error_Invalid_expression_forward_to                          35925
#define Rexx_Error_Invalid_expression_forward_arguments                   35926
#define Rexx_Error_Invalid_expression_forward_message                     35927
#define Rexx_Error_Invalid_expression_forward_class                       35928
#define Rexx_Error_Invalid_expression_logical_list                        35929
#define Rexx_Error_Invalid_expression_use_arg_default                     35930
#define Rexx_Error_Invalid_expression_parse                               35931
#define Rexx_Error_Invalid_expression_call                                35932
#define Rexx_Error_Invalid_expression_select_case                         35933
#define Rexx_Error_Invalid_expression_case_when_list                      35934
#define Rexx_Error_Invalid_expression_missing_general                     35935
#define Rexx_Error_Invalid_expression_missing_constant                    35936
#define Rexx_Error_Unmatched_parenthesis                                  36000
#define Rexx_Error_Unmatched_parenthesis_user_defined                     36900
#define Rexx_Error_Unmatched_parenthesis_paren                            36901
#define Rexx_Error_Unmatched_parenthesis_square                           36902
#define Rexx_Error_Unexpected_comma                                       37000
#define Rexx_Error_Unexpected_comma_comma                                 37001
#define Rexx_Error_Unexpected_comma_paren                                 37002
#define Rexx_Error_Unexpected_comma_user_defined                          37900
#define Rexx_Error_Unexpected_comma_bracket                               37901
#define Rexx_Error_Invalid_template                                       38000
#define Rexx_Error_Invalid_template_trigger                               38001
#define Rexx_Error_Invalid_template_position                              38002
#define Rexx_Error_Invalid_template_with                                  38003
#define Rexx_Error_Invalid_template_user_defined                          38900
#define Rexx_Error_Invalid_template_missing                               38901
#define Rexx_Error_Evaluation_stack_overflow                              39000
#define Rexx_Error_Incorrect_call                                         40000
#define Rexx_Error_Incorrect_call_external                                40001
#define Rexx_Error_Incorrect_call_minarg                                  40003
#define Rexx_Error_Incorrect_call_maxarg                                  40004
#define Rexx_Error_Incorrect_call_noarg                                   40005
#define Rexx_Error_Incorrect_call_number                                  40011
#define Rexx_Error_Incorrect_call_whole                                   40012
#define Rexx_Error_Incorrect_call_nonnegative                             40013
#define Rexx_Error_Incorrect_call_positive                                40014
#define Rexx_Error_Incorrect_call_format_invalid                          40019
#define Rexx_Error_Incorrect_call_null                                    40021
#define Rexx_Error_Incorrect_call_option                                  40022
#define Rexx_Error_Incorrect_call_pad                                     40023
#define Rexx_Error_Incorrect_call_binary                                  40024
#define Rexx_Error_Incorrect_call_hex                                     40025
#define Rexx_Error_Incorrect_call_symbol                                  40026
#define Rexx_Error_Incorrect_call_stream_name                             40027
#define Rexx_Error_Incorrect_call_pad_or_name                             40028
#define Rexx_Error_Incorrect_call_invalid_conversion                      40029
#define Rexx_Error_Incorrect_call_random_range                            40032
#define Rexx_Error_Incorrect_call_random                                  40033
#define Rexx_Error_Incorrect_call_sourceline                              40034
#define Rexx_Error_Incorrect_call_x2d                                     40035
#define Rexx_Error_Incorrect_call_parm_wrong_sep                          40043
#define Rexx_Error_Incorrect_call_format_incomp_sep                       40044
#define Rexx_Error_Incorrect_call_user_defined                            40900
#define Rexx_Error_Incorrect_call_result                                  40901
#define Rexx_Error_Incorrect_call_toobig                                  40902
#define Rexx_Error_Incorrect_call_range                                   40903
#define Rexx_Error_Incorrect_call_list                                    40904
#define Rexx_Error_Incorrect_call_trace                                   40905
#define Rexx_Error_Incorrect_call_array                                   40912
#define Rexx_Error_Incorrect_call_nostring                                40913
#define Rexx_Error_Incorrect_call_selector                                40914
#define Rexx_Error_Incorrect_call_queue_no_char                           40915
#define Rexx_Error_Incorrect_call_read_from_writeonly                     40916
#define Rexx_Error_Incorrect_call_write_to_readonly                       40917
#define Rexx_Error_Incorrect_call_signature                               40918
#define Rexx_Error_Incorrect_call_nostem                                  40919
#define Rexx_Error_Incorrect_call_bad_option                              40920
#define Rexx_Error_Incorrect_call_relative                                40921
#define Rexx_Error_Incorrect_call_stem_size                               40922
#define Rexx_Error_Incorrect_call_stem_range                              40923
#define Rexx_Error_Incorrect_call_stem_sparse_array                       40924
#define Rexx_Error_Incorrect_call_noarray_nostem                          40925
#define Rexx_Error_Conversion                                             41000
#define Rexx_Error_Conversion_operator                                    41001
#define Rexx_Error_Conversion_prefix                                      41003
#define Rexx_Error_Conversion_to                                          41004
#define Rexx_Error_Conversion_by                                          41005
#define Rexx_Error_Conversion_control                                     41006
#define Rexx_Error_Conversion_exponent                                    41007
#define Rexx_Error_Conversion_user_defined                                41900
#define Rexx_Error_Conversion_raise                                       41901
#define Rexx_Error_Overflow                                               42000
#define Rexx_Error_Overflow_overflow                                      42001
#define Rexx_Error_Overflow_underflow                                     42002
#define Rexx_Error_Overflow_zero                                          42003
#define Rexx_Error_Overflow_user_defined                                  42900
#define Rexx_Error_Overflow_expoverflow                                   42901
#define Rexx_Error_Overflow_expunderflow                                  42902
#define Rexx_Error_Overflow_power                                         42903
#define Rexx_Error_Routine_not_found                                      43000
#define Rexx_Error_Routine_not_found_name                                 43001
#define Rexx_Error_Routine_not_found_user_defined                         43900
#define Rexx_Error_Routine_not_found_requires                             43901
#define Rexx_Error_Routine_not_found_namespace                            43902
#define Rexx_Error_Function_no_data                                       44000
#define Rexx_Error_Function_no_data_function                              44001
#define Rexx_Error_Function_no_data_user_defined                          44900
#define Rexx_Error_No_data_on_return                                      45000
#define Rexx_Error_No_data_on_return_name                                 45001
#define Rexx_Error_Variable_reference                                     46000
#define Rexx_Error_Variable_reference_extra                               46001
#define Rexx_Error_Variable_reference_user_defined                        46900
#define Rexx_Error_Variable_reference_missing                             46901
#define Rexx_Error_Variable_reference_use                                 46902
#define Rexx_Error_Unexpected_label                                       47000
#define Rexx_Error_Unexpected_label_interpret                             47001
#define Rexx_Error_System_service                                         48000
#define Rexx_Error_System_service_service                                 48001
#define Rexx_Error_System_service_user_defined                            48900
#define Rexx_Error_Interpretation                                         49000
#define Rexx_Error_Interpretation_initialization                          49001
#define Rexx_Error_Interpretation_switch                                  49002
#define Rexx_Error_Interpretation_user_defined                            49900
#define Rexx_Error_Invalid_argument                                       88000
#define Rexx_Error_Invalid_argument_user_defined                          88900
#define Rexx_Error_Invalid_argument_noarg                                 88901
#define Rexx_Error_Invalid_argument_number                                88902
#define Rexx_Error_Invalid_argument_whole                                 88903
#define Rexx_Error_Invalid_argument_nonnegative                           88904
#define Rexx_Error_Invalid_argument_positive                              88905
#define Rexx_Error_Invalid_argument_toobig                                88906
#define Rexx_Error_Invalid_argument_range                                 88907
#define Rexx_Error_Invalid_argument_null                                  88908
#define Rexx_Error_Invalid_argument_string                                88909
#define Rexx_Error_Invalid_argument_pad                                   88910
#define Rexx_Error_Invalid_argument_length                                88911
#define Rexx_Error_Invalid_argument_position                              88912
#define Rexx_Error_Invalid_argument_noarray                               88913
#define Rexx_Error_Invalid_argument_noclass                               88914
#define Rexx_Error_Invalid_argument_argType                               88915
#define Rexx_Error_Invalid_argument_list                                  88916
#define Rexx_Error_Invalid_argument_general                               88917
#define Rexx_Error_Invalid_argument_format                                88918
#define Rexx_Error_Invalid_argument_pointer                               88919
#define Rexx_Error_Invalid_argument_nostem                                88920
#define Rexx_Error_Invalid_argument_double                                88921
#define Rexx_Error_Invalid_argument_maxarg                                88922
#define Rexx_Error_Invalid_argument_array                                 88923
#define Rexx_Error_Invalid_argument_array_size                            88924
#define Rexx_Error_Invalid_argument_nonnegative_number                    88925
#define Rexx_Error_Invalid_argument_positive_number                       88926
#define Rexx_Error_Invalid_argument_logical                               88927
#define Rexx_Error_Invalid_argument_variable_reference                    88928
#define Rexx_Error_Invalid_argument_variable_reference_stem               88929
#define Rexx_Error_Invalid_argument_variable_reference_simple             88930
#define Rexx_Error_Invalid_argument_no_reference                          88931
#define Rexx_Error_Invalid_argument_date_template                         88932
#define Rexx_Error_Invalid_argument_bad_date                              88933
#define Rexx_Error_Variable_expected                                      89000
#define Rexx_Error_Variable_expected_USE                                  89001
#define Rexx_Error_Variable_expected_PARSE                                89002
#define Rexx_Error_External_name_not_found                                90000
#define Rexx_Error_External_name_not_found_user_defined                   90900
#define Rexx_Error_External_name_not_found_class                          90997
#define Rexx_Error_External_name_not_found_method                         90998
#define Rexx_Error_External_name_not_found_routine                        90999
#define Rexx_Error_No_result_object                                       91000
#define Rexx_Error_No_result_object_user_defined                          91900
#define Rexx_Error_No_result_object_message                               91999
#define Rexx_Error_OLE_Error                                              92000
#define Rexx_Error_OLE_Error_user_defined                                 92900
#define Rexx_Error_Unknown_OLE_Error                                      92901
#define Rexx_Error_Variant2Rexx                                           92902
#define Rexx_Error_Rexx2Variant                                           92903
#define Rexx_Error_Argument_Count_Mismatch                                92904
#define Rexx_Error_Invalid_Variant                                        92905
#define Rexx_Error_OLE_Exception                                          92906
#define Rexx_Error_Unknown_OLE_Method                                     92907
#define Rexx_Error_Coercion_Failed_Overflow                               92908
#define Rexx_Error_Coercion_Failed_Type_Mismatch                          92909
#define Rexx_Error_Parameter_Omitted                                      92910
#define Rexx_Error_No_OLE_instance                                        92911
#define Rexx_Error_Client_Disconnected_From_Server                        92912
#define Rexx_Error_Incorrect_method                                       93000
#define Rexx_Error_Incorrect_method_user_defined                          93900
#define Rexx_Error_Incorrect_method_minarg                                93901
#define Rexx_Error_Incorrect_method_maxarg                                93902
#define Rexx_Error_Incorrect_method_noarg                                 93903
#define Rexx_Error_Incorrect_method_number                                93904
#define Rexx_Error_Incorrect_method_whole                                 93905
#define Rexx_Error_Incorrect_method_nonnegative                           93906
#define Rexx_Error_Incorrect_method_positive                              93907
#define Rexx_Error_Incorrect_method_toobig                                93908
#define Rexx_Error_Incorrect_method_range                                 93909
#define Rexx_Error_Incorrect_method_null                                  93911
#define Rexx_Error_Incorrect_method_hex                                   93912
#define Rexx_Error_Incorrect_method_symbol                                93913
#define Rexx_Error_Incorrect_method_list                                  93914
#define Rexx_Error_Incorrect_method_option                                93915
#define Rexx_Error_Incorrect_method_methodname                            93917
#define Rexx_Error_Incorrect_method_index                                 93918
#define Rexx_Error_Incorrect_method_array                                 93919
#define Rexx_Error_Incorrect_method_binary                                93921
#define Rexx_Error_Incorrect_method_pad                                   93922
#define Rexx_Error_Incorrect_method_length                                93923
#define Rexx_Error_Incorrect_method_position                              93924
#define Rexx_Error_Incorrect_method_minsub                                93925
#define Rexx_Error_Incorrect_method_maxsub                                93926
#define Rexx_Error_Incorrect_method_d2xd2c                                93927
#define Rexx_Error_Incorrect_method_d2x                                   93928
#define Rexx_Error_Incorrect_method_d2c                                   93929
#define Rexx_Error_Incorrect_method_hexblank                              93931
#define Rexx_Error_Incorrect_method_binblank                              93932
#define Rexx_Error_Incorrect_method_invhex                                93933
#define Rexx_Error_Incorrect_method_invbin                                93934
#define Rexx_Error_Incorrect_method_x2dbig                                93935
#define Rexx_Error_Incorrect_method_c2dbig                                93936
#define Rexx_Error_Incorrect_method_supplier                              93937
#define Rexx_Error_Incorrect_method_nostring                              93938
#define Rexx_Error_Incorrect_method_noarray                               93939
#define Rexx_Error_Incorrect_method_string_no_whole_number                93940
#define Rexx_Error_Incorrect_method_exponent_oversize                     93941
#define Rexx_Error_Incorrect_method_before_oversize                       93942
#define Rexx_Error_Incorrect_method_string_nonumber                       93943
#define Rexx_Error_Incorrect_method_nomessage                             93944
#define Rexx_Error_Incorrect_method_message_noarg                         93945
#define Rexx_Error_Incorrect_method_message                               93946
#define Rexx_Error_Incorrect_method_section                               93947
#define Rexx_Error_Incorrect_method_noclass                               93948
#define Rexx_Error_Incorrect_method_nomatch                               93949
#define Rexx_Error_Incorrect_method_time                                  93951
#define Rexx_Error_Incorrect_method_nostring_inarray                      93952
#define Rexx_Error_Incorrect_method_argType                               93953
#define Rexx_Error_Incorrect_method_array_dimension                       93954
#define Rexx_Error_Incorrect_method_array_nostring                        93956
#define Rexx_Error_Incorrect_method_array_noclass                         93957
#define Rexx_Error_Incorrect_method_stream_type                           93958
#define Rexx_Error_Incorrect_method_array_too_big                         93959
#define Rexx_Error_Incorrect_method_no_method                             93961
#define Rexx_Error_Incorrect_method_invbase64                             93962
#define Rexx_Error_Unsupported_method                                     93963
#define Rexx_Error_Application_error                                      93964
#define Rexx_Error_Incorrect_method_abstract                              93965
#define Rexx_Error_Incorrect_method_queue_index                           93966
#define Rexx_Error_Unsupported_new_method                                 93967
#define Rexx_Error_Incorrect_method_signature                             93968
#define Rexx_Error_Incorrect_method_nostem                                93969
#define Rexx_Error_Unsupported_copy_method                                93970
#define Rexx_Error_Incorrect_method_multi_dimension                       93971
#define Rexx_Error_Incorrect_method_message_name                          93972
#define Rexx_Error_Incorrect_method_nil_not_orderable                     93973
#define Rexx_Error_Incorrect_method_no_method_type                        93974
#define Rexx_Error_Incorrect_method_invalid_value_for                     93975
#define Rexx_Error_Incorrect_method_invhex_group                          93976
#define Rexx_Error_Incorrect_method_invbin_group                          93977
#define Rexx_Error_Incorrect_method_request_type                          93978
#define Rexx_Error_No_method                                              97000
#define Rexx_Error_No_method_name                                         97001
#define Rexx_Error_No_method_private                                      97002
#define Rexx_Error_No_method_package                                      97003
#define Rexx_Error_No_method_constant                                     97004
#define Rexx_Error_No_method_unhandled                                    97005
#define Rexx_Error_No_method_user_defined                                 97900
#define Rexx_Error_Execution                                              98000
#define Rexx_Error_Execution_user_defined                                 98900
#define Rexx_Error_Execution_noinit                                       98901
#define Rexx_Error_Execution_nodouble                                     98902
#define Rexx_Error_Execution_library                                      98903
#define Rexx_Error_Execution_terminate                                    98904
#define Rexx_Error_Execution_deadlock                                     98905
#define Rexx_Error_Execution_badobject                                    98906
#define Rexx_Error_Execution_wrongobject                                  98907
#define Rexx_Error_Execution_nometaclass                                  98908
#define Rexx_Error_Execution_noclass                                      98909
#define Rexx_Error_Execution_cyclic                                       98911
#define Rexx_Error_Execution_noarray                                      98913
#define Rexx_Error_Execution_nostring                                     98914
#define Rexx_Error_Execution_message_reuse                                98915
#define Rexx_Error_Execution_message_error                                98916
#define Rexx_Error_Execution_raise_object                                 98917
#define Rexx_Error_Execution_propagate                                    98918
#define Rexx_Error_Execution_nomethod                                     98919
#define Rexx_Error_Execution_file_not_writeable                           98920
#define Rexx_Error_Execution_address_redirection_not_supported            98921
#define Rexx_Error_Execution_using_rexxqueue_option                       98922
#define Rexx_Error_Execution_address_redirection_failed                   98923
#define Rexx_Error_Execution_address_input_source                         98924
#define Rexx_Error_Execution_reply                                        98935
#define Rexx_Error_Execution_reply_return                                 98936
#define Rexx_Error_Execution_reply_exit                                   98937
#define Rexx_Error_Execution_super                                        98938
#define Rexx_Error_Execution_syntax_additional                            98939
#define Rexx_Error_Execution_error_condition                              98941
#define Rexx_Error_Execution_mixinclass                                   98942
#define Rexx_Error_Execution_baseclass                                    98943
#define Rexx_Error_Execution_recursive_inherit                            98944
#define Rexx_Error_Execution_uninherit                                    98945
#define Rexx_Error_Execution_forward_arguments                            98946
#define Rexx_Error_Execution_forward                                      98947
#define Rexx_Error_Execution_authorization                                98948
#define Rexx_Error_Execution_no_concurrency                               98951
#define Rexx_Error_Execution_circular_requires                            98952
#define Rexx_Error_Execution_error_syntax                                 98970
#define Rexx_Error_Execution_failure_syntax                               98971
#define Rexx_Error_Execution_lostdigits_syntax                            98972
#define Rexx_Error_Execution_nostring_syntax                              98973
#define Rexx_Error_Execution_notready_syntax                              98974
#define Rexx_Error_Execution_sparse_array                                 98975
#define Rexx_Error_Execution_nostem                                       98976
#define Rexx_Error_Execution_library_method                               98978
#define Rexx_Error_Execution_library_routine                              98979
#define Rexx_Error_Execution_native_routine                               98980
#define Rexx_Error_Execution_context_not_active                           98981
#define Rexx_Error_Execution_library_version                              98982
#define Rexx_Error_Execution_invalid_thread                               98983
#define Rexx_Error_Execution_rexx_package_update                          98984
#define Rexx_Error_Execution_rexx_defined_class                           98985
#define Rexx_Error_Execution_unassigned_variable                          98986
#define Rexx_Error_Execution_no_namespace                                 98987
#define Rexx_Error_Execution_no_namespace_class                           98988
#define Rexx_Error_Execution_abstract_class                               98989
#define Rexx_Error_Execution_abstract_metaclass                           98990
#define Rexx_Error_Execution_private_access                               98991
#define Rexx_Error_Execution_expose_method                                98992
#define Rexx_Error_Execution_use_local_method                             98993
#define Rexx_Error_Execution_no_supplier                                  98994
#define Rexx_Error_Execution_reference_variable_in_use                    98995
#define Rexx_Error_Execution_address_output_target                        98996
#define Rexx_Error_Execution_using_stream_option                          98997
#define Rexx_Error_Execution_missing_stem_array_index                     98998
#define Rexx_Error_Execution_file_not_readable                            98999
#define Rexx_Error_Translation                                            99000
#define Rexx_Error_Translation_user_defined                               99900
#define Rexx_Error_Translation_duplicate_class                            99901
#define Rexx_Error_Translation_duplicate_method                           99902
#define Rexx_Error_Translation_duplicate_routine                          99903
#define Rexx_Error_Translation_duplicate_requires                         99904
#define Rexx_Error_Translation_missing_class                              99905
#define Rexx_Error_Translation_constant_no_class                          99906
#define Rexx_Error_Translation_expose                                     99907
#define Rexx_Error_Translation_expose_interpret                           99908
#define Rexx_Error_Translation_guard                                      99909
#define Rexx_Error_Translation_use_local                                  99910
#define Rexx_Error_Translation_guard_guard                                99911
#define Rexx_Error_Translation_guard_interpret                            99912
#define Rexx_Error_Translation_guard_expose                               99913
#define Rexx_Error_Translation_directive_interpret                        99914
#define Rexx_Error_Translation_use_local_interpret                        99915
#define Rexx_Error_Translation_bad_directive                              99916
#define Rexx_Error_Translation_bad_external                               99917
#define Rexx_Error_Translation_use_comma                                  99918
#define Rexx_Error_Translation_reply                                      99919
#define Rexx_Error_Translation_invalid_line                               99921
#define Rexx_Error_Translation_requires                                   99922
#define Rexx_Error_Translation_forward_interpret                          99923
#define Rexx_Error_Translation_reply_interpret                            99924
#define Rexx_Error_Translation_invalid_attribute                          99925
#define Rexx_Error_Translation_class_external_bad_parameters              99926
#define Rexx_Error_Translation_bad_metaclass                              99927
#define Rexx_Error_Translation_class_external_bad_class_name              99928
#define Rexx_Error_Translation_class_external_bad_class_server            99929
#define Rexx_Error_Translation_use_arg_ellipsis                           99930
#define Rexx_Error_Translation_duplicate_attribute                        99931
#define Rexx_Error_Translation_duplicate_constant                         99932
#define Rexx_Error_Translation_abstract_method                            99933
#define Rexx_Error_Translation_attribute_method                           99934
#define Rexx_Error_Translation_external_attribute                         99935
#define Rexx_Error_Translation_external_method                            99936
#define Rexx_Error_Translation_body_error                                 99937
#define Rexx_Error_Translation_constant_body                              99938
#define Rexx_Error_Translation_external_routine                           99939
#define Rexx_Error_Translation_abstract_attribute                         99940
#define Rexx_Error_Translation_directive_method_routine                   99941
#define Rexx_Error_Translation_duplicate_resource                         99942
#define Rexx_Error_Translation_missing_resource_end                       99943
#define Rexx_Error_Translation_reserved_namespace                         99944
#define Rexx_Error_Translation_missing_annotation_target                  99945
#define Rexx_Error_Translation_delegate_method                            99946
#define Rexx_Error_Translation_delegate_attribute                         99947
#define Rexx_Error_Translation_use_local_compound                         99948
#define Rexx_Error_Translation_bad_class                                  99949
#define Rexx_Error_Translation_use_arg_reference_no_default               99950


#endif

/* -------------------------------------------------------------------------- */
/* --            file is generated by build process                        -- */
/* --            ==================================================        -- */
/* --            DO NOT CHANGE THIS FILE, ALL CHANGES WILL BE LOST!        -- */
/* --            ==================================================        -- */
/* -------------------------------------------------------------------------- */
