/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionConfig$;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.MockScheduler;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\reb\u0001B\u0001\u0003\u0001%\u0011!\u0004\u0016:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN\u001d+fgRT!a\u0001\u0003\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003\u000b\u0019\t1bY8pe\u0012Lg.\u0019;pe*\tq!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\rC\u0003\u0012\u0001\u0011\u0005!#\u0001\u0004=S:LGO\u0010\u000b\u0002'A\u0011A\u0003A\u0007\u0002\u0005!9a\u0003\u0001b\u0001\n\u00039\u0012\u0001\u0002;j[\u0016,\u0012\u0001\u0007\t\u00033\rj\u0011A\u0007\u0006\u00037q\tQ!\u001e;jYNT!!\b\u0010\u0002\r\r|W.\\8o\u0015\t9qD\u0003\u0002!C\u00051\u0011\r]1dQ\u0016T\u0011AI\u0001\u0004_J<\u0017B\u0001\u0013\u001b\u0005!iunY6US6,\u0007B\u0002\u0014\u0001A\u0003%\u0001$A\u0003uS6,\u0007\u0005C\u0004)\u0001\u0001\u0007I\u0011A\u0015\u0002\u000f9,\u0007\u0010\u001e)jIV\t!\u0006\u0005\u0002\fW%\u0011A\u0006\u0004\u0002\u0005\u0019>tw\rC\u0004/\u0001\u0001\u0007I\u0011A\u0018\u0002\u00179,\u0007\u0010\u001e)jI~#S-\u001d\u000b\u0003aM\u0002\"aC\u0019\n\u0005Ib!\u0001B+oSRDq\u0001N\u0017\u0002\u0002\u0003\u0007!&A\u0002yIEBaA\u000e\u0001!B\u0013Q\u0013\u0001\u00038fqR\u0004\u0016\u000e\u001a\u0011\t\u000fa\u0002!\u0019!C\u0001s\u0005Q\u0001/\u001b3NC:\fw-\u001a:\u0016\u0003i\u0002\"\u0001F\u001e\n\u0005q\u0012!!\u0005)s_\u0012,8-\u001a:JI6\u000bg.Y4fe\"1a\b\u0001Q\u0001\ni\n1\u0002]5e\u001b\u0006t\u0017mZ3sA!9\u0001\t\u0001b\u0001\n\u0003\t\u0015A\u0005;sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJ,\u0012A\u0011\t\u0003)\rK!\u0001\u0012\u0002\u0003/Q\u0013\u0018M\\:bGRLwN\\*uCR,W*\u00198bO\u0016\u0014\bB\u0002$\u0001A\u0003%!)A\nue\u0006t7/Y2uS>tW*\u00198bO\u0016\u0014\b\u0005C\u0004I\u0001\t\u0007I\u0011A%\u0002?Q\u0014\u0018M\\:bGRLwN\\'be.,'o\u00115b]:,G.T1oC\u001e,'/F\u0001K!\t!2*\u0003\u0002M\u0005\tyBK]1og\u0006\u001cG/[8o\u001b\u0006\u00148.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\t\r9\u0003\u0001\u0015!\u0003K\u0003\u0001\"(/\u00198tC\u000e$\u0018n\u001c8NCJ\\WM]\"iC:tW\r\\'b]\u0006<WM\u001d\u0011\t\u000fA\u0003!\u0019!C\u0001#\u0006Y1-\u00199ukJ,G\r\u0016=o+\u0005\u0011\u0006cA*W16\tAK\u0003\u0002VC\u0005AQ-Y:z[>\u001c7.\u0003\u0002X)\n91)\u00199ukJ,\u0007C\u0001\u000bZ\u0013\tQ&AA\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\r\u0003\u0004]\u0001\u0001\u0006IAU\u0001\rG\u0006\u0004H/\u001e:fIRCh\u000e\t\u0005\b=\u0002\u0011\r\u0011\"\u0001`\u0003Y\u0019\u0017\r\u001d;ve\u0016$WI\u001d:peN\u001c\u0015\r\u001c7cC\u000e\\W#\u00011\u0011\u0007M3\u0016\r\u0005\u0003\fE\u0012\u0004\u0014BA2\r\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002fQ6\taM\u0003\u0002h9\u0005A\u0001O]8u_\u000e|G.\u0003\u0002jM\n1QI\u001d:peNDaa\u001b\u0001!\u0002\u0013\u0001\u0017aF2baR,(/\u001a3FeJ|'o]\"bY2\u0014\u0017mY6!\u0011\u001di\u0007A1A\u0005\u00029\f\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002_B\u00111\u0002]\u0005\u0003c2\u00111!\u00138u\u0011\u0019\u0019\b\u0001)A\u0005_\u0006I!M]8lKJLE\r\t\u0005\bk\u0002\u0011\r\u0011\"\u0001o\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000e\u0003\u0004x\u0001\u0001\u0006Ia\\\u0001\u0012G>|'\u000fZ5oCR|'/\u00129pG\"\u0004\u0003bB=\u0001\u0005\u0004%IA_\u0001\u0010iJ\fgn]1di&|g.\u00197JIV\t1\u0010E\u0002}\u0003\u0007i\u0011! \u0006\u0003}~\fA\u0001\\1oO*\u0011\u0011\u0011A\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0006u\u0014aa\u0015;sS:<\u0007bBA\u0005\u0001\u0001\u0006Ia_\u0001\u0011iJ\fgn]1di&|g.\u00197JI\u0002B\u0001\"!\u0004\u0001\u0005\u0004%IA\\\u0001\u000baJ|G-^2fe&#\u0007bBA\t\u0001\u0001\u0006Ia\\\u0001\faJ|G-^2fe&#\u0007\u0005C\u0005\u0002\u0016\u0001\u0011\r\u0011\"\u0003\u0002\u0018\u0005i\u0001O]8ek\u000e,'/\u00129pG\",\"!!\u0007\u0011\u0007-\tY\"C\u0002\u0002\u001e1\u0011Qa\u00155peRD\u0001\"!\t\u0001A\u0003%\u0011\u0011D\u0001\u000faJ|G-^2fe\u0016\u0003xn\u00195!\u0011!\t)\u0003\u0001b\u0001\n\u0013q\u0017\u0001\u0004;y]RKW.Z8vi6\u001b\bbBA\u0015\u0001\u0001\u0006Ia\\\u0001\u000eibtG+[7f_V$Xj\u001d\u0011\t\u0013\u00055\u0002A1A\u0005\n\u0005=\u0012A\u00039beRLG/[8ogV\u0011\u0011\u0011\u0007\t\u0007\u0003g\ti$!\u0011\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\tq!\\;uC\ndWMC\u0002\u0002<1\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty$!\u000e\u0003\u0007M+G\u000f\u0005\u0003\u0002D\u0005\u0015S\"\u0001\u000f\n\u0007\u0005\u001dCD\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u0011\u0005-\u0003\u0001)A\u0005\u0003c\t1\u0002]1si&$\u0018n\u001c8tA!I\u0011q\n\u0001C\u0002\u0013%\u0011\u0011K\u0001\ng\u000eDW\rZ;mKJ,\"!a\u0015\u0011\t\u0005U\u0013\u0011L\u0007\u0003\u0003/R!a\u0007\u0004\n\t\u0005m\u0013q\u000b\u0002\u000e\u001b>\u001c7nU2iK\u0012,H.\u001a:\t\u0011\u0005}\u0003\u0001)A\u0005\u0003'\n!b]2iK\u0012,H.\u001a:!\u0011!)\u0001A1A\u0005\u0002\u0005\rTCAA3!\r!\u0012qM\u0005\u0004\u0003S\u0012!A\u0006+sC:\u001c\u0018m\u0019;j_:\u001cun\u001c:eS:\fGo\u001c:\t\u0011\u00055\u0004\u0001)A\u0005\u0003K\nAbY8pe\u0012Lg.\u0019;pe\u0002B1\"!\u001d\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002t\u00051!/Z:vYR,\"!!\u001e\u0011\u0007Q\t9(C\u0002\u0002z\t\u0011A#\u00138jiB\u0013x\u000eZ;dKJLEMU3tk2$\bbCA?\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u007f\n!B]3tk2$x\fJ3r)\r\u0001\u0014\u0011\u0011\u0005\ni\u0005m\u0014\u0011!a\u0001\u0003kB1\"!\"\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002v\u00059!/Z:vYR\u0004\u0003\"CAE\u0001\u0001\u0007I\u0011AAF\u0003\u0015)'O]8s+\u0005!\u0007\"CAH\u0001\u0001\u0007I\u0011AAI\u0003%)'O]8s?\u0012*\u0017\u000fF\u00021\u0003'C\u0001\u0002NAG\u0003\u0003\u0005\r\u0001\u001a\u0005\b\u0003/\u0003\u0001\u0015)\u0003e\u0003\u0019)'O]8sA!9\u00111\u0014\u0001\u0005\n\u0005u\u0015AD7pG.\u0004\u0016\u000eZ'b]\u0006<WM\u001d\u000b\u0002a!9\u0011\u0011\u0015\u0001\u0005\n\u0005\r\u0016aE5oSR\u0004\u0016\u000eZ$f]\u0016\u0014\u0018nY'pG.\u001cHc\u0001\u0019\u0002&\"9\u00110a(A\u0002\u0005\u001d\u0006\u0003BAU\u0003osA!a+\u00024B\u0019\u0011Q\u0016\u0007\u000e\u0005\u0005=&bAAY\u0011\u00051AH]8pizJ1!!.\r\u0003\u0019\u0001&/\u001a3fM&!\u0011QAA]\u0015\r\t)\f\u0004\u0005\b\u0003{\u0003A\u0011AAO\u0003Q\u001a\bn\\;mIJ+G/\u001e:o\u0013:4\u0018\r\\5e%\u0016\fX/Z:u/\",g\u000e\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ%t\u000b6\u0004H/\u001f\u0015\u0005\u0003w\u000b\t\r\u0005\u0003\u0002D\u0006%WBAAc\u0015\r\t9-I\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u0017\f)M\u0001\u0003UKN$\bbBAh\u0001\u0011\u0005\u0011QT\u0001=g\"|W\u000f\u001c3BG\u000e,\u0007\u000f^%oSR\u0004\u0016\u000eZ!oIJ+G/\u001e:o\u001d\u0016DH\u000fU5e/\",g\u000e\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ%t\u001dVdG\u000e\u000b\u0003\u0002N\u0006\u0005\u0007bBAk\u0001\u0011\u0005\u0011QT\u00010g\"|W\u000f\u001c3J]&$\b+\u001b3XSRDW\t]8dQj+'o\u001c$pe:+w\u000f\u0016:b]N\f7\r^5p]\u0006d\u0017\n\u001a\u0015\u0005\u0003'\f\t\rC\u0004\u0002\\\u0002!\t!!(\u0002YMDw.\u001e7e\u000f\u0016tWM]1uK:+w\u000f\u0015:pIV\u001cWM]%e\u0013\u001a,\u0005o\\2ig\u0016C\b.Y;ti\u0016$\u0007\u0006BAm\u0003\u0003Dq!!9\u0001\t\u0003\ti*\u0001\u001etQ>,H\u000e\u001a*fgB|g\u000eZ,ji\"tu\u000e^\"p_J$\u0017N\\1u_J|e.\u00138jiBKGm\u00165f]:{GoQ8pe\u0012Lg.\u0019;pe\"\"\u0011q\\Aa\u0011\u001d\t9\u000f\u0001C\u0001\u0003;\u000b\u0001j\u001d5pk2$'+Z:q_:$w+\u001b;i\u0007>|'\u000fZ5oCR|'\u000fT8bI&s\u0007K]8he\u0016\u001c8o\u00148J]&$\b+\u001b3XQ\u0016t7i\\8sI&tGo\u001c:M_\u0006$\u0017N\\4)\t\u0005\u0015\u0018\u0011\u0019\u0005\b\u0003[\u0004A\u0011AAO\u0003m\u001b\bn\\;mIJ+7\u000f]8oI^KG\u000f[%om\u0006d\u0017\u000e\u001a)jI6\u000b\u0007\u000f]5oO>s\u0017\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016:b]N\f7\r^5p]^CWM\u001c+sC:\u001c\u0018m\u0019;j_:\fG.\u00133O_R\u0004&/Z:f]RDC!a;\u0002B\"9\u00111\u001f\u0001\u0005\u0002\u0005u\u0015aU:i_VdGMU3ta>tGmV5uQ&sg/\u00197jIJ+\u0017/^3ti\u0006#G\rU1si&$\u0018n\u001c8t)>$&/\u00198tC\u000e$\u0018n\u001c8XQ\u0016tGK]1og\u0006\u001cG/[8oC2LE-S:F[B$\u0018\u0010\u000b\u0003\u0002r\u0006\u0005\u0007bBA}\u0001\u0011\u0005\u0011QT\u0001Sg\"|W\u000f\u001c3SKN\u0004xN\u001c3XSRD\u0017J\u001c<bY&$'+Z9vKN$\u0018\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016:b]N\f7\r^5p]^CWM\u001c+sC:\u001c\u0018m\u0019;j_:\fG.\u00133Jg:+H\u000e\u001c\u0015\u0005\u0003o\f\t\rC\u0004\u0002\u0000\u0002!\t!!(\u0002\u0001NDw.\u001e7e%\u0016\u001c\bo\u001c8e/&$\bNT8u\u0007>|'\u000fZ5oCR|'o\u00148BI\u0012\u0004\u0016M\u001d;ji&|gn],iK:tu\u000e^\"p_J$\u0017N\\1u_JDC!!@\u0002B\"9!Q\u0001\u0001\u0005\u0002\u0005u\u0015AT:i_VdGMU3ta>tGmV5uQ\u000e{wN\u001d3j]\u0006$xN\u001d'pC\u0012Le\u000e\u0015:pOJ,7o](o\u0003\u0012$\u0007+\u0019:uSRLwN\\:XQ\u0016t7i\\8sI&tGo\u001c:M_\u0006$\u0017N\\4)\t\t\r\u0011\u0011\u0019\u0005\b\u0005\u0017\u0001A\u0011AAO\u00039\u001b\bn\\;mIJ+7\u000f]8oI^KG\u000f[\"p]\u000e,(O]3oiR\u0013\u0018M\\:bGRLwN\\:P]\u0006#G\rU1si&$\u0018n\u001c8t/\",gn\u0015;bi\u0016L5\u000f\u0015:fa\u0006\u0014XmQ8n[&$\b\u0006\u0002B\u0005\u0003\u0003DqA!\u0005\u0001\t\u0003\ti*\u0001'tQ>,H\u000e\u001a*fgB|g\u000eZ,ji\"\u001cuN\\2veJ,g\u000e\u001e+sC:\u001c\u0018m\u0019;j_:|e.\u00113e!\u0006\u0014H/\u001b;j_:\u001cx\u000b[3o'R\fG/Z%t!J,\u0007/\u0019:f\u0003\n|'\u000f\u001e\u0015\u0005\u0005\u001f\t\t\rC\u0004\u0003\u0018\u0001!\tA!\u0007\u0002=Y\fG.\u001b3bi\u0016\u001cuN\\2veJ,g\u000e\u001e+sC:\u001c\u0018m\u0019;j_:\u001cHc\u0001\u0019\u0003\u001c!A!Q\u0004B\u000b\u0001\u0004\u0011y\"A\u0003ti\u0006$X\rE\u0002\u0015\u0005CI1Aa\t\u0003\u0005A!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X\rC\u0004\u0003(\u0001!\t!!(\u0002\u0019NDw.\u001e7e%\u0016\u001c\bo\u001c8e/&$\b.\u00138wC2LG\r\u00168y!J|G-^2f\u000bB|7\r[(o\u0003\u0012$\u0007+\u0019:uSRLwN\\:XQ\u0016tW\t]8dQN\f%/\u001a#jM\u001a,'/\u001a8uQ\u0011\u0011)#!1\t\u000f\t5\u0002\u0001\"\u0001\u0002\u001e\u0006q4\u000f[8vY\u0012\f\u0005\u000f]3oI:+w/T3uC\u0012\fG/\u0019+p\u0019><wJ\\!eIB\u000b'\u000f^5uS>t7o\u00165f]B\u000b'\u000f^5uS>t7/\u00113eK\u0012DCAa\u000b\u0002B\"9!1\u0007\u0001\u0005\u0002\u0005u\u0015!O:i_VdGMU3ta>tGmV5uQN+8mY3tg>s\u0017\t\u001a3QCJ$\u0018\u000e^5p]N<\u0006.\u001a8Ti\u0006$X-S:P]\u001e|\u0017N\\4)\t\tE\u0012\u0011\u0019\u0005\b\u0005s\u0001A\u0011AAO\u0003\u0001\u001b\bn\\;mIJ+7\u000f]8oI^KG\u000f[*vG\u000e,7o](o\u0003\u0012$\u0007+\u0019:uSRLwN\\:XQ\u0016t7\u000b^1uK&\u001b8i\\7qY\u0016$XmQ8n[&$\b\u0006\u0002B\u001c\u0003\u0003DqAa\u0010\u0001\t\u0003\ti*A tQ>,H\u000e\u001a*fgB|g\u000eZ,ji\"\u001cVoY2fgN|e.\u00113e!\u0006\u0014H/\u001b;j_:\u001cx\u000b[3o'R\fG/Z%t\u0007>l\u0007\u000f\\3uK\u0006\u0013wN\u001d;)\t\tu\u0012\u0011\u0019\u0005\b\u0005\u000b\u0002A\u0011\u0001B$\u0003}1\u0018\r\\5eCR,7+^2dKN\u001ch-\u001e7BI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0004a\t%\u0003\u0002\u0003B&\u0005\u0007\u0002\rAa\b\u0002\u001bA\u0014XM^5pkN\u001cF/\u0019;f\u0011\u001d\u0011y\u0005\u0001C\u0001\u0003;\u000b\u0011j\u001d5pk2$'+Z:q_:$w+\u001b;i\u000bJ\u0014xN]:O_:,wJ\\!eIB\u000b'\u000f^5uS>tw\u000b[3o\u001d>,%O]8sg\u0006sG\rU1si&$\u0018n\u001c8t)\",7+Y7fQ\u0011\u0011i%!1\t\u000f\tU\u0003\u0001\"\u0001\u0002\u001e\u0006a4\u000f[8vY\u0012\u0014V\r\u001d7z/&$\b.\u00138wC2LG\rU5e\u001b\u0006\u0004\b/\u001b8h\u001f:,e\u000e\u001a+y]^CWM\u001c+y]&#Gi\\3t]R,\u00050[:uQ\u0011\u0011\u0019&!1\t\u000f\tm\u0003\u0001\"\u0001\u0002\u001e\u0006\u00015\u000f[8vY\u0012\u0014V\r\u001d7z/&$\b.\u00138wC2LG\rU5e\u001b\u0006\u0004\b/\u001b8h\u001f:,e\u000e\u001a+y]^CWM\u001c)jI\u0012{7/\u001a8u\u001b\u0006$8\r['baB,G\r\u000b\u0003\u0003Z\u0005\u0005\u0007b\u0002B1\u0001\u0011\u0005\u0011QT\u0001Eg\"|W\u000f\u001c3SKBd\u0017pV5uQB\u0013x\u000eZ;dKJ4UM\\2fI>sWI\u001c3Uq:<\u0006.\u001a8Fa>\u001c\u0007.S:O_R\u001c\u0016-\\3BgR\u0013\u0018M\\:bGRLwN\u001c\u0015\u0005\u0005?\n\t\rC\u0004\u0003h\u0001!\t!!(\u0002\u0003NDw.\u001e7e%\u0016$XO\u001d8PW>sWI\u001c3Uq:<\u0006.\u001a8Ti\u0006$Xo]%t\u0007>l\u0007\u000f\\3uK\u000e{W.\\5u\u0003:$'+Z:vYRL5oQ8n[&$\b\u0006\u0002B3\u0003\u0003DqA!\u001c\u0001\t\u0003\ti*A tQ>,H\u000e\u001a*fiV\u0014hnT6P]\u0016sG\r\u0016=o/\",gn\u0015;biV\u001c\u0018j]\"p[BdW\r^3BE>\u0014H/\u00118e%\u0016\u001cX\u000f\u001c;Jg\u0006\u0013wN\u001d;)\t\t-\u0014\u0011\u0019\u0005\b\u0005g\u0002A\u0011AAO\u0003a\u001b\bn\\;mIJ+G/\u001e:o\u0013:4\u0018\r\\5e)bt'+Z9vKN$xJ\\#oIRChNU3rk\u0016\u001cHo\u00165f]N#\u0018\r^;t\u0013N\u001cu.\u001c9mKR,\u0017IY8si\u0006sGMU3tk2$\u0018j\u001d(pi\u0006\u0013wN\u001d;)\t\tE\u0014\u0011\u0019\u0005\b\u0005s\u0002A\u0011AAO\u0003i\u001b\bn\\;mIJ+G/\u001e:o\u0013:4\u0018\r\\5e)bt'+Z9vKN$xJ\\#oIRChNU3rk\u0016\u001cHo\u00165f]N#\u0018\r^;t\u0013N\u001cu.\u001c9mKR,7i\\7nSR\fe\u000e\u001a*fgVdG/S:O_R\u001cu.\\7ji\"\"!qOAa\u0011\u001d\u0011y\b\u0001C\u0001\u0003;\u000b\u0001j\u001d5pk2$'+\u001a;ve:\u001cuN\\2veJ,g\u000e\u001e+y]J+\u0017/^3ti>sWI\u001c3Uq:\u0014V-];fgR<\u0006.\u001a8Ti\u0006$Xo]%t!J,\u0007/\u0019:f\u0007>lW.\u001b;)\t\tu\u0014\u0011\u0019\u0005\b\u0005\u000b\u0003A\u0011AAO\u0003\u0011\u001b\bn\\;mIJ+G/\u001e:o\u0013:4\u0018\r\\5e)bt'+Z9vKN$xJ\\#oIRChNU3rk\u0016\u001cHo\u00165f]N#\u0018\r^;t\u0013N\u0004&/\u001a9be\u0016\f%m\u001c:uQ\u0011\u0011\u0019)!1\t\u000f\t-\u0005\u0001\"\u0001\u0002\u001e\u0006Q5\u000f[8vY\u0012\f\u0005\u000f]3oIB\u0013X\r]1sK\u000e{W.\\5u)>dunZ(o\u000b:$G\u000b\u001f8XQ\u0016t7\u000b^1ukNL5o\u00148h_&tw-\u00118e%\u0016\u001cX\u000f\u001c;Jg\u000e{W.\\5uQ\u0011\u0011I)!1\t\u000f\tE\u0005\u0001\"\u0001\u0002\u001e\u0006A5\u000f[8vY\u0012\f\u0005\u000f]3oIB\u0013X\r]1sK\u0006\u0013wN\u001d;U_2{wm\u00148F]\u0012$\u0006P\\,iK:\u001cF/\u0019;vg&\u001bxJ\\4pS:<\u0017I\u001c3SKN,H\u000e^%t\u0003\n|'\u000f\u001e\u0015\u0005\u0005\u001f\u000b\t\rC\u0004\u0003\u0018\u0002!\t!!(\u0002\u0001NDw.\u001e7e%\u0016\u001c\bo\u001c8e/&$\b.\u00138wC2LGMU3rk\u0016\u001cHo\u00148F]\u0012$\u0006P\\,iK:$&/\u00198tC\u000e$\u0018n\u001c8bY&#\u0017j\u001d(vY2DCA!&\u0002B\"9!Q\u0014\u0001\u0005\u0002\u0005u\u0015!Q:i_VdGMU3ta>tGmV5uQ&sg/\u00197jIJ+\u0017/^3ti>sWI\u001c3Uq:<\u0006.\u001a8Ue\u0006t7/Y2uS>t\u0017\r\\%e\u0013N,U\u000e\u001d;zQ\u0011\u0011Y*!1\t\u000f\t\r\u0006\u0001\"\u0001\u0002\u001e\u0006\u00015\u000f[8vY\u0012\u0014Vm\u001d9p]\u0012<\u0016\u000e\u001e5O_R\u001cun\u001c:eS:\fGo\u001c:P]\u0016sG\r\u0016=o/\",g.S:O_R\u001cun\u001c:eS:\fGo\u001c:G_JLE\r\u000b\u0003\u0003\"\u0006\u0005\u0007b\u0002BU\u0001\u0011\u0005\u0011QT\u0001Kg\"|W\u000f\u001c3SKN\u0004xN\u001c3XSRD7i\\8sI&t\u0017\r^8s\u0019>\fG-\u00138Qe><'/Z:t\u001f:,e\u000e\u001a+y]^CWM\\\"p_J$\u0017N\\1u_JL5\u000fT8bI&tw\r\u000b\u0003\u0003(\u0006\u0005\u0007b\u0002BX\u0001\u0011\u0005\u0011QT\u0001Qg\"|W\u000f\u001c3J]\u000e\u0014X-\\3oi\u0016\u0003xn\u00195B]\u0012,\u0006\u000fZ1uK6+G/\u00193bi\u0006|e\u000eS1oI2,\u0017J\\5u!&$w\u000b[3o\u000bbL7\u000f^5oO\u0016k\u0007\u000f^=Ue\u0006t7/Y2uS>t\u0007\u0006\u0002BW\u0003\u0003DqA!.\u0001\t\u0003\ti*A*tQ>,H\u000eZ%oGJ,W.\u001a8u\u000bB|7\r[!oIV\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uC>s\u0007*\u00198eY\u0016Le.\u001b;QS\u0012<\u0006.\u001a8Fq&\u001cH/\u001b8h\u0007>l\u0007\u000f\\3uKR\u0013\u0018M\\:bGRLwN\u001c\u0015\u0005\u0005g\u000b\t\rC\u0004\u0003<\u0002!\t!!(\u00023NDw.\u001e7e\u0013:\u001c'/Z7f]R,\u0005o\\2i\u0003:$W\u000b\u001d3bi\u0016lU\r^1eCR\fwJ\u001c%b]\u0012dW-\u00138jiBKGm\u00165f]\u0016C\u0018n\u001d;j]\u001e\u001cu.\u001c9mKR,7i\\7nSR$&/\u00198tC\u000e$\u0018n\u001c8)\t\te\u0016\u0011\u0019\u0005\b\u0005\u0003\u0004A\u0011AAO\u0003Y\u001b\bn\\;mI^\u000b\u0017\u000e\u001e$pe\u000e{W.\\5u)>\u001cu.\u001c9mKR,wJ\u001c%b]\u0012dW-\u00138jiBKG-\u00118e\u000bbL7\u000f^5oOR\u0013\u0018M\\:bGRLwN\\%o!J,\u0007/\u0019:f\u0007>lW.\u001b;Ti\u0006$X\r\u000b\u0003\u0003@\u0006\u0005\u0007b\u0002Bd\u0001\u0011\u0005\u0011QT\u0001Vg\"|W\u000f\u001c3XC&$hi\u001c:D_6l\u0017\u000e\u001e+p\u0007>l\u0007\u000f\\3uK>s\u0007*\u00198eY\u0016Le.\u001b;QS\u0012\fe\u000eZ#ySN$\u0018N\\4Ue\u0006t7/Y2uS>t\u0017J\u001c)sKB\f'/Z!c_J$8\u000b^1uK\"\"!QYAa\u0011\u001d\u0011i\r\u0001C\u0001\u0003;\u000b!j\u001d5pk2$\u0017IY8siR\u0013\u0018M\\:bGRLwN\\(o\u0011\u0006tG\r\\3J]&$\b+\u001b3XQ\u0016tW\t_5ti&tw\r\u0016:b]N\f7\r^5p]&swJ\\4pS:<7\u000b^1uK\"\"!1ZAa\u0011\u001d\u0011\u0019\u000e\u0001C\u0001\u0003;\u000bqf\u001d5pk2$Wk]3MCN$X\t]8dQR{g)\u001a8dK^CWM\\#q_\u000eD7/\u0011:f\u000bbD\u0017-^:uK\u0012DCA!5\u0002B\"9!\u0011\u001c\u0001\u0005\u0002\u0005u\u0015\u0001M:i_VdGMU3n_Z,GK]1og\u0006\u001cG/[8og\u001a{'\u000fU1si&$\u0018n\u001c8P]\u0016k\u0017n\u001a:bi&|g\u000e\u000b\u0003\u0003X\u0006\u0005\u0007b\u0002Bp\u0001\u0011\u0005\u0011QT\u00019g\"|W\u000f\u001c3BE>\u0014H/\u0012=qSJ,G\r\u0016:b]N\f7\r^5p]NLen\u00148h_&twm\u0015;bi\u0016\fe\u000e\u001a\"v[B,\u0005o\\2iQ\u0011\u0011i.!1\t\u000f\t\u0015\b\u0001\"\u0001\u0002\u001e\u0006\u00015\u000f[8vY\u0012tu\u000e^!c_J$X\t\u001f9je\u0016$GK]1og\u0006\u001cG/[8ogRC\u0017\r\u001e%bm\u0016\f\u0005+\u001a8eS:<7\u000b^1uKR\u0013\u0018M\\:ji&|g\u000e\u000b\u0003\u0003d\u0006\u0005\u0007b\u0002Bv\u0001\u0011%!Q^\u0001Fm\u0006d\u0017\u000eZ1uKJ+7\u000f]8oIN<\u0016\u000e\u001e5D_:\u001cWO\u001d:f]R$&/\u00198tC\u000e$\u0018n\u001c8t\u001f:Le.\u001b;QS\u0012<\u0006.\u001a8J]B\u0013X\r]1sKN#\u0018\r^3\u0015\u0007A\u0012y\u000f\u0003\u0005\u0003\u001e\t%\b\u0019\u0001B\u0010\u0011\u001d\u0011\u0019\u0010\u0001C\u0005\u0005k\fqE^1mS\u0012\fG/Z%oGJ,W.\u001a8u\u000bB|7\r[!oIV\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCR\u0019\u0001Ga>\t\u0011\tu!\u0011\u001fa\u0001\u0005?AqAa?\u0001\t\u0013\u0011i0A\u0006n_\u000e\\\u0007K]3qCJ,G#\u0002-\u0003\u0000\u000e\r\u0001\u0002CB\u0001\u0005s\u0004\rAa\b\u0002!Q\u0014\u0018M\\:bGRLwN\\*uCR,\u0007BCB\u0003\u0005s\u0004\n\u00111\u0001\u0004\b\u0005Y!/\u001e8DC2d'-Y2l!\rY1\u0011B\u0005\u0004\u0007\u0017a!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0007\u001f\u0001A\u0011AB\t\u0003iIg.\u001b;Qe>$WoY3s\u0013\u0012lunY6DC2d'-Y2l)\r\u000141\u0003\u0005\t\u0007+\u0019i\u00011\u0001\u0002v\u0005\u0019!/\u001a;\t\u000f\re\u0001\u0001\"\u0001\u0004\u001c\u0005qQM\u001d:peN\u001c\u0015\r\u001c7cC\u000e\\Gc\u0001\u0019\u0004\u001e!91QCB\f\u0001\u0004!\u0007\"CB\u0011\u0001E\u0005I\u0011BB\u0012\u0003UiwnY6Qe\u0016\u0004\u0018M]3%I\u00164\u0017-\u001e7uII*\"a!\n+\t\r\u001d1qE\u0016\u0003\u0007S\u0001Baa\u000b\u000465\u00111Q\u0006\u0006\u0005\u0007_\u0019\t$A\u0005v]\u000eDWmY6fI*\u001911\u0007\u0007\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00048\r5\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class TransactionCoordinatorTest {
    private final MockTime time = new MockTime();
    private long nextPid = 0L;
    private final ProducerIdManager pidManager = (ProducerIdManager)EasyMock.createNiceMock(ProducerIdManager.class);
    private final TransactionStateManager transactionManager = (TransactionStateManager)EasyMock.createNiceMock(TransactionStateManager.class);
    private final TransactionMarkerChannelManager transactionMarkerChannelManager = (TransactionMarkerChannelManager)EasyMock.createNiceMock(TransactionMarkerChannelManager.class);
    private final Capture<TransactionMetadata> capturedTxn = EasyMock.newCapture();
    private final Capture<Function1<Errors, BoxedUnit>> capturedErrorsCallback = EasyMock.newCapture();
    private final int brokerId;
    private final int coordinatorEpoch;
    private final String transactionalId;
    private final int producerId;
    private final short producerEpoch;
    private final int txnTimeoutMs;
    private final Set<TopicPartition> partitions = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0)}));
    private final MockScheduler scheduler = new MockScheduler((Time)this.time());
    private final TransactionCoordinator coordinator = new TransactionCoordinator(this.brokerId(), new TransactionConfig(TransactionConfig$.MODULE$.$lessinit$greater$default$1(), TransactionConfig$.MODULE$.$lessinit$greater$default$2(), TransactionConfig$.MODULE$.$lessinit$greater$default$3(), TransactionConfig$.MODULE$.$lessinit$greater$default$4(), TransactionConfig$.MODULE$.$lessinit$greater$default$5(), TransactionConfig$.MODULE$.$lessinit$greater$default$6(), TransactionConfig$.MODULE$.$lessinit$greater$default$7(), TransactionConfig$.MODULE$.$lessinit$greater$default$8(), TransactionConfig$.MODULE$.$lessinit$greater$default$9(), TransactionConfig$.MODULE$.$lessinit$greater$default$10()), (Scheduler)this.scheduler(), this.pidManager(), this.transactionManager(), this.transactionMarkerChannelManager(), (Time)this.time(), new LogContext());
    private InitProducerIdResult result;
    private Errors error = Errors.NONE;

    public MockTime time() {
        return this.time;
    }

    public long nextPid() {
        return this.nextPid;
    }

    public void nextPid_$eq(long x$1) {
        this.nextPid = x$1;
    }

    public ProducerIdManager pidManager() {
        return this.pidManager;
    }

    public TransactionStateManager transactionManager() {
        return this.transactionManager;
    }

    public TransactionMarkerChannelManager transactionMarkerChannelManager() {
        return this.transactionMarkerChannelManager;
    }

    public Capture<TransactionMetadata> capturedTxn() {
        return this.capturedTxn;
    }

    public Capture<Function1<Errors, BoxedUnit>> capturedErrorsCallback() {
        return this.capturedErrorsCallback;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    private String transactionalId() {
        return this.transactionalId;
    }

    private int producerId() {
        return this.producerId;
    }

    private short producerEpoch() {
        return this.producerEpoch;
    }

    private int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    private Set<TopicPartition> partitions() {
        return this.partitions;
    }

    private MockScheduler scheduler() {
        return this.scheduler;
    }

    public TransactionCoordinator coordinator() {
        return this.coordinator;
    }

    public InitProducerIdResult result() {
        return this.result;
    }

    public void result_$eq(InitProducerIdResult x$1) {
        this.result = x$1;
    }

    public Errors error() {
        return this.error;
    }

    public void error_$eq(Errors x$1) {
        this.error = x$1;
    }

    private void mockPidManager() {
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)this.pidManager().generateProducerId())).andAnswer((IAnswer)new IAnswer<Object>(this){
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public long answer() {
                this.$outer.nextPid_$eq(this.$outer.nextPid() + 1L);
                return this.$outer.nextPid() - 1L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).anyTimes();
    }

    private void initPidGenericMocks(String transactionalId) {
        this.mockPidManager();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
    }

    @Test
    public void shouldReturnInvalidRequestWhenTransactionalIdIsEmpty() {
        this.mockPidManager();
        EasyMock.replay((Object[])new Object[]{this.pidManager()});
        this.coordinator().handleInitProducerId("", this.txnTimeoutMs(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.INVALID_REQUEST), (Object)this.result());
        this.coordinator().handleInitProducerId("", this.txnTimeoutMs(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.INVALID_REQUEST), (Object)this.result());
    }

    @Test
    public void shouldAcceptInitPidAndReturnNextPidWhenTransactionalIdIsNull() {
        this.mockPidManager();
        EasyMock.replay((Object[])new Object[]{this.pidManager()});
        this.coordinator().handleInitProducerId(null, this.txnTimeoutMs(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new InitProducerIdResult(0L, 0, Errors.NONE), (Object)this.result());
        this.coordinator().handleInitProducerId(null, this.txnTimeoutMs(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new InitProducerIdResult(1L, 0, Errors.NONE), (Object)this.result());
    }

    @Test
    public void shouldInitPidWithEpochZeroForNewTransactionalId() {
        this.initPidGenericMocks(this.transactionalId());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$)).once();
        EasyMock.expect((Object)this.transactionManager().putTransactionStateIfNotExists((String)EasyMock.eq((Object)this.transactionalId()), (TransactionMetadata)EasyMock.capture(this.capturedTxn()))).andAnswer((IAnswer)new IAnswer<Either<Errors, CoordinatorEpochAndTxnMetadata>>(this){
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public Either<Errors, CoordinatorEpochAndTxnMetadata> answer() {
                Assert.assertTrue((boolean)this.$outer.capturedTxn().hasCaptured());
                return package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.$outer.coordinatorEpoch(), (TransactionMetadata)this.$outer.capturedTxn().getValue()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).once();
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.anyObject(), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this){
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public void answer() {
                ((Function1)this.$outer.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.pidManager(), this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), this.txnTimeoutMs(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new InitProducerIdResult(this.nextPid() - 1L, 0, Errors.NONE), (Object)this.result());
    }

    @Test
    public void shouldGenerateNewProducerIdIfEpochsExhausted() {
        this.initPidGenericMocks(this.transactionalId());
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), (short)32766, this.txnTimeoutMs(), (TransactionState)Empty$.MODULE$, Set$.MODULE$.empty(), this.time().milliseconds(), this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))));
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.anyObject(), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this){
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public void answer() {
                ((Function1)this.$outer.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.pidManager(), this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), this.txnTimeoutMs(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertNotEquals((long)this.producerId(), (long)this.result().producerId());
        Assert.assertEquals((long)0L, (long)this.result().producerEpoch());
        Assert.assertEquals((Object)Errors.NONE, (Object)this.result().error());
    }

    @Test
    public void shouldRespondWithNotCoordinatorOnInitPidWhenNotCoordinator() {
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), this.txnTimeoutMs(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.NOT_COORDINATOR), (Object)this.result());
    }

    @Test
    public void shouldRespondWithCoordinatorLoadInProgressOnInitPidWhenCoordintorLoading() {
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), this.txnTimeoutMs(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.COORDINATOR_LOAD_IN_PROGRESS), (Object)this.result());
    }

    @Test
    public void shouldRespondWithInvalidPidMappingOnAddPartitionsToTransactionWhenTransactionalIdNotPresent() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), 0L, (short)1, this.partitions(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_PRODUCER_ID_MAPPING, (Object)this.error());
    }

    @Test
    public void shouldRespondWithInvalidRequestAddPartitionsToTransactionWhenTransactionalIdIsEmpty() {
        this.coordinator().handleAddPartitionsToTransaction("", 0L, (short)1, this.partitions(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_REQUEST, (Object)this.error());
    }

    @Test
    public void shouldRespondWithInvalidRequestAddPartitionsToTransactionWhenTransactionalIdIsNull() {
        this.coordinator().handleAddPartitionsToTransaction(null, 0L, (short)1, this.partitions(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_REQUEST, (Object)this.error());
    }

    @Test
    public void shouldRespondWithNotCoordinatorOnAddPartitionsWhenNotCoordinator() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), 0L, (short)1, this.partitions(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)this.error());
    }

    @Test
    public void shouldRespondWithCoordinatorLoadInProgressOnAddPartitionsWhenCoordintorLoading() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), 0L, (short)1, this.partitions(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)this.error());
    }

    @Test
    public void shouldRespondWithConcurrentTransactionsOnAddPartitionsWhenStateIsPrepareCommit() {
        this.validateConcurrentTransactions((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldRespondWithConcurrentTransactionOnAddPartitionsWhenStateIsPrepareAbort() {
        this.validateConcurrentTransactions((TransactionState)PrepareAbort$.MODULE$);
    }

    public void validateConcurrentTransactions(TransactionState state) {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), 0L, 0, 0, state, Set$.MODULE$.empty(), 0L, 0L)))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), 0L, (short)0, this.partitions(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.CONCURRENT_TRANSACTIONS, (Object)this.error());
    }

    @Test
    public void shouldRespondWithInvalidTnxProduceEpochOnAddPartitionsWhenEpochsAreDifferent() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), 0L, 10, 0, (TransactionState)PrepareCommit$.MODULE$, Set$.MODULE$.empty(), 0L, 0L)))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), 0L, (short)0, this.partitions(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_PRODUCER_EPOCH, (Object)this.error());
    }

    @Test
    public void shouldAppendNewMetadataToLogOnAddPartitionsWhenPartitionsAdded() {
        this.validateSuccessfulAddPartitions((TransactionState)Empty$.MODULE$);
    }

    @Test
    public void shouldRespondWithSuccessOnAddPartitionsWhenStateIsOngoing() {
        this.validateSuccessfulAddPartitions((TransactionState)Ongoing$.MODULE$);
    }

    @Test
    public void shouldRespondWithSuccessOnAddPartitionsWhenStateIsCompleteCommit() {
        this.validateSuccessfulAddPartitions((TransactionState)CompleteCommit$.MODULE$);
    }

    @Test
    public void shouldRespondWithSuccessOnAddPartitionsWhenStateIsCompleteAbort() {
        this.validateSuccessfulAddPartitions((TransactionState)CompleteAbort$.MODULE$);
    }

    public void validateSuccessfulAddPartitions(TransactionState previousState) {
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), previousState, Set$.MODULE$.empty(), this.time().milliseconds(), this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))));
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.anyObject(), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.partitions(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldRespondWithErrorsNoneOnAddPartitionWhenNoErrorsAndPartitionsTheSame() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), 0L, 0, 0, (TransactionState)Empty$.MODULE$, this.partitions(), 0L, 0L)))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), 0L, (short)0, this.partitions(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReplyWithInvalidPidMappingOnEndTxnWhenTxnIdDoesntExist() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), 0L, (short)0, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_PRODUCER_ID_MAPPING, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReplyWithInvalidPidMappingOnEndTxnWhenPidDosentMatchMapped() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), 10L, 0, 0, (TransactionState)Ongoing$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds())))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), 0L, (short)0, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_PRODUCER_ID_MAPPING, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReplyWithProducerFencedOnEndTxnWhenEpochIsNotSameAsTransaction() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)Ongoing$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds())))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)0, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_PRODUCER_EPOCH, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReturnOkOnEndTxnWhenStatusIsCompleteCommitAndResultIsCommit() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)CompleteCommit$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds())))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)1, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReturnOkOnEndTxnWhenStatusIsCompleteAbortAndResultIsAbort() {
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)CompleteAbort$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)1, TransactionResult.ABORT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReturnInvalidTxnRequestOnEndTxnRequestWhenStatusIsCompleteAbortAndResultIsNotAbort() {
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)CompleteAbort$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)1, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_TXN_STATE, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReturnInvalidTxnRequestOnEndTxnRequestWhenStatusIsCompleteCommitAndResultIsNotCommit() {
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)CompleteCommit$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)1, TransactionResult.ABORT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_TXN_STATE, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReturnConcurrentTxnRequestOnEndTxnRequestWhenStatusIsPrepareCommit() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)PrepareCommit$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds())))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)1, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.CONCURRENT_TRANSACTIONS, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReturnInvalidTxnRequestOnEndTxnRequestWhenStatusIsPrepareAbort() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)PrepareAbort$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds())))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)1, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_TXN_STATE, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldAppendPrepareCommitToLogOnEndTxnWhenStatusIsOngoingAndResultIsCommit() {
        this.mockPrepare((TransactionState)PrepareCommit$.MODULE$, this.mockPrepare$default$2());
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldAppendPrepareAbortToLogOnEndTxnWhenStatusIsOngoingAndResultIsAbort() {
        this.mockPrepare((TransactionState)PrepareAbort$.MODULE$, this.mockPrepare$default$2());
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), TransactionResult.ABORT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldRespondWithInvalidRequestOnEndTxnWhenTransactionalIdIsNull() {
        this.coordinator().handleEndTransaction(null, 0L, (short)0, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_REQUEST, (Object)this.error());
    }

    @Test
    public void shouldRespondWithInvalidRequestOnEndTxnWhenTransactionalIdIsEmpty() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction("", 0L, (short)0, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_REQUEST, (Object)this.error());
    }

    @Test
    public void shouldRespondWithNotCoordinatorOnEndTxnWhenIsNotCoordinatorForId() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), 0L, (short)0, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)this.error());
    }

    @Test
    public void shouldRespondWithCoordinatorLoadInProgressOnEndTxnWhenCoordinatorIsLoading() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), 0L, (short)0, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)this.error());
    }

    @Test
    public void shouldIncrementEpochAndUpdateMetadataOnHandleInitPidWhenExistingEmptyTransaction() {
        this.validateIncrementEpochAndUpdateMetadata((TransactionState)Empty$.MODULE$);
    }

    @Test
    public void shouldIncrementEpochAndUpdateMetadataOnHandleInitPidWhenExistingCompleteTransaction() {
        this.validateIncrementEpochAndUpdateMetadata((TransactionState)CompleteAbort$.MODULE$);
    }

    @Test
    public void shouldIncrementEpochAndUpdateMetadataOnHandleInitPidWhenExistingCompleteCommitTransaction() {
        this.validateIncrementEpochAndUpdateMetadata((TransactionState)CompleteCommit$.MODULE$);
    }

    @Test
    public void shouldWaitForCommitToCompleteOnHandleInitPidAndExistingTransactionInPrepareCommitState() {
        this.validateRespondsWithConcurrentTransactionsOnInitPidWhenInPrepareState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldWaitForCommitToCompleteOnHandleInitPidAndExistingTransactionInPrepareAbortState() {
        this.validateRespondsWithConcurrentTransactionsOnInitPidWhenInPrepareState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test
    public void shouldAbortTransactionOnHandleInitPidWhenExistingTransactionInOngoingState() {
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (TransactionState)Ongoing$.MODULE$, this.partitions(), this.time().milliseconds(), this.time().milliseconds());
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.transactionManager().putTransactionStateIfNotExists((String)EasyMock.eq((Object)this.transactionalId()), (TransactionMetadata)EasyMock.anyObject())).andReturn((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))).anyTimes();
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata)))).anyTimes();
        TransactionMetadata originalMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), (short)(this.producerEpoch() + 1), this.txnTimeoutMs(), (TransactionState)Ongoing$.MODULE$, this.partitions(), this.time().milliseconds(), this.time().milliseconds());
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)originalMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, this.time().milliseconds())), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this){
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public void answer() {
                ((Function1)this.$outer.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), this.txnTimeoutMs(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.CONCURRENT_TRANSACTIONS), (Object)this.result());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldUseLastEpochToFenceWhenEpochsAreExhausted() {
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), (short)32766, this.txnTimeoutMs(), (TransactionState)Ongoing$.MODULE$, this.partitions(), this.time().milliseconds(), this.time().milliseconds());
        Assert.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.transactionManager().putTransactionStateIfNotExists((String)EasyMock.eq((Object)this.transactionalId()), (TransactionMetadata)EasyMock.anyObject())).andReturn((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))).anyTimes();
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata)))).anyTimes();
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)new TxnTransitMetadata((long)this.producerId(), Short.MAX_VALUE, this.txnTimeoutMs(), (TransactionState)PrepareAbort$.MODULE$, this.partitions().toSet(), this.time().milliseconds(), this.time().milliseconds())), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this){
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public void answer() {
                ((Function1)this.$outer.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), this.txnTimeoutMs(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)32767L, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.CONCURRENT_TRANSACTIONS), (Object)this.result());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldRemoveTransactionsForPartitionOnEmigration() {
        this.transactionManager().removeTransactionsForTxnTopicPartition(0, this.coordinatorEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.transactionMarkerChannelManager().removeMarkersForTxnTopicPartition(0);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.transactionManager(), this.transactionMarkerChannelManager()});
        this.coordinator().handleTxnEmigration(0, this.coordinatorEpoch());
        EasyMock.verify((Object[])new Object[]{this.transactionManager(), this.transactionMarkerChannelManager()});
    }

    @Test
    public void shouldAbortExpiredTransactionsInOngoingStateAndBumpEpoch() {
        long now = this.time().milliseconds();
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (TransactionState)Ongoing$.MODULE$, this.partitions(), now, now);
        EasyMock.expect((Object)this.transactionManager().timedOutTransactions()).andReturn((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransactionalIdAndProducerIdEpoch[]{new TransactionalIdAndProducerIdEpoch(this.transactionalId(), (long)this.producerId(), this.producerEpoch())})));
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata)))).times(2);
        short bumpedEpoch = (short)(this.producerEpoch() + 1);
        TxnTransitMetadata expectedTransition = new TxnTransitMetadata((long)this.producerId(), bumpedEpoch, this.txnTimeoutMs(), (TransactionState)PrepareAbort$.MODULE$, this.partitions().toSet(), now, now + (long)TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs());
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)expectedTransition), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null){

            public void answer() {
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.transactionManager(), this.transactionMarkerChannelManager()});
        this.coordinator().startup(false);
        this.time().sleep((long)TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs());
        this.scheduler().tick();
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldNotAbortExpiredTransactionsThatHaveAPendingStateTransition() {
        TransactionMetadata metadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (TransactionState)Ongoing$.MODULE$, this.partitions(), this.time().milliseconds(), this.time().milliseconds());
        metadata.prepareAbortOrCommit((TransactionState)PrepareCommit$.MODULE$, this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().timedOutTransactions()).andReturn((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransactionalIdAndProducerIdEpoch[]{new TransactionalIdAndProducerIdEpoch(this.transactionalId(), (long)this.producerId(), this.producerEpoch())})));
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), metadata)))).once();
        EasyMock.replay((Object[])new Object[]{this.transactionManager(), this.transactionMarkerChannelManager()});
        this.coordinator().startup(false);
        this.time().sleep((long)TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs());
        this.scheduler().tick();
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    private void validateRespondsWithConcurrentTransactionsOnInitPidWhenInPrepareState(TransactionState state) {
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        TransactionMetadata metadata = new TransactionMetadata(this.transactionalId(), 0L, 0, 0, state, (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic", 1)})), 0L, 0L);
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), metadata)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), 10, (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.CONCURRENT_TRANSACTIONS), (Object)this.result());
    }

    private void validateIncrementEpochAndUpdateMetadata(TransactionState state) {
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)this.pidManager().generateProducerId())).andReturn((Object)BoxesRunTime.boxToLong((long)this.producerId())).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        TransactionMetadata metadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), state, Set$.MODULE$.empty(), this.time().milliseconds(), this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), metadata))));
        Capture capturedNewMetadata = EasyMock.newCapture();
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.capture((Capture)capturedNewMetadata), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, metadata, capturedNewMetadata){
            private final /* synthetic */ TransactionCoordinatorTest $outer;
            private final TransactionMetadata metadata$1;
            private final Capture capturedNewMetadata$1;

            public void answer() {
                this.metadata$1.completeTransitionTo((TxnTransitMetadata)this.capturedNewMetadata$1.getValue());
                ((Function1)this.$outer.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.metadata$1 = metadata$1;
                this.capturedNewMetadata$1 = capturedNewMetadata$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.pidManager(), this.transactionManager()});
        int newTxnTimeoutMs = 10;
        this.coordinator().handleInitProducerId(this.transactionalId(), newTxnTimeoutMs, (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new InitProducerIdResult((long)this.producerId(), (short)(this.producerEpoch() + 1), Errors.NONE), (Object)this.result());
        Assert.assertEquals((long)newTxnTimeoutMs, (long)metadata.txnTimeoutMs());
        Assert.assertEquals((long)this.time().milliseconds(), (long)metadata.txnLastUpdateTimestamp());
        Assert.assertEquals((long)((short)(this.producerEpoch() + 1)), (long)metadata.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)metadata.producerId());
    }

    private TransactionMetadata mockPrepare(TransactionState transactionState, boolean runCallback) {
        long now = this.time().milliseconds();
        TransactionMetadata originalMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (TransactionState)Ongoing$.MODULE$, this.partitions(), now, now);
        TxnTransitMetadata transition = new TxnTransitMetadata((long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), transactionState, this.partitions().toSet(), now, now);
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), originalMetadata)))).once();
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)transition), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, runCallback){
            private final /* synthetic */ TransactionCoordinatorTest $outer;
            private final boolean runCallback$1;

            public void answer() {
                block0: {
                    if (!this.runCallback$1) break block0;
                    ((Function1)this.$outer.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.runCallback$1 = runCallback$1;
            }
        }).once();
        return new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), transactionState, this.partitions(), this.time().milliseconds(), this.time().milliseconds());
    }

    private boolean mockPrepare$default$2() {
        return false;
    }

    public void initProducerIdMockCallback(InitProducerIdResult ret) {
        this.result_$eq(ret);
    }

    public void errorsCallback(Errors ret) {
        this.error_$eq(ret);
    }

    public TransactionCoordinatorTest() {
        this.brokerId = 0;
        this.coordinatorEpoch = 0;
        this.transactionalId = "known";
        this.producerId = 10;
        this.producerEpoch = 1;
        this.txnTimeoutMs = 1;
    }
}

