/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Properties;
import kafka.api.BaseQuotaTest;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaId;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Sanitizer;
import org.junit.Before;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001\u000f\t\t2\t\\5f]RLE-U;pi\u0006$Vm\u001d;\u000b\u0005\r!\u0011aA1qS*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u00055\u0011\u0015m]3Rk>$\u0018\rV3ti\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003\u0013\u0001Aq!\u0005\u0001C\u0002\u0013\u0005##A\u0007vg\u0016\u0014\bK]5oG&\u0004\u0018\r\\\u000b\u0002'A\u0011A#G\u0007\u0002+)\u0011acF\u0001\u0005Y\u0006twMC\u0001\u0019\u0003\u0011Q\u0017M^1\n\u0005i)\"AB*ue&tw\r\u0003\u0004\u001d\u0001\u0001\u0006IaE\u0001\u000fkN,'\u000f\u0015:j]\u000eL\u0007/\u00197!\u0011\u0015q\u0002\u0001\"\u0011\u0013\u0003A\u0001(o\u001c3vG\u0016\u00148\t\\5f]RLE\rC\u0003!\u0001\u0011\u0005##\u0001\td_:\u001cX/\\3s\u00072LWM\u001c;JI\"9!\u0005\u0001b\u0001\n\u0003\u001a\u0013a\u00049s_\u0012,8-\u001a:Rk>$\u0018-\u00133\u0016\u0003\u0011\u0002\"!\n\u0015\u000e\u0003\u0019R!a\n\u0003\u0002\rM,'O^3s\u0013\tIcEA\u0004Rk>$\u0018-\u00133\t\r-\u0002\u0001\u0015!\u0003%\u0003A\u0001(o\u001c3vG\u0016\u0014\u0018+^8uC&#\u0007\u0005C\u0004.\u0001\t\u0007I\u0011I\u0012\u0002\u001f\r|gn];nKJ\fVo\u001c;b\u0013\u0012Daa\f\u0001!\u0002\u0013!\u0013\u0001E2p]N,X.\u001a:Rk>$\u0018-\u00133!\u0011\u0015\t\u0004\u0001\"\u00113\u0003\u0015\u0019X\r^+q)\u0005\u0019\u0004C\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$\u0001B+oSRD#\u0001\r\u001e\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014!\u00026v]&$(\"A \u0002\u0007=\u0014x-\u0003\u0002By\t1!)\u001a4pe\u0016DQa\u0011\u0001\u0005B\u0011\u000bab\u001c<feJLG-Z)v_R\f7\u000f\u0006\u00034\u000b*c\u0005\"\u0002$C\u0001\u00049\u0015!\u00049s_\u0012,8-\u001a:Rk>$\u0018\r\u0005\u00025\u0011&\u0011\u0011*\u000e\u0002\u0005\u0019>tw\rC\u0003L\u0005\u0002\u0007q)A\u0007d_:\u001cX/\\3s#V|G/\u0019\u0005\u0006\u001b\n\u0003\rAT\u0001\re\u0016\fX/Z:u#V|G/\u0019\t\u0003i=K!\u0001U\u001b\u0003\r\u0011{WO\u00197f\u0011\u0015\u0011\u0006\u0001\"\u00113\u0003Q\u0011X-\\8wKF+x\u000e^1Pm\u0016\u0014(/\u001b3fg\")A\u000b\u0001C\u0005+\u0006\u0019R\u000f\u001d3bi\u0016\fVo\u001c;b\u001fZ,'O]5eKR\u00191G\u00162\t\u000b]\u001b\u0006\u0019\u0001-\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\u0004\"!\u00171\u000f\u0005is\u0006CA.6\u001b\u0005a&BA/\u0007\u0003\u0019a$o\\8u}%\u0011q,N\u0001\u0007!J,G-\u001a4\n\u0005i\t'BA06\u0011\u0015\u00197\u000b1\u0001e\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0003K\"l\u0011A\u001a\u0006\u0003O^\tA!\u001e;jY&\u0011\u0011N\u001a\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b")
public class ClientIdQuotaTest
extends BaseQuotaTest {
    private final String userPrincipal = KafkaPrincipal.ANONYMOUS.getName();
    private final QuotaId producerQuotaId = new QuotaId((Option)None$.MODULE$, (Option)new Some((Object)this.producerClientId()), (Option)new Some((Object)Sanitizer.sanitize((String)this.producerClientId())));
    private final QuotaId consumerQuotaId = new QuotaId((Option)None$.MODULE$, (Option)new Some((Object)this.consumerClientId()), (Option)new Some((Object)Sanitizer.sanitize((String)this.consumerClientId())));

    @Override
    public String userPrincipal() {
        return this.userPrincipal;
    }

    @Override
    public String producerClientId() {
        return "QuotasTestProducer-!@#$%^&*()";
    }

    @Override
    public String consumerClientId() {
        return "QuotasTestConsumer-!@#$%^&*()";
    }

    @Override
    public QuotaId producerQuotaId() {
        return this.producerQuotaId;
    }

    @Override
    public QuotaId consumerQuotaId() {
        return this.consumerQuotaId;
    }

    @Override
    @Before
    public void setUp() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ProducerQuotaBytesPerSecondDefaultProp(), ((Object)BoxesRunTime.boxToInteger((int)this.defaultProducerQuota())).toString());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ConsumerQuotaBytesPerSecondDefaultProp(), ((Object)BoxesRunTime.boxToInteger((int)this.defaultConsumerQuota())).toString());
        super.setUp();
    }

    @Override
    public void overrideQuotas(long producerQuota, long consumerQuota, double requestQuota) {
        Properties producerProps = new Properties();
        producerProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)producerQuota)).toString());
        producerProps.put(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), ((Object)BoxesRunTime.boxToDouble((double)requestQuota)).toString());
        this.updateQuotaOverride(this.producerClientId(), producerProps);
        Properties consumerProps = new Properties();
        consumerProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)consumerQuota)).toString());
        consumerProps.put(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), ((Object)BoxesRunTime.boxToDouble((double)requestQuota)).toString());
        this.updateQuotaOverride(this.consumerClientId(), consumerProps);
    }

    @Override
    public void removeQuotaOverrides() {
        Properties emptyProps = new Properties();
        this.updateQuotaOverride(this.producerClientId(), emptyProps);
        this.updateQuotaOverride(this.consumerClientId(), emptyProps);
    }

    private void updateQuotaOverride(String clientId, Properties properties) {
        this.adminZkClient().changeClientIdConfig(Sanitizer.sanitize((String)clientId), properties);
    }
}

