/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quickstart;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.MultipartConfigElement;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspPropertyGroupDescriptor;
import javax.servlet.descriptor.TaglibDescriptor;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.plus.annotation.LifeCycleCallback;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlAppendable;

public class QuickStartDescriptorGenerator {
    private static final Logger LOG = Log.getLogger(QuickStartDescriptorGenerator.class);
    public static final String DEFAULT_QUICKSTART_DESCRIPTOR_NAME = "quickstart-web.xml";
    protected WebAppContext _webApp;
    protected String _extraXML;

    public QuickStartDescriptorGenerator(WebAppContext w, String extraXML) {
        this._webApp = w;
        this._extraXML = extraXML;
    }

    /*
     * WARNING - void declaration
     */
    public void generateQuickStartWebXml(OutputStream stream) throws FileNotFoundException, IOException {
        LifeCycleCallbackCollection lifecycles;
        ServletContextHandler.JspConfig jspConfig;
        MimeTypes mimeTypes;
        Map errorPages;
        Map localeEncodings;
        SecurityHandler security;
        ServletHandler servlets;
        if (this._webApp == null) {
            throw new IllegalStateException("No webapp for quickstart generation");
        }
        if (stream == null) {
            throw new IllegalStateException("No output for quickstart generation");
        }
        this._webApp.getMetaData().getOrigins();
        if (this._webApp.getBaseResource() == null) {
            throw new IllegalArgumentException("No base resource for " + this);
        }
        LOG.info("Quickstart generating", new Object[0]);
        XmlAppendable out = new XmlAppendable(stream, "UTF-8");
        MetaData md = this._webApp.getMetaData();
        HashMap<String, String> webappAttr = new HashMap<String, String>();
        webappAttr.put("xmlns", "http://xmlns.jcp.org/xml/ns/javaee");
        webappAttr.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        webappAttr.put("xsi:schemaLocation", "http://xmlns.jcp.org/xml/ns/javaee http://xmlns.jcp.org/xml/ns/javaee/web-app_3_1.xsd");
        webappAttr.put("metadata-complete", "true");
        webappAttr.put("version", "3.1");
        out.openTag("web-app", webappAttr);
        if (this._webApp.getDisplayName() != null) {
            out.tag("display-name", this._webApp.getDisplayName());
        }
        String resourceBase = this._webApp.getBaseResource().getFile().getCanonicalFile().getAbsoluteFile().toURI().toString();
        this.addContextParamFromAttribute(out, "javax.servlet.context.orderedLibs");
        this.addContextParamFromAttribute(out, "org.eclipse.jetty.containerInitializers");
        this.addContextParamFromAttribute(out, "org.eclipse.jetty.tlds", resourceBase);
        this.addContextParamFromAttribute(out, "org.eclipse.jetty.resources", resourceBase);
        for (String p : this._webApp.getInitParams().keySet()) {
            out.openTag("context-param", this.origin(md, "context-param." + p)).tag("param-name", p).tag("param-value", this._webApp.getInitParameter(p)).closeTag();
        }
        if (this._webApp.getEventListeners() != null) {
            for (EventListener e : this._webApp.getEventListeners()) {
                out.openTag("listener", this.origin(md, e.getClass().getCanonicalName() + ".listener")).tag("listener-class", e.getClass().getCanonicalName()).closeTag();
            }
        }
        if ((servlets = this._webApp.getServletHandler()).getFilters() != null) {
            for (FilterHolder filterHolder : servlets.getFilters()) {
                this.outholder(out, md, filterHolder);
            }
        }
        if (servlets.getFilterMappings() != null) {
            for (FilterMapping filterMapping : servlets.getFilterMappings()) {
                out.openTag("filter-mapping");
                out.tag("filter-name", filterMapping.getFilterName());
                if (filterMapping.getPathSpecs() != null) {
                    for (String s : filterMapping.getPathSpecs()) {
                        out.tag("url-pattern", s);
                    }
                }
                if (filterMapping.getServletNames() != null) {
                    for (String n : filterMapping.getServletNames()) {
                        out.tag("servlet-name", n);
                    }
                }
                if (!filterMapping.isDefaultDispatches()) {
                    if (filterMapping.appliesTo(DispatcherType.REQUEST)) {
                        out.tag("dispatcher", "REQUEST");
                    }
                    if (filterMapping.appliesTo(DispatcherType.ASYNC)) {
                        out.tag("dispatcher", "ASYNC");
                    }
                    if (filterMapping.appliesTo(DispatcherType.ERROR)) {
                        out.tag("dispatcher", "ERROR");
                    }
                    if (filterMapping.appliesTo(DispatcherType.FORWARD)) {
                        out.tag("dispatcher", "FORWARD");
                    }
                    if (filterMapping.appliesTo(DispatcherType.INCLUDE)) {
                        out.tag("dispatcher", "INCLUDE");
                    }
                }
                out.closeTag();
            }
        }
        if (servlets.getServlets() != null) {
            for (ServletHolder servletHolder : servlets.getServlets()) {
                this.outholder(out, md, servletHolder);
            }
        }
        if (servlets.getServletMappings() != null) {
            for (ServletMapping servletMapping : servlets.getServletMappings()) {
                out.openTag("servlet-mapping", this.origin(md, servletMapping.getServletName() + ".servlet.mappings"));
                out.tag("servlet-name", servletMapping.getServletName());
                if (servletMapping.getPathSpecs() != null) {
                    for (String s : servletMapping.getPathSpecs()) {
                        out.tag("url-pattern", s);
                    }
                }
                out.closeTag();
            }
        }
        if ((security = this._webApp.getSecurityHandler()) != null && (security.getRealmName() != null || security.getAuthMethod() != null)) {
            out.openTag("login-config");
            if (security.getAuthMethod() != null) {
                out.tag("auth-method", this.origin(md, "auth-method"), security.getAuthMethod());
            }
            if (security.getRealmName() != null) {
                out.tag("realm-name", this.origin(md, "realm-name"), security.getRealmName());
            }
            if ("FORM".equalsIgnoreCase(security.getAuthMethod())) {
                out.openTag("form-login-config");
                out.tag("form-login-page", this.origin(md, "form-login-page"), security.getInitParameter("org.eclipse.jetty.security.form_login_page"));
                out.tag("form-error-page", this.origin(md, "form-error-page"), security.getInitParameter("org.eclipse.jetty.security.form_error_page"));
                out.closeTag();
            }
            out.closeTag();
        }
        if (security instanceof ConstraintAware) {
            ConstraintAware ca = (ConstraintAware)security;
            for (String string : ca.getRoles()) {
                out.openTag("security-role").tag("role-name", string).closeTag();
            }
            for (ConstraintMapping constraintMapping : ca.getConstraintMappings()) {
                out.openTag("security-constraint");
                out.openTag("web-resource-collection");
                if (constraintMapping.getConstraint().getName() != null) {
                    out.tag("web-resource-name", constraintMapping.getConstraint().getName());
                }
                if (constraintMapping.getPathSpec() != null) {
                    out.tag("url-pattern", this.origin(md, "constraint.url." + constraintMapping.getPathSpec()), constraintMapping.getPathSpec());
                }
                if (constraintMapping.getMethod() != null) {
                    out.tag("http-method", constraintMapping.getMethod());
                }
                if (constraintMapping.getMethodOmissions() != null) {
                    for (String o : constraintMapping.getMethodOmissions()) {
                        out.tag("http-method-omission", o);
                    }
                }
                out.closeTag();
                if (constraintMapping.getConstraint().getAuthenticate()) {
                    String[] roles = constraintMapping.getConstraint().getRoles();
                    if (roles != null && roles.length > 0) {
                        out.openTag("auth-constraint");
                        if (constraintMapping.getConstraint().getRoles() != null) {
                            for (String r : constraintMapping.getConstraint().getRoles()) {
                                out.tag("role-name", r);
                            }
                        }
                        out.closeTag();
                    } else {
                        out.tag("auth-constraint");
                    }
                }
                switch (constraintMapping.getConstraint().getDataConstraint()) {
                    case 0: {
                        out.openTag("user-data-constraint").tag("transport-guarantee", "NONE").closeTag();
                        break;
                    }
                    case 1: {
                        out.openTag("user-data-constraint").tag("transport-guarantee", "INTEGRAL").closeTag();
                        break;
                    }
                    case 2: {
                        out.openTag("user-data-constraint").tag("transport-guarantee", "CONFIDENTIAL").closeTag();
                        break;
                    }
                }
                out.closeTag();
            }
        }
        if (this._webApp.getWelcomeFiles() != null) {
            void var10_40;
            out.openTag("welcome-file-list");
            String[] arr$ = this._webApp.getWelcomeFiles();
            int len$ = arr$.length;
            boolean bl = false;
            while (var10_40 < len$) {
                String welcomeFile = arr$[var10_40];
                out.tag("welcome-file", welcomeFile);
                ++var10_40;
            }
            out.closeTag();
        }
        if ((localeEncodings = this._webApp.getLocaleEncodings()) != null && !localeEncodings.isEmpty()) {
            out.openTag("locale-encoding-mapping-list");
            for (Map.Entry entry : localeEncodings.entrySet()) {
                out.openTag("locale-encoding-mapping", this.origin(md, "locale-encoding." + (String)entry.getKey()));
                out.tag("locale", (String)entry.getKey());
                out.tag("encoding", (String)entry.getValue());
                out.closeTag();
            }
            out.closeTag();
        }
        if (this._webApp.getSessionHandler().getSessionManager() != null) {
            Set modes;
            out.openTag("session-config");
            int maxInactiveSec = this._webApp.getSessionHandler().getSessionManager().getMaxInactiveInterval();
            out.tag("session-timeout", maxInactiveSec == 0 ? "0" : Integer.toString(maxInactiveSec / 60));
            SessionCookieConfig sessionCookieConfig = this._webApp.getSessionHandler().getSessionManager().getSessionCookieConfig();
            if (sessionCookieConfig != null) {
                out.openTag("cookie-config");
                if (sessionCookieConfig.getName() != null) {
                    out.tag("name", this.origin(md, "cookie-config.name"), sessionCookieConfig.getName());
                }
                if (sessionCookieConfig.getDomain() != null) {
                    out.tag("domain", this.origin(md, "cookie-config.domain"), sessionCookieConfig.getDomain());
                }
                if (sessionCookieConfig.getPath() != null) {
                    out.tag("path", this.origin(md, "cookie-config.path"), sessionCookieConfig.getPath());
                }
                if (sessionCookieConfig.getComment() != null) {
                    out.tag("comment", this.origin(md, "cookie-config.comment"), sessionCookieConfig.getComment());
                }
                out.tag("http-only", this.origin(md, "cookie-config.http-only"), Boolean.toString(sessionCookieConfig.isHttpOnly()));
                out.tag("secure", this.origin(md, "cookie-config.secure"), Boolean.toString(sessionCookieConfig.isSecure()));
                out.tag("max-age", this.origin(md, "cookie-config.max-age"), Integer.toString(sessionCookieConfig.getMaxAge()));
                out.closeTag();
            }
            if ((modes = this._webApp.getSessionHandler().getSessionManager().getEffectiveSessionTrackingModes()) != null) {
                for (SessionTrackingMode mode : modes) {
                    out.tag("tracking-mode", mode.toString());
                }
            }
            out.closeTag();
        }
        if ((errorPages = ((ErrorPageErrorHandler)this._webApp.getErrorHandler()).getErrorPages()) != null) {
            for (Map.Entry entry : errorPages.entrySet()) {
                out.openTag("error-page", this.origin(md, "error." + (String)entry.getKey()));
                if (!"org.eclipse.jetty.server.error_page.global".equals(entry.getKey())) {
                    if (((String)entry.getKey()).matches("\\d{3}")) {
                        out.tag("error-code", (String)entry.getKey());
                    } else {
                        out.tag("exception-type", (String)entry.getKey());
                    }
                }
                out.tag("location", (String)entry.getValue());
                out.closeTag();
            }
        }
        if ((mimeTypes = this._webApp.getMimeTypes()) != null) {
            for (Map.Entry entry : mimeTypes.getMimeMap().entrySet()) {
                out.openTag("mime-mapping");
                out.tag("extension", this.origin(md, "extension." + (String)entry.getKey()), (String)entry.getKey());
                out.tag("mime-type", (String)entry.getValue());
                out.closeTag();
            }
        }
        if ((jspConfig = (ServletContextHandler.JspConfig)this._webApp.getServletContext().getJspConfigDescriptor()) != null) {
            Collection jspPropertyGroups;
            out.openTag("jsp-config");
            Collection tlds = jspConfig.getTaglibs();
            if (tlds != null && !tlds.isEmpty()) {
                for (TaglibDescriptor tld : tlds) {
                    out.openTag("taglib");
                    out.tag("taglib-uri", tld.getTaglibURI());
                    out.tag("taglib-location", tld.getTaglibLocation());
                    out.closeTag();
                }
            }
            if ((jspPropertyGroups = jspConfig.getJspPropertyGroups()) != null && !jspPropertyGroups.isEmpty()) {
                for (JspPropertyGroupDescriptor jspPropertyGroup : jspPropertyGroups) {
                    out.openTag("jsp-property-group");
                    Collection strings = jspPropertyGroup.getUrlPatterns();
                    if (strings != null && !strings.isEmpty()) {
                        for (String urlPattern : strings) {
                            out.tag("url-pattern", urlPattern);
                        }
                    }
                    if (jspPropertyGroup.getElIgnored() != null) {
                        out.tag("el-ignored", jspPropertyGroup.getElIgnored());
                    }
                    if (jspPropertyGroup.getPageEncoding() != null) {
                        out.tag("page-encoding", jspPropertyGroup.getPageEncoding());
                    }
                    if (jspPropertyGroup.getScriptingInvalid() != null) {
                        out.tag("scripting-invalid", jspPropertyGroup.getScriptingInvalid());
                    }
                    if (jspPropertyGroup.getIsXml() != null) {
                        out.tag("is-xml", jspPropertyGroup.getIsXml());
                    }
                    if (jspPropertyGroup.getDeferredSyntaxAllowedAsLiteral() != null) {
                        out.tag("deferred-syntax-allowed-as-literal", jspPropertyGroup.getDeferredSyntaxAllowedAsLiteral());
                    }
                    if (jspPropertyGroup.getTrimDirectiveWhitespaces() != null) {
                        out.tag("trim-directive-whitespaces", jspPropertyGroup.getTrimDirectiveWhitespaces());
                    }
                    if (jspPropertyGroup.getDefaultContentType() != null) {
                        out.tag("default-content-type", jspPropertyGroup.getDefaultContentType());
                    }
                    if (jspPropertyGroup.getBuffer() != null) {
                        out.tag("buffer", jspPropertyGroup.getBuffer());
                    }
                    if (jspPropertyGroup.getErrorOnUndeclaredNamespace() != null) {
                        out.tag("error-on-undeclared-namespace", jspPropertyGroup.getErrorOnUndeclaredNamespace());
                    }
                    if ((strings = jspPropertyGroup.getIncludePreludes()) != null && !strings.isEmpty()) {
                        for (String prelude : strings) {
                            out.tag("include-prelude", prelude);
                        }
                    }
                    if ((strings = jspPropertyGroup.getIncludeCodas()) != null && !strings.isEmpty()) {
                        for (String coda : strings) {
                            out.tag("include-coda", coda);
                        }
                    }
                    out.closeTag();
                }
            }
            out.closeTag();
        }
        if ((lifecycles = (LifeCycleCallbackCollection)this._webApp.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection")) != null) {
            Collection tmp = lifecycles.getPostConstructCallbacks();
            for (LifeCycleCallback c : tmp) {
                out.openTag("post-construct");
                out.tag("lifecycle-callback-class", c.getTargetClassName());
                out.tag("lifecycle-callback-method", c.getMethodName());
                out.closeTag();
            }
            tmp = lifecycles.getPreDestroyCallbacks();
            for (LifeCycleCallback c : tmp) {
                out.openTag("pre-destroy");
                out.tag("lifecycle-callback-class", c.getTargetClassName());
                out.tag("lifecycle-callback-method", c.getMethodName());
                out.closeTag();
            }
        }
        out.literal(this._extraXML);
        out.closeTag();
    }

    private void addContextParamFromAttribute(XmlAppendable out, String attribute) throws IOException {
        this.addContextParamFromAttribute(out, attribute, null);
    }

    private void addContextParamFromAttribute(XmlAppendable out, String attribute, String resourceBase) throws IOException {
        Object o = this._webApp.getAttribute(attribute);
        if (o == null) {
            return;
        }
        List<Object> c = o instanceof Collection ? (List<Object>)o : Collections.singletonList(o);
        StringBuilder v = new StringBuilder();
        for (Object e : c) {
            if (e == null) continue;
            if (v.length() > 0) {
                v.append(",\n    ");
            } else {
                v.append("\n    ");
            }
            if (resourceBase == null) {
                QuotedStringTokenizer.quote((Appendable)v, (String)e.toString());
                continue;
            }
            QuotedStringTokenizer.quote((Appendable)v, (String)e.toString().replace(resourceBase, "${WAR}/"));
        }
        out.openTag("context-param").tag("param-name", attribute).tagCDATA("param-value", v.toString()).closeTag();
    }

    private void outholder(XmlAppendable out, MetaData md, FilterHolder holder) throws IOException {
        if (LOG.isDebugEnabled()) {
            out.openTag("filter", Collections.singletonMap("source", holder.getSource().toString()));
        } else {
            out.openTag("filter");
        }
        String n = holder.getName();
        out.tag("filter-name", n);
        String ot = n + ".filter.";
        if (holder instanceof FilterHolder) {
            out.tag("filter-class", this.origin(md, ot + "filter-class"), holder.getClassName());
            out.tag("async-supported", this.origin(md, ot + "async-supported"), holder.isAsyncSupported() ? "true" : "false");
        }
        for (String p : holder.getInitParameters().keySet()) {
            out.openTag("init-param", this.origin(md, ot + "init-param." + p)).tag("param-name", p).tag("param-value", holder.getInitParameter(p)).closeTag();
        }
        out.closeTag();
    }

    private void outholder(XmlAppendable out, MetaData md, ServletHolder holder) throws IOException {
        MultipartConfigElement multipartConfig;
        Map roles;
        if (LOG.isDebugEnabled()) {
            out.openTag("servlet", Collections.singletonMap("source", holder.getSource().toString()));
        } else {
            out.openTag("servlet");
        }
        String n = holder.getName();
        out.tag("servlet-name", n);
        String ot = n + ".servlet.";
        ServletHolder s = holder;
        if (s.getForcedPath() != null && s.getClassName() == null) {
            out.tag("jsp-file", s.getForcedPath());
        } else {
            out.tag("servlet-class", this.origin(md, ot + "servlet-class"), s.getClassName());
        }
        for (String p : holder.getInitParameters().keySet()) {
            if ("jsp".equalsIgnoreCase(n) && "scratchdir".equalsIgnoreCase(p)) continue;
            out.openTag("init-param", this.origin(md, ot + "init-param." + p)).tag("param-name", p).tag("param-value", holder.getInitParameter(p)).closeTag();
        }
        if (s.getInitOrder() >= 0) {
            out.tag("load-on-startup", Integer.toString(s.getInitOrder()));
        }
        if (!s.isEnabled()) {
            out.tag("enabled", this.origin(md, ot + "enabled"), "false");
        }
        out.tag("async-supported", this.origin(md, ot + "async-supported"), holder.isAsyncSupported() ? "true" : "false");
        if (s.getRunAsRole() != null) {
            out.openTag("run-as", this.origin(md, ot + "run-as")).tag("role-name", s.getRunAsRole()).closeTag();
        }
        if ((roles = s.getRoleRefMap()) != null) {
            for (Map.Entry e : roles.entrySet()) {
                out.openTag("security-role-ref", this.origin(md, ot + "role-name." + (String)e.getKey())).tag("role-name", (String)e.getKey()).tag("role-link", (String)e.getValue()).closeTag();
            }
        }
        if ((multipartConfig = ((ServletHolder.Registration)s.getRegistration()).getMultipartConfig()) != null) {
            out.openTag("multipart-config", this.origin(md, s.getName() + ".servlet.multipart-config"));
            if (multipartConfig.getLocation() != null) {
                out.tag("location", multipartConfig.getLocation());
            }
            out.tag("max-file-size", Long.toString(multipartConfig.getMaxFileSize()));
            out.tag("max-request-size", Long.toString(multipartConfig.getMaxRequestSize()));
            out.tag("file-size-threshold", Long.toString(multipartConfig.getFileSizeThreshold()));
            out.closeTag();
        }
        out.closeTag();
    }

    public Map<String, String> origin(MetaData md, String name) {
        if (!LOG.isDebugEnabled()) {
            return Collections.emptyMap();
        }
        if (name == null) {
            return Collections.emptyMap();
        }
        MetaData.OriginInfo origin = md.getOriginInfo(name);
        if (LOG.isDebugEnabled()) {
            LOG.debug("origin of " + name + " is " + origin, new Object[0]);
        }
        if (origin == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("origin", origin.toString());
    }
}

