/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.indexlifecycle;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleExecutionState;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleSettings;
import org.elasticsearch.xpack.core.indexlifecycle.Step;
import org.elasticsearch.xpack.indexlifecycle.IndexLifecycleRunner;

public class SetStepInfoUpdateTask
extends ClusterStateUpdateTask {
    private final Index index;
    private final String policy;
    private final Step.StepKey currentStepKey;
    private ToXContentObject stepInfo;

    public SetStepInfoUpdateTask(Index index, String policy, Step.StepKey currentStepKey, ToXContentObject stepInfo) {
        this.index = index;
        this.policy = policy;
        this.currentStepKey = currentStepKey;
        this.stepInfo = stepInfo;
    }

    Index getIndex() {
        return this.index;
    }

    String getPolicy() {
        return this.policy;
    }

    Step.StepKey getCurrentStepKey() {
        return this.currentStepKey;
    }

    ToXContentObject getStepInfo() {
        return this.stepInfo;
    }

    public ClusterState execute(ClusterState currentState) throws IOException {
        IndexMetaData idxMeta = currentState.getMetaData().index(this.index);
        if (idxMeta == null) {
            return currentState;
        }
        Settings indexSettings = idxMeta.getSettings();
        LifecycleExecutionState indexILMData = LifecycleExecutionState.fromIndexMetadata((IndexMetaData)idxMeta);
        if (this.policy.equals(LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexSettings)) && Objects.equals(this.currentStepKey, IndexLifecycleRunner.getCurrentStepKey(indexILMData))) {
            return IndexLifecycleRunner.addStepInfoToClusterState(this.index, currentState, this.stepInfo);
        }
        return currentState;
    }

    public void onFailure(String source, Exception e) {
        throw new ElasticsearchException("policy [" + this.policy + "] for index [" + this.index.getName() + "] failed trying to set step info for step [" + this.currentStepKey + "].", (Throwable)e, new Object[0]);
    }

    public static class ExceptionWrapper
    implements ToXContentObject {
        private final Throwable exception;

        public ExceptionWrapper(Throwable exception) {
            this.exception = exception;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)params, (Throwable)this.exception);
            builder.endObject();
            return builder;
        }
    }
}

