/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.action.AutoFollowCoordinator;
import org.elasticsearch.xpack.core.ccr.AutoFollowStats;
import org.elasticsearch.xpack.core.ccr.action.CcrStatsAction;
import org.elasticsearch.xpack.core.ccr.action.FollowStatsAction;

public class TransportCcrStatsAction
extends TransportMasterNodeAction<CcrStatsAction.Request, CcrStatsAction.Response> {
    private final Client client;
    private final CcrLicenseChecker ccrLicenseChecker;
    private final AutoFollowCoordinator autoFollowCoordinator;

    @Inject
    public TransportCcrStatsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AutoFollowCoordinator autoFollowCoordinator, CcrLicenseChecker ccrLicenseChecker, Client client) {
        super(settings, "cluster:monitor/ccr/stats", transportService, clusterService, threadPool, actionFilters, CcrStatsAction.Request::new, indexNameExpressionResolver);
        this.client = client;
        this.ccrLicenseChecker = Objects.requireNonNull(ccrLicenseChecker);
        this.autoFollowCoordinator = Objects.requireNonNull(autoFollowCoordinator);
    }

    protected String executor() {
        return "ccr";
    }

    protected CcrStatsAction.Response newResponse() {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }

    protected CcrStatsAction.Response read(StreamInput in) throws IOException {
        return new CcrStatsAction.Response(in);
    }

    protected void doExecute(Task task, CcrStatsAction.Request request, ActionListener<CcrStatsAction.Response> listener) {
        if (!this.ccrLicenseChecker.isCcrAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ccr"));
            return;
        }
        super.doExecute(task, (MasterNodeRequest)request, listener);
    }

    protected void masterOperation(CcrStatsAction.Request request, ClusterState state, ActionListener<CcrStatsAction.Response> listener) throws Exception {
        CheckedConsumer handler = statsResponse -> {
            AutoFollowStats stats = this.autoFollowCoordinator.getStats();
            listener.onResponse((Object)new CcrStatsAction.Response(stats, statsResponse));
        };
        FollowStatsAction.StatsRequest statsRequest = new FollowStatsAction.StatsRequest();
        this.client.execute((Action)FollowStatsAction.INSTANCE, (ActionRequest)statsRequest, ActionListener.wrap((CheckedConsumer)handler, arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(CcrStatsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

