/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.math;

import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.BinaryMathProcessor;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.BinaryPipe;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;

public class BinaryMathPipe
extends BinaryPipe {
    private final BinaryMathProcessor.BinaryMathOperation operation;

    public BinaryMathPipe(Source source, Expression expression, Pipe left, Pipe right, BinaryMathProcessor.BinaryMathOperation operation) {
        super(source, expression, left, right);
        this.operation = operation;
    }

    @Override
    protected NodeInfo<BinaryMathPipe> info() {
        return NodeInfo.create(this, BinaryMathPipe::new, this.expression(), this.left(), this.right(), this.operation);
    }

    public BinaryMathProcessor.BinaryMathOperation operation() {
        return this.operation;
    }

    @Override
    protected BinaryPipe replaceChildren(Pipe left, Pipe right) {
        return new BinaryMathPipe(this.source(), this.expression(), left, right, this.operation);
    }

    @Override
    public BinaryMathProcessor asProcessor() {
        return new BinaryMathProcessor(this.left().asProcessor(), this.right().asProcessor(), this.operation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.operation);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            BinaryMathPipe other = (BinaryMathPipe)obj;
            return Objects.equals(this.operation, other.operation);
        }
        return false;
    }
}

