/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.expression.gen.script.Scripts;
import org.elasticsearch.xpack.sql.tree.Source;

public abstract class BinaryScalarFunction
extends ScalarFunction {
    private final Expression left;
    private final Expression right;

    protected BinaryScalarFunction(Source source, Expression left, Expression right) {
        super(source, Arrays.asList(left, right));
        this.left = left;
        this.right = right;
    }

    @Override
    public final BinaryScalarFunction replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 2) {
            throw new IllegalArgumentException("expected [2] children but received [" + newChildren.size() + "]");
        }
        return this.replaceChildren(newChildren.get(0), newChildren.get(1));
    }

    protected abstract BinaryScalarFunction replaceChildren(Expression var1, Expression var2);

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    @Override
    public boolean foldable() {
        return this.left.foldable() && this.right.foldable();
    }

    @Override
    public ScriptTemplate asScript() {
        ScriptTemplate leftScript = this.asScript(this.left());
        ScriptTemplate rightScript = this.asScript(this.right());
        return this.asScriptFrom(leftScript, rightScript);
    }

    protected ScriptTemplate asScriptFrom(ScriptTemplate leftScript, ScriptTemplate rightScript) {
        return Scripts.binaryMethod(this.scriptMethodName(), leftScript, rightScript, this.dataType());
    }

    protected String scriptMethodName() {
        return this.getClass().getSimpleName().toLowerCase(Locale.ROOT);
    }
}

