/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.esnative;

import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.user.User;

class UserAndPassword {
    private final User user;
    private final char[] passwordHash;
    private final Hasher hasher;

    UserAndPassword(User user, char[] passwordHash) {
        this.user = user;
        this.passwordHash = passwordHash;
        this.hasher = Hasher.resolveFromHash((char[])this.passwordHash);
    }

    public User user() {
        return this.user;
    }

    public char[] passwordHash() {
        return this.passwordHash;
    }

    boolean verifyPassword(SecureString data) {
        return this.hasher.verify(data, this.passwordHash);
    }

    public boolean equals(Object o) {
        return false;
    }

    public int hashCode() {
        int result = this.user.hashCode();
        result = 31 * result + this.passwordHash().hashCode();
        return result;
    }
}

