/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.persistent;

import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.persistent.CompletionPersistentTaskAction;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskResponse;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.RemovePersistentTaskAction;
import org.elasticsearch.persistent.StartPersistentTaskAction;
import org.elasticsearch.persistent.UpdatePersistentTaskStatusAction;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;

public class PersistentTasksService {
    private static final Logger logger = LogManager.getLogger(PersistentTasksService.class);
    private static final String PERSISTENT_TASK_ORIGIN = "persistent_tasks";
    private final Client client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;

    public PersistentTasksService(ClusterService clusterService, ThreadPool threadPool, Client client) {
        this.client = new OriginSettingClient(client, PERSISTENT_TASK_ORIGIN);
        this.clusterService = clusterService;
        this.threadPool = threadPool;
    }

    public <Params extends PersistentTaskParams> void sendStartRequest(String taskId, String taskName, Params taskParams, ActionListener<PersistentTasksCustomMetaData.PersistentTask<Params>> listener) {
        ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>> wrappedListener = ActionListener.wrap(t -> listener.onResponse((PersistentTasksCustomMetaData.PersistentTask)t), listener::onFailure);
        StartPersistentTaskAction.Request request = new StartPersistentTaskAction.Request(taskId, taskName, taskParams);
        this.execute(request, StartPersistentTaskAction.INSTANCE, wrappedListener);
    }

    public void sendCompletionRequest(String taskId, long taskAllocationId, @Nullable Exception taskFailure, ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>> listener) {
        CompletionPersistentTaskAction.Request request = new CompletionPersistentTaskAction.Request(taskId, taskAllocationId, taskFailure);
        this.execute(request, CompletionPersistentTaskAction.INSTANCE, listener);
    }

    void sendCancelRequest(long taskId, String reason, ActionListener<CancelTasksResponse> listener) {
        CancelTasksRequest request = new CancelTasksRequest();
        request.setTaskId(new TaskId(this.clusterService.localNode().getId(), taskId));
        request.setReason(reason);
        try {
            this.client.admin().cluster().cancelTasks(request, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    void sendUpdateStateRequest(String taskId, long taskAllocationID, PersistentTaskState taskState, ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>> listener) {
        UpdatePersistentTaskStatusAction.Request request = new UpdatePersistentTaskStatusAction.Request(taskId, taskAllocationID, taskState);
        this.execute(request, UpdatePersistentTaskStatusAction.INSTANCE, listener);
    }

    public void sendRemoveRequest(String taskId, ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>> listener) {
        RemovePersistentTaskAction.Request request = new RemovePersistentTaskAction.Request(taskId);
        this.execute(request, RemovePersistentTaskAction.INSTANCE, listener);
    }

    private <Req extends ActionRequest, Resp extends PersistentTaskResponse, Builder extends ActionRequestBuilder<Req, Resp, Builder>> void execute(Req request, Action<Req, Resp, Builder> action, ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>> listener) {
        try {
            this.client.execute(action, request, ActionListener.wrap(r -> listener.onResponse(r.getTask()), listener::onFailure));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void waitForPersistentTaskCondition(final String taskId, Predicate<PersistentTasksCustomMetaData.PersistentTask<?>> predicate, @Nullable TimeValue timeout, final WaitForPersistentTaskListener<?> listener) {
        Predicate<ClusterState> clusterStatePredicate = clusterState -> predicate.test(PersistentTasksCustomMetaData.getTaskWithId(clusterState, taskId));
        ClusterStateObserver observer = new ClusterStateObserver(this.clusterService, timeout, logger, this.threadPool.getThreadContext());
        ClusterState clusterState2 = observer.setAndGetObservedState();
        if (clusterStatePredicate.test(clusterState2)) {
            listener.onResponse(PersistentTasksCustomMetaData.getTaskWithId(clusterState2, taskId));
        } else {
            observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    listener.onResponse(PersistentTasksCustomMetaData.getTaskWithId(state, taskId));
                }

                @Override
                public void onClusterServiceClose() {
                    listener.onFailure(new NodeClosedException(PersistentTasksService.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    listener.onTimeout(timeout);
                }
            }, clusterStatePredicate);
        }
    }

    public void waitForPersistentTasksCondition(Predicate<PersistentTasksCustomMetaData> predicate, @Nullable TimeValue timeout, final ActionListener<Boolean> listener) {
        Predicate<ClusterState> clusterStatePredicate = clusterState -> predicate.test((PersistentTasksCustomMetaData)clusterState.metaData().custom(PERSISTENT_TASK_ORIGIN));
        ClusterStateObserver observer = new ClusterStateObserver(this.clusterService, timeout, logger, this.threadPool.getThreadContext());
        if (clusterStatePredicate.test(observer.setAndGetObservedState())) {
            listener.onResponse(true);
        } else {
            observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    listener.onResponse(true);
                }

                @Override
                public void onClusterServiceClose() {
                    listener.onFailure(new NodeClosedException(PersistentTasksService.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    listener.onFailure(new IllegalStateException("Timed out when waiting for persistent tasks after " + timeout));
                }
            }, clusterStatePredicate, timeout);
        }
    }

    public static interface WaitForPersistentTaskListener<P extends PersistentTaskParams>
    extends ActionListener<PersistentTasksCustomMetaData.PersistentTask<P>> {
        default public void onTimeout(TimeValue timeout) {
            this.onFailure(new IllegalStateException("Timed out when waiting for persistent task after " + timeout));
        }
    }
}

