/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.unit.ByteSizeValue;

public class Segment
implements Streamable {
    private String name;
    private long generation;
    public boolean committed;
    public boolean search;
    public long sizeInBytes = -1L;
    public int docCount = -1;
    public int delDocCount = -1;
    public org.apache.lucene.util.Version version = null;
    public Boolean compound = null;
    public String mergeId;
    public long memoryInBytes;
    public Sort segmentSort;
    public Accountable ramTree = null;
    public Map<String, String> attributes;

    Segment() {
    }

    public Segment(String name) {
        this.name = name;
        this.generation = Long.parseLong(name.substring(1), 36);
    }

    public String getName() {
        return this.name;
    }

    public long getGeneration() {
        return this.generation;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean isSearch() {
        return this.search;
    }

    public int getNumDocs() {
        return this.docCount;
    }

    public int getDeletedDocs() {
        return this.delDocCount;
    }

    public ByteSizeValue getSize() {
        return new ByteSizeValue(this.sizeInBytes);
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public org.apache.lucene.util.Version getVersion() {
        return this.version;
    }

    @Nullable
    public Boolean isCompound() {
        return this.compound;
    }

    @Nullable
    public String getMergeId() {
        return this.mergeId;
    }

    public long getMemoryInBytes() {
        return this.memoryInBytes;
    }

    public Sort getSegmentSort() {
        return this.segmentSort;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Segment segment = (Segment)o;
        return !(this.name != null ? !this.name.equals(segment.name) : segment.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public static Segment readSegment(StreamInput in) throws IOException {
        Segment segment = new Segment();
        segment.readFrom(in);
        return segment;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.generation = Long.parseLong(this.name.substring(1), 36);
        this.committed = in.readBoolean();
        this.search = in.readBoolean();
        this.docCount = in.readInt();
        this.delDocCount = in.readInt();
        this.sizeInBytes = in.readLong();
        this.version = Lucene.parseVersionLenient(in.readOptionalString(), null);
        this.compound = in.readOptionalBoolean();
        this.mergeId = in.readOptionalString();
        this.memoryInBytes = in.readLong();
        if (in.readBoolean()) {
            this.ramTree = this.readRamTree(in);
        }
        this.segmentSort = in.getVersion().onOrAfter(Version.V_6_0_0_alpha1) ? this.readSegmentSort(in) : null;
        this.attributes = in.getVersion().onOrAfter(Version.V_6_1_0) && in.readBoolean() ? in.readMap(StreamInput::readString, StreamInput::readString) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeBoolean(this.committed);
        out.writeBoolean(this.search);
        out.writeInt(this.docCount);
        out.writeInt(this.delDocCount);
        out.writeLong(this.sizeInBytes);
        out.writeOptionalString(this.version.toString());
        out.writeOptionalBoolean(this.compound);
        out.writeOptionalString(this.mergeId);
        out.writeLong(this.memoryInBytes);
        boolean verbose = this.ramTree != null;
        out.writeBoolean(verbose);
        if (verbose) {
            this.writeRamTree(out, this.ramTree);
        }
        if (out.getVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
            this.writeSegmentSort(out, this.segmentSort);
        }
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            boolean hasAttributes = this.attributes != null;
            out.writeBoolean(hasAttributes);
            if (hasAttributes) {
                out.writeMap(this.attributes, StreamOutput::writeString, StreamOutput::writeString);
            }
        }
    }

    Sort readSegmentSort(StreamInput in) throws IOException {
        int size = in.readVInt();
        if (size == 0) {
            return null;
        }
        SortField[] fields = new SortField[size];
        for (int i = 0; i < size; ++i) {
            SortField.Type numericType;
            boolean reverse;
            boolean max;
            String field = in.readString();
            byte type = in.readByte();
            if (type == 0) {
                Boolean missingFirst = in.readOptionalBoolean();
                max = in.readBoolean();
                reverse = in.readBoolean();
                fields[i] = new SortedSetSortField(field, reverse, max ? SortedSetSelector.Type.MAX : SortedSetSelector.Type.MIN);
                if (missingFirst == null) continue;
                fields[i].setMissingValue(missingFirst != false ? SortedSetSortField.STRING_FIRST : SortedSetSortField.STRING_LAST);
                continue;
            }
            Object missing = in.readGenericValue();
            max = in.readBoolean();
            reverse = in.readBoolean();
            switch (type) {
                case 1: {
                    numericType = SortField.Type.INT;
                    break;
                }
                case 2: {
                    numericType = SortField.Type.FLOAT;
                    break;
                }
                case 3: {
                    numericType = SortField.Type.DOUBLE;
                    break;
                }
                case 4: {
                    numericType = SortField.Type.LONG;
                    break;
                }
                default: {
                    throw new IOException("invalid index sort type:[" + type + "] for numeric field:[" + field + "]");
                }
            }
            fields[i] = new SortedNumericSortField(field, numericType, reverse, max ? SortedNumericSelector.Type.MAX : SortedNumericSelector.Type.MIN);
            if (missing == null) continue;
            fields[i].setMissingValue(missing);
        }
        return new Sort(fields);
    }

    void writeSegmentSort(StreamOutput out, Sort sort) throws IOException {
        if (sort == null) {
            out.writeVInt(0);
            return;
        }
        out.writeVInt(sort.getSort().length);
        for (SortField field : sort.getSort()) {
            out.writeString(field.getField());
            if (field instanceof SortedSetSortField) {
                out.writeByte((byte)0);
                out.writeOptionalBoolean(field.getMissingValue() == null ? null : Boolean.valueOf(field.getMissingValue() == SortField.STRING_FIRST));
                out.writeBoolean(((SortedSetSortField)field).getSelector() == SortedSetSelector.Type.MAX);
                out.writeBoolean(field.getReverse());
                continue;
            }
            if (field instanceof SortedNumericSortField) {
                switch (((SortedNumericSortField)field).getNumericType()) {
                    case INT: {
                        out.writeByte((byte)1);
                        break;
                    }
                    case FLOAT: {
                        out.writeByte((byte)2);
                        break;
                    }
                    case DOUBLE: {
                        out.writeByte((byte)3);
                        break;
                    }
                    case LONG: {
                        out.writeByte((byte)4);
                        break;
                    }
                    default: {
                        throw new IOException("invalid index sort field:" + field);
                    }
                }
                out.writeGenericValue(field.getMissingValue());
                out.writeBoolean(((SortedNumericSortField)field).getSelector() == SortedNumericSelector.Type.MAX);
                out.writeBoolean(field.getReverse());
                continue;
            }
            throw new IOException("invalid index sort field:" + field);
        }
    }

    Accountable readRamTree(StreamInput in) throws IOException {
        String name = in.readString();
        long bytes = in.readVLong();
        int numChildren = in.readVInt();
        if (numChildren == 0) {
            return Accountables.namedAccountable((String)name, (long)bytes);
        }
        ArrayList<Accountable> children = new ArrayList<Accountable>(numChildren);
        while (numChildren-- > 0) {
            children.add(this.readRamTree(in));
        }
        return Accountables.namedAccountable((String)name, children, (long)bytes);
    }

    void writeRamTree(StreamOutput out, Accountable tree) throws IOException {
        out.writeString(tree.toString());
        out.writeVLong(tree.ramBytesUsed());
        Collection children = tree.getChildResources();
        out.writeVInt(children.size());
        for (Accountable child : children) {
            this.writeRamTree(out, child);
        }
    }

    public String toString() {
        return "Segment{name='" + this.name + '\'' + ", generation=" + this.generation + ", committed=" + this.committed + ", search=" + this.search + ", sizeInBytes=" + this.sizeInBytes + ", docCount=" + this.docCount + ", delDocCount=" + this.delDocCount + ", version='" + this.version + '\'' + ", compound=" + this.compound + ", mergeId='" + this.mergeId + '\'' + ", memoryInBytes=" + this.memoryInBytes + (this.segmentSort != null ? ", sort=" + this.segmentSort : "") + ", attributes=" + this.attributes + '}';
    }
}

