/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.calendar;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.xpack.core.ml.action.GetCalendarsAction;
import org.elasticsearch.xpack.core.ml.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;

public class RestGetCalendarsAction
extends BaseRestHandler {
    public RestGetCalendarsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_xpack/ml/calendars/{" + Calendar.ID.getPreferredName() + "}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_ml/calendars/{" + Calendar.ID.getPreferredName() + "}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_xpack/ml/calendars/", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_ml/calendars/", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/ml/calendars/{" + Calendar.ID.getPreferredName() + "}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_ml/calendars/{" + Calendar.ID.getPreferredName() + "}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/ml/calendars/", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_ml/calendars/", (RestHandler)this);
    }

    public String getName() {
        return "xpack_ml_get_calendars_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        GetCalendarsAction.Request request;
        String calendarId = restRequest.param(Calendar.ID.getPreferredName());
        if (restRequest.hasContentOrSourceParam()) {
            try (XContentParser parser = restRequest.contentOrSourceParamParser();){
                request = GetCalendarsAction.Request.parseRequest((String)calendarId, (XContentParser)parser);
            }
        } else {
            request = new GetCalendarsAction.Request();
            if (!Strings.isNullOrEmpty((String)calendarId)) {
                request.setCalendarId(calendarId);
            }
            if (restRequest.hasParam(PageParams.FROM.getPreferredName()) || restRequest.hasParam(PageParams.SIZE.getPreferredName())) {
                request.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
            }
        }
        return channel -> client.execute((Action)GetCalendarsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestStatusToXContentListener(channel));
    }
}

