/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public final class ClusterStateJobUpdate {
    private ClusterStateJobUpdate() {
    }

    public static boolean jobIsInClusterState(ClusterState clusterState, String jobId) {
        MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)clusterState);
        return mlMetadata.getJobs().containsKey(jobId);
    }

    public static boolean jobIsInMlMetadata(MlMetadata mlMetadata, String jobId) {
        return mlMetadata.getJobs().containsKey(jobId);
    }

    public static ClusterState putJobInClusterState(Job job, boolean overwrite, ClusterState currentState) {
        MlMetadata.Builder builder = ClusterStateJobUpdate.createMlMetadataBuilder(currentState);
        builder.putJob(job, overwrite);
        return ClusterStateJobUpdate.buildNewClusterState(currentState, builder);
    }

    private static MlMetadata.Builder createMlMetadataBuilder(ClusterState currentState) {
        return new MlMetadata.Builder(MlMetadata.getMlMetadata((ClusterState)currentState));
    }

    private static ClusterState buildNewClusterState(ClusterState currentState, MlMetadata.Builder builder) {
        XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)currentState);
        ClusterState.Builder newState = ClusterState.builder((ClusterState)currentState);
        newState.metaData(MetaData.builder((MetaData)currentState.getMetaData()).putCustom("ml", (MetaData.Custom)builder.build()).build());
        return newState.build();
    }

    public static void markJobAsDeleting(final String jobId, final boolean force, ClusterService clusterService, final ActionListener<Boolean> listener) {
        clusterService.submitStateUpdateTask("mark-job-as-deleted", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) {
                PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)currentState.metaData().custom("persistent_tasks");
                MlMetadata.Builder builder = new MlMetadata.Builder(MlMetadata.getMlMetadata((ClusterState)currentState));
                builder.markJobAsDeleting(jobId, tasks, force);
                return ClusterStateJobUpdate.buildNewClusterState(currentState, builder);
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)true);
            }
        });
    }

    public static void deleteJob(DeleteJobAction.Request request, ClusterService clusterService, ActionListener<Boolean> listener) {
        final String jobId = request.getJobId();
        clusterService.submitStateUpdateTask("delete-job-" + jobId, (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<Boolean>((AckedRequest)request, listener){

            protected Boolean newResponse(boolean acknowledged) {
                return acknowledged;
            }

            public ClusterState execute(ClusterState currentState) {
                MlMetadata currentMlMetadata = MlMetadata.getMlMetadata((ClusterState)currentState);
                if (!currentMlMetadata.getJobs().containsKey(jobId)) {
                    return currentState;
                }
                MlMetadata.Builder builder = new MlMetadata.Builder(currentMlMetadata);
                builder.deleteJob(jobId, (PersistentTasksCustomMetaData)currentState.getMetaData().custom("persistent_tasks"));
                return ClusterStateJobUpdate.buildNewClusterState(currentState, builder);
            }
        });
    }
}

