/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.filestructurefinder;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.grok.Grok;
import org.elasticsearch.xpack.ml.filestructurefinder.TimeoutChecker;

public final class TimestampFormatFinder {
    private static final String PREFACE = "preface";
    private static final String EPILOGUE = "epilogue";
    private static final String FRACTIONAL_SECOND_SEPARATORS = ":.,";
    private static final Pattern FRACTIONAL_SECOND_INTERPRETER = Pattern.compile("([:.,])(\\d{3,9})");
    private static final char DEFAULT_FRACTIONAL_SECOND_SEPARATOR = ',';
    private static final Pattern FRACTIONAL_SECOND_TIMESTAMP_FORMAT_PATTERN = Pattern.compile("([:.,]S{3,9})");
    private static final String DEFAULT_FRACTIONAL_SECOND_FORMAT = ",SSS";
    private static final List<Pattern> QUICK_RULE_OUT_PATTERNS = Arrays.asList(Pattern.compile("\\b\\d{4}-\\d{2}-\\d{2} "), Pattern.compile("\\d \\d{2}:\\d{2}\\b"), Pattern.compile(" \\d{2}:\\d{2}:\\d{2} "), Pattern.compile("\\dT\\d"));
    static final List<CandidateTimestampFormat> ORDERED_CANDIDATE_FORMATS = Arrays.asList(new CandidateTimestampFormat("YYYY-MM-dd HH:mm:ss,SSS Z", "yyyy-MM-dd HH:mm:ss,SSS XX", "\\b\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3}", "\\b20\\d{2}-%{MONTHNUM}-%{MONTHDAY} %{HOUR}:?%{MINUTE}:(?:[0-5][0-9]|60)[:.,][0-9]{3,9} (?:Z|[+-]%{HOUR}%{MINUTE})\\b", "TOMCAT_DATESTAMP", Arrays.asList(0, 1)), new CandidateTimestampFormat("YYYY-MM-dd HH:mm:ss,SSSZ", "yyyy-MM-dd HH:mm:ss,SSSXX", "\\b\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3}", "\\b%{YEAR}-%{MONTHNUM}-%{MONTHDAY} %{HOUR}:?%{MINUTE}:(?:[0-5][0-9]|60)[:.,][0-9]{3,9}(?:Z|[+-]%{HOUR}%{MINUTE})\\b", "TIMESTAMP_ISO8601", Arrays.asList(0, 1)), new CandidateTimestampFormat("YYYY-MM-dd HH:mm:ss,SSSZZ", "yyyy-MM-dd HH:mm:ss,SSSXXX", "\\b\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3}", "\\b%{YEAR}-%{MONTHNUM}-%{MONTHDAY} %{HOUR}:?%{MINUTE}:(?:[0-5][0-9]|60)[:.,][0-9]{3,9}[+-]%{HOUR}:%{MINUTE}\\b", "TIMESTAMP_ISO8601", Arrays.asList(0, 1)), new CandidateTimestampFormat("YYYY-MM-dd HH:mm:ss,SSS", "yyyy-MM-dd HH:mm:ss,SSS", "\\b\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3}", "\\b%{YEAR}-%{MONTHNUM}-%{MONTHDAY} %{HOUR}:?%{MINUTE}:(?:[0-5][0-9]|60)[:.,][0-9]{3,9}\\b", "TIMESTAMP_ISO8601", Arrays.asList(0, 1)), new CandidateTimestampFormat("YYYY-MM-dd HH:mm:ssZ", "yyyy-MM-dd HH:mm:ssXX", "\\b\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}", "\\b%{YEAR}-%{MONTHNUM}-%{MONTHDAY} %{HOUR}:?%{MINUTE}:(?:[0-5][0-9]|60)(?:Z|[+-]%{HOUR}%{MINUTE})\\b", "TIMESTAMP_ISO8601", Arrays.asList(0, 1)), new CandidateTimestampFormat("YYYY-MM-dd HH:mm:ssZZ", "yyyy-MM-dd HH:mm:ssXXX", "\\b\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}", "\\b%{YEAR}-%{MONTHNUM}-%{MONTHDAY} %{HOUR}:?%{MINUTE}:(?:[0-5][0-9]|60)[+-]%{HOUR}:%{MINUTE}\\b", "TIMESTAMP_ISO8601", Arrays.asList(0, 1)), new CandidateTimestampFormat("YYYY-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss", "\\b\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}", "\\b%{YEAR}-%{MONTHNUM}-%{MONTHDAY} %{HOUR}:?%{MINUTE}:(?:[0-5][0-9]|60)\\b", "TIMESTAMP_ISO8601", Arrays.asList(0, 1)), new CandidateTimestampFormat("ISO8601", "yyyy-MM-dd'T'HH:mm:ss,SSSXX", "\\b\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2},\\d{3}", "\\b%{YEAR}-%{MONTHNUM}-%{MONTHDAY}T%{HOUR}:?%{MINUTE}:(?:[0-5][0-9]|60)[:.,][0-9]{3,9}(?:Z|[+-]%{HOUR}%{MINUTE})\\b", "TIMESTAMP_ISO8601", Collections.singletonList(3)), new CandidateTimestampFormat("ISO8601", "yyyy-MM-dd'T'HH:mm:ss,SSSXXX", "\\b\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2},\\d{3}", "\\b%{YEAR}-%{MONTHNUM}-%{MONTHDAY}T%{HOUR}:?%{MINUTE}:(?:[0-5][0-9]|60)[:.,][0-9]{3,9}[+-]%{HOUR}:%{MINUTE}\\b", "TIMESTAMP_ISO8601", Collections.singletonList(3)), new CandidateTimestampFormat("ISO8601", "yyyy-MM-dd'T'HH:mm:ss,SSS", "\\b\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2},\\d{3}", "\\b%{YEAR}-%{MONTHNUM}-%{MONTHDAY}T%{HOUR}:?%{MINUTE}:(?:[0-5][0-9]|60)[:.,][0-9]{3,9}\\b", "TIMESTAMP_ISO8601", Collections.singletonList(3)), new CandidateTimestampFormat("ISO8601", "ISO8601", "\\b\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}", "\\b%{TIMESTAMP_ISO8601}\\b", "TIMESTAMP_ISO8601", Collections.singletonList(3)), new CandidateTimestampFormat("EEE MMM dd YYYY HH:mm:ss zzz", "EEE MMM dd yyyy HH:mm:ss zzz", "\\b[A-Z]\\S{2,8} [A-Z]\\S{2,8} \\d{1,2} \\d{4} \\d{2}:\\d{2}:\\d{2} ", "\\b%{DAY} %{MONTH} %{MONTHDAY} %{YEAR} %{HOUR}:%{MINUTE}:(?:[0-5][0-9]|60) %{TZ}\\b", "DATESTAMP_RFC822", Arrays.asList(1, 2)), new CandidateTimestampFormat("EEE MMM dd YYYY HH:mm zzz", "EEE MMM dd yyyy HH:mm zzz", "\\b[A-Z]\\S{2,8} [A-Z]\\S{2,8} \\d{1,2} \\d{4} \\d{2}:\\d{2} ", "\\b%{DAY} %{MONTH} %{MONTHDAY} %{YEAR} %{HOUR}:%{MINUTE} %{TZ}\\b", "DATESTAMP_RFC822", Collections.singletonList(1)), new CandidateTimestampFormat("EEE, dd MMM YYYY HH:mm:ss ZZ", "EEE, dd MMM yyyy HH:mm:ss XXX", "\\b[A-Z]\\S{2,8}, \\d{1,2} [A-Z]\\S{2,8} \\d{4} \\d{2}:\\d{2}:\\d{2} ", "\\b%{DAY}, %{MONTHDAY} %{MONTH} %{YEAR} %{HOUR}:%{MINUTE}:(?:[0-5][0-9]|60) (?:Z|[+-]%{HOUR}:%{MINUTE})\\b", "DATESTAMP_RFC2822", Arrays.asList(1, 2)), new CandidateTimestampFormat("EEE, dd MMM YYYY HH:mm:ss Z", "EEE, dd MMM yyyy HH:mm:ss XX", "\\b[A-Z]\\S{2,8}, \\d{1,2} [A-Z]\\S{2,8} \\d{4} \\d{2}:\\d{2}:\\d{2} ", "\\b%{DAY}, %{MONTHDAY} %{MONTH} %{YEAR} %{HOUR}:%{MINUTE}:(?:[0-5][0-9]|60) (?:Z|[+-]%{HOUR}%{MINUTE})\\b", "DATESTAMP_RFC2822", Arrays.asList(1, 2)), new CandidateTimestampFormat("EEE, dd MMM YYYY HH:mm ZZ", "EEE, dd MMM yyyy HH:mm XXX", "\\b[A-Z]\\S{2,8}, \\d{1,2} [A-Z]\\S{2,8} \\d{4} \\d{2}:\\d{2} ", "\\b%{DAY}, %{MONTHDAY} %{MONTH} %{YEAR} %{HOUR}:%{MINUTE} (?:Z|[+-]%{HOUR}:%{MINUTE})\\b", "DATESTAMP_RFC2822", Collections.singletonList(1)), new CandidateTimestampFormat("EEE, dd MMM YYYY HH:mm Z", "EEE, dd MMM yyyy HH:mm XX", "\\b[A-Z]\\S{2,8}, \\d{1,2} [A-Z]\\S{2,8} \\d{4} \\d{2}:\\d{2} ", "\\b%{DAY}, %{MONTHDAY} %{MONTH} %{YEAR} %{HOUR}:%{MINUTE} (?:Z|[+-]%{HOUR}%{MINUTE})\\b", "DATESTAMP_RFC2822", Collections.singletonList(1)), new CandidateTimestampFormat("EEE MMM dd HH:mm:ss zzz YYYY", "EEE MMM dd HH:mm:ss zzz yyyy", "\\b[A-Z]\\S{2,8} [A-Z]\\S{2,8} \\d{1,2} \\d{2}:\\d{2}:\\d{2} [A-Z]{3,4} \\d{4}\\b", "\\b%{DAY} %{MONTH} %{MONTHDAY} %{HOUR}:%{MINUTE}:(?:[0-5][0-9]|60) %{TZ} %{YEAR}\\b", "DATESTAMP_OTHER", Arrays.asList(1, 2)), new CandidateTimestampFormat("EEE MMM dd HH:mm zzz YYYY", "EEE MMM dd HH:mm zzz yyyy", "\\b[A-Z]\\S{2,8} [A-Z]\\S{2,8} \\d{1,2} \\d{2}:\\d{2} [A-Z]{3,4} \\d{4}\\b", "\\b%{DAY} %{MONTH} %{MONTHDAY} %{HOUR}:%{MINUTE} %{TZ} %{YEAR}\\b", "DATESTAMP_OTHER", Collections.singletonList(1)), new CandidateTimestampFormat("YYYYMMddHHmmss", "yyyyMMddHHmmss", "\\b\\d{14}\\b", "\\b20\\d{2}%{MONTHNUM2}(?:(?:0[1-9])|(?:[12][0-9])|(?:3[01]))(?:2[0123]|[01][0-9])%{MINUTE}(?:[0-5][0-9]|60)\\b", "DATESTAMP_EVENTLOG"), new CandidateTimestampFormat("EEE MMM dd HH:mm:ss YYYY", "EEE MMM dd HH:mm:ss yyyy", "\\b[A-Z]\\S{2,8} [A-Z]\\S{2,8} \\d{1,2} \\d{2}:\\d{2}:\\d{2} \\d{4}\\b", "\\b%{DAY} %{MONTH} %{MONTHDAY} %{HOUR}:%{MINUTE}:(?:[0-5][0-9]|60) %{YEAR}\\b", "HTTPDERROR_DATE", Arrays.asList(1, 2)), new CandidateTimestampFormat(Arrays.asList("MMM dd HH:mm:ss,SSS", "MMM  d HH:mm:ss,SSS"), Arrays.asList("MMM dd HH:mm:ss,SSS", "MMM  d HH:mm:ss,SSS"), "\\b[A-Z]\\S{2,8} {1,2}\\d{1,2} \\d{2}:\\d{2}:\\d{2},\\d{3}", "%{MONTH} +%{MONTHDAY} %{HOUR}:%{MINUTE}:(?:[0-5][0-9]|60)[:.,][0-9]{3,9}\\b", "SYSLOGTIMESTAMP", Collections.singletonList(1)), new CandidateTimestampFormat(Arrays.asList("MMM dd HH:mm:ss", "MMM  d HH:mm:ss"), Arrays.asList("MMM dd HH:mm:ss", "MMM  d HH:mm:ss"), "\\b[A-Z]\\S{2,8} {1,2}\\d{1,2} \\d{2}:\\d{2}:\\d{2}\\b", "%{MONTH} +%{MONTHDAY} %{HOUR}:%{MINUTE}:(?:[0-5][0-9]|60)\\b", "SYSLOGTIMESTAMP", Collections.singletonList(1)), new CandidateTimestampFormat("dd/MMM/YYYY:HH:mm:ss Z", "dd/MMM/yyyy:HH:mm:ss XX", "\\b\\d{2}/[A-Z]\\S{2}/\\d{4}:\\d{2}:\\d{2}:\\d{2} ", "\\b%{MONTHDAY}/%{MONTH}/%{YEAR}:%{HOUR}:%{MINUTE}:(?:[0-5][0-9]|60) [+-]?%{HOUR}%{MINUTE}\\b", "HTTPDATE"), new CandidateTimestampFormat("MMM dd, YYYY h:mm:ss a", "MMM dd, yyyy h:mm:ss a", "\\b[A-Z]\\S{2,8} \\d{1,2}, \\d{4} \\d{1,2}:\\d{2}:\\d{2} [AP]M\\b", "%{MONTH} %{MONTHDAY}, 20\\d{2} %{HOUR}:%{MINUTE}:(?:[0-5][0-9]|60) (?:AM|PM)\\b", "CATALINA_DATESTAMP"), new CandidateTimestampFormat(Arrays.asList("MMM dd YYYY HH:mm:ss", "MMM  d YYYY HH:mm:ss"), Arrays.asList("MMM dd yyyy HH:mm:ss", "MMM  d yyyy HH:mm:ss"), "\\b[A-Z]\\S{2,8} {1,2}\\d{1,2} \\d{4} \\d{2}:\\d{2}:\\d{2}\\b", "%{MONTH} +%{MONTHDAY} %{YEAR} %{HOUR}:%{MINUTE}:(?:[0-5][0-9]|60)\\b", "CISCOTIMESTAMP", Collections.singletonList(1)), new CandidateTimestampFormat("UNIX_MS", "UNIX_MS", "\\b\\d{13}\\b", "\\b\\d{13}\\b", "POSINT"), new CandidateTimestampFormat("UNIX", "UNIX", "\\b\\d{10}\\.\\d{3,9}\\b", "\\b\\d{10}\\.(?:\\d{3}){1,3}\\b", "NUMBER"), new CandidateTimestampFormat("UNIX", "UNIX", "\\b\\d{10}\\b", "\\b\\d{10}\\b", "POSINT"), new CandidateTimestampFormat("TAI64N", "TAI64N", "\\b[0-9A-Fa-f]{24}\\b", "\\b[0-9A-Fa-f]{24}\\b", "BASE16NUM"));

    private TimestampFormatFinder() {
    }

    public static TimestampMatch findFirstMatch(String text, TimeoutChecker timeoutChecker) {
        return TimestampFormatFinder.findFirstMatch(text, 0, timeoutChecker);
    }

    public static TimestampMatch findFirstMatch(String text, String requiredFormat, TimeoutChecker timeoutChecker) {
        return TimestampFormatFinder.findFirstMatch(text, 0, requiredFormat, timeoutChecker);
    }

    public static TimestampMatch findFirstMatch(String text, int ignoreCandidates, TimeoutChecker timeoutChecker) {
        return TimestampFormatFinder.findFirstMatch(text, ignoreCandidates, null, timeoutChecker);
    }

    public static TimestampMatch findFirstMatch(String text, int ignoreCandidates, String requiredFormat, TimeoutChecker timeoutChecker) {
        if (ignoreCandidates >= ORDERED_CANDIDATE_FORMATS.size()) {
            return null;
        }
        Boolean[] quickRuleoutMatches = new Boolean[QUICK_RULE_OUT_PATTERNS.size()];
        int index = ignoreCandidates;
        String adjustedRequiredFormat = TimestampFormatFinder.adjustRequiredFormat(requiredFormat);
        for (CandidateTimestampFormat candidate : ORDERED_CANDIDATE_FORMATS.subList(ignoreCandidates, ORDERED_CANDIDATE_FORMATS.size())) {
            if (adjustedRequiredFormat == null || candidate.jodaTimestampFormats.contains(adjustedRequiredFormat) || candidate.javaTimestampFormats.contains(adjustedRequiredFormat)) {
                Map<String, Object> captures;
                boolean quicklyRuledOut = false;
                for (Integer quickRuleOutIndex : candidate.quickRuleOutIndices) {
                    if (quickRuleoutMatches[quickRuleOutIndex] == null) {
                        quickRuleoutMatches[quickRuleOutIndex.intValue()] = QUICK_RULE_OUT_PATTERNS.get(quickRuleOutIndex).matcher(text).find();
                    }
                    if (quickRuleoutMatches[quickRuleOutIndex].booleanValue()) continue;
                    quicklyRuledOut = true;
                    break;
                }
                if (!quicklyRuledOut && (captures = timeoutChecker.grokCaptures(candidate.strictSearchGrok, text, "timestamp format determination")) != null) {
                    String preface = captures.getOrDefault(PREFACE, "").toString();
                    String epilogue = captures.getOrDefault(EPILOGUE, "").toString();
                    return TimestampFormatFinder.makeTimestampMatch(candidate, index, preface, text.substring(preface.length(), text.length() - epilogue.length()), epilogue);
                }
            }
            ++index;
        }
        return null;
    }

    public static TimestampMatch findFirstFullMatch(String text, TimeoutChecker timeoutChecker) {
        return TimestampFormatFinder.findFirstFullMatch(text, 0, timeoutChecker);
    }

    public static TimestampMatch findFirstFullMatch(String text, String requiredFormat, TimeoutChecker timeoutChecker) {
        return TimestampFormatFinder.findFirstFullMatch(text, 0, requiredFormat, timeoutChecker);
    }

    public static TimestampMatch findFirstFullMatch(String text, int ignoreCandidates, TimeoutChecker timeoutChecker) {
        return TimestampFormatFinder.findFirstFullMatch(text, ignoreCandidates, null, timeoutChecker);
    }

    public static TimestampMatch findFirstFullMatch(String text, int ignoreCandidates, String requiredFormat, TimeoutChecker timeoutChecker) {
        if (ignoreCandidates >= ORDERED_CANDIDATE_FORMATS.size()) {
            return null;
        }
        int index = ignoreCandidates;
        String adjustedRequiredFormat = TimestampFormatFinder.adjustRequiredFormat(requiredFormat);
        for (CandidateTimestampFormat candidate : ORDERED_CANDIDATE_FORMATS.subList(ignoreCandidates, ORDERED_CANDIDATE_FORMATS.size())) {
            Map<String, Object> captures;
            if ((adjustedRequiredFormat == null || candidate.jodaTimestampFormats.contains(adjustedRequiredFormat) || candidate.javaTimestampFormats.contains(adjustedRequiredFormat)) && (captures = timeoutChecker.grokCaptures(candidate.strictFullMatchGrok, text, "timestamp format determination")) != null) {
                return TimestampFormatFinder.makeTimestampMatch(candidate, index, "", text, "");
            }
            ++index;
        }
        return null;
    }

    static String adjustRequiredFormat(String requiredFormat) {
        return requiredFormat == null ? null : FRACTIONAL_SECOND_TIMESTAMP_FORMAT_PATTERN.matcher(requiredFormat).replaceFirst(DEFAULT_FRACTIONAL_SECOND_FORMAT);
    }

    private static TimestampMatch makeTimestampMatch(CandidateTimestampFormat chosenTimestampFormat, int chosenIndex, String preface, String matchedDate, String epilogue) {
        int numberOfDigitsInFractionalComponent;
        Tuple<Character, Integer> fractionalSecondsInterpretation = TimestampFormatFinder.interpretFractionalSeconds(matchedDate);
        List<String> jodaTimestampFormats = chosenTimestampFormat.jodaTimestampFormats;
        List<String> javaTimestampFormats = chosenTimestampFormat.javaTimestampFormats;
        Pattern simplePattern = chosenTimestampFormat.simplePattern;
        char separator = ((Character)fractionalSecondsInterpretation.v1()).charValue();
        if (separator != ',') {
            String patternStr;
            int separatorPos;
            jodaTimestampFormats = jodaTimestampFormats.stream().map(jodaTimestampFormat -> jodaTimestampFormat.replace(',', separator)).collect(Collectors.toList());
            javaTimestampFormats = javaTimestampFormats.stream().map(javaTimestampFormat -> javaTimestampFormat.replace(',', separator)).collect(Collectors.toList());
            if (jodaTimestampFormats.stream().noneMatch(jodaTimestampFormat -> jodaTimestampFormat.startsWith("UNIX")) && (separatorPos = (patternStr = simplePattern.pattern()).lastIndexOf(44)) >= 0) {
                StringBuilder newPatternStr = new StringBuilder(patternStr);
                newPatternStr.replace(separatorPos, separatorPos + 1, (separator == '.' ? "\\" : "") + separator);
                simplePattern = Pattern.compile(newPatternStr.toString());
            }
        }
        if ((numberOfDigitsInFractionalComponent = ((Integer)fractionalSecondsInterpretation.v2()).intValue()) > 3) {
            String fractionalSecondsFormat = "SSSSSSSSS".substring(0, numberOfDigitsInFractionalComponent);
            jodaTimestampFormats = jodaTimestampFormats.stream().map(jodaTimestampFormat -> jodaTimestampFormat.replace("SSS", fractionalSecondsFormat)).collect(Collectors.toList());
            javaTimestampFormats = javaTimestampFormats.stream().map(javaTimestampFormat -> javaTimestampFormat.replace("SSS", fractionalSecondsFormat)).collect(Collectors.toList());
        }
        return new TimestampMatch(chosenIndex, preface, jodaTimestampFormats, javaTimestampFormats, simplePattern, chosenTimestampFormat.standardGrokPatternName, epilogue);
    }

    static Tuple<Character, Integer> interpretFractionalSeconds(String date) {
        Matcher matcher = FRACTIONAL_SECOND_INTERPRETER.matcher(date);
        if (matcher.find()) {
            return new Tuple((Object)Character.valueOf(matcher.group(1).charAt(0)), (Object)matcher.group(2).length());
        }
        return new Tuple((Object)Character.valueOf(','), (Object)0);
    }

    static final class CandidateTimestampFormat {
        final List<String> jodaTimestampFormats;
        final List<String> javaTimestampFormats;
        final Pattern simplePattern;
        final Grok strictSearchGrok;
        final Grok strictFullMatchGrok;
        final String standardGrokPatternName;
        final List<Integer> quickRuleOutIndices;

        CandidateTimestampFormat(String jodaTimestampFormat, String javaTimestampFormat, String simpleRegex, String strictGrokPattern, String standardGrokPatternName) {
            this(Collections.singletonList(jodaTimestampFormat), Collections.singletonList(javaTimestampFormat), simpleRegex, strictGrokPattern, standardGrokPatternName);
        }

        CandidateTimestampFormat(String jodaTimestampFormat, String javaTimestampFormat, String simpleRegex, String strictGrokPattern, String standardGrokPatternName, List<Integer> quickRuleOutIndices) {
            this(Collections.singletonList(jodaTimestampFormat), Collections.singletonList(javaTimestampFormat), simpleRegex, strictGrokPattern, standardGrokPatternName, quickRuleOutIndices);
        }

        CandidateTimestampFormat(List<String> jodaTimestampFormats, List<String> javaTimestampFormats, String simpleRegex, String strictGrokPattern, String standardGrokPatternName) {
            this(jodaTimestampFormats, javaTimestampFormats, simpleRegex, strictGrokPattern, standardGrokPatternName, Collections.emptyList());
        }

        CandidateTimestampFormat(List<String> jodaTimestampFormats, List<String> javaTimestampFormats, String simpleRegex, String strictGrokPattern, String standardGrokPatternName, List<Integer> quickRuleOutIndices) {
            this.jodaTimestampFormats = jodaTimestampFormats;
            this.javaTimestampFormats = javaTimestampFormats;
            this.simplePattern = Pattern.compile(simpleRegex, 8);
            this.strictSearchGrok = new Grok(Grok.getBuiltinPatterns(), "(?m)%{DATA:preface}" + strictGrokPattern + "%{GREEDYDATA:" + TimestampFormatFinder.EPILOGUE + "}", TimeoutChecker.watchdog);
            this.strictFullMatchGrok = new Grok(Grok.getBuiltinPatterns(), "^" + strictGrokPattern + "$", TimeoutChecker.watchdog);
            this.standardGrokPatternName = standardGrokPatternName;
            assert (quickRuleOutIndices.stream().noneMatch(quickRuleOutIndex -> quickRuleOutIndex < 0 || quickRuleOutIndex >= QUICK_RULE_OUT_PATTERNS.size()));
            this.quickRuleOutIndices = quickRuleOutIndices;
        }
    }

    public static final class TimestampMatch {
        public final int candidateIndex;
        public final String preface;
        public final List<String> jodaTimestampFormats;
        public final List<String> javaTimestampFormats;
        public final Pattern simplePattern;
        public final String grokPatternName;
        public final String epilogue;

        TimestampMatch(int candidateIndex, String preface, String jodaTimestampFormat, String javaTimestampFormat, String simpleRegex, String grokPatternName, String epilogue) {
            this(candidateIndex, preface, Collections.singletonList(jodaTimestampFormat), Collections.singletonList(javaTimestampFormat), simpleRegex, grokPatternName, epilogue);
        }

        TimestampMatch(int candidateIndex, String preface, List<String> jodaTimestampFormats, List<String> javaTimestampFormats, String simpleRegex, String grokPatternName, String epilogue) {
            this(candidateIndex, preface, jodaTimestampFormats, javaTimestampFormats, Pattern.compile(simpleRegex), grokPatternName, epilogue);
        }

        TimestampMatch(int candidateIndex, String preface, List<String> jodaTimestampFormats, List<String> javaTimestampFormats, Pattern simplePattern, String grokPatternName, String epilogue) {
            this.candidateIndex = candidateIndex;
            this.preface = preface;
            this.jodaTimestampFormats = Collections.unmodifiableList(jodaTimestampFormats);
            this.javaTimestampFormats = Collections.unmodifiableList(javaTimestampFormats);
            this.simplePattern = simplePattern;
            this.grokPatternName = grokPatternName;
            this.epilogue = epilogue;
        }

        public boolean hasTimezoneDependentParsing() {
            return this.javaTimestampFormats.stream().anyMatch(javaTimestampFormat -> javaTimestampFormat.indexOf(88) == -1 && javaTimestampFormat.indexOf(122) == -1 && javaTimestampFormat.contains("mm"));
        }

        public Map<String, String> getEsDateMappingTypeWithFormat() {
            if (this.javaTimestampFormats.contains("TAI64N")) {
                return Collections.singletonMap("type", "keyword");
            }
            LinkedHashMap<String, String> mapping = new LinkedHashMap<String, String>();
            mapping.put("type", "date");
            String formats = this.javaTimestampFormats.stream().flatMap(format -> {
                switch (format) {
                    case "ISO8601": {
                        return Stream.empty();
                    }
                    case "UNIX_MS": {
                        return Stream.of("epoch_millis");
                    }
                    case "UNIX": {
                        return Stream.of("epoch_second");
                    }
                }
                return Stream.of("8" + format);
            }).collect(Collectors.joining("||"));
            if (!formats.isEmpty()) {
                mapping.put("format", formats);
            }
            return mapping;
        }

        public int hashCode() {
            return Objects.hash(this.candidateIndex, this.preface, this.jodaTimestampFormats, this.javaTimestampFormats, this.simplePattern.pattern(), this.grokPatternName, this.epilogue);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            TimestampMatch that = (TimestampMatch)other;
            return this.candidateIndex == that.candidateIndex && Objects.equals(this.preface, that.preface) && Objects.equals(this.jodaTimestampFormats, that.jodaTimestampFormats) && Objects.equals(this.javaTimestampFormats, that.javaTimestampFormats) && Objects.equals(this.simplePattern.pattern(), that.simplePattern.pattern()) && Objects.equals(this.grokPatternName, that.grokPatternName) && Objects.equals(this.epilogue, that.epilogue);
        }

        public String toString() {
            return "index = " + this.candidateIndex + (this.preface.isEmpty() ? "" : ", preface = '" + this.preface + "'") + ", Joda timestamp formats = " + this.jodaTimestampFormats.stream().collect(Collectors.joining("', '", "[ '", "' ]")) + ", Java timestamp formats = " + this.javaTimestampFormats.stream().collect(Collectors.joining("', '", "[ '", "' ]")) + ", simple pattern = '" + this.simplePattern.pattern() + "', grok pattern = '" + this.grokPatternName + "'" + (this.epilogue.isEmpty() ? "" : ", epilogue = '" + this.epilogue + "'");
        }
    }
}

