/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.upgrade;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.allocation.decider.EnableAllocationDecider;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.protocol.xpack.migration.UpgradeActionRequired;
import org.elasticsearch.script.Script;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.xpack.upgrade.InternalIndexReindexer;

public class IndexUpgradeCheck<T>
extends AbstractComponent {
    private final String name;
    private final Function<IndexMetaData, UpgradeActionRequired> actionRequired;
    private final InternalIndexReindexer<T> reindexer;

    public IndexUpgradeCheck(String name, Function<IndexMetaData, UpgradeActionRequired> actionRequired, Client client, ClusterService clusterService, String[] types, Script updateScript) {
        this(name, actionRequired, client, clusterService, types, updateScript, (cs, listener) -> {
            EnableAllocationDecider.Allocation clusterRoutingAllocation = (EnableAllocationDecider.Allocation)EnableAllocationDecider.CLUSTER_ROUTING_ALLOCATION_ENABLE_SETTING.get(cs.getMetaData().settings());
            if (EnableAllocationDecider.Allocation.NONE == clusterRoutingAllocation) {
                listener.onFailure((Exception)new ElasticsearchException("pre-upgrade check failed, please enable cluster routing allocation using setting [{}]", new Object[]{EnableAllocationDecider.CLUSTER_ROUTING_ALLOCATION_ENABLE_SETTING.getKey()}));
            } else {
                listener.onResponse(null);
            }
        }, (t, listener) -> listener.onResponse((Object)TransportResponse.Empty.INSTANCE));
    }

    public IndexUpgradeCheck(String name, Function<IndexMetaData, UpgradeActionRequired> actionRequired, Client client, ClusterService clusterService, String[] types, Script updateScript, BiConsumer<ClusterState, ActionListener<T>> preUpgrade, BiConsumer<T, ActionListener<TransportResponse.Empty>> postUpgrade) {
        this.name = name;
        this.actionRequired = actionRequired;
        this.reindexer = new InternalIndexReindexer<T>(client, clusterService, 6, updateScript, types, preUpgrade, postUpgrade);
    }

    public String getName() {
        return this.name;
    }

    public UpgradeActionRequired actionRequired(IndexMetaData indexMetaData) {
        return this.actionRequired.apply(indexMetaData);
    }

    public void upgrade(TaskId task, IndexMetaData indexMetaData, ClusterState state, ActionListener<BulkByScrollResponse> listener) {
        this.reindexer.upgrade(task, indexMetaData.getIndex().getName(), state, listener);
    }

    InternalIndexReindexer getInternalIndexReindexer() {
        return this.reindexer;
    }
}

