/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.List;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;

final class MlDeprecationChecks {
    private MlDeprecationChecks() {
    }

    static DeprecationIssue checkDataFeedQuery(DatafeedConfig datafeedConfig, NamedXContentRegistry xContentRegistry) {
        List deprecations = datafeedConfig.getQueryDeprecations(xContentRegistry);
        if (deprecations.isEmpty()) {
            return null;
        }
        return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Datafeed [" + datafeedConfig.getId() + "] uses deprecated query options", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking-changes-7.0.html#breaking_70_search_changes", deprecations.toString());
    }

    static DeprecationIssue checkDataFeedAggregations(DatafeedConfig datafeedConfig, NamedXContentRegistry xContentRegistry) {
        List deprecations = datafeedConfig.getAggDeprecations(xContentRegistry);
        if (deprecations.isEmpty()) {
            return null;
        }
        return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Datafeed [" + datafeedConfig.getId() + "] uses deprecated aggregation options", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking-changes-7.0.html#breaking_70_aggregations_changes", deprecations.toString());
    }
}

