/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.util.ConstructorUtils;
import org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.util.MiscStatementTools;
import org.benf.cfr.reader.bytecode.analysis.parse.Expression;
import org.benf.cfr.reader.bytecode.analysis.parse.LValue;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.SuperFunctionInvokation;
import org.benf.cfr.reader.bytecode.analysis.parse.lvalue.FieldVariable;
import org.benf.cfr.reader.bytecode.analysis.parse.lvalue.StaticVariable;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.LValueUsageCollectorSimple;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.Pair;
import org.benf.cfr.reader.bytecode.analysis.structured.StructuredStatement;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredComment;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredDefinition;
import org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement;
import org.benf.cfr.reader.entities.AccessFlag;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.entities.ClassFileField;
import org.benf.cfr.reader.entities.Method;
import org.benf.cfr.reader.util.Functional;
import org.benf.cfr.reader.util.ListFactory;
import org.benf.cfr.reader.util.MapFactory;
import org.benf.cfr.reader.util.Predicate;

public class NonStaticLifter {
    private final ClassFile classFile;

    public NonStaticLifter(ClassFile classFile) {
        this.classFile = classFile;
    }

    public void liftNonStatics() {
        LinkedList<ClassFileField> classFileFields = new LinkedList<ClassFileField>(Functional.filter(this.classFile.getFields(), new Predicate<ClassFileField>(){

            @Override
            public boolean test(ClassFileField in) {
                if (in.getField().testAccessFlag(AccessFlag.ACC_STATIC)) {
                    return false;
                }
                return !in.getField().testAccessFlag(AccessFlag.ACC_SYNTHETIC);
            }
        }));
        if (classFileFields.isEmpty()) {
            return;
        }
        Map<String, Pair<Integer, ClassFileField>> fieldMap = MapFactory.newMap();
        int len = classFileFields.size();
        for (int x = 0; x < len; ++x) {
            ClassFileField classFileField = classFileFields.get(x);
            fieldMap.put(classFileField.getField().getFieldName(), Pair.make(x, classFileField));
        }
        List<Method> constructors = Functional.filter(this.classFile.getConstructors(), new Predicate<Method>(){

            @Override
            public boolean test(Method in) {
                return !ConstructorUtils.isDelegating(in);
            }
        });
        List<List> constructorCodeList = ListFactory.newList();
        int minSize = Integer.MAX_VALUE;
        for (Method constructor : constructors) {
            Expression expression;
            List<Op04StructuredStatement> blockStatements = MiscStatementTools.getBlockStatements(constructor.getAnalysis());
            if (blockStatements == null) {
                return;
            }
            if ((blockStatements = Functional.filter(blockStatements, new Predicate<Op04StructuredStatement>(){

                @Override
                public boolean test(Op04StructuredStatement in) {
                    StructuredStatement stm = in.getStatement();
                    if (stm instanceof StructuredComment) {
                        return false;
                    }
                    return !(stm instanceof StructuredDefinition);
                }
            })).isEmpty()) {
                return;
            }
            StructuredStatement superTest = blockStatements.get(0).getStatement();
            if (superTest instanceof StructuredExpressionStatement && (expression = ((StructuredExpressionStatement)superTest).getExpression()) instanceof SuperFunctionInvokation) {
                blockStatements.remove(0);
            }
            constructorCodeList.add(blockStatements);
            if (blockStatements.size() >= minSize) continue;
            minSize = blockStatements.size();
        }
        if (constructorCodeList.isEmpty()) {
            return;
        }
        int numConstructors = constructorCodeList.size();
        List constructorCode = constructorCodeList.get(0);
        for (int x = 0; x < minSize; ++x) {
            if (constructorCode.isEmpty()) {
                return;
            }
            StructuredStatement s1 = ((Op04StructuredStatement)constructorCode.get(x)).getStatement();
            for (int y = 1; y < numConstructors; ++y) {
                StructuredStatement sOther = ((Op04StructuredStatement)constructorCodeList.get(y).get(x)).getStatement();
                if (s1.equals(sOther)) continue;
                return;
            }
            if (!(s1 instanceof StructuredAssignment)) {
                return;
            }
            StructuredAssignment structuredAssignment = (StructuredAssignment)s1;
            LValue lValue = structuredAssignment.getLvalue();
            if (!(lValue instanceof FieldVariable)) {
                return;
            }
            if (!this.fromThisClass((FieldVariable)lValue)) {
                return;
            }
            if (!this.tryLift((FieldVariable)lValue, structuredAssignment.getRvalue(), fieldMap)) {
                return;
            }
            for (List constructorCodeLst1 : constructorCodeList) {
                ((Op04StructuredStatement)constructorCodeLst1.get(x)).nopOut();
            }
        }
    }

    private boolean fromThisClass(FieldVariable fv) {
        return fv.getOwningClassType().equals(this.classFile.getClassType());
    }

    private boolean tryLift(FieldVariable lValue, Expression rValue, Map<String, Pair<Integer, ClassFileField>> fieldMap) {
        Pair<Integer, ClassFileField> thisField = fieldMap.get(lValue.getFieldName());
        if (thisField == null) {
            return false;
        }
        ClassFileField classFileField = thisField.getSecond();
        int thisIdx = thisField.getFirst();
        LValueUsageCollectorSimple usageCollector = new LValueUsageCollectorSimple();
        rValue.collectUsedLValues(usageCollector);
        for (LValue usedLValue : usageCollector.getUsedLValues()) {
            if (usedLValue instanceof StaticVariable) continue;
            if (usedLValue instanceof FieldVariable) {
                FieldVariable usedFieldVariable = (FieldVariable)usedLValue;
                if (!this.fromThisClass(usedFieldVariable)) {
                    return false;
                }
                Pair<Integer, ClassFileField> usedField = fieldMap.get(usedFieldVariable.getFieldName());
                if (usedField == null) {
                    return false;
                }
                ClassFileField usedClassFileField = usedField.getSecond();
                int usedIdx = usedField.getFirst();
                if (usedIdx >= thisIdx) {
                    return false;
                }
                if (usedClassFileField.getInitialValue() != null) continue;
                return false;
            }
            return false;
        }
        classFileField.setInitialValue(rValue);
        return true;
    }
}

