/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class SendMailFactory
implements ObjectFactory {
    protected final String DataSourceClassName = "javax.mail.internet.MimePartDataSource";

    @Override
    public Object getObjectInstance(Object refObj, Name name, Context ctx, Hashtable<?, ?> env) throws Exception {
        final Reference ref = (Reference)refObj;
        if (ref.getClassName().equals("javax.mail.internet.MimePartDataSource")) {
            return AccessController.doPrivileged(new PrivilegedAction<MimePartDataSource>(){

                @Override
                public MimePartDataSource run() {
                    Properties props = new Properties();
                    Enumeration<RefAddr> list = ref.getAll();
                    props.put("mail.transport.protocol", "smtp");
                    while (list.hasMoreElements()) {
                        RefAddr refaddr = list.nextElement();
                        props.put(refaddr.getType(), refaddr.getContent());
                    }
                    MimeMessage message = new MimeMessage(Session.getInstance((Properties)props));
                    try {
                        RefAddr fromAddr = ref.get("mail.from");
                        String from = null;
                        if (fromAddr != null) {
                            from = (String)ref.get("mail.from").getContent();
                        }
                        if (from != null) {
                            message.setFrom(new InternetAddress(from));
                        }
                        message.setSubject("");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    MimePartDataSource mds = new MimePartDataSource((MimePart)message);
                    return mds;
                }
            });
        }
        return null;
    }
}

