/*
* MyGoGrinder - a program to practice Go problems
* Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder.sgf;

import java.awt.Point;
//           import javax.swing.*;
import GoGrinder.GS;

/**
 *
 * @author  tkington
 */
public class NodeLabel extends SimpleMark {
    private String label;
    
    /** Creates a new instance of Label */
    public NodeLabel(String s, Point p) throws SGFParseException { // 1. in 1st Node(root) is asked for SZ for e.g. AW, AB LB etc. but
                                                             // if they are not yet processed...
                                                     // 2. and in the 2nd and further node the same question again see SGFParser:~175
        super(LABEL, p); // at this point we still don't know SZ
        int SZ = 0; // with all this coming and going with size, a central size management would be nice
        SZ = Node.currMainBranchSZ; // maybe I should just use oop
//        if(SGFParser.VALIDATING){SZ = SGFParser.sgfValiSZ; // huh! - gets old value (previous file)?
  //d.b.g(SZ,Node.currMainBranchSZ," SZ = sgfValiSZ - currMainBranchSZ - in NodeLabel");
        //}//
        //else if(!GS.getEnableWGFEditor()){SZ = SGFParser.sgfSZ; }//d.b.g(SZ," sgfSZ, NodeLabel");
        //else {SZ = SGFParser.wgfSZ; }//d.b.g(SZ," wgfSZ, NodeLabel");
        SGFUtils.checkPoint(p, SZ); // WAS fixed "19" - should be board size! it seems ,T.K. had the same problem as I
        
        //  Remove leading 0's from numbers ( ?? - I didn't see them yet - which program produces them?=
        try { // LB[ef:13] or LB[ef:X] is the label a number?
            int i = Integer.parseInt(s);
            label = String.valueOf(i);
        }
        catch(NumberFormatException e) { // LB[ef:X] the label is not a number
            label = s;
        }
    }
    
    public Object clone() {
    	try {
    		return new NodeLabel(label, new Point(pt));
    	}
    	catch(SGFParseException e) {
    		return null;
    	}
    }
    
    public boolean equals(Object o) {
        if(!(o instanceof NodeLabel))
            return false;
        
        NodeLabel l = (NodeLabel)o;
        if(!pt.equals(l.pt))
            return false;
        if(!label.equals(l.label))
            return false;
        return true;
    }
    
    public String getText() { return label; }
    
	public void printBody(StringBuffer out) {
		out.append("[" + SGFUtils.pointToString(pt) + ":" + label + "]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	}
}
