# $Id: clientinfo.tcl 1433 2008-05-19 20:08:49Z sergei $

namespace eval clientinfo {
    set options(autoask) 0
}

# TODO: connid
proc clientinfo::add_user_popup_info {infovar connid jid} {
    variable users
    upvar 0 $infovar info

    if {[info exists ::userinfo::userinfo(fn,$jid)] && \
	    $::userinfo::userinfo(fn,$jid) != ""} {
	append info [format [::msgcat::mc "\n\tName: %s"] \
			 $::userinfo::userinfo(fn,$jid)]
    } elseif {[info exists ::userinfo::userinfo(name,$jid)] && \
		  $::userinfo::userinfo(name,$jid) != ""} {
	append info [format [::msgcat::mc "\n\tName: %s"] \
			 $::userinfo::userinfo(name,$jid)]
	
	if {[info exists ::userinfo::userinfo(family,$jid)] && \
		$::userinfo::userinfo(family,$jid) != ""} {
	    append info " $::userinfo::userinfo(family,$jid)"
	}
    }

    if {[info exists ::userinfo::userinfo(clientname,$jid)] && \
	    $::userinfo::userinfo(clientname,$jid) != ""} {
	append info [format [::msgcat::mc "\n\tClient: %s"] \
			 $::userinfo::userinfo(clientname,$jid)]
	if {[info exists ::userinfo::userinfo(clientversion,$jid)]} {
	    append info " $::userinfo::userinfo(clientversion,$jid)"
	}
    }
    if {[info exists ::userinfo::userinfo(os,$jid)] && \
	    $::userinfo::userinfo(os,$jid) != ""} {
	append info [format [::msgcat::mc "\n\tOS: %s"] \
			 $::userinfo::userinfo(os,$jid)]
    }
}
hook::add roster_user_popup_info_hook \
    [namespace current]::clientinfo::add_user_popup_info


proc clientinfo::on_presence {connid from type x args} {
    variable options
    variable asked

    if {!$options(autoask)} return

    switch -- $type {
	available {
	    if {![info exists ::userinfo::userinfo(clientname,$from)] && \
		    ![info exists asked($from)]} {
		set asked($from) ""
		userinfo::request_iq version $connid $from
	    }
	}
    }
}
hook::add client_presence_hook \
    [namespace current]::clientinfo::on_presence

