//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#ifndef _D700_POS_TYPE_H
#define _D700_POS_TYPE_H

#include "pos_type.h"
#include "packet.h"
#include "endianmess.h"
#include "declarations.h"

#include <string>
#include <iostream>

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

// garmin d 700 position type class 
class D700_Pos_Type : public Pos_Type, Endianmess
{
   public:

      /// output-string return the data in gpd-string format 
      string os(void);

      void os(ostream);

      /// set data by garmin-packet 
      void set(Packet);

      /// return a garmin packet to send it to a gamin gps 
      Packet makePacket(void);

   protected:

   private:
      g_long lat;                                         // 0-3   
      g_long lon;                                         // 4-7

      double   latitude;
      double   longitude;

};


}
#endif 

