/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.connectivity;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.CubicCurve2D;
import org.diylc.common.ObjectCache;
import org.diylc.components.AbstractCurvedComponent;
import org.diylc.components.connectivity.AWG;
import org.diylc.core.ComponentState;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;

@ComponentDescriptor(name="Hookup Wire", author="Branislav Stojkovic", category="Connectivity", instanceNamePrefix="W", description="Flexible wire with two control points", zOrder=4.0, bomPolicy=BomPolicy.NEVER_SHOW, autoEdit=false)
public class HookupWire
extends AbstractCurvedComponent<Void> {
    private static final long serialVersionUID = 1L;
    public static Color COLOR = Color.green;
    public static double INSULATION_THICKNESS_PCT = 0.3;
    protected AWG gauge = AWG._22;

    protected Color getDefaultColor() {
        return COLOR;
    }

    protected void drawCurve(CubicCurve2D curve, Graphics2D g2d, ComponentState componentState) {
        int thickness = (int)(Math.pow(Math.E, -1.12436 - 0.11594 * (double)this.gauge.getValue()) * 200.0 * (1.0 + 2.0 * INSULATION_THICKNESS_PCT));
        Color curveColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.color.darker();
        g2d.setColor(curveColor);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(thickness));
        g2d.draw(curve);
        if (componentState == ComponentState.NORMAL) {
            g2d.setColor(this.color);
            g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(thickness - 2));
            g2d.draw(curve);
        }
    }

    @EditableProperty(name="AWG")
    public AWG getGauge() {
        return this.gauge;
    }

    public void setGauge(AWG gauge) {
        this.gauge = gauge;
    }

    public Void getValue() {
        return null;
    }

    public void setValue(Void value) {
    }
}

