/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.connectivity;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Arrays;
import org.diylc.common.ObjectCache;
import org.diylc.common.PCBLayer;
import org.diylc.components.AbstractComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Ground Fill", author="Branislav Stojkovic", category="Connectivity", instanceNamePrefix="GF", description="Polygonal ground fill area", zOrder=3.0, bomPolicy=BomPolicy.NEVER_SHOW, autoEdit=false)
public class GroundFill
extends AbstractComponent<Void> {
    private static final long serialVersionUID = 1L;
    public static Color COLOR = Color.black;
    public static Size DEFAULT_WIDTH = new Size(Double.valueOf(1.5), SizeUnit.in);
    public static Size DEFAULT_HEIGHT = new Size(Double.valueOf(1.2), SizeUnit.in);
    protected Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, (int)DEFAULT_HEIGHT.convertToPixels()), new Point((int)DEFAULT_WIDTH.convertToPixels(), (int)DEFAULT_HEIGHT.convertToPixels()), new Point((int)DEFAULT_WIDTH.convertToPixels(), 0)};
    protected Color color = COLOR;
    protected PointCount pointCount = PointCount._4;
    private PCBLayer layer = PCBLayer._1;

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1));
        Color fillColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.color;
        g2d.setColor(fillColor);
        int[] xPoints = new int[this.controlPoints.length];
        int[] yPoints = new int[this.controlPoints.length];
        for (int i = 0; i < this.controlPoints.length; ++i) {
            xPoints[i] = this.controlPoints[i].x;
            yPoints[i] = this.controlPoints[i].y;
        }
        g2d.fillPolygon(xPoints, yPoints, this.controlPoints.length);
        drawingObserver.stopTracking();
    }

    @EditableProperty(name="Color")
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public boolean isControlPointSticky(int index) {
        return false;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.WHEN_SELECTED;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
    }

    @EditableProperty(name="Edges")
    public PointCount getPointCount() {
        return this.pointCount;
    }

    public void setPointCount(PointCount pointCount) {
        if (this.pointCount == pointCount) {
            return;
        }
        int oldPointCount = Integer.parseInt(this.pointCount.toString());
        int newPointCount = Integer.parseInt(pointCount.toString());
        this.controlPoints = Arrays.copyOf(this.controlPoints, newPointCount);
        if (oldPointCount < newPointCount) {
            this.controlPoints[newPointCount - 1] = this.controlPoints[oldPointCount - 1];
            for (int i = oldPointCount - 1; i < newPointCount - 1; ++i) {
                this.controlPoints[i] = new Point((this.controlPoints[i - 1].x + this.controlPoints[newPointCount - 1].x) / 2, (this.controlPoints[i - 1].y + this.controlPoints[newPointCount - 1].y) / 2);
            }
        }
        this.pointCount = pointCount;
    }

    @EditableProperty
    public PCBLayer getLayer() {
        if (this.layer == null) {
            this.layer = PCBLayer._1;
        }
        return this.layer;
    }

    public void setLayer(PCBLayer layer) {
        this.layer = layer;
    }

    @Deprecated
    public Void getValue() {
        return null;
    }

    @Deprecated
    public void setValue(Void value) {
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int factor = 32 / width;
        g2d.setColor(COLOR);
        int[] x = new int[]{2 / factor, width - 2 / factor, width - 4 / factor, 3 / factor};
        int[] y = new int[]{4 / factor, 2 / factor, height - 5 / factor, height - 2 / factor};
        g2d.fillPolygon(x, y, 4);
    }

    public static enum PointCount {
        _3,
        _4,
        _5,
        _6,
        _7,
        _8;


        public String toString() {
            return this.name().substring(1);
        }
    }
}

