/*
* MyGoGrinder - a program to practice Go problems
* This class' code copyright (C) Ruediger Klehn (2015)
*   RuediRf@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;

 
/**
 *
 * @author  Ruediger Klehn
 */
 // prepare system information as Strings for display on the console or in the GUI 
public class SysInfo{
  public static final String JAVA_VENDOR = System.getProperty("java.vendor"); // SysInfoDialog, (? + gring log ?)
  public static final String JAVA_RUNTIME = System.getProperty("java.runtime.name"); // SysInfoDialog, (? + gring log ?)
  
  public static final String JAVA_VERSION = System.getProperty("java.version"); // About, (? + gring log ?)
  public static final String JAVA_HOME = System.getProperty("java.home"); 
                                      // where the Java running GoGrinder is installed
  public static final String OS_NAME = System.getProperty("os.name"); // About, (? + gring log ?)
  public static final String OS_ARCH = System.getProperty("os.arch"); // About, (? + gring log ?)
  public static final String OS_VERSION = System.getProperty("os.version"); // About, (? + gring log ?)
  public static final String WIN_SERVICE_PACK = System.getProperty("sun.os.patch.level"); // this gives the Windows service pack
  public static final String USER_NAME = System.getProperty("user.name"); // PRIVAT - do we need this?
  private static String servicePack = OS_NAME.toLowerCase().startsWith("windows") ? " " + WIN_SERVICE_PACK : "";
  private String sysInfo1 = "";
  private String sysInfo2 = "";
  private String sysInfo3 = "";
  private String sysInfo4 = "";
  private String sysInfo5 = "";
  private String sysInfo6 = "";
  private String sysInfoLogs = "";
  private String sysInfoLogsTmp = "";
  private String privData = " (private data!)"; // do I need this?
  private String warnCharsInPath = "";
  private String copiedClipB = "";
  private String clipBdLnx1 = "";
  private String clipBdLnx2 = "";
  private String usedLangRessource = "";
  private boolean settFromEnv = (!Main.SETT_FROM_ENV.equals("") ) ? true : false;
  public String sysInfoWithSettingsText = "";
  public String sysInfoWithSettingsTextEN = "";
  
  private String NL = Main.NL;
  
/**
 *
 * @author  Ruediger Klehn
 */
   public SysInfo(int doFor){ // 0 = display in commandline; 1 = display in GUI; 2 = display in log file (this = not yet)
    String settFromEnvHint = "";
    if (doFor == 1) usedLangRessource = Main.language.equals("") ? "default" : Main.language;
    
    if (settFromEnv) {settFromEnvHint = " (set by environment variable).";}
    else if(Main.PORTABLE) {settFromEnvHint = " (portable use of MyGoGrinder).";}

    sysInfo1 = Main.GRINDER_TITLE + Params.getPrgInfo() + NL 
              + Params.getCompileInfo() + NL;
    sysInfo2 = "Used Java version: " + JAVA_VERSION + NL
              + "Java vendor: " + JAVA_VENDOR + NL 
              + "Java runtime name: " + JAVA_RUNTIME + NL
              + "Java path: \"" + JAVA_HOME + "\"" + NL
              + "OS name, architecture and version: " + OS_NAME + " (" + OS_ARCH + ") " + OS_VERSION + servicePack + NL ;
    sysInfo3 = "User name and user's home directory (private data!): " + USER_NAME + NL 
             + "  \"" + Main.USER_HOME + "\"" + NL ;
    sysInfo4 = "Your Grinder settings reside in: \"" + Main.pathToSettings + "\"" + settFromEnvHint + NL
              + "The language ressource you are using: \"" + usedLangRessource + "\"" + NL ;
    sysInfoLogs = "Log files are: \"" + Main.commonLogFilePath + "\"" + NL
                + "          and  \"" + Main.sgfLogFilePath + "\"" + NL
                + "          (at startup and validating from CLI, these are written to: \"" + Main.TEMP_DIR + "\")" + NL ;
    sysInfoLogsTmp = "While in startup and on validating from CLI, logs are written to:" + NL 
                   + "  \"" + Main.TEMP_DIR + "\")" + NL + NL ;
    sysInfo5 = "Grinder's program directory: \"" + Main.thisProgsFolder + "\"" + NL + NL ;
    warnCharsInPath = "There is a possibility, that a path contains characters (e.g. Russian" + NL
        + "  or special characters, so as %, &, #, \", spaces etc.) which make problems. In" + NL
        + "  case you send a bug report, where paths play a role (e.g. '... not found'," + NL
        + "  'couldn't create ...'), you should mention these characters." + NL + NL ;
    copiedClipB = "This info has been copied to your clipboard, so you can paste it into a bug" + NL 
                + "  report. " + NL ;
    clipBdLnx1 = "Linux/Mac: Java erases the clipboard on program's end. So use the clipboard" + NL 
               + "  before you close Grinder!";
    clipBdLnx2 = "Paste the clipboard content to a text window, then press \n"
              + "(in this console) the [Enter] key to quit the program." ;
    
    if(doFor == 0) sysInfoNoSettings();
    if(doFor == 1) sysInfoWithSettings();
  }
  
    private void sysInfoNoSettings(){
      // when we split this, we can use it also for SysInfoDialog
      String prgName = (Main.TEST) ? "TEST_Grinder - " : "MyGoGrinder - ";
      String sysInfoNoSettingsText = NL + prgName + sysInfo1 //Messages.getString("gg_title")
                                    + sysInfo2
                                    + sysInfo3
                                    + sysInfo5
                                    + sysInfoLogsTmp
                                    + warnCharsInPath;
      System.out.println (sysInfoNoSettingsText + copiedClipB + clipBdLnx1);
      StringSelection myStringSelection = new StringSelection(sysInfoNoSettingsText);
      Clipboard myClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
      myClipboard.setContents(myStringSelection, null);
      // in Linux Java clears the clipboard, when exiting
      if (!OS_NAME.toLowerCase().startsWith("windows")){
//        int ready = 0;
        System.out.println(clipBdLnx2); // \"any\" 
//        while (ready == 0){ // System.in.read() gives an integer value!
          try{int ready = System.in.read();} // System.in.read() waits until [Enter], so the while thing is obsolete
          catch(Exception e){}           // but ... I want the "any" key!
//        }
      }
      System.exit(0);
    }
    
    public void sysInfoWithSettings(){
      sysInfoWithSettingsText = sysInfo1
                             + sysInfo2
                             + sysInfo3
                             + sysInfo4
                             + sysInfoLogs
                             + sysInfo5
                             + warnCharsInPath
                             + clipBdLnx1;
      sysInfoWithSettingsTextEN = sysInfo1  // this part remains in English, as it is for the coder
        + "Used Java version: " + SysInfo.JAVA_VERSION + NL
        + "Java vendor: " + SysInfo.JAVA_VENDOR + NL 
        + "Java runtime name: " + SysInfo.JAVA_RUNTIME + NL
        + "Java path: \"" + SysInfo.JAVA_HOME + "\"" + NL
        + "OS name, architecture and version: " + SysInfo.OS_NAME + " (" + SysInfo.OS_ARCH + ") " + SysInfo.OS_VERSION + servicePack + NL
        + "User name and user's home directory (private data!): " + SysInfo.USER_NAME + " (\"" + Main.USER_HOME + "\")" + NL
        + "Grinder's settings folder (private data!): \"" + Main.pathToSettings + "\"" + NL
        + "Used language ressource: \"" + usedLangRessource + "\"" + NL
        + "Grinder's program directory: \"" + Main.thisProgsFolder +"\"" + NL
        + NL 
        + "There is a possibility, that a path contains characters (e.g. unicode characters or" + NL
        + "  special characters, so as %, &, #, \", !, spaces etc.) which make problems. In case you send" + NL
        + "  a bug report, where paths play a role (e.g. '... not found'), you should mention" + NL
        + "  these characters." + NL;
        
    // + "Path to your problem files : \"" + "PATH" + "\"\n"       // CODE NOT WRITTEN
    // + DateCompiled
    
// Messages.getString("sysinfo_msg_")
// Messages.getString("sysinfo_msg_privat")
// Messages.getString("sysinfo_msg_javaversion")
// Messages.getString("sysinfo_msg_javavendor")
// Messages.getString("sysinfo_msg_javapath")
// Messages.getString("sysinfo_msg_os")
// Messages.getString("sysinfo_msg_homedir")
// Messages.getString("sysinfo_msg_pwddir")
// Messages.getString("sysinfo_msg_userdatadir")
// Messages.getString("sysinfo_msg_pathcharacters")
    }
    
}