/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.util.Enumeration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import writer2latex.office.FontDeclaration;
import writer2latex.office.ListStyle;
import writer2latex.office.MasterPage;
import writer2latex.office.OfficeStyle;
import writer2latex.office.PageMaster;
import writer2latex.office.ParStyle;
import writer2latex.office.SectionStyle;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.CSVList;
import writer2latex.util.Config;
import writer2latex.util.ExportNameCollection;
import writer2latex.util.Misc;
import writer2latex.util.SimpleInputBuffer;
import writer2latex.xhtml.ConverterHelper;
import writer2latex.xhtml.DocumentSerializerImpl;

class StyleConverter
extends ConverterHelper {
    private int nType;
    private String sScale;
    private String sColScale;
    private boolean bConvertToPx;
    private ExportNameCollection parStyleNames = new ExportNameCollection(true);
    private ExportNameCollection textStyleNames = new ExportNameCollection(true);
    private ExportNameCollection frameStyleNames = new ExportNameCollection(true);
    private ExportNameCollection listStyleNames = new ExportNameCollection(true);
    private String[] sHeadingStyles = new String[7];
    private String sAnchorStyle = null;
    private String sVisitedAnchorStyle = null;

    StyleConverter(WriterStyleCollection wsc, Config config, DocumentSerializerImpl converter, int nType) {
        super(wsc, config, converter);
        this.nType = nType;
        this.sScale = config.getXhtmlScaling();
        this.sColScale = config.getXhtmlColumnScaling();
        this.bConvertToPx = config.xhtmlConvertToPx();
    }

    public void applyDirection(StyleWithProperties style, Element hnode) {
        String sDir = style.getProperty("style:writing-mode");
        if ("lr-tb".equals(sDir)) {
            hnode.setAttribute("dir", "ltr");
        } else if ("rl-tb".equals(sDir)) {
            hnode.setAttribute("dir", "rtl");
        }
    }

    public void applyLang(StyleWithProperties style, Element hnode) {
        String sLang = style.getProperty("fo:language");
        String sCountry = style.getProperty("fo:country");
        if (sLang != null) {
            if (sCountry == null) {
                hnode.setAttribute("xml:lang", sLang);
            } else {
                hnode.setAttribute("xml:lang", sLang + "-" + sCountry);
            }
            if (this.nType == 0) {
                if (sCountry == null) {
                    hnode.setAttribute("lang", sLang);
                } else {
                    hnode.setAttribute("lang", sLang + "-" + sCountry);
                }
            }
        }
    }

    public void applyDefaultLanguage(Element hnode) {
        StyleWithProperties style;
        StyleWithProperties styleWithProperties = style = this.converter.isCalc() ? this.wsc.getDefaultCellStyle() : this.wsc.getDefaultParStyle();
        if (style != null) {
            this.applyLang(style, hnode);
        }
    }

    public void applyTextStyle(String sStyleName, Element hnode) {
        StyleWithProperties style = this.wsc.getTextStyle(sStyleName);
        if (style != null) {
            this.applyLang(style, hnode);
            if (style.isAutomatic()) {
                CSVList props = new CSVList(";");
                this.cssText(style, props);
                hnode.setAttribute("style", props.toString());
            } else {
                hnode.setAttribute("class", this.textStyleNames.getExportName(sStyleName));
            }
        }
    }

    public void applyParStyle(String sStyleName, Element hnode, boolean bUseHard) {
        ParStyle style = this.wsc.getParStyle(sStyleName);
        if (style != null) {
            if (style.isAutomatic()) {
                String sParentName = style.getParentName();
                if (sParentName != null) {
                    hnode.setAttribute("class", this.parStyleNames.getExportName(sParentName));
                }
                if (bUseHard) {
                    CSVList props = new CSVList(";");
                    this.cssBox(style, props, false);
                    this.cssPar(style, props, false);
                    this.cssText(style, props, false);
                    if (!props.isEmpty()) {
                        hnode.setAttribute("style", props.toString());
                    }
                }
            } else {
                hnode.setAttribute("class", this.parStyleNames.getExportName(sStyleName));
            }
            this.applyLang(style, hnode);
            this.applyDirection(style, hnode);
        }
    }

    public void applyFrameStyle(String sStyleName, Element hnode, CSVList props, boolean bFloat, boolean bUseHard) {
        StyleWithProperties style = this.wsc.getFrameStyle(sStyleName);
        if (style != null) {
            if ("none".equals(style.getProperty("style:wrap"))) {
                bFloat = false;
            }
            if (bFloat) {
                this.cssFloat(style, props);
            }
            if (style.isAutomatic()) {
                if (bUseHard) {
                    this.cssBox(style, props);
                }
                hnode.setAttribute("style", props.toString());
            } else {
                hnode.setAttribute("class", this.frameStyleNames.getExportName(sStyleName));
                hnode.setAttribute("style", props.toString());
            }
        }
    }

    public void applySectionStyle(String sStyleName, Element hnode) {
        SectionStyle style = this.wsc.getSectionStyle(sStyleName);
        if (style != null) {
            this.applyLang(style, hnode);
            this.applyDirection(style, hnode);
            if (!this.config.xhtmlIgnoreStyles()) {
                CSVList props = new CSVList(";");
                this.cssBox(style, props);
                if (props.toString().length() > 0) {
                    hnode.setAttribute("style", props.toString());
                }
            }
        }
    }

    public void applyPageStyle(String sMasterPage, Element hnode) {
        if (sMasterPage == null) {
            return;
        }
        MasterPage masterPage = this.wsc.getMasterPage(sMasterPage);
        if (masterPage == null) {
            return;
        }
        String sPageMaster = masterPage.getProperty("style:page-master-name");
        PageMaster pageMaster = this.wsc.getPageMaster(sPageMaster);
        if (pageMaster == null) {
            return;
        }
        this.applyDirection(pageMaster, hnode);
        if (!this.config.xhtmlIgnoreStyles()) {
            CSVList props = new CSVList(";");
            this.cssBackground(pageMaster, props, true);
            if (props.toString().length() > 0) {
                hnode.setAttribute("style", props.toString());
            }
        }
    }

    public void applyTableStyle(String sStyleName, Element hnode) {
        StyleWithProperties style = this.wsc.getTableStyle(sStyleName);
        if (style != null && style.isAutomatic()) {
            this.applyDirection(style, hnode);
            CSVList props = new CSVList(";");
            this.cssBox(style, props);
            props.addValue("border-collapse", "separate");
            props.addValue("border-spacing", "0");
            if (this.converter.isCalc()) {
                props.addValue("white-space:nowrap");
            }
            hnode.setAttribute("style", props.toString());
        }
    }

    public void applyColumnStyle(String sStyleName, Element hnode) {
        StyleWithProperties style = this.wsc.getColumnStyle(sStyleName);
        if (style != null && style.isAutomatic()) {
            CSVList props = new CSVList(";");
            this.cssColumn(style, props);
            hnode.setAttribute("style", props.toString());
        }
    }

    public void applyRowStyle(String sStyleName, Element hnode) {
        StyleWithProperties style = this.wsc.getRowStyle(sStyleName);
        if (style != null && style.isAutomatic()) {
            CSVList props = new CSVList(";");
            this.cssRow(style, props);
            this.cssBackground(style, props, false);
            hnode.setAttribute("style", props.toString());
        }
    }

    public void applyCellStyle(String sStyleName, String sValueType, Element hnode) {
        StyleWithProperties style = this.wsc.getCellStyle(sStyleName);
        if (style != null) {
            CSVList props = new CSVList(";");
            this.cssText(style, props);
            this.cssPar(style, props);
            this.cssBox(style, props);
            this.cssCell(style, props, sValueType);
            hnode.setAttribute("style", props.toString());
        }
    }

    public void applyListStyle(int nLevel, String sStyleName, Element hnode, boolean bUseHard) {
        ListStyle style = this.wsc.getListStyle(sStyleName);
        if (style != null) {
            if (style.isAutomatic()) {
                if (bUseHard) {
                    CSVList props = new CSVList(";");
                    this.cssList(style, nLevel, props);
                    hnode.setAttribute("style", props.toString());
                }
            } else {
                hnode.setAttribute("class", "listlevel" + Integer.toString(nLevel) + this.listStyleNames.getExportName(sStyleName));
            }
        }
    }

    public void setHeadingStyle(int nLevel, String sStyleName) {
        if (this.sHeadingStyles[nLevel] == null) {
            this.sHeadingStyles[nLevel] = sStyleName;
        }
    }

    public void setAnchorStyle(String sStyleName, String sVisitedStyleName) {
        if (this.sAnchorStyle == null) {
            this.sAnchorStyle = sStyleName;
            this.sVisitedAnchorStyle = sVisitedStyleName;
        }
    }

    public Node exportStyles(Document htmlDOM) {
        CSVList props;
        Text css;
        String sName;
        OfficeStyle style;
        StyleWithProperties defaultStyle;
        Element htmlStyle = htmlDOM.createElement("style");
        htmlStyle.setAttribute("media", "all");
        htmlStyle.setAttribute("type", "text/css");
        htmlStyle.appendChild(htmlDOM.createTextNode("\n"));
        StyleWithProperties styleWithProperties = defaultStyle = this.converter.isCalc() ? this.wsc.getDefaultCellStyle() : this.wsc.getDefaultParStyle();
        if (defaultStyle != null) {
            CSVList props2 = new CSVList(";");
            this.cssText(defaultStyle, props2);
            Text css2 = htmlDOM.createTextNode("      body {" + props2.toString() + "}\n");
            htmlStyle.appendChild(css2);
        }
        int i = 1;
        while (i <= 6) {
            ParStyle style2;
            if (this.sHeadingStyles[i] != null && (style2 = this.wsc.getParStyle(this.sHeadingStyles[i])) != null) {
                CSVList props3 = new CSVList(";");
                this.cssBox(style2, props3);
                this.cssPar(style2, props3);
                this.cssText(style2, props3);
                props3.addValue("clear", "left");
                Text css3 = htmlDOM.createTextNode("      h" + i + " {" + props3.toString() + "}\n");
                htmlStyle.appendChild(css3);
            }
            ++i;
        }
        Enumeration enumeration = this.wsc.getListStyles().getStylesEnumeration();
        while (enumeration.hasMoreElements()) {
            style = (ListStyle)enumeration.nextElement();
            sName = style.getName();
            if (style.isAutomatic() || !this.listStyleNames.containsName(sName)) continue;
            int nLevel = 1;
            while (nLevel < 10) {
                CSVList props4 = new CSVList(";");
                this.cssList((ListStyle)style, nLevel, props4);
                String sCssName = ".listlevel" + Integer.toString(nLevel) + this.listStyleNames.getExportName(sName);
                Text css4 = htmlDOM.createTextNode("      " + sCssName + " {" + props4.toString() + "}\n");
                htmlStyle.appendChild(css4);
                ++nLevel;
            }
        }
        enumeration = this.wsc.getFrameStyles().getStylesEnumeration();
        while (enumeration.hasMoreElements()) {
            style = (StyleWithProperties)enumeration.nextElement();
            sName = style.getName();
            if (style.isAutomatic() || !this.frameStyleNames.containsName(sName)) continue;
            CSVList props5 = new CSVList(";");
            this.cssBox((StyleWithProperties)style, props5);
            css = htmlDOM.createTextNode("      .frame" + this.frameStyleNames.getExportName(sName) + " {" + props5.toString() + "}\n");
            htmlStyle.appendChild(css);
        }
        enumeration = this.wsc.getParStyles().getStylesEnumeration();
        while (enumeration.hasMoreElements()) {
            style = (StyleWithProperties)enumeration.nextElement();
            sName = style.getName();
            if (style.isAutomatic() || !this.parStyleNames.containsName(sName)) continue;
            CSVList props6 = new CSVList(";");
            this.cssBox((StyleWithProperties)style, props6);
            this.cssPar((StyleWithProperties)style, props6);
            this.cssText((StyleWithProperties)style, props6);
            css = htmlDOM.createTextNode("      p." + this.parStyleNames.getExportName(sName) + " {" + props6.toString() + "}\n");
            htmlStyle.appendChild(css);
        }
        if (this.sAnchorStyle != null) {
            style = this.wsc.getTextStyle(this.sAnchorStyle);
            props = new CSVList(";");
            this.cssText((StyleWithProperties)style, props);
            Text css5 = htmlDOM.createTextNode("      a:link {" + props.toString() + "}\n");
            htmlStyle.appendChild(css5);
        }
        if (this.sVisitedAnchorStyle != null) {
            style = this.wsc.getTextStyle(this.sAnchorStyle);
            props = new CSVList(";");
            this.cssText((StyleWithProperties)style, props);
            Text css6 = htmlDOM.createTextNode("      a:visited {" + props.toString() + "}\n");
            htmlStyle.appendChild(css6);
        }
        enumeration = this.wsc.getTextStyles().getStylesEnumeration();
        while (enumeration.hasMoreElements()) {
            style = (StyleWithProperties)enumeration.nextElement();
            sName = style.getName();
            if (style.isAutomatic() || !this.textStyleNames.containsName(sName)) continue;
            CSVList props7 = new CSVList(";");
            this.cssText((StyleWithProperties)style, props7);
            css = htmlDOM.createTextNode("      span." + this.textStyleNames.getExportName(sName) + " {" + props7.toString() + "}\n");
            htmlStyle.appendChild(css);
        }
        htmlStyle.appendChild(htmlDOM.createTextNode("    "));
        return htmlStyle;
    }

    public boolean isBold(StyleWithProperties style) {
        String s = style.getProperty("fo:font-weight", false);
        return s != null && "bold".equals(s);
    }

    public boolean isItalics(StyleWithProperties style) {
        String s = style.getProperty("fo:font-style", false);
        return s != null && !"normal".equals(s);
    }

    public boolean isFixed(StyleWithProperties style) {
        String s = style.getProperty("style:font-name", false);
        String s2 = null;
        String s3 = null;
        if (s != null) {
            FontDeclaration fd = (FontDeclaration)this.wsc.getFontDeclarations().getStyle(s);
            s2 = fd.getProperty("style:font-family-generic");
            s3 = fd.getProperty("style:font-pitch");
        } else {
            s = style.getProperty("fo:font-family", false);
            s2 = style.getProperty("style:font-family-generic", false);
            s3 = style.getProperty("style:font-pitch", false);
        }
        if ("fixed".equals(s3)) {
            return true;
        }
        return "modern".equals(s2);
    }

    public boolean isSuperscript(StyleWithProperties style) {
        String sPos = style.getProperty("style:text-position", false);
        if (sPos == null) {
            return false;
        }
        if (sPos.startsWith("sub")) {
            return false;
        }
        return !sPos.startsWith("-");
    }

    public boolean isSubscript(StyleWithProperties style) {
        String sPos = style.getProperty("style:text-position", false);
        if (sPos == null) {
            return false;
        }
        if (sPos.startsWith("sub")) {
            return true;
        }
        return sPos.startsWith("-");
    }

    private String scale(String s) {
        if (this.bConvertToPx) {
            return Misc.length2px(Misc.multiply(this.sScale, s));
        }
        return Misc.multiply(this.sScale, s);
    }

    /*
     * Unable to fully structure code
     */
    private String borderScale(String sBorder) {
        in = new SimpleInputBuffer(sBorder);
        out = new StringBuffer();
        ** GOTO lbl17
        {
            out.append(" ");
            in.getChar();
            do {
                if (in.peekChar() == ' ') continue block0;
                if ('0' <= in.peekChar() && in.peekChar() <= '9') {
                    out.append(this.scale(in.getNumber() + in.getIdentifier()));
                }
                while (in.peekChar() != ' ' && in.peekChar() != '\u0000') {
                    out.append(in.getChar());
                }
lbl17:
                // 2 sources

            } while (in.peekChar() != '\u0000');
        }
        return out.toString();
    }

    private void cssText(StyleWithProperties style, CSVList props) {
        this.cssText(style, props, true);
    }

    private void cssText(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s3;
        String s2;
        String s;
        CSVList val;
        if (bInherit || style.getProperty("style:font-name", false) != null) {
            val = new CSVList(",");
            s = style.getProperty("style:font-name");
            if (s != null) {
                FontDeclaration fd = (FontDeclaration)this.wsc.getFontDeclarations().getStyle(s);
                s = fd.getProperty("fo:font-family");
                s2 = fd.getProperty("style:font-family-generic");
                s3 = fd.getProperty("style:font-pitch");
            } else {
                s = style.getProperty("fo:font-family");
                s2 = style.getProperty("style:font-family-generic");
                s3 = style.getProperty("style:font-pitch");
            }
            if (s != null) {
                val.addValue(s);
            }
            if ("fixed".equals(s3)) {
                val.addValue("monospace");
            } else if ("roman".equals(s2)) {
                val.addValue("serif");
            } else if ("swiss".equals(s2)) {
                val.addValue("sans-serif");
            } else if ("modern".equals(s2)) {
                val.addValue("monospace");
            } else if ("decorative".equals(s2)) {
                val.addValue("fantasy");
            } else if ("script".equals(s2)) {
                val.addValue("cursive");
            } else if ("system".equals(s2)) {
                val.addValue("monospace");
            }
            if (!val.isEmpty()) {
                props.addValue("font-family", val.toString());
            }
        }
        if ((s = style.getProperty("fo:font-style", bInherit)) != null) {
            props.addValue("font-style", s);
        }
        if ((s = style.getProperty("fo:font-variant", bInherit)) != null) {
            props.addValue("font-variant", s);
        }
        if ((s = style.getProperty("fo:font-weight", bInherit)) != null) {
            props.addValue("font-weight", s);
        }
        if (bInherit || style.getProperty("fo:font-size", false) != null || style.getProperty("style:text-position", false) != null) {
            s = style.getAbsoluteProperty("fo:font-size");
            s2 = style.getProperty("style:text-position");
            if (s2 != null) {
                String s4;
                int i = (s2 = s2.trim()).indexOf(" ");
                if (i > 0) {
                    s3 = s2.substring(0, i);
                    s4 = s2.substring(i + 1);
                } else {
                    s3 = s2;
                    s4 = "100%";
                }
                if (s != null) {
                    props.addValue("font-size", Misc.multiply(s4, this.scale(s)));
                } else {
                    props.addValue("font-size", s4);
                }
                props.addValue("vertical-align", s3);
            } else if (s != null) {
                props.addValue("font-size", this.scale(s));
            }
        }
        if ((s = style.getProperty("fo:color", bInherit)) != null) {
            props.addValue("color", s);
        }
        if ((s = style.getProperty("style:text-background-color", bInherit)) != null) {
            props.addValue("background-color", s);
        }
        if ((s = style.getProperty("fo:text-shadow", bInherit)) != null) {
            props.addValue("text-shadow", s);
        }
        s = style.getProperty("style:text-crossing-out", bInherit);
        s2 = style.getProperty("style:text-underline", bInherit);
        s3 = style.getProperty("style:text-blinking", bInherit);
        if ("none".equals(s) || "none".equals(s2) || "false".equals(s3)) {
            props.addValue("text-decoration", "none");
        } else {
            val = new CSVList(" ");
            if (s != null && !"none".equals(s)) {
                val.addValue("line-through");
            }
            if (s2 != null && !"none".equals(s2)) {
                val.addValue("underline");
            }
            if (s3 != null && "true".equals(s3)) {
                val.addValue("blink");
            }
            if (!val.isEmpty()) {
                props.addValue("text-decoration", val.toString());
            }
        }
        s = style.getProperty("fo:letter-spacing", bInherit);
        if (s != null) {
            props.addValue("letter-spacing", this.scale(s));
        }
        if ((s = style.getProperty("fo:text-transform", bInherit)) != null) {
            props.addValue("text-transform", s);
        }
    }

    private void cssPar(StyleWithProperties style, CSVList props) {
        this.cssPar(style, props, true);
    }

    private void cssPar(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s;
        if (bInherit || style.getProperty("fo:text-indent", false) != null) {
            s = style.getAbsoluteProperty("fo:text-indent");
            if (s != null) {
                props.addValue("text-indent", this.scale(s));
            } else {
                s = style.getProperty("style:auto-text-indent");
                if ("true".equals(s)) {
                    props.addValue("text-indent", "2em");
                }
            }
        }
        if ((s = style.getProperty("fo:text-align", bInherit)) != null) {
            if (s.equals("start")) {
                s = "left";
            } else if (s.equals("end")) {
                s = "right";
            }
            props.addValue("text-align", s);
        }
        if (this.converter.isCalc()) {
            s = style.getProperty("fo:wrap-option", bInherit);
            if ("no-wrap".equals(s)) {
                props.addValue("white-space", "nowrap");
            } else if ("wrap".equals(s)) {
                props.addValue("white-space", "normal");
            }
        }
    }

    private void cssColumn(StyleWithProperties style, CSVList props) {
        String s = style.getAbsoluteProperty("style:column-width");
        if (s != null) {
            props.addValue("width", Misc.multiply(this.sColScale, this.scale(s)));
        }
    }

    private void cssRow(StyleWithProperties style, CSVList props) {
        String s = style.getAbsoluteProperty("style:row-height");
        if (s == null) {
            s = style.getAbsoluteProperty("style:min-row-height");
        }
        if (s != null) {
            props.addValue("height", this.scale(s));
        }
    }

    private void cssCell(StyleWithProperties style, CSVList props, String sValueType) {
        String s = style.getProperty("fo:vertical-align");
        if ("middle".equals(s)) {
            props.addValue("vertical-align", "middle");
        } else if ("bottom".equals(s)) {
            props.addValue("vertical-align", "bottom");
        } else {
            props.addValue("vertical-align", "top");
        }
        if (!"fix".equals(style.getProperty("style:text-align-source")) && sValueType != null) {
            props.addValue("text-align", "string".equals(sValueType) ? "left" : "right");
        }
    }

    private void cssBackground(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s = style.getProperty("fo:background-color", bInherit);
        if (s != null) {
            props.addValue("background-color", s);
        }
    }

    private void cssBox(StyleWithProperties style, CSVList props) {
        this.cssBox(style, props, true);
    }

    private void cssBox(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s;
        if (bInherit || style.getProperty("fo:margin-left", false) != null) {
            s = style.getAbsoluteProperty("fo:margin-left");
            if (s != null) {
                props.addValue("margin-left", this.scale(s));
            } else {
                props.addValue("margin-left", "0");
            }
        }
        if (bInherit || style.getProperty("fo:margin-right", false) != null) {
            s = style.getAbsoluteProperty("fo:margin-right");
            if (s != null) {
                props.addValue("margin-right", this.scale(s));
            } else {
                props.addValue("margin-right", "0");
            }
        }
        if (bInherit || style.getProperty("fo:margin-top", false) != null) {
            s = style.getAbsoluteProperty("fo:margin-top");
            if (s != null) {
                props.addValue("margin-top", this.scale(s));
            } else {
                props.addValue("margin-top", "0");
            }
        }
        if (bInherit || style.getProperty("fo:margin-bottom", false) != null) {
            s = style.getAbsoluteProperty("fo:margin-bottom");
            if (s != null) {
                props.addValue("margin-bottom", this.scale(s));
            } else {
                props.addValue("margin-bottom", "0");
            }
        }
        s = null;
        if (bInherit || style.getProperty("fo:padding", false) != null) {
            s = style.getAbsoluteProperty("fo:padding");
        }
        if (s != null) {
            props.addValue("padding", this.scale(s));
        } else {
            if ((bInherit || style.getProperty("fo:padding-top", false) != null) && (s = style.getAbsoluteProperty("fo:padding-top")) != null) {
                props.addValue("padding-top", this.scale(s));
            }
            if ((bInherit || style.getProperty("fo:padding-bottom", false) != null) && (s = style.getAbsoluteProperty("fo:padding-bottom")) != null) {
                props.addValue("padding-bottom", this.scale(s));
            }
            if ((bInherit || style.getProperty("fo:padding-left", false) != null) && (s = style.getAbsoluteProperty("fo:padding-left")) != null) {
                props.addValue("padding-left", this.scale(s));
            }
            if ((bInherit || style.getProperty("fo:padding-right", false) != null) && (s = style.getAbsoluteProperty("fo:padding-right")) != null) {
                props.addValue("padding-right", this.scale(s));
            }
        }
        boolean bHasBorder = false;
        s = null;
        if (bInherit || style.getProperty("fo:border", false) != null) {
            s = style.getProperty("fo:border");
        }
        if (s != null) {
            props.addValue("border", this.borderScale(s));
            bHasBorder = true;
        } else {
            if ((bInherit || style.getProperty("fo:border-top", false) != null) && (s = style.getProperty("fo:border-top")) != null) {
                props.addValue("border-top", this.borderScale(s));
                bHasBorder = true;
            }
            if ((bInherit || style.getProperty("fo:border-bottom", false) != null) && (s = style.getProperty("fo:border-bottom")) != null) {
                props.addValue("border-bottom", this.borderScale(s));
                bHasBorder = true;
            }
            if ((bInherit || style.getProperty("fo:border-left", false) != null) && (s = style.getProperty("fo:border-left")) != null) {
                props.addValue("border-left", this.borderScale(s));
                bHasBorder = true;
            }
            if ((bInherit || style.getProperty("fo:border-right", false) != null) && (s = style.getProperty("fo:border-right")) != null) {
                props.addValue("border-right", this.borderScale(s));
                bHasBorder = true;
            }
        }
        if (bInherit && !bHasBorder) {
            props.addValue("border", "none");
        }
        this.cssBackground(style, props, bInherit);
    }

    private void cssFloat(StyleWithProperties style, CSVList props) {
        String s = style.getProperty("style:horizontal-pos");
        if ("from-left".equals(s) || "left".equals(s)) {
            props.addValue("float", "left");
        } else {
            props.addValue("float", "right");
        }
    }

    private void cssList(ListStyle style, int nLevel, CSVList props) {
        String sHref;
        String sLevelType = style.getLevelType(nLevel);
        if ("text:list-level-style-number".equals(sLevelType)) {
            String sNumFormat = style.getLevelProperty(nLevel, "style:num-format");
            if ("1".equals(sNumFormat)) {
                props.addValue("list-style-type", "decimal");
            } else if ("i".equals(sNumFormat)) {
                props.addValue("list-style-type", "lower-roman");
            } else if ("I".equals(sNumFormat)) {
                props.addValue("list-style-type", "upper-roman");
            } else if ("a".equals(sNumFormat)) {
                props.addValue("list-style-type", "lower-alpha");
            } else if ("A".equals(sNumFormat)) {
                props.addValue("list-style-type", "upper-alpha");
            }
        } else if ("text:list-level-style-bullet".equals(sLevelType)) {
            switch (nLevel % 3) {
                case 1: {
                    props.addValue("list-style-type", "disc");
                    break;
                }
                case 2: {
                    props.addValue("list-style-type", "bullet");
                    break;
                }
                case 0: {
                    props.addValue("list-style-type", "square");
                }
            }
        } else if ("text:list-level-style-image".equals(sLevelType) && (sHref = style.getLevelProperty(nLevel, "xlink:href")) != null) {
            props.addValue("list-style-image", "url('" + sHref + "')");
        }
    }
}

