/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.AnimManager;
import com.xerox.VTM.engine.CAnimation;
import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import java.util.Date;

class CTranslation
extends CAnimation {
    LongPoint[] steps;

    CTranslation(Camera c, AnimManager mgr, long d) {
        this.started = false;
        this.target = c;
        this.parent = mgr;
        this.duration = d;
        this.type = "pos";
    }

    void start() {
        this.now = new Date();
        this.startTime = this.now.getTime();
        this.started = true;
    }

    void animate() {
        if (this.started) {
            this.now = new Date();
            this.progression = (double)(this.now.getTime() - this.startTime) / (double)this.duration;
            this.step = (int)Math.round((double)this.steps.length * this.progression);
            if (this.step < this.steps.length) {
                this.target.posx = this.steps[this.step].x;
                this.target.posy = this.steps[this.step].y;
                this.target.updatePrecisePosition();
                if (this.step > 0) {
                    this.target.propagateMove(this.steps[this.step].x - this.steps[this.step - 1].x, this.steps[this.step].y - this.steps[this.step - 1].y);
                }
            } else {
                this.target.posx = this.steps[this.steps.length - 1].x;
                this.target.posy = this.steps[this.steps.length - 1].y;
                this.target.updatePrecisePosition();
                if (this.step > 1) {
                    this.target.propagateMove(this.steps[this.steps.length - 1].x - this.steps[this.steps.length - 2].x, this.steps[this.steps.length - 1].y - this.steps[this.steps.length - 2].y);
                }
                this.parent.killCAnim(this, this.type);
            }
        }
    }

    protected void conclude() {
        this.target.posx = this.steps[this.steps.length - 1].x;
        this.target.posy = this.steps[this.steps.length - 1].y;
        this.target.updatePrecisePosition();
        if (this.steps.length > 1) {
            this.target.propagateMove(this.steps[this.steps.length - 1].x - this.steps[this.steps.length - 2].x, this.steps[this.steps.length - 1].y - this.steps[this.steps.length - 2].y);
        }
    }

    public void postAnimAction() {
        if (this.paa != null) {
            this.paa.animationEnded(this.target, (short)1, "pos");
        }
    }
}

