#                                                         -*- Perl -*-
# Copyright (c) 2000  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
# Ǽ᤿ե륯饹Τδ쥯饹
#
package FreePWING::BaseUserChar;

require 5.005;
require Exporter;
use FileHandle;
use English;
use strict;
use integer;

use vars qw(@ISA
	    @EXPORT
	    @EXPORT_OK
	    $block_length
	    $start_character_number
	    $max_character_count);

@ISA = qw(Exporter);

#
# ֥åĹ (Хȿ)
#
$block_length = 2048;

#
# ǽ˳Ƥʸֹ
#
$start_character_number = 0xa121;

#
# ǽ˳Ƥʸֹ
#
$max_character_count = 8192;

#
# :
#	new()
# ᥽åɤζʬ:
# 	public 饹᥽åɡ
# :
# 	֥Ȥ롣
# :
# 	֥ȤؤΥե󥹤֤
#
sub new {
    my $type = shift;
    my $new = {
	# ̾եΥϥɥ
	'name_handle' => FileHandle->new(),

	# ե̾
	'name_file_name' => '',

	# ι⤵  (16  48 ɥå) 
	'bitmap_heights' => [16, 24, 30, 48],

	#  (⤵ 16  48 ɥå) 
	'bitmap_widths' => [0, 0, 0, 0],

	#  (⤵ 16  48 ɥå) Υӥåȥޥåפξ񥵥
	#
	#   ׻: (width + 7) / 8 * height
	#
	'bitmap_sizes' => [0, 0, 0, 0],

	#  (⤵ 16  48 ɥå) եΥϥɥ
	'bitmap_handles' => [FileHandle->new(),
			     FileHandle->new(),
			     FileHandle->new(),
			     FileHandle->new()],

	#  (⤵ 16  48 ɥå) ե̾
	'bitmap_file_names' => ['', '', '', ''],

	# Υӥåȥޥåפι⤵̤μ
	'bitmap_height_count' => 0,

	#
	#  (⤵ 16  48 ɥå)  1  (1024 Х) 
	# ˼ޤĿ (= 񤭹ݤˡͤʪ򤷤ƼΥ֥
	# ˰ܤʤȤʤ)
	#
	#   ׻: 1024 / ((width + 7) / 8 * height)
	#
	'bitmap_pad_cycles' => [0, 0, 0, 0],

	#
	#  (⤵ 16  48 ɥå) 񤭹Ȥˡͤʪ
	# ƼΥ󥯤˰ܤˤͤʪΥ
	#
	#   ׻: 1024 % ((width + 7) / 8 * height)
	#
	'bitmap_pad_lengths' => [0, 0, 0, 0],

	# ޤǤ˽񤭹ȥ
	'character_count' => 0,

	# ׵᤬褿Ȥˡʸ˳Ƥʸֹ
	'character_number' => $start_character_number,

	# ̾
	'names' => {},

	# 顼å
	'error_message' => '',
    };
    return bless($new, $type);
}

#
# :
#	open(name_file_name, bitmap_16_file_name,
#	    [bitmap_24_file_name, bitmap_30_file_name, bitmap_48_file_name])
#           name_file_name
#		̾ե̾
#	    bitmap_16_file_name
#		 (⤵ 16 ɥå) Υӥåȥޥåץե̾
#	    bitmap_24_file_name
#		 (⤵ 24 ɥå) Υӥåȥޥåץե̾
#	    bitmap_30_file_name
#		 (⤵ 30 ɥå) Υӥåȥޥåץե̾
#	    bitmap_48_file_name
#		 (⤵ 48 ɥå) Υӥåȥޥåץե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽å
# :
# 	񤭹Ѥ˻Ⱦե򳫤
# :
#	 1 ֤Ԥ 0 ֤
#
sub open {
    my $self = shift;
    my ($name_file_name, @bitmap_file_names) = @ARG;
    my $i;

    #
    # ̾ե򳫤
    #
    $self->{'name_file_name'} = $name_file_name;
    if (!$self->{'name_handle'}
	->open($self->{'name_file_name'}, 'w')) {
	$self->{'error_message'} = "failed to open the file, $ERRNO: "
	    . $self->{'name_file_name'};
	$self->close_internal();
	return 0;
    }

    $self->{'bitmap_height_count'} = @bitmap_file_names;

    for ($i = 0; $i < $self->{'bitmap_height_count'}; $i++) {
	#
	# Υӥåȥޥåץե򳫤
	#
	$self->{'bitmap_file_names'}->[$i] = $bitmap_file_names[$i];
	if (!$self->{'bitmap_handles'}->[$i]
	    ->open($self->{'bitmap_file_names'}->[$i], 'w')) {
	    $self->{'error_message'} = "failed to open the file, $ERRNO: "
		. $self->{'bitmap_file_names'}->[$i];
	    $self->close_internal();
	    return 0;
	}
	binmode($self->{'bitmap_handles'}->[$i]);

	#
	# ΥӥåȥޥåץեκǽΥ֥å `\0' 롣
	#
	if (!$self->{'bitmap_handles'}->[$i]
	    ->print("\0" x $block_length)) {
	    $self->{'error_message'} = "failed to write the file, $ERRNO: "
		. $self->{'bitmap_file_name'}->[$i];
	    $self->close_internal();
	    return 0;
	}
    }
    return 1;
}

#
# :
#	close()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	ȾեĤ롣ƤʤС⤷ʤ
# :
#	 1 ֤
#
sub close {
    my $self = shift;
    my $data;
    my $i;
    my $block_pad;

    for ($i = 0; $i < $self->{'bitmap_height_count'}; $i++) {
	#
	# ֥åޤ "\0" 񤭹ࡣ
	#
	$block_pad = $block_length
	    - $self->{'bitmap_handles'}->[$i]->tell() % $block_length;
	if ($block_pad < $block_length
	    && !$self->{'bitmap_handles'}->[$i]->print("\0" x $block_pad)) {
	    $self->{'error_message'} = "failed to write the file, $ERRNO: "
		. $self->{'bitmap_file_names'}->[$i];
	    $self->close_internal();
	    return 0;
	}
	
	#
	# ΥӥåȥޥåץեƬƤξ񤭹ࡣ
	#
	if (!$self->{'bitmap_handles'}->[$i]->seek(0, FileHandle->SEEK_SET)) {
	    $self->{'error_message'} = "failed to seek the file, $ERRNO: "
		. $self->{'bitmap_file_names'}->[$i];
	}
	$data = pack("C8 CC n n C2", 1, 0, 0, 0, 0, 0, 0, 0,
		     $self->{'bitmap_widths'}->[$i],
		     $self->{'bitmap_heights'}->[$i],
		     $start_character_number,
		     $self->{'character_count'},
		     0, 0);
	if (!$self->{'bitmap_handles'}->[$i]->print($data)) {
	    $self->{'error_message'} = "failed to write the file, $ERRNO: "
		. $self->{'bitmap_file_names'}->[$i];
	    $self->close_internal();
	    return 0;
	}
    }

    #
    # ΥӥåȥޥåץեĤ롣
    #
    $self->close_internal();
    return 1;
}

#
# :
#	close_internal()
# ᥽åɤζʬ:
# 	private 󥹥󥹥᥽åɡ
# :
#	close() ѥ᥽åɡ
#
sub close_internal {
    my $self = shift;
    my $i;

    #
    # ̾եĤ롣
    #
    if ($self->{'name_handle'}->fileno()) {
	$self->{'name_handle'}->close();
    }

    #
    # ΥӥåȥޥåץեĤ롣
    #
    for ($i = 0; $i < $self->{'bitmap_height_count'}; $i++) {
	$self->{'bitmap_handles'}->[$i]->close();
    }
}

#
# :
#	add_character(name, [xbm_16_file_name, xbm_24_file_name,
#	    xbm_30_file_name, xbm_48_file_name])
#           name
#		̾
#	    xbm_16_file_name
#		 (⤵ 16 ɥå)  XBM ӥåȥޥåץե̾
#	    xbm_24_file_name
#		 (⤵ 24 ɥå)  XBM ӥåȥޥåץե̾
#	    xbm_30_file_name
#		 (⤵ 30 ɥå)  XBM ӥåȥޥåץե̾
#	    xbm_48_file_name
#		 (⤵ 48 ɥå)  XBM ӥåȥޥåץե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	Ⱦե˥֥åȥȥɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_character {
    my $self = shift;
    my ($name, @xbm_file_names) = @ARG;
    my ($width, $height, $bitmap);
    my $i;

    #
    # Ͽʸǧ롣
    #
    if ($max_character_count <= $self->{'character_count'}) {
	$self->{'error_message'} = "define too many characters";
	$self->close_internal();
	return 0;
    }

    #
    # ˤ̾ĳϿƤ뤫Ĵ٤롣
    #
    if (defined($self->{'name'}->{$name})) {
	$self->{'error_message'} = "character name has already been defined: "
	    . $name;
	$self->close_internal();
	return 0;
    }

    #
    # ̾եˤγ񤭹ࡣ
    #
    if (!$self->{'name_handle'}
	->printf("%s\t%04x\n", $name, $self->{'character_number'})) {
	$self->{'error_message'} = "failed to write the file, $ERRNO: "
	    . $self->{'name_file_name'};
	$self->close_internal();
	return 0;
    }

    for ($i = 0; $i < $self->{'bitmap_height_count'}; $i++) {
	if (!defined($xbm_file_names[$i])) {
	    $self->{'error_message'} =
		sprintf("bitmap file (height=%s) not specified",
			$self->{'bitmap_heights'}->[$i]);
	    $self->close_internal();
	    return 0;
	}

	#
	#  XBM եɤ߹ࡣ
	#
	($width, $height, $bitmap) = $self->read_xbm_file($xbm_file_names[$i]);
	if (!defined($bitmap)) {
	    $self->close_internal();
	    return 0;
	}
	if ($width != $self->{'bitmap_widths'}->[$i]
	    || $height != $self->{'bitmap_heights'}->[$i]) {
	    $self->{'error_message'} = "XBM file has incorrect size: "
		. $xbm_file_names[$i];
	    $self->close_internal();
	    return 0;
	}

	#
	# Υӥåȥޥåפ񤭹ࡣ
	#
	if (!$self->{'bitmap_handles'}->[$i]->print($bitmap)) {
	    $self->{'error_message'} = "failed to write the file, $ERRNO: "
		. $self->{'bitmap_file_names'}->[$i];
	    $self->close_internal();
	    return 0;
	}

	#
	# ֥åնƤϡĤ "\0" Ƽ
	# ֥å˰ܤ롣
	#
	if (($self->{'character_count'} + 1)
	    % $self->{'bitmap_pad_cycles'}->[$i] == 0) {
	    if (!$self->{'bitmap_handles'}->[$i]
		->print("\0" x $self->{'bitmap_pad_lengths'}->[$i])) {
		$self->{'error_message'} = "failed to write the file, $ERRNO: "
		    . $self->{'bitmap_file_names'}->[$i];
		$self->close_internal();
		return 0;
	    }
	}
    }


    $self->{'name'}->{$name} = 1;
    $self->{'character_count'}++;
    if (($self->{'character_number'} & 0x7f) == 0x7e) {
	$self->{'character_number'} += 0xa3;
    } else {
	$self->{'character_number'}++;
    }
    return 1;
}

#
# :
#	read_xbm_file(file_name)
#	    file_name
#		ɤ߹ XBM ե̾
# ᥽åɤζʬ:
# 	private 󥹥󥹥᥽åɡ
# :
#	XBM եɤ߹ࡣ
# :
#	Ȥϡ 3 ĤǤ򤳤ν¤٤ꥹȤ֤
#	    1. ӥåȥޥåץǡΥɥåȿ
#	    2. ӥåȥޥåץǡι⤵Υɥåȿ
#           3. ӥåȥޥåץǡpack("C*") ǳƥХȤͤ᤿Ρ
#       ԤȤϡundef ֤
# :
#	X11R6.3  Xmu/RdBitF.c  XmuReadBitmapData() 򻲹ͤˤ
#
sub read_xbm_file {
    my $self = shift;
    my ($file_name) = @ARG;

    #
    # XBM ե򳫤
    #
    my $handle = FileHandle->new();
    if (!$handle->open($file_name, 'r')) {
        $self->{'error_message'} = 
            "failed to open the file, $ERRNO: $file_name";
        return;
    }

    #
    # XBM եñ̤ɤ߹ࡣ
    # "bits[] = {" ιԤ˽в񤦤ޤǷ֤
    #
    my $line;
    my ($name, $value);
    my ($width, $height) = (0, 0);
    for (;;) {
        $line = $handle->getline();
        if (!defined($line)) {
	    $handle->close();
	    $self->{'error_message'} = "broken XBM file: $file_name";
            return;
        }

	if ($line =~ /^\#define[ \t]+(\S+)[ \t]+([0-9]+)/) {
	    #
	    # "#define ...." ǻϤޤԡ
	    #
	    $name = $1;
	    $value = $2;
	    if ($name eq 'width' || $name =~ /_width$/) {
		$width = $value;
	    } elsif ($name eq 'height' || $name =~ /_height$/) {
		$height = $value;
	    }
	} elsif ($line =~ /static[ \t]+char[ \t]+(\S+)[ \t]+=[ \t]+\{/) {
	    #
	    # "static char ...." ǻϤޤԡ
	    #
	    $name = $1;
	    if ($name eq 'bits[]' || $name =~ /_bits\[\]$/) {
		last;
	    }
	} elsif ($line =~ /static unsigned char (\S+) = \{/) {
	    #
	    # "static unsigned char ...." ǻϤޤԡ
	    #
	    $name = $1;
	    if ($name eq 'bits[]' || $name =~ /_bits\[\]$/) {
		last;
	    }
	}
    }

    #
    # width, height ʤХ顼
    #
    if ($width == 0 || $height == 0) {
	$handle->close();
	$self->{'error_message'} = "broken XBM file: $file_name";
	return;
    }

    #
    # ӥåȥޥåפ 16 ʿʬ 1 ʸñ̤ɤ߹ࡣ 
    # 
    my @values = ();
    my $current_value = 0;
    my $size = ($width + 7) / 8 * $height;
    my $gotone = 0;
    my $i = 0;
    my $c;
    while ($i < $size) {
        $c = $handle->getc();
        if ($c eq '') {
	    #
	    # ͽƤʤ EOF
	    #
	    $handle->close();
	    $self->{'error_message'} = "broken XBM file: $file_name";
            return;
        } elsif ($c =~ /^[0-9A-Fa-f]$/) {
	    #
	    # 16 ʿ
	    #
	    $current_value = ($current_value << 4) + hex($c);
	    $gotone++;
	} elsif ($c =~ /^[ ,\}\t\n]$/ && $gotone) {
	    #
	    # 16 ʿ 1 ʾɤ߹ζڤʸ
	    # 16 ʿͤѴӥåȤ¤Ӥ򺸱 (MSB  LSB)
	    # žƤ @values ˵Ͽ롣
	    #
	    $values[$i] = 0;
	    $values[$i] |= 0x80 if (($current_value & 0x01) != 0);
	    $values[$i] |= 0x40 if (($current_value & 0x02) != 0);
	    $values[$i] |= 0x20 if (($current_value & 0x04) != 0);
	    $values[$i] |= 0x10 if (($current_value & 0x08) != 0);
	    $values[$i] |= 0x08 if (($current_value & 0x10) != 0);
	    $values[$i] |= 0x04 if (($current_value & 0x20) != 0);
	    $values[$i] |= 0x02 if (($current_value & 0x40) != 0);
	    $values[$i] |= 0x01 if (($current_value & 0x80) != 0);
	    $current_value = 0;
	    $gotone = 0;
	    $i++;
	}
    }

    #
    # XBM եĤ롣
    #
    $handle->close();

    return ($width, $height, pack("C*", @values));
}

######################################################################
# <󥹥ѿ֤ͤ᥽åɷ>
#
# :
#	󥹥ѿ̾()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
#	󥹥ѿ֤ͤ
#
sub name_file_name {
    my $self = shift;
    return $self->{'name_file_name'};
}
sub bitmap_file_name {
    my $self = shift;
    my ($height) = @ARG;
    return $self->{'bitmap_file_name'}->{$height};
}
sub character_count {
    my $self = shift;
    return $self->{'character_count'};
}
sub character_number {
    my $self = shift;
    return $self->{'character_number'};
}
sub error_message {
    my $self = shift;
    return $self->{'error_message'};
}

1;
