/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.dialects.CommonHibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.OptionalSqlClause;
import net.sourceforge.squirrel_sql.fw.dialects.SequencePropertyMutability;
import net.sourceforge.squirrel_sql.fw.dialects.SqlGenerationPreferences;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import org.antlr.stringtemplate.StringTemplate;
import org.hibernate.HibernateException;
import org.hibernate.dialect.HSQLDialect;

public class HSQLDialectExt
extends CommonHibernateDialect
implements HibernateDialect {
    private HSQLDialectHelper _dialect = new HSQLDialectHelper();

    @Override
    public String getTypeName(int code, int length, int precision, int scale) throws HibernateException {
        return this._dialect.getTypeName(code, length, precision, scale);
    }

    @Override
    public boolean canPasteTo(IDatabaseObjectInfo info) {
        boolean result = true;
        DatabaseObjectType type = info.getDatabaseObjectType();
        if (type.getName().equalsIgnoreCase("database")) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean supportsSchemasInTableDefinition() {
        return false;
    }

    @Override
    public String getDisplayName() {
        return "HSQL";
    }

    @Override
    public boolean supportsProduct(String databaseProductName, String databaseProductVersion) {
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().startsWith("HSQL");
    }

    @Override
    public boolean supportsColumnComment() {
        return false;
    }

    @Override
    public String getColumnDropSQL(String tableName, String columnName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getColumnDropSQL(tableName, columnName, qualifier, prefs, this);
    }

    @Override
    public List<String> getTableDropSQL(ITableInfo iTableInfo, boolean cascadeConstraints, boolean isMaterializedView, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getTableDropSQL(iTableInfo, true, cascadeConstraints, false, "CASCADE", false, qualifier, prefs, this);
    }

    @Override
    public String[] getAddPrimaryKeySQL(String pkName, TableColumnInfo[] columns, ITableInfo ti, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String tableName = DialectUtils.shapeQualifiableIdentifier(ti.getSimpleName(), qualifier, prefs, this);
        return this.getAddPrimaryKeySQL(pkName, columns, tableName, qualifier, prefs);
    }

    private String[] getAddPrimaryKeySQL(String pkName, TableColumnInfo[] columns, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuffer result = new StringBuffer();
        result.append("ALTER TABLE ");
        result.append(tableName);
        result.append(" ADD CONSTRAINT ");
        result.append(pkName);
        result.append(" PRIMARY KEY (");
        for (int i = 0; i < columns.length; ++i) {
            String columnName = DialectUtils.shapeIdentifier(columns[i].getColumnName(), prefs, this);
            result.append(columnName);
            if (i + 1 >= columns.length) continue;
            result.append(", ");
        }
        result.append(")");
        return new String[]{result.toString()};
    }

    @Override
    public String getColumnCommentAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("HSQLDB doesn't support column comments");
    }

    @Override
    public boolean supportsAlterColumnNull() {
        return true;
    }

    @Override
    public String[] getColumnNullableAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("ALTER TABLE $tableName$ ALTER COLUMN $columnName$ SET $nullable$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("tableName", info.getTableName(), "columnName", info.getColumnName());
        if (info.isNullable().equalsIgnoreCase("YES")) {
            valuesMap.put("nullable", "NULL");
        } else {
            valuesMap.put("nullable", "NOT NULL");
        }
        return new String[]{DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs)};
    }

    @Override
    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    public String getColumnNameAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String alterClause = "ALTER COLUMN";
        String renameToClause = "RENAME TO";
        return DialectUtils.getColumnNameAlterSQL(from, to, alterClause, renameToClause, qualifier, prefs, this);
    }

    @Override
    public List<String> getColumnTypeAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        String alterClause = "ALTER COLUMN";
        String setClause = "";
        return DialectUtils.getColumnTypeAlterSQL(this, alterClause, setClause, false, from, to, qualifier, prefs);
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    public String getColumnDefaultAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String alterClause = "ALTER COLUMN";
        String defaultClause = "SET DEFAULT";
        return DialectUtils.getColumnDefaultAlterSQL(this, info, alterClause, false, defaultClause, qualifier, prefs);
    }

    @Override
    public String getDropPrimaryKeySQL(String pkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropPrimaryKeySQL(pkName, tableName, false, false, qualifier, prefs, this);
    }

    @Override
    public DialectType getDialectType() {
        return DialectType.HSQLDB;
    }

    @Override
    public String[] getIndexAccessMethodsTypes() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String[] getIndexStorageOptions() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String[] getAddAutoIncrementSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("ALTER TABLE $tableName$ ALTER COLUMN $columnName$ IDENTITY");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("tableName", column.getTableName(), "columnName", column.getColumnName());
        String[] pkSQL = this.getAddPrimaryKeySQL("PK_" + column.getTableName() + "_" + column.getColumnName(), new TableColumnInfo[]{column}, column.getTableName(), qualifier, prefs);
        ArrayList<String> result = new ArrayList<String>();
        result.add("-- Column must be a primary key and an integer type");
        result.addAll(Arrays.asList(pkSQL));
        result.add(DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs));
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getAddColumnSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        ArrayList<String> result = new ArrayList<String>();
        boolean addDefaultClause = false;
        boolean supportsNullQualifier = true;
        boolean addNullClause = true;
        String sql = DialectUtils.getAddColumSQL(column, this, addDefaultClause, supportsNullQualifier, addNullClause, qualifier, prefs);
        result.add(sql);
        if (column.getDefaultValue() != null && !"".equals(column.getDefaultValue())) {
            StringBuilder defaultSQL = new StringBuilder();
            defaultSQL.append("ALTER TABLE ");
            defaultSQL.append(column.getTableName());
            defaultSQL.append(" ALTER COLUMN ");
            defaultSQL.append(column.getColumnName());
            defaultSQL.append(" SET DEFAULT ");
            if (JDBCTypeMapper.isNumberType(column.getDataType())) {
                defaultSQL.append(column.getDefaultValue());
            } else {
                defaultSQL.append("'");
                defaultSQL.append(column.getDefaultValue());
                defaultSQL.append("'");
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getAddForeignKeyConstraintSQL(String localTableName, String refTableName, String constraintName, Boolean deferrable, Boolean initiallyDeferred, Boolean matchFull, boolean autoFKIndex, String fkIndexName, Collection<String[]> localRefColumns, String onUpdateAction, String onDeleteAction, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate fkST = new StringTemplate("ALTER TABLE $childTableName$ ADD $constraint$ $constraintName$ FOREIGN KEY ( $childColumn; separator=\",\"$ ) REFERENCES $parentTableName$ ( $parentColumn; separator=\",\"$ )");
        HashMap<String, String> fkValuesMap = DialectUtils.getValuesMap("childTableName", localTableName);
        fkValuesMap.put("constraint", "CONSTRAINT");
        fkValuesMap.put("constraintName", constraintName);
        fkValuesMap.put("parentTableName", refTableName);
        StringTemplate childIndexST = null;
        HashMap<String, String> ckIndexValuesMap = null;
        if (autoFKIndex) {
            childIndexST = new StringTemplate("CREATE $unique$ $storageOption$ INDEX $indexName$ ON $tableName$ ( $columnName; separator=\",\"$ )");
            ckIndexValuesMap = new HashMap<String, String>();
            ckIndexValuesMap.put("indexName", "fk_child_idx");
        }
        return DialectUtils.getAddForeignKeyConstraintSQL(fkST, fkValuesMap, childIndexST, ckIndexValuesMap, localRefColumns, qualifier, prefs, this);
    }

    @Override
    public String[] getAddUniqueConstraintSQL(String tableName, String constraintName, TableColumnInfo[] columns, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("ALTER TABLE $tableName$ ADD CONSTRAINT $constraintName$ UNIQUE ($columnName;  separator=\",\"$)");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("tableName", tableName, "constraintName", constraintName);
        return new String[]{DialectUtils.getAddUniqueConstraintSQL(st, valuesMap, columns, qualifier, prefs, (HibernateDialect)this)};
    }

    @Override
    public String[] getAlterSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String restart, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("ALTER SEQUENCE $sequenceName$ $restartWith$ $startValue$ $incrementBy$ $incrementValue$ ");
        st.setAttribute("sequenceName", (Object)sequenceName);
        st.setAttribute("restartWith", (Object)"RESTART WITH");
        st.setAttribute("startValue", (Object)restart);
        return new String[]{st.toString()};
    }

    @Override
    public String getCreateIndexSQL(String indexName, String tableName, String accessMethod, String[] columns, boolean unique, String tablespace, String constraints, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("CREATE $unique$ $storageOption$ INDEX $indexName$ ON $tableName$ ( $columnName; separator=\",\"$ )");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("indexName", indexName, "tableName", tableName);
        if (unique) {
            valuesMap.put("unique", "UNIQUE");
        }
        return DialectUtils.bindTemplateAttributes((HibernateDialect)this, st, valuesMap, columns, qualifier, prefs);
    }

    @Override
    public String getCreateSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String start, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("CREATE SEQUENCE $sequenceName$ $startWith$ $increment$ $minimum$ $maximum$ $cache$ $cycle$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("sequenceName", sequenceName);
        OptionalSqlClause startWithClause = new OptionalSqlClause("START WITH", start);
        OptionalSqlClause incrementByClause = new OptionalSqlClause("INCREMENT BY", increment);
        valuesMap.put("startWith", startWithClause.toString());
        valuesMap.put("increment", incrementByClause.toString());
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getCreateViewSQL(String viewName, String definition, String checkOption, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("CREATE VIEW $viewName$ AS $selectStatement$ $with$ $checkOptionType$ $checkOption$");
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("viewName", viewName);
        valuesMap.put("selectStatement", definition);
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getDropConstraintSQL(String tableName, String constraintName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("ALTER TABLE $tableName$ DROP CONSTRAINT $constraintName$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("tableName", tableName, "constraintName", constraintName);
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getDropIndexSQL(String tableName, String indexName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("DROP INDEX $indexName$");
        st.setAttribute("indexName", (Object)indexName);
        return st.toString();
    }

    @Override
    public String getDropSequenceSQL(String sequenceName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("DROP SEQUENCE $sequenceName$ $cascade$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("sequenceName", sequenceName);
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getDropViewSQL(String viewName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("DROP VIEW $viewName$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("viewName", viewName);
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getRenameTableSQL(String oldTableName, String newTableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 9;
        String msg = DialectUtils.getUnsupportedMessage(this, 9);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String[] getRenameViewSQL(String oldViewName, String newViewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getSequenceInformationSQL(String sequenceName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String templateStr = "select start_with as last_value, MAXIMUM_VALUE, MINIMUM_VALUE, 0 as CACHE_VALUE, INCREMENT, case INCREMENT when 'NO' then 0 else 1 end as INCREMENT_BY from INFORMATION_SCHEMA.SYSTEM_SEQUENCES where SEQUENCE_SCHEMA = '$sequenceSchema$' and SEQUENCE_NAME = '$sequenceName$' ";
        StringTemplate st = new StringTemplate(templateStr);
        st.setAttribute("sequenceName", (Object)sequenceName);
        st.setAttribute("schemaName", (Object)qualifier.getSchema());
        return st.toString();
    }

    @Override
    public boolean supportsAccessMethods() {
        return false;
    }

    @Override
    public boolean supportsAddForeignKeyConstraint() {
        return true;
    }

    @Override
    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    @Override
    public boolean supportsAlterSequence() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    @Override
    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    @Override
    public boolean supportsCreateIndex() {
        return true;
    }

    @Override
    public boolean supportsCreateSequence() {
        return true;
    }

    @Override
    public boolean supportsCreateView() {
        return true;
    }

    @Override
    public boolean supportsDropConstraint() {
        return true;
    }

    @Override
    public boolean supportsDropIndex() {
        return true;
    }

    @Override
    public boolean supportsDropSequence() {
        return true;
    }

    @Override
    public boolean supportsDropView() {
        return true;
    }

    @Override
    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsMultipleRowInserts() {
        return false;
    }

    @Override
    public boolean supportsRenameTable() {
        return false;
    }

    @Override
    public boolean supportsRenameView() {
        return false;
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    @Override
    public boolean supportsSequenceInformation() {
        return true;
    }

    @Override
    public boolean supportsTablespace() {
        return false;
    }

    @Override
    public boolean supportsUpdate() {
        return true;
    }

    @Override
    public boolean supportsAddColumn() {
        return true;
    }

    @Override
    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public String getViewDefinitionSQL(String viewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String templateStr = "SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.SYSTEM_VIEWS WHERE TABLE_NAME = '$viewName$' and TABLE_SCHEMA = '$schemaName$' ";
        StringTemplate st = new StringTemplate(templateStr);
        st.setAttribute("viewName", (Object)viewName);
        st.setAttribute("schemaName", (Object)qualifier.getSchema());
        return st.toString();
    }

    @Override
    public String getQualifiedIdentifier(String identifier, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return identifier;
    }

    @Override
    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    @Override
    public SequencePropertyMutability getSequencePropertyMutability() {
        SequencePropertyMutability result = new SequencePropertyMutability();
        result.setCache(false);
        result.setCycle(false);
        result.setMaxValue(false);
        result.setMinValue(false);
        result.setRestart(true);
        result.setStartWith(true);
        return result;
    }

    @Override
    public int getTimestampMaximumFractionalDigits() {
        return 9;
    }

    private class HSQLDialectHelper
    extends HSQLDialect {
        public HSQLDialectHelper() {
            this.registerColumnType(-5, "bigint");
            this.registerColumnType(-2, "binary");
            this.registerColumnType(-7, "bit");
            this.registerColumnType(2004, "longvarbinary");
            this.registerColumnType(16, "boolean");
            this.registerColumnType(1, "char($l)");
            this.registerColumnType(2005, "longvarchar");
            this.registerColumnType(91, "date");
            this.registerColumnType(3, "decimal");
            this.registerColumnType(8, "double");
            this.registerColumnType(6, "float");
            this.registerColumnType(4, "integer");
            this.registerColumnType(-4, "longvarbinary");
            this.registerColumnType(-1, "longvarchar");
            this.registerColumnType(2, "numeric");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-6, "tinyint");
            this.registerColumnType(-3, "varbinary");
            this.registerColumnType(12, "varchar");
        }
    }
}

