/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.completion;

import net.sourceforge.squirrel_sql.fw.completion.CompletionInfo;

public class CompletionCandidates {
    private CompletionInfo[] _candidates;
    private int _replacementStart;
    private String _stringToReplace;

    public CompletionCandidates(CompletionInfo[] candidates, int replacementStart, String stringToReplace) {
        this._candidates = candidates;
        this._replacementStart = replacementStart;
        this._stringToReplace = stringToReplace;
    }

    public CompletionCandidates(CompletionInfo[] candidates) {
        this._candidates = candidates;
    }

    public CompletionInfo[] getCandidates() {
        return this._candidates;
    }

    public int getReplacementStart() {
        return this._replacementStart;
    }

    public String getStringToReplace() {
        return this._stringToReplace;
    }

    public String getAllCandidatesPrefix(boolean caseSensitive) {
        if (0 == this._candidates.length) {
            return "";
        }
        String prefix = null;
        block0: for (CompletionInfo _candidate : this._candidates) {
            String completionString = _candidate.getCompletionString();
            if (null == prefix) {
                prefix = completionString;
                continue;
            }
            int minLen = Math.min(prefix.length(), completionString.length());
            prefix = prefix.substring(0, minLen);
            for (int ix = 0; ix < minLen; ++ix) {
                if (this.getCharAt(prefix, ix, caseSensitive) == this.getCharAt(completionString, ix, caseSensitive)) continue;
                prefix = prefix.substring(0, ix);
                continue block0;
            }
        }
        return prefix;
    }

    private char getCharAt(String prefix, int ix, boolean caseSensitive) {
        char c = prefix.charAt(ix);
        return caseSensitive ? c : Character.toUpperCase(c);
    }
}

