/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.core.ManifestHeaderElement;
import org.apache.ivy.osgi.core.ManifestHeaderValue;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.namespace.NamespaceTransformer;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.file.FileResource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;
import scala.math.ScalaNumber;

public class LogOptions {
    private String log = "default";

    public LogOptions() {
    }

    public LogOptions(LogOptions logOptions) {
        this.log = logOptions.log;
    }

    public final String getLog() {
        return this.log;
    }

    public final LogOptions setLog(String string) {
        this.log = string;
        return this;
    }

    public static void checkCachePattern(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null cache pattern not allowed.");
        }
        if (string.startsWith("..")) {
            throw new IllegalArgumentException("invalid cache pattern: '" + string + "': cache patterns must not lead outside cache directory");
        }
        if (string.startsWith("/")) {
            throw new IllegalArgumentException("invalid cache pattern: '" + string + "': cache patterns must not be absolute");
        }
    }

    public static BundleInfo parseManifest(Manifest manifest) {
        Version version;
        Attributes attributes = manifest.getMainAttributes();
        if (attributes.getValue("Bundle-ManifestVersion") == null) {
            throw new ParseException("No Bundle-ManifestVersion in the manifest", 0);
        }
        String string = new ManifestHeaderValue(attributes.getValue("Bundle-SymbolicName")).getSingleValue();
        if (string == null) {
            throw new ParseException("No Bundle-SymbolicName in the manifest", 0);
        }
        if (new ManifestHeaderValue(attributes.getValue("Bundle-Description")).getSingleValue() == null) {
            new ManifestHeaderValue(attributes.getValue("Bundle-Description")).getSingleValue();
        }
        String string2 = new ManifestHeaderValue(attributes.getValue("Bundle-Version")).getSingleValue();
        try {
            version = LogOptions.versionOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("The Bundle-Version has an incorrect version: " + string2 + " (" + numberFormatException.getMessage() + ")", 0);
        }
        BundleInfo bundleInfo = new BundleInfo(string, version);
        BundleInfo.setDescription$552c4e01();
        List list = new ManifestHeaderValue(attributes.getValue("Bundle-RequiredExecutionEnvironment")).getValues();
        bundleInfo.setExecutionEnvironments(list);
        LogOptions.parseRequirement(bundleInfo, attributes, "Require-Bundle", "bundle", "bundle-version");
        LogOptions.parseRequirement(bundleInfo, attributes, "Import-Package", "package", "version");
        LogOptions.parseRequirement(bundleInfo, attributes, "Import-Service", "service", "version");
        for (ManifestHeaderElement manifestHeaderElement : new ManifestHeaderValue(attributes.getValue("Export-Package")).getElements()) {
            Version version2;
            String string3 = (String)manifestHeaderElement.getAttributes().get("version");
            try {
                version2 = LogOptions.versionOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("The Export-Package has an incorrect version: " + string3 + " (" + numberFormatException.getMessage() + ")", 0);
            }
            for (String string4 : manifestHeaderElement.getValues()) {
                ExportPackage exportPackage = new ExportPackage(string4, version2);
                String string5 = (String)manifestHeaderElement.getDirectives().get("use");
                if (string5 != null) {
                    String[] stringArray = string5.trim().split(",");
                    for (int i = 0; i < stringArray.length; ++i) {
                        exportPackage.addUse(stringArray[i].trim());
                    }
                }
                bundleInfo.addCapability(exportPackage);
            }
        }
        LogOptions.parseCapability(bundleInfo, attributes, "Export-Service", "service");
        return bundleInfo;
    }

    private static void parseRequirement(BundleInfo bundleInfo, Attributes attributes, String string, String string2, String string3) {
        for (ManifestHeaderElement manifestHeaderElement : new ManifestHeaderValue(attributes.getValue(string)).getElements()) {
            VersionRange versionRange;
            String string4 = (String)manifestHeaderElement.getDirectives().get("resolution");
            String string5 = (String)manifestHeaderElement.getAttributes().get(string3);
            try {
                String string6 = string5;
                versionRange = string6 == null ? null : new VersionRange(string6);
            }
            catch (ParseException parseException) {
                throw new ParseException("The " + string + " has an incorrect version: " + string5 + " (" + parseException.getMessage() + ")", 0);
            }
            for (String string7 : manifestHeaderElement.getValues()) {
                bundleInfo.addRequirement(new BundleRequirement(string2, string7, versionRange, string4));
            }
        }
    }

    private static void parseCapability(BundleInfo bundleInfo, Attributes attributes, String string, String string2) {
        for (ManifestHeaderElement manifestHeaderElement : new ManifestHeaderValue(attributes.getValue(string)).getElements()) {
            Version version;
            String string3 = (String)manifestHeaderElement.getAttributes().get("version");
            try {
                version = LogOptions.versionOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("The " + string + " has an incorrect version: " + string3 + " (" + numberFormatException.getMessage() + ")", 0);
            }
            for (String string4 : manifestHeaderElement.getValues()) {
                BundleCapability bundleCapability = new BundleCapability(string2, string4, version);
                bundleInfo.addCapability(bundleCapability);
            }
        }
    }

    private static Version versionOf(String string) {
        if (string == null) {
            return null;
        }
        return new Version(string);
    }

    public static String formatMessage(ModuleRevisionId[] moduleRevisionIdArray) {
        HashSet<ModuleRevisionId> hashSet = new HashSet<ModuleRevisionId>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(moduleRevisionIdArray[0]);
        hashSet.add(moduleRevisionIdArray[0]);
        for (int i = 1; i < moduleRevisionIdArray.length; ++i) {
            stringBuffer.append("->");
            if (!hashSet.add(moduleRevisionIdArray[i])) {
                stringBuffer.append("...");
                break;
            }
            stringBuffer.append(moduleRevisionIdArray[i]);
        }
        return stringBuffer.toString();
    }

    private static boolean matches(PatternMatcher patternMatcher, String string, String string2) {
        return patternMatcher.getMatcher(string).matches(string2);
    }

    public static boolean matches(PatternMatcher patternMatcher, ArtifactId artifactId, ArtifactId artifactId2) {
        ModuleId moduleId = artifactId2.getModuleId();
        PatternMatcher patternMatcher2 = patternMatcher;
        ModuleId moduleId2 = artifactId.getModuleId();
        return LogOptions.matches(patternMatcher2, moduleId2.getOrganisation(), moduleId.getOrganisation()) && LogOptions.matches(patternMatcher2, moduleId2.getName(), moduleId.getName()) && LogOptions.matches(patternMatcher, artifactId.getName(), artifactId2.getName()) && LogOptions.matches(patternMatcher, artifactId.getExt(), artifactId2.getExt()) && LogOptions.matches(patternMatcher, artifactId.getType(), artifactId2.getType());
    }

    public static Artifact transform(Artifact artifact, NamespaceTransformer namespaceTransformer) {
        if (namespaceTransformer.isIdentity()) {
            return artifact;
        }
        ModuleRevisionId moduleRevisionId = namespaceTransformer.transform(artifact.getModuleRevisionId());
        if (artifact.getModuleRevisionId().equals(moduleRevisionId)) {
            return artifact;
        }
        return new DefaultArtifact(moduleRevisionId, artifact.getPublicationDate(), artifact.getName(), artifact.getType(), artifact.getExt(), artifact.getUrl(), artifact.getQualifiedExtraAttributes());
    }

    public static ArtifactId transform(ArtifactId artifactId, NamespaceTransformer namespaceTransformer) {
        if (namespaceTransformer.isIdentity()) {
            return artifactId;
        }
        ModuleId moduleId = LogOptions.transform(artifactId.getModuleId(), namespaceTransformer);
        if (moduleId.equals(artifactId.getModuleId())) {
            return artifactId;
        }
        return new ArtifactId(moduleId, artifactId.getName(), artifactId.getType(), artifactId.getExt());
    }

    public static ModuleId transform(ModuleId moduleId, NamespaceTransformer namespaceTransformer) {
        if (namespaceTransformer.isIdentity()) {
            return moduleId;
        }
        return namespaceTransformer.transform(new ModuleRevisionId(moduleId, "")).getModuleId();
    }

    public static boolean equals(Resource resource, File file2) {
        if (resource == null && file2 == null) {
            return true;
        }
        if (resource == null || file2 == null) {
            return false;
        }
        if (resource instanceof FileResource) {
            return new File(resource.getName()).equals(file2);
        }
        if (resource instanceof URLResource) {
            try {
                return file2.toURI().toURL().toExternalForm().equals(resource.getName());
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }
        return false;
    }

    private static String[] listTokenValues(Repository repository, String string, String string2) {
        String string3;
        String string4 = repository.getFileSeparator();
        int n = (string = repository.standardize(string)).indexOf(string3 = IvyPatternHelper.getTokenString(string2));
        if (n == -1) {
            Message.verbose("unable to list " + string2 + " in " + string + ": token not found in pattern");
            return null;
        }
        if ((string.length() <= n + string3.length() || string4.equals(string.substring(n + string3.length(), n + string3.length() + 1))) && (n == 0 || string4.equals(string.substring(n - 1, n)))) {
            String string5 = string.substring(0, n);
            return LogOptions.listAll(repository, string5);
        }
        int n2 = string.substring(0, n).lastIndexOf(string4);
        String string6 = n2 == -1 ? "" : string.substring(0, n2);
        try {
            Message.debug("\tusing " + repository + " to list all in " + string6);
            List list = repository.list(string6);
            if (list != null) {
                Message.debug("\t\tfound " + list.size() + " urls");
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                int n3 = string.indexOf(string4, n2 + 1);
                String string7 = n3 != -1 ? string.substring(n2 + 1, n3) : string.substring(n2 + 1);
                Pattern pattern = Pattern.compile(IvyPatternHelper.substituteToken(string7.replaceAll("\\.", "\\\\."), string2, "(.+)"));
                for (String string8 : list) {
                    Matcher matcher = pattern.matcher(string8.substring(string6.length() + 1));
                    if (!matcher.matches()) continue;
                    String string9 = matcher.group(1);
                    arrayList.add(string9);
                }
                Message.debug("\t\t" + arrayList.size() + " matched " + string);
                return arrayList.toArray(new String[arrayList.size()]);
            }
            return null;
        }
        catch (IOException iOException) {
            Message.verbose("problem while listing resources in " + string6 + " with " + repository + ":");
            Message.verbose("  " + iOException.getClass().getName() + " " + iOException.getMessage());
            return null;
        }
        catch (Exception exception) {
            Message.warn("problem while listing resources in " + string6 + " with " + repository + ":");
            Message.warn("  " + exception.getClass().getName() + " " + exception.getMessage());
            return null;
        }
    }

    private static String[] listAll(Repository repository, String string) {
        try {
            String string2 = repository.getFileSeparator();
            Message.debug("\tusing " + repository + " to list all in " + string);
            List list = repository.list(string);
            if (list != null) {
                Message.debug("\t\tfound " + list.size() + " resources");
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                for (String string3 : list) {
                    if (string3.endsWith(string2)) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                    int n = string3.lastIndexOf(string2);
                    arrayList.add(string3.substring(n + 1));
                }
                return arrayList.toArray(new String[arrayList.size()]);
            }
            Message.debug("\t\tno resources found");
            return null;
        }
        catch (IOException iOException) {
            Message.verbose("problem while listing resources in " + string + " with " + repository + ":");
            Message.verbose("  " + iOException.getClass().getName() + " " + iOException.getMessage());
            return null;
        }
        catch (Exception exception) {
            Message.warn("problem while listing resources in " + string + " with " + repository + ":");
            Message.warn("  " + exception.getClass().getName() + " " + exception.getMessage());
            return null;
        }
    }

    public static ResolvedResource[] findAll(Repository repository, ModuleRevisionId moduleRevisionId, String string, Artifact artifact) {
        String string2 = IvyPatternHelper.substitute(string, ModuleRevisionId.newInstance(moduleRevisionId, IvyPatternHelper.getTokenString("revision")), artifact);
        Message.debug("\tlisting all in " + string2);
        String[] stringArray = LogOptions.listTokenValues(repository, string2, "revision");
        if (stringArray != null) {
            Message.debug("\tfound revs: " + Arrays.asList(stringArray));
            ArrayList<ResolvedResource> arrayList = new ArrayList<ResolvedResource>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = IvyPatternHelper.substituteToken(string2, "revision", stringArray[i]);
                try {
                    Resource resource = repository.getResource(string3);
                    if (resource == null) continue;
                    arrayList.add(new ResolvedResource(resource, stringArray[i]));
                    continue;
                }
                catch (IOException iOException) {
                    Message.warn("impossible to get resource from name listed by repository: " + string3 + ": " + iOException.getMessage());
                }
            }
            if (stringArray.length != arrayList.size()) {
                Message.debug("\tfound resolved res: " + arrayList);
            }
            return arrayList.toArray(new ResolvedResource[arrayList.size()]);
        }
        if (string2.indexOf("[revision]") == -1) {
            try {
                Resource resource = repository.getResource(string2);
                if (resource.exists()) {
                    Message.debug("\tonly one resource found without real listing: using and defining it as working@" + repository.getName() + " revision: " + resource.getName());
                    return new ResolvedResource[]{new ResolvedResource(resource, "working@" + repository.getName())};
                }
            }
            catch (IOException iOException) {
                Message.debug("\timpossible to get resource from name listed by repository: " + string2 + ": " + iOException.getMessage());
            }
            Message.debug("\tno revision found");
        }
        return null;
    }

    public static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string + " must not be null");
        }
    }

    public static File checkAbsolute(String string, String string2) {
        LogOptions.checkNotNull(string, string2);
        File file2 = new File(string);
        if (!file2.isAbsolute()) {
            throw new IllegalArgumentException(string2 + " must be absolute: " + string);
        }
        return FileUtil.normalize(file2.getPath());
    }

    public static String format(Date date) {
        return new SimpleDateFormat("yyyyMMddHHmmss").format(date);
    }

    public static Date parse(String string) {
        return new SimpleDateFormat("yyyyMMddHHmmss").parse(string);
    }

    public static void sumupProblems(MessageLogger messageLogger) {
        if (messageLogger.getProblems().size() > 0) {
            List list = messageLogger.getWarns();
            List list2 = messageLogger.getErrors();
            messageLogger.info("");
            if (!list2.isEmpty()) {
                messageLogger.log(":: problems summary ::", 0);
            } else {
                messageLogger.log(":: problems summary ::", 1);
            }
            if (list.size() > 0) {
                messageLogger.log(":::: WARNINGS", 1);
                for (String string : list) {
                    messageLogger.log("\t" + string + "\n", 1);
                }
            }
            if (list2.size() > 0) {
                messageLogger.log(":::: ERRORS", 0);
                for (String string : list2) {
                    messageLogger.log("\t" + string + "\n", 0);
                }
            }
            messageLogger.info("\n:: USE VERBOSE OR DEBUG MESSAGE LEVEL FOR MORE DETAILS");
        }
    }

    public static Map getExtraAttributes(org.xml.sax.Attributes attributes, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getQName(i).startsWith(string)) continue;
            hashMap.put(attributes.getQName(i).substring(string.length()), attributes.getValue(i));
        }
        return hashMap;
    }

    public static Map getExtraAttributes(ParserSettings parserSettings, org.xml.sax.Attributes attributes, String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List<String> list = Arrays.asList(stringArray);
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (list.contains(attributes.getQName(i))) continue;
            hashMap.put(attributes.getQName(i), parserSettings.substitute(attributes.getValue(i)));
        }
        return hashMap;
    }

    private static int typeCode(Object object) {
        if (object instanceof Integer) {
            return 3;
        }
        if (object instanceof Double) {
            return 6;
        }
        if (object instanceof Long) {
            return 4;
        }
        if (object instanceof Character) {
            return 0;
        }
        if (object instanceof Float) {
            return 5;
        }
        if (object instanceof Byte || object instanceof Short) {
            return 3;
        }
        return 7;
    }

    public static boolean unboxToBoolean(Object object) {
        if (object == null) {
            return false;
        }
        return (Boolean)object;
    }

    public static char unboxToChar(Object object) {
        if (object == null) {
            return '\u0000';
        }
        return ((Character)object).charValue();
    }

    public static byte unboxToByte(Object object) {
        if (object == null) {
            return 0;
        }
        return (Byte)object;
    }

    public static short unboxToShort(Object object) {
        if (object == null) {
            return 0;
        }
        return (Short)object;
    }

    public static int unboxToInt(Object object) {
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    public static long unboxToLong(Object object) {
        if (object == null) {
            return 0L;
        }
        return (Long)object;
    }

    public static float unboxToFloat(Object object) {
        if (object == null) {
            return 0.0f;
        }
        return ((Float)object).floatValue();
    }

    public static double unboxToDouble(Object object) {
        if (object == null) {
            return 0.0;
        }
        return (Double)object;
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        Object object3 = object2;
        Object object4 = object;
        if (object4 instanceof Number) {
            return LogOptions.equalsNumObject((Number)object4, object3);
        }
        if (object4 instanceof Character) {
            return LogOptions.equalsCharObject((Character)object4, object3);
        }
        if (object4 == null) {
            return object3 == null;
        }
        return object4.equals(object3);
    }

    public static boolean equalsNumObject(Number number, Object object) {
        if (object instanceof Number) {
            Number number2 = (Number)object;
            Number number3 = number;
            int n = LogOptions.typeCode(number3);
            int n2 = LogOptions.typeCode(number2);
            switch (n2 > n ? n2 : n) {
                case 3: {
                    return number3.intValue() == number2.intValue();
                }
                case 4: {
                    return number3.longValue() == number2.longValue();
                }
                case 5: {
                    return number3.floatValue() == number2.floatValue();
                }
                case 6: {
                    return number3.doubleValue() == number2.doubleValue();
                }
            }
            if (number2 instanceof ScalaNumber && !(number3 instanceof ScalaNumber)) {
                return number2.equals(number3);
            }
            if (number3 == null) {
                return number2 == null;
            }
            return number3.equals(number2);
        }
        if (object instanceof Character) {
            return LogOptions.equalsNumChar(number, (Character)object);
        }
        if (number == null) {
            return object == null;
        }
        return number.equals(object);
    }

    public static boolean equalsCharObject(Character c, Object object) {
        if (object instanceof Character) {
            return c.charValue() == ((Character)object).charValue();
        }
        if (object instanceof Number) {
            return LogOptions.equalsNumChar((Number)object, c);
        }
        if (c == null) {
            return object == null;
        }
        return c.equals(object);
    }

    private static boolean equalsNumChar(Number number, Character c) {
        if (c == null) {
            return number == null;
        }
        char c2 = c.charValue();
        switch (LogOptions.typeCode(number)) {
            case 3: {
                return number.intValue() == c2;
            }
            case 4: {
                return number.longValue() == (long)c2;
            }
            case 5: {
                return number.floatValue() == (float)c2;
            }
            case 6: {
                return number.doubleValue() == (double)c2;
            }
        }
        return number.equals(c);
    }

    public static int hashFromNumber(Number number) {
        if (number instanceof Long) {
            Long l = (Long)number;
            int n = l.intValue();
            if ((long)n == l) {
                return n;
            }
            return l.hashCode();
        }
        if (number instanceof Double) {
            double d;
            Double d2 = (Double)number;
            int n = d2.intValue();
            if ((double)n == (d = d2.doubleValue())) {
                return n;
            }
            long l = d2.longValue();
            if ((double)l == d) {
                return Long.valueOf(l).hashCode();
            }
            float f = d2.floatValue();
            if ((double)f == d) {
                return Float.valueOf(f).hashCode();
            }
            return d2.hashCode();
        }
        if (number instanceof Float) {
            float f;
            Float f2 = (Float)number;
            int n = f2.intValue();
            if ((float)n == (f = f2.floatValue())) {
                return n;
            }
            long l = f2.longValue();
            if ((float)l == f) {
                return Long.valueOf(l).hashCode();
            }
            return f2.hashCode();
        }
        return number.hashCode();
    }

    public static int mix(int n, int n2) {
        int n3 = Integer.rotateLeft(n2 * -862048943, 15) * 461845907;
        return Integer.rotateLeft(n ^ n3, 13) * 5 + -430675100;
    }

    public static int finalizeHash(int n, int n2) {
        int n3 = n ^ n2;
        n3 = (n3 ^ n3 >>> 16) * -2048144789;
        n3 = (n3 ^ n3 >>> 13) * -1028477387;
        return n3 ^ n3 >>> 16;
    }

    public static int anyHash(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Long) {
            long l = (Long)object;
            if ((long)((int)l) == l) {
                return (int)l;
            }
            return (int)(l ^ l >>> 32);
        }
        if (object instanceof Double) {
            double d = (Double)object;
            int n = (int)d;
            if ((double)n == d) {
                return n;
            }
            float f = (float)d;
            if ((double)f == d) {
                return Float.floatToIntBits(f);
            }
            long l = (long)d;
            if ((double)l == d) {
                return (int)l;
            }
            l = Double.doubleToLongBits(d);
            return (int)(l ^ l >>> 32);
        }
        if (object instanceof Float) {
            float f = ((Float)object).floatValue();
            int n = (int)f;
            if ((float)n == f) {
                return n;
            }
            long l = (long)f;
            if ((float)l == f) {
                return (int)(l ^ l >>> 32);
            }
            return Float.floatToIntBits(f);
        }
        return object.hashCode();
    }
}

