/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.om.AbstractItem;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class ObjectValue
extends AbstractItem {
    private Object value;

    public ObjectValue(Object object) {
        if (object == null) {
            throw new NullPointerException("External object cannot wrap a Java null");
        }
        this.value = object;
    }

    public String getStringValue() {
        return this.value.toString();
    }

    public CharSequence getStringValueCS() {
        return this.value.toString();
    }

    public ItemType getItemType(TypeHierarchy th) {
        return new ExternalObjectType(this.value.getClass());
    }

    public String displayTypeName() {
        return "java-type:" + this.value.getClass().getName();
    }

    public boolean effectiveBooleanValue() {
        return true;
    }

    public Object getObject() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (other instanceof ObjectValue) {
            Object o = ((ObjectValue)other).value;
            return this.value.equals(o);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

