/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.BooleanValue;

public class XSLIf
extends StyleElement {
    private Expression test;

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        this.test = XSLIf.prepareTestAttribute(this);
        if (this.test == null) {
            this.reportAbsence("test");
        }
    }

    public static Expression prepareTestAttribute(StyleElement se) throws XPathException {
        String testAtt = null;
        AttributeCollection atts = se.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("test")) {
                testAtt = atts.getValue(a);
                continue;
            }
            se.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (testAtt == null) {
            return null;
        }
        try {
            return se.makeExpression(testAtt);
        }
        catch (XPathException err) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
    }

    public void validate(Declaration decl) throws XPathException {
        this.test = this.typeCheck("test", this.test);
    }

    public boolean markTailCalls() {
        StyleElement last = this.getLastChildInstruction();
        return last != null && last.markTailCalls();
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        Expression action;
        if (this.test instanceof Literal) {
            GroundedValue testVal = ((Literal)this.test).getValue();
            try {
                if (testVal.effectiveBooleanValue()) {
                    return this.compileSequenceConstructor(exec, decl, this.iterateAxis((byte)3), true);
                }
                return null;
            }
            catch (XPathException err) {
                // empty catch block
            }
        }
        if ((action = this.compileSequenceConstructor(exec, decl, this.iterateAxis((byte)3), true)) == null) {
            return null;
        }
        Expression[] conditions = new Expression[]{this.test};
        Expression[] actions = new Expression[]{action};
        return new Choose(conditions, actions);
    }
}

