/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.io.PrintStream;
import java.io.Serializable;
import net.sf.saxon.regex.CaseVariants;
import net.sf.saxon.regex.Operation;
import net.sf.saxon.regex.REFlags;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntPredicate;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntSetPredicate;
import net.sf.saxon.z.IntSingletonSet;
import net.sf.saxon.z.IntValuePredicate;

public class REProgram
implements Serializable {
    static final int OPT_HASBACKREFS = 1;
    static final int OPT_HASBOL = 2;
    Operation[] instructions;
    REFlags flags;
    UnicodeString prefix;
    IntPredicate initialCharClass;
    int optimizationFlags;
    int maxParens = -1;
    boolean nullable = false;

    public REProgram(Operation[] instructions, int parens, REFlags flags) {
        this.flags = flags;
        this.setInstructions(instructions);
        this.maxParens = parens;
    }

    private void setInstructions(Operation[] instructions) {
        this.instructions = instructions;
        this.optimizationFlags = 0;
        this.prefix = null;
        if (instructions != null && instructions.length != 0) {
            int next;
            int first = 0;
            while (instructions[first] instanceof Operation.OpContinue) {
                ++first;
            }
            if (instructions[first] instanceof Operation.OpAtom) {
                this.prefix = ((Operation.OpAtom)instructions[first]).atom;
            }
            if (instructions[first] instanceof Operation.OpCharClass) {
                this.initialCharClass = ((Operation.OpCharClass)instructions[first]).predicate;
            }
            if (instructions[first] instanceof Operation.OpBranch && instructions[next = instructions[first].next] instanceof Operation.OpEndProgram) {
                Operation nextOp = instructions[first + 1];
                if (nextOp instanceof Operation.OpAtom) {
                    this.prefix = ((Operation.OpAtom)nextOp).atom;
                } else if (nextOp instanceof Operation.OpBOL) {
                    this.optimizationFlags |= 2;
                }
            }
            for (Operation op : instructions) {
                if (!(op instanceof Operation.OpBackReference)) continue;
                this.optimizationFlags |= 1;
                break;
            }
            boolean caseBlind = this.flags.isCaseIndependent();
            for (int i = 0; i < instructions.length; ++i) {
                Operation op = instructions[i];
                if (op instanceof Operation.OpStar && op.next == i + 2 && (instructions[i + 1] instanceof Operation.OpAtom || instructions[i + 1] instanceof Operation.OpCharClass)) {
                    if (!this.noAmbiguity(instructions[i + 1], instructions[op.next], caseBlind)) continue;
                    instructions[i] = new Operation.OpConfidentStar();
                    instructions[i].next = op.next;
                    continue;
                }
                if (!(op instanceof Operation.OpPlus) || op.next != i - 2 || !(instructions[i - 1] instanceof Operation.OpAtom) && !(instructions[i - 1] instanceof Operation.OpCharClass) || instructions[i - 2].next != i + 1 || !this.noAmbiguity(instructions[i - 1], instructions[i + 1], caseBlind)) continue;
                instructions[i] = new Operation.OpConfidentPlus();
                instructions[i].next = i + 1;
            }
        }
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public UnicodeString getPrefix() {
        return this.prefix;
    }

    public void display(PrintStream out) {
        for (int i = 0; i < this.instructions.length; ++i) {
            int nextOffset = this.instructions[i].next;
            out.println(i + ". " + this.instructions[i].toString() + (nextOffset == -1 ? "" : ", next = " + nextOffset));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean noAmbiguity(Operation op0, Operation op1, boolean caseBlind) {
        IntSet set1;
        IntSet set0;
        if (op1 instanceof Operation.OpClose || op1 instanceof Operation.OpCloseCluster) {
            op1 = this.instructions[op1.next];
        }
        if (op1 instanceof Operation.OpEndProgram || op1 instanceof Operation.OpBOL || op1 instanceof Operation.OpEOL) {
            return true;
        }
        if (op0 instanceof Operation.OpAtom) {
            set0 = this.getInitialChars((Operation.OpAtom)op0, caseBlind);
        } else {
            IntPredicate ip0 = ((Operation.OpCharClass)op0).predicate;
            if (ip0 instanceof IntSetPredicate) {
                set0 = ((IntSetPredicate)ip0).getIntSet();
            } else {
                if (!(ip0 instanceof IntValuePredicate)) return false;
                set0 = new IntSingletonSet(((IntValuePredicate)ip0).getTarget());
            }
        }
        if (op1 instanceof Operation.OpAtom) {
            set1 = this.getInitialChars((Operation.OpAtom)op1, caseBlind);
            return this.isDisjoint(set0, set1);
        } else {
            if (!(op1 instanceof Operation.OpCharClass)) return false;
            IntPredicate ip1 = ((Operation.OpCharClass)op1).predicate;
            if (ip1 instanceof IntSetPredicate) {
                set1 = ((IntSetPredicate)ip1).getIntSet();
                return this.isDisjoint(set0, set1);
            } else {
                if (!(ip1 instanceof IntValuePredicate)) return false;
                set1 = new IntSingletonSet(((IntValuePredicate)ip1).getTarget());
            }
        }
        return this.isDisjoint(set0, set1);
    }

    private IntSet getInitialChars(Operation.OpAtom op, boolean caseBlind) {
        int ch = op.atom.charAt(0);
        IntSet set = new IntSingletonSet(ch);
        if (caseBlind) {
            set = new IntHashSet(10);
            set.add(ch);
            for (int v : CaseVariants.getCaseVariants(ch)) {
                set.add(v);
            }
        }
        return set;
    }

    boolean isDisjoint(IntSet set0, IntSet set1) {
        try {
            IntSet intersection = set0.intersect(set1);
            return intersection.isEmpty();
        }
        catch (Throwable e) {
            return false;
        }
    }
}

