/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NumericValue;

public final class RoundHalfToEven
extends SystemFunctionCall
implements Callable {
    public NumericValue evaluateItem(XPathContext context) throws XPathException {
        NumericValue val0 = (NumericValue)this.argument[0].evaluateItem(context);
        if (val0 == null) {
            return null;
        }
        int scale = 0;
        if (this.argument.length == 2) {
            NumericValue scaleVal = (NumericValue)this.argument[1].evaluateItem(context);
            if (scaleVal.compareTo(Integer.MAX_VALUE) > 0) {
                return val0;
            }
            scale = scaleVal.compareTo(Integer.MIN_VALUE) < 0 ? Integer.MIN_VALUE : (int)scaleVal.longValue();
        }
        return val0.roundHalfToEven(scale);
    }

    public int computeCardinality() {
        return this.argument[0].getCardinality();
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        NumericValue val0 = (NumericValue)arguments[0].head();
        if (val0 == null) {
            return EmptySequence.getInstance();
        }
        int scale = 0;
        if (arguments.length == 2) {
            NumericValue scaleVal = (NumericValue)arguments[1].head();
            if (scaleVal.compareTo(Integer.MAX_VALUE) > 0) {
                return val0;
            }
            scale = scaleVal.compareTo(Integer.MIN_VALUE) < 0 ? Integer.MIN_VALUE : (int)scaleVal.longValue();
        }
        return val0.roundHalfToEven(scale);
    }
}

