/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutableFunctionLibrary
implements FunctionLibrary {
    private transient Configuration config;
    private HashMap<String, UserFunction> functions = new HashMap(20);

    public ExecutableFunctionLibrary(Configuration config) {
        this.config = config;
    }

    private String makeKey(StructuredQName functionName, int arity) {
        String uri = functionName.getURI();
        String local = functionName.getLocalPart();
        FastStringBuffer sb = new FastStringBuffer(uri.length() + local.length() + 8);
        sb.append('{');
        sb.append(uri);
        sb.append('}');
        sb.append(local);
        sb.append("#" + arity);
        return sb.toString();
    }

    public void addFunction(UserFunction fn) {
        this.functions.put(this.makeKey(fn.getFunctionName(), fn.getNumberOfArguments()), fn);
    }

    @Override
    public Expression bind(StructuredQName functionName, int arity, Expression[] staticArgs, StaticContext env, Container container) throws XPathException {
        UserFunction fn = this.functions.get(this.makeKey(functionName, staticArgs.length));
        if (fn == null) {
            return null;
        }
        ExpressionVisitor visitor = ExpressionVisitor.make(env, fn.getExecutable());
        UserFunctionCall fc = new UserFunctionCall();
        fc.setFunctionName(functionName);
        fc.setArguments(staticArgs);
        fc.setFunction(fn);
        fc.checkFunctionCall(fn, visitor);
        fc.setStaticType(fn.getResultType(this.config.getTypeHierarchy()));
        return fc;
    }

    @Override
    public boolean isAvailable(StructuredQName functionName, int arity) {
        return this.functions.get(this.makeKey(functionName, arity)) != null;
    }

    @Override
    public FunctionLibrary copy() {
        ExecutableFunctionLibrary efl = new ExecutableFunctionLibrary(this.config);
        efl.functions = new HashMap<String, UserFunction>(this.functions);
        return efl;
    }

    public Iterator<UserFunction> iterateFunctions() {
        return this.functions.values().iterator();
    }
}

