/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.HashSet;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicSortComparer;
import net.sf.saxon.expr.sort.ComparisonKey;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;

public class DistinctValues
extends CollatingFunction
implements Callable {
    protected int getCollationArgument() {
        return 1;
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        ItemType itemType = this.argument[0].getItemType(th);
        if (itemType instanceof AtomicType) {
            this.preAllocateComparer((AtomicType)itemType, (AtomicType)itemType, visitor.getStaticContext(), true);
        }
    }

    public AtomicComparer getAtomicComparer() {
        return this.getPreAllocatedAtomicComparer();
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        AtomicComparer comparer = this.getPreAllocatedAtomicComparer();
        if (comparer != null) {
            comparer = comparer.provideContext(context);
        } else {
            int type = this.argument[0].getItemType(context.getConfiguration().getTypeHierarchy()).getPrimitiveType();
            comparer = AtomicSortComparer.makeSortComparer(this.getCollator(context), type, context);
        }
        SequenceIterator<? extends Item> iter = this.argument[0].iterate(context);
        return new DistinctIterator(iter, comparer);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringCollator collator = this.getCollatorFromLastArgument(arguments, 1, context);
        AtomicComparer comp = AtomicSortComparer.makeSortComparer(collator, 632, context);
        return SequenceTool.toLazySequence(new DistinctIterator(arguments[0].iterate(), comp));
    }

    public static class DistinctIterator
    implements SequenceIterator {
        private SequenceIterator base;
        private AtomicComparer comparer;
        private int position;
        private AtomicValue current;
        private HashSet<ComparisonKey> lookup = new HashSet(40);

        public DistinctIterator(SequenceIterator base, AtomicComparer comparer) {
            this.base = base;
            this.comparer = comparer;
            this.position = 0;
        }

        public Item next() throws XPathException {
            AtomicValue nextBase;
            ComparisonKey key;
            do {
                if ((nextBase = (AtomicValue)this.base.next()) != null) continue;
                this.current = null;
                this.position = -1;
                return null;
            } while (!this.lookup.add(key = this.comparer.getComparisonKey(nextBase)));
            this.current = nextBase;
            ++this.position;
            return nextBase;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public void close() {
            this.base.close();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new DistinctIterator(this.base.getAnother(), this.comparer);
        }

        public int getProperties() {
            return 0;
        }
    }
}

