/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;

public class LocalVariableReference
extends VariableReference {
    int slotNumber = -999;

    public LocalVariableReference() {
    }

    public LocalVariableReference(Binding binding) {
        super(binding);
    }

    public Expression copy() {
        if (this.binding == null) {
            throw new UnsupportedOperationException("Cannot copy a variable reference whose binding is unknown");
        }
        LocalVariableReference ref = new LocalVariableReference();
        ref.binding = this.binding;
        ref.staticType = this.staticType;
        ref.slotNumber = this.slotNumber;
        ref.constantValue = this.constantValue;
        ref.displayName = this.displayName;
        this.binding.addReference(this.isInLoop());
        ExpressionTool.copyLocationInfo(this, ref);
        return ref;
    }

    public void setSlotNumber(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public Sequence evaluateVariable(XPathContext c) throws XPathException {
        try {
            return c.getStackFrame().slots[this.slotNumber];
        }
        catch (ArrayIndexOutOfBoundsException err) {
            if (this.slotNumber == -999) {
                if (this.binding != null) {
                    try {
                        this.slotNumber = this.binding.getLocalSlotNumber();
                        return c.getStackFrame().slots[this.slotNumber];
                    }
                    catch (ArrayIndexOutOfBoundsException err2) {
                        // empty catch block
                    }
                }
                throw new ArrayIndexOutOfBoundsException("Local variable $" + this.getDisplayName() + " has not been allocated a stack frame slot");
            }
            int actual = c.getStackFrame().slots.length;
            throw new ArrayIndexOutOfBoundsException("Local variable $" + this.getDisplayName() + " uses slot " + this.slotNumber + " but " + (actual == 0 ? "no" : "only " + c.getStackFrame().slots.length + " slots") + " are allocated on the stack frame");
        }
    }
}

