/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.math.BigInteger;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.IntegerValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigRangeIterator
implements SequenceIterator<IntegerValue>,
LastPositionFinder<IntegerValue>,
LookaheadIterator<IntegerValue> {
    BigInteger start;
    BigInteger currentValue;
    BigInteger limit;

    public BigRangeIterator(BigInteger start, BigInteger end) throws XPathException {
        if (end.subtract(start).compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new XPathException("Saxon limit on sequence length exceeded (2^32-1)");
        }
        this.start = start;
        this.currentValue = start.subtract(BigInteger.valueOf(1L));
        this.limit = end;
    }

    @Override
    public boolean hasNext() {
        return this.currentValue.compareTo(this.limit) < 0;
    }

    @Override
    public IntegerValue next() {
        this.currentValue = this.currentValue.add(BigInteger.valueOf(1L));
        if (this.currentValue.compareTo(this.limit) > 0) {
            return null;
        }
        return IntegerValue.makeIntegerValue(this.currentValue);
    }

    @Override
    public IntegerValue current() {
        if (this.currentValue.compareTo(this.limit) > 0) {
            return null;
        }
        return IntegerValue.makeIntegerValue(this.currentValue);
    }

    @Override
    public int position() {
        if (this.currentValue.compareTo(this.limit) > 0) {
            return -1;
        }
        BigInteger pos = this.currentValue.subtract(this.start).add(BigInteger.valueOf(1L));
        if (pos.abs().compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new UncheckedXPathException(new XPathException("Sequence exceeds Saxon limit (32-bit integer)"));
        }
        return pos.intValue();
    }

    @Override
    public void close() {
    }

    @Override
    public int getLength() {
        BigInteger len = this.limit.subtract(this.start).add(BigInteger.valueOf(1L));
        if (len.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new UncheckedXPathException(new XPathException("Sequence exceeds Saxon limit (32-bit integer)"));
        }
        return len.intValue();
    }

    @Override
    public SequenceIterator<IntegerValue> getAnother() throws XPathException {
        return new BigRangeIterator(this.start, this.limit);
    }

    @Override
    public int getProperties() {
        return 6;
    }
}

