/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.UntypedSequenceConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicSequenceConverter
extends UnaryExpression {
    public static ToStringMappingFunction TO_STRING_MAPPER = new ToStringMappingFunction();
    private PlainType requiredItemType;
    protected Converter converter;

    public AtomicSequenceConverter(Expression sequence, PlainType requiredItemType) {
        super(sequence);
        this.requiredItemType = requiredItemType;
    }

    public void allocateConverter(Configuration config, boolean allowNull) {
        ItemType sourceType = this.operand.getItemType(config.getTypeHierarchy());
        final ConversionRules rules = config.getConversionRules();
        if (sourceType instanceof EmptySequenceTest) {
            this.converter = Converter.IDENTITY_CONVERTER;
        } else if (!(sourceType instanceof AtomicType)) {
            this.converter = null;
        } else if (this.requiredItemType instanceof AtomicType) {
            this.converter = rules.getConverter((AtomicType)sourceType, (AtomicType)this.requiredItemType);
        } else if (((SimpleType)((Object)this.requiredItemType)).isUnionType()) {
            this.converter = new StringConverter.StringToUnionConverter(this.requiredItemType, rules);
        }
        if (this.converter == null && !allowNull) {
            this.converter = new Converter(rules){

                public ConversionResult convert(AtomicValue input) {
                    Converter converter = rules.getConverter(input.getPrimitiveType(), (AtomicType)AtomicSequenceConverter.this.requiredItemType);
                    if (converter == null) {
                        return new ValidationFailure("Cannot convert value from " + input.getPrimitiveType() + " to " + AtomicSequenceConverter.this.requiredItemType);
                    }
                    return converter.convert(input);
                }
            };
        }
    }

    public PlainType getRequiredItemType() {
        return this.requiredItemType;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.operand = visitor.simplify(this.operand);
        if (this.operand instanceof Literal && this.requiredItemType instanceof AtomicType) {
            if (Literal.isEmptySequence(this.operand)) {
                return this.operand;
            }
            Configuration config = visitor.getConfiguration();
            this.allocateConverter(config, true);
            if (this.converter != null) {
                GroundedValue val = SequenceExtent.makeSequenceExtent(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext()));
                return Literal.makeLiteral(val);
            }
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        Configuration config = visitor.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        if (th.isSubType(this.operand.getItemType(th), this.requiredItemType)) {
            return this.operand;
        }
        if (this.converter == null) {
            this.allocateConverter(config, true);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (this.operand instanceof UntypedSequenceConverter) {
            UntypedSequenceConverter asc = (UntypedSequenceConverter)this.operand;
            ItemType ascType = asc.getItemType(th);
            if (ascType == this.requiredItemType) {
                return this.operand;
            }
            if (!(this.requiredItemType != BuiltInAtomicType.STRING && this.requiredItemType != BuiltInAtomicType.UNTYPED_ATOMIC || ascType != BuiltInAtomicType.STRING && ascType != BuiltInAtomicType.UNTYPED_ATOMIC)) {
                UntypedSequenceConverter old = (UntypedSequenceConverter)this.operand;
                UntypedSequenceConverter asc2 = new UntypedSequenceConverter(old.getBaseExpression(), this.requiredItemType);
                return asc2.typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
            }
        } else if (this.operand instanceof AtomicSequenceConverter) {
            AtomicSequenceConverter asc = (AtomicSequenceConverter)this.operand;
            ItemType ascType = asc.getItemType(th);
            if (ascType == this.requiredItemType) {
                return this.operand;
            }
            if (!(this.requiredItemType != BuiltInAtomicType.STRING && this.requiredItemType != BuiltInAtomicType.UNTYPED_ATOMIC || ascType != BuiltInAtomicType.STRING && ascType != BuiltInAtomicType.UNTYPED_ATOMIC)) {
                AtomicSequenceConverter old = (AtomicSequenceConverter)this.operand;
                AtomicSequenceConverter asc2 = new AtomicSequenceConverter(old.getBaseExpression(), this.requiredItemType);
                return asc2.typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
            }
        }
        return this;
    }

    @Override
    public int computeSpecialProperties() {
        return super.computeSpecialProperties() | 0x400000;
    }

    @Override
    public Expression copy() {
        AtomicSequenceConverter atomicConverter = new AtomicSequenceConverter(this.getBaseExpression().copy(), this.requiredItemType);
        atomicConverter.setConverter(this.converter);
        return atomicConverter;
    }

    public SequenceIterator<? extends AtomicValue> iterate(XPathContext context) throws XPathException {
        SequenceIterator<? extends Item> base = this.operand.iterate(context);
        if (this.converter == null) {
            this.allocateConverter(context.getConfiguration(), false);
        }
        if (this.converter == Converter.TO_STRING) {
            return new ItemMappingIterator<Item, StringValue>(base, TO_STRING_MAPPER, true);
        }
        AtomicSequenceMappingFunction mapper = new AtomicSequenceMappingFunction();
        mapper.setConverter(this.converter);
        return new ItemMappingIterator<Item, AtomicValue>(base, mapper, true);
    }

    @Override
    public AtomicValue evaluateItem(XPathContext context) throws XPathException {
        AtomicValue item = (AtomicValue)this.operand.evaluateItem(context);
        if (item == null) {
            return null;
        }
        return this.converter.convert(item).asAtomic();
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.requiredItemType;
    }

    @Override
    public int computeCardinality() {
        return this.operand.getCardinality();
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.requiredItemType.equals(((AtomicSequenceConverter)other).requiredItemType);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.requiredItemType.hashCode();
    }

    @Override
    public String getExpressionName() {
        return "convertItems";
    }

    @Override
    protected String displayOperator(Configuration config) {
        return "convertItems";
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("convertItems");
        destination.emitAttribute("to", this.requiredItemType.toString());
        this.operand.explain(destination);
        destination.endElement();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToStringMappingFunction
    implements ItemMappingFunction<Item, StringValue> {
        @Override
        public StringValue mapItem(Item item) throws XPathException {
            return StringValue.makeStringValue(item.getStringValueCS());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AtomicSequenceMappingFunction
    implements ItemMappingFunction<Item, AtomicValue> {
        private Converter converter;

        public void setConverter(Converter converter) {
            this.converter = converter;
        }

        @Override
        public AtomicValue mapItem(Item item) throws XPathException {
            return this.converter.convert((AtomicValue)item).asAtomic();
        }
    }
}

